/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.exclusions;

import gde.DataAccess;
import gde.histo.innercache.Cache;
import gde.histo.innercache.CacheBuilder;
import gde.histo.innercache.CacheStats;
import gde.histo.utils.SecureHash;
import gde.log.Logger;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class InclusionData
extends Properties {
    private static final String $CLASS_NAME = InclusionData.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final long serialVersionUID = -2477509505185819765L;
    private static final Cache<String, InclusionData> memoryCache = CacheBuilder.newBuilder().maximumSize(111L).recordStats().build();
    private final Path activeFolder;
    private final DataAccess dataAccess;

    public InclusionData(Path activeFolder, DataAccess dataAccess) {
        this.activeFolder = activeFolder;
        this.dataAccess = dataAccess;
        String fileName = SecureHash.sha1(this.activeFolder.toString());
        Properties cachedInstance = memoryCache.getIfPresent(fileName);
        log.finer(() -> {
            CacheStats stats = memoryCache.stats();
            return String.format("evictionCount=%d  hitCount=%d  missCount=%d hitRate=%f missRate=%f", stats.evictionCount(), stats.hitCount(), stats.missCount(), stats.hitRate(), stats.missRate());
        });
        if (cachedInstance == null) {
            this.load();
        } else {
            this.putAll((Map<?, ?>)cachedInstance);
        }
    }

    public boolean isIncluded(String recordName, boolean defaultValue) {
        if (recordName.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        boolean included = defaultValue;
        if (!this.isEmpty()) {
            boolean bl = included = this.getProperty(recordName) != null;
            if (included) {
                log.fine(() -> String.format("record included by user %s %s", this.activeFolder.toString(), recordName));
            }
        }
        return included;
    }

    @Override
    public String toString() {
        return this.stringPropertyNames().stream().sorted(Comparator.comparing(this::getProperty)).map(this::getProperty).map(k -> k.isEmpty() ? k : k + " : " + k).collect(Collectors.joining(","));
    }

    @Override
    public InclusionData setProperty(String recordName, String irrelevantValue) {
        if (recordName.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return (InclusionData)super.setProperty(recordName, irrelevantValue);
    }

    public InclusionData setProperty(String recordName) {
        return (InclusionData)super.setProperty(recordName, "");
    }

    public String deleteProperty(String recordName) {
        String value = (String)this.remove(recordName);
        return value;
    }

    private void load() {
        this.dataAccess.ensureInclusionDirectory();
        String fileName = SecureHash.sha1(this.activeFolder.toString());
        if (this.dataAccess.existsInclusionFile(fileName)) {
            try (InputStreamReader reader = new InputStreamReader(this.dataAccess.getInclusionsInputStream(fileName));){
                this.load(reader);
                memoryCache.put(fileName, this);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void store() {
        if (this.size() > 0) {
            this.dataAccess.ensureInclusionDirectory();
            String fileName = SecureHash.sha1(this.activeFolder.toString());
            try (OutputStreamWriter writer = new OutputStreamWriter(this.dataAccess.getInclusionsOutputStream(fileName), "UTF-8");){
                this.store(writer, this.activeFolder.toString());
                memoryCache.put(fileName, this);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            this.delete();
            String fileName = SecureHash.sha1(this.activeFolder.toString());
            memoryCache.invalidate(fileName);
        }
    }

    public void delete() {
        String fileName = SecureHash.sha1(this.activeFolder.toString());
        this.dataAccess.deleteInclusionFile(fileName);
        memoryCache.invalidateAll();
    }

    public String[] getIncludedRecordNames() {
        return this.stringPropertyNames().toArray(new String[0]);
    }
}

