/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.config;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.DataAccess;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.MeasurementType;
import gde.histo.config.ObjectGraphicsTemplate;
import gde.histo.config.StandardGraphicsTemplate;
import gde.histo.innercache.Cache;
import gde.histo.innercache.CacheBuilder;
import gde.histo.utils.SecureHash;
import gde.log.Level;
import gde.log.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class HistoGraphicsTemplate
extends Properties {
    static final String $CLASS_NAME = HistoGraphicsTemplate.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    static final long serialVersionUID = 2088159376716311896L;
    private static final Cache<String, HistoGraphicsTemplate> memoryCache = CacheBuilder.newBuilder().maximumSize(444L).recordStats().build();
    public static final String IS_ACTIVE = "_isActive";
    public static final String SMART_STATISTICS = "RecordSet_smartStatistics";
    protected final boolean suppressNewFile;
    protected final Analyzer analyzer;
    protected final String defaultHistoFileName;
    protected final String defaultFileName;
    protected Path currentFilePathFragment;
    protected String histoFileName;
    protected boolean isAvailable = false;
    protected boolean isSaved = false;
    protected String commentSuffix = "";

    public static HistoGraphicsTemplate createGraphicsTemplate(Analyzer analyzer) {
        boolean tmpSuppressNewFile = false;
        Settings settings = analyzer.getSettings();
        if (!settings.getActiveObjectKey().isEmpty() && settings.isObjectTemplatesActive()) {
            return new ObjectGraphicsTemplate(analyzer, settings.getActiveObjectKey(), tmpSuppressNewFile);
        }
        if (settings.getActiveObjectKey().isEmpty() && settings.isObjectTemplatesActive()) {
            return new ObjectGraphicsTemplate(analyzer, "_", tmpSuppressNewFile);
        }
        return new StandardGraphicsTemplate(analyzer, tmpSuppressNewFile);
    }

    public static HistoGraphicsTemplate createTransitoryTemplate(Analyzer analyzer) {
        boolean tmpSuppressNewFile = true;
        Settings settings = analyzer.getSettings();
        if (!settings.getActiveObjectKey().isEmpty() && settings.isObjectTemplatesActive()) {
            return new ObjectGraphicsTemplate(analyzer, settings.getActiveObjectKey(), tmpSuppressNewFile);
        }
        if (settings.getActiveObjectKey().isEmpty() && settings.isObjectTemplatesActive()) {
            return new ObjectGraphicsTemplate(analyzer, "_", tmpSuppressNewFile);
        }
        return new StandardGraphicsTemplate(analyzer, tmpSuppressNewFile);
    }

    protected HistoGraphicsTemplate(Analyzer analyzer, boolean suppressNewFile) {
        this.analyzer = analyzer;
        this.suppressNewFile = suppressNewFile;
        String deviceSignature = analyzer.getActiveDevice().getName() + "_" + analyzer.getActiveChannel().getNumber();
        this.defaultFileName = deviceSignature + "*.xml".substring("*.xml".length() - 4);
        this.defaultHistoFileName = deviceSignature + "H" + "*.xml".substring("*.xml".length() - 4);
        this.setHistoFileName(this.defaultHistoFileName);
        log.log(java.util.logging.Level.FINE, "Histo graphics template file is ", this.defaultFileName);
    }

    public void setCommentSuffix(String commentSuffix) {
        this.commentSuffix = commentSuffix;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void loadAlien(Path filePath) {
        Path fileSubPath = null;
        try {
            Path tmpSubPath = Paths.get(Settings.getGraphicsTemplatePath(), new String[0]).relativize(filePath);
            fileSubPath = tmpSubPath.toString().startsWith("..") ? null : tmpSubPath;
        }
        catch (Exception e) {
            fileSubPath = null;
        }
        if (fileSubPath != null && fileSubPath.getNameCount() > 1 && fileSubPath.getParent().equals(this.getTargetFileSubPath().getParent())) {
            this.setHistoFileName(filePath.getFileName().toString());
            this.load();
        } else {
            try (InputStream stream = ((DataAccess.LocalAccess)this.analyzer.getDataAccess()).getAlienTemplateInputStream(filePath.toFile());){
                this.currentFilePathFragment = null;
                this.clear();
                this.loadFromXML(stream);
                log.log(java.util.logging.Level.FINE, "alien file loaded successfully", filePath);
                this.currentFilePathFragment = filePath;
                this.setHistoFileName(filePath.getFileName().toString());
                this.isAvailable = true;
            }
            catch (InvalidPropertiesFormatException e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.WARNING, e.getMessage());
            }
        }
    }

    public void load() {
        try {
            this.currentFilePathFragment = null;
            Path fileSubPath = this.getTargetFileSubPath();
            if (!this.analyzer.getDataAccess().existsGraphicsTemplate(fileSubPath)) {
                if (this.suppressNewFile) {
                    fileSubPath = Paths.get(this.defaultFileName, new String[0]);
                    this.loadFromXml(fileSubPath);
                } else {
                    log.log(java.util.logging.Level.FINE, "convert legacy default template as a replacement for ", fileSubPath);
                    ConvertedLegacyTemplate template = new ConvertedLegacyTemplate(this.analyzer);
                    HistoGraphicsTemplate convertedTemplate = template.convertToHistoTemplate();
                    convertedTemplate.store();
                    fileSubPath = convertedTemplate.getTargetFileSubPath();
                    this.clear();
                    this.putAll((Map<?, ?>)convertedTemplate);
                }
            } else {
                this.clear();
                this.loadFromXml(fileSubPath);
                boolean isHistoTemplate = this.keySet().stream().map(String.class::cast).anyMatch(k -> k.indexOf("__") >= 0);
                if (!isHistoTemplate) {
                    log.log(java.util.logging.Level.FINE, "convert template identified as legacy template ", fileSubPath);
                    ConvertedLegacyTemplate template = new ConvertedLegacyTemplate(fileSubPath, this.analyzer);
                    HistoGraphicsTemplate convertedTemplate = template.convertToHistoTemplate();
                    this.clear();
                    this.putAll((Map<?, ?>)convertedTemplate);
                }
            }
            this.currentFilePathFragment = fileSubPath;
            this.isAvailable = true;
        }
        catch (InvalidPropertiesFormatException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.WARNING, e.getMessage());
        }
    }

    protected void loadFromXml(Path fileSubPath) throws IOException, InvalidPropertiesFormatException, FileNotFoundException {
        log.log(java.util.logging.Level.FINE, "opening template file ", fileSubPath);
        String fileName = SecureHash.sha1(fileSubPath.toString());
        Properties cachedInstance = memoryCache.getIfPresent(fileName);
        if (cachedInstance == null || cachedInstance == this) {
            try (InputStream stream = this.analyzer.getDataAccess().getGraphicsTemplateInputStream(fileSubPath);){
                this.loadFromXML(stream);
                memoryCache.put(fileName, this);
                log.log(java.util.logging.Level.FINE, "template file successful loaded ", fileSubPath);
            }
        } else {
            this.clear();
            this.putAll((Map<?, ?>)cachedInstance);
        }
    }

    public void store() {
        String deviceSignature = this.analyzer.getActiveDevice().getName() + "_" + this.analyzer.getActiveChannel().getNumber();
        String propertiesComment = "-- DataExplorer Histo GraphicsTemplate " + deviceSignature + " -- " + this.getTargetFileSubPath().getFileName().toString() + " " + ZonedDateTime.now().toInstant() + " -- " + this.commentSuffix;
        this.store(propertiesComment);
    }

    protected void store(String propertiesComment) {
        try {
            this.currentFilePathFragment = null;
            try (OutputStream stream = this.analyzer.getDataAccess().getGraphicsTemplateOutputStream(this.getTargetFileSubPath());){
                this.storeToXML(stream, propertiesComment);
                String fileName = SecureHash.sha1(this.getTargetFileSubPath().toString());
                memoryCache.put(fileName, this);
            }
            this.currentFilePathFragment = this.getTargetFileSubPath();
            this.isSaved = true;
        }
        catch (InvalidPropertiesFormatException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
        }
    }

    public void setSaved(boolean newValue) {
        this.isSaved = newValue;
    }

    public void setHistoFileName(String fileName) {
        log.log(java.util.logging.Level.FINE, "fileName=", fileName);
        this.histoFileName = fileName;
    }

    public String getHistoFileName() {
        return this.histoFileName;
    }

    public String getDefaultHistoFileName() {
        return this.defaultHistoFileName;
    }

    public abstract Path getTargetFileSubPath();

    public String getFilePathMessage() {
        if (this.currentFilePathFragment != null && !this.currentFilePathFragment.getFileName().toString().equals(this.getDefaultHistoFileName())) {
            return this.currentFilePathFragment.toString();
        }
        return "";
    }

    public String getDefaultFileName() {
        return this.histoFileName;
    }

    public String getRecordProperty(String recordName, String keyPostfix, String defaultValue) {
        return super.getProperty(recordName + "_" + keyPostfix, defaultValue);
    }

    public String getRecordProperty(String recordName, String keyPostfix) {
        return super.getProperty(recordName + "_" + keyPostfix);
    }

    @Nullable
    public String setRecordProperty(String recordName, String keyPostfix, String value) {
        return (String)super.setProperty(recordName + "_" + keyPostfix, value);
    }

    @Override
    public String toString() {
        return "HistoGraphicsTemplate [defaultHistoFileName=" + this.defaultHistoFileName + ", defaultFileName=" + this.defaultFileName + ", histoFileName=" + this.histoFileName + ", commentSuffix=" + this.commentSuffix + "]";
    }

    protected static final class ConvertedLegacyTemplate
    extends Properties {
        private static final long serialVersionUID = -4459032385846145309L;
        private final Path legacyFileSubPath;
        private final HistoGraphicsTemplate convertedTemplate;

        ConvertedLegacyTemplate(Analyzer analyzer) {
            String deviceSignature = analyzer.getActiveDevice().getName() + "_" + analyzer.getActiveChannel().getNumber();
            this.legacyFileSubPath = Paths.get(deviceSignature + "*.xml".substring("*.xml".length() - 4), new String[0]);
            log.log(Level.FINE, "from signature ", this);
            this.convertedTemplate = HistoGraphicsTemplate.createGraphicsTemplate(analyzer);
            this.convertedTemplate.setHistoFileName(deviceSignature + "H" + "*.xml".substring("*.xml".length() - 4));
        }

        public ConvertedLegacyTemplate(Path fileSubPath, Analyzer analyzer) {
            this.legacyFileSubPath = fileSubPath;
            log.log(Level.FINE, "from file ", this);
            this.convertedTemplate = HistoGraphicsTemplate.createGraphicsTemplate(analyzer);
            String pureFileName = fileSubPath.getFileName().toString().substring(0, fileSubPath.getFileName().toString().lastIndexOf("."));
            if (pureFileName.endsWith("H")) {
                pureFileName = pureFileName.substring(0, pureFileName.length() - 1);
            }
            this.convertedTemplate.setHistoFileName(pureFileName + "cnvH" + "*.xml".substring("*.xml".length() - 4));
        }

        HistoGraphicsTemplate convertToHistoTemplate() throws FileNotFoundException, IOException {
            try (InputStream stream = this.convertedTemplate.analyzer.getDataAccess().getGraphicsTemplateInputStream(this.legacyFileSubPath);){
                this.loadFromXML(stream);
            }
            DeviceConfiguration configuration = this.convertedTemplate.analyzer.getDeviceConfigurations().get(this.convertedTemplate.analyzer.getActiveDevice().getName());
            List<MeasurementType> channelMeasurements = configuration.getChannelMeasuremts(this.convertedTemplate.analyzer.getActiveChannel().getNumber());
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                this.convertedTemplate.setProperty(this.getPrefixedName((String)entry.getKey(), channelMeasurements), (String)entry.getValue());
            }
            this.convertedTemplate.setCommentSuffix(this.legacyFileSubPath.getFileName().toString() + " " + Instant.ofEpochMilli(this.convertedTemplate.analyzer.getDataAccess().getGraphicsTemplateLastModified(this.legacyFileSubPath)));
            return this.convertedTemplate;
        }

        private String getPrefixedName(String key, List<MeasurementType> channelMeasurements) {
            String prefixedName;
            log.log(java.util.logging.Level.FINE, "key=", key);
            String[] splitKey = key.split("_");
            if (splitKey[0].isEmpty()) {
                prefixedName = key;
            } else {
                try {
                    MeasurementType measurementType = channelMeasurements.get(Integer.parseInt(splitKey[0]));
                    prefixedName = measurementType.getName() + "_" + "_" + splitKey[1];
                }
                catch (NumberFormatException e) {
                    prefixedName = key;
                }
                catch (IndexOutOfBoundsException e) {
                    prefixedName = "|Unk|" + key;
                }
                catch (Exception e) {
                    prefixedName = "|Exc|" + key;
                }
            }
            return prefixedName;
        }

        @Override
        public String toString() {
            return "DefaultGraphicsTemplate [legacyFileSubPath=" + this.legacyFileSubPath + "]";
        }
    }
}

