/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="line_ending_types")
@XmlEnum
public enum LineEndingTypes {
    CRLF("<CR><LF>"),
    CR("<CR>"),
    LF("<LF>");

    private final String value;

    private LineEndingTypes(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static LineEndingTypes fromValue(String v) {
        for (LineEndingTypes c : LineEndingTypes.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static String[] valuesAsStingArray() {
        StringBuilder sb = new StringBuilder();
        for (LineEndingTypes element : LineEndingTypes.values()) {
            sb.append(element.value).append("-");
        }
        return sb.toString().split("-");
    }

    public static byte[] bytesFromValue(String v) {
        byte[] bytes = new byte[]{13, 10};
        switch (LineEndingTypes.fromValue(v)) {
            case CRLF: {
                return new byte[]{13, 10};
            }
            case CR: {
                return new byte[]{13};
            }
            case LF: {
                return new byte[]{10};
            }
        }
        return bytes;
    }

    public static String valueFrom(byte[] bytes) {
        String value = LineEndingTypes.CRLF.value;
        if (bytes[0] == 10) {
            value = LineEndingTypes.LF.value;
        } else if (bytes[0] == 13 && bytes.length > 1 && bytes[1] == 10) {
            value = LineEndingTypes.CRLF.value;
        } else if (bytes[0] == 13 && bytes.length == 1) {
            value = LineEndingTypes.CR.value;
        }
        return value;
    }
}

