/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.exception.ApplicationConfigurationException;
import gde.exception.FailedQueryException;
import gde.exception.ReadWriteOutOfSyncException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.OperatingSystemHelper;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import gde.utils.WindowsHelper;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsbException;

public class DeviceSerialPortImpl
implements IDeviceCommPort,
SerialPortEventListener {
    static final String $CLASS_NAME = DeviceSerialPortImpl.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final DeviceConfiguration deviceConfig;
    protected final DataExplorer application;
    final Settings settings;
    protected SerialPort serialPort = null;
    protected int xferErrors = 0;
    protected int queryErrors = 0;
    protected int timeoutErrors = 0;
    boolean isConnected = false;
    String serialPortStr = "";
    Thread closeThread;
    CommPortIdentifier portId;
    CommPortIdentifier saveportId;
    InputStream inputStream = null;
    OutputStream outputStream = null;

    public DeviceSerialPortImpl(DeviceConfiguration currentDeviceConfig, DataExplorer currentApplication) {
        this.deviceConfig = currentDeviceConfig;
        this.application = currentApplication;
        this.settings = Settings.getInstance();
    }

    public DeviceSerialPortImpl() {
        this.deviceConfig = null;
        this.application = null;
        this.settings = null;
    }

    public static synchronized TreeMap<String, String> listConfiguredSerialPorts(boolean doAvialabilityCheck, String portBlackList, Vector<String> portWhiteList) {
        String $METHOD_NAME = "listConfiguredSerialPorts";
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "listConfiguredSerialPorts", "entry");
        }
        if (GDE.IS_WINDOWS) {
            try {
                WindowsHelper.registerSerialPorts();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, Messages.getString("GDE_MSGW0035"));
            }
        }
        try {
            CommPortIdentifier commPortIdentifier;
            DeviceCommPort.availablePorts.clear();
            if (portWhiteList.size() > 0) {
                for (String serialPortStr : portWhiteList) {
                    try {
                        commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)serialPortStr);
                        if (commPortIdentifier.getPortType() != 1 || commPortIdentifier.isCurrentlyOwned()) continue;
                        try {
                            if (doAvialabilityCheck) {
                                ((SerialPort)commPortIdentifier.open("DataExplorer", 1000)).close();
                            }
                            DeviceCommPort.availablePorts.put(serialPortStr, "");
                            if (!log.isLoggable(Level.FINER)) continue;
                            log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found available port: " + serialPortStr);
                        }
                        catch (Exception e) {
                            if (!log.isLoggable(Level.FINER)) continue;
                            log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found port, but in use: " + serialPortStr);
                        }
                    }
                    catch (NoSuchPortException e) {
                        log.logp(Level.WARNING, $CLASS_NAME, "listConfiguredSerialPorts", ((Object)((Object)e)).getClass().getName() + " - " + serialPortStr);
                    }
                }
            } else {
                Enumeration enumIdentifiers = CommPortIdentifier.getPortIdentifiers();
                while (enumIdentifiers.hasMoreElements()) {
                    commPortIdentifier = (CommPortIdentifier)enumIdentifiers.nextElement();
                    String serialPortStr = commPortIdentifier.getName();
                    if (portBlackList.contains(serialPortStr) || commPortIdentifier.getPortType() != 1 || commPortIdentifier.isCurrentlyOwned()) continue;
                    try {
                        if (doAvialabilityCheck) {
                            ((SerialPort)commPortIdentifier.open("DataExplorer", 1000)).close();
                        }
                        DeviceCommPort.availablePorts.put(serialPortStr, "");
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found available port: " + serialPortStr);
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.logp(Level.FINER, $CLASS_NAME, "listConfiguredSerialPorts", "Found port, but in use: " + serialPortStr);
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder().append("Available serial Ports : ");
                for (String comPort : DeviceCommPort.availablePorts.keySet()) {
                    sb.append(comPort).append(" ");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, $CLASS_NAME, "listConfiguredSerialPorts", sb.toString());
                }
            }
            if (GDE.IS_MAC) {
                Iterator<String> iterator = DeviceCommPort.availablePorts.keySet().iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().contains("cu.")) continue;
                    iterator.remove();
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.getMessage(), t);
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "listConfiguredSerialPorts", "exit");
        }
        return DeviceCommPort.availablePorts;
    }

    public static String[] prepareSerialPortList() {
        String[] serialPortList = new String[DeviceCommPort.availablePorts.size()];
        String[] tmpSerialPortList = DeviceCommPort.availablePorts.keySet().toArray(new String[DeviceCommPort.availablePorts.size()]);
        for (int i = 0; i < tmpSerialPortList.length; ++i) {
            if (GDE.IS_WINDOWS) {
                try {
                    int portNumber = Integer.parseInt(tmpSerialPortList[i].substring(3));
                    String portDescription = DeviceCommPort.getWindowsPorts().get(portNumber) == null ? "" : DeviceCommPort.getWindowsPorts().get(portNumber);
                    serialPortList[i] = " " + tmpSerialPortList[i] + " - " + portDescription;
                }
                catch (Exception e) {
                    serialPortList[i] = " " + tmpSerialPortList[i];
                }
                continue;
            }
            if (GDE.IS_LINUX) {
                String portName = OperatingSystemHelper.dereferenceLink("/dev/serial/by-id", tmpSerialPortList[i].substring(tmpSerialPortList[i].lastIndexOf(47)));
                if (portName.length() > 8) {
                    serialPortList[i] = " " + tmpSerialPortList[i] + " - " + portName.substring(portName.indexOf("usb-") + 4, portName.length() - 11);
                    continue;
                }
                serialPortList[i] = " " + tmpSerialPortList[i];
                continue;
            }
            serialPortList[i] = " " + tmpSerialPortList[i];
        }
        return serialPortList;
    }

    @Override
    public boolean isMatchAvailablePorts(String newSerialPortStr) {
        boolean match = false;
        if (DeviceCommPort.availablePorts.size() == 0 || this.serialPortStr != null && !DeviceCommPort.availablePorts.keySet().contains(this.serialPortStr)) {
            DeviceSerialPortImpl.listConfiguredSerialPorts(false, this.settings.isSerialPortBlackListEnabled() ? this.settings.getSerialPortBlackList() : "", this.settings.isSerialPortWhiteListEnabled() ? this.settings.getSerialPortWhiteList() : new Vector<String>());
        }
        for (String availablePort : DeviceCommPort.availablePorts.keySet()) {
            if (!availablePort.equals(newSerialPortStr)) continue;
            match = true;
            break;
        }
        return match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SerialPort open() throws ApplicationConfigurationException, SerialPortException {
        String $METHOD_NAME = "open";
        this.timeoutErrors = 0;
        this.xferErrors = 0;
        try {
            this.serialPortStr = this.deviceConfig.getPort();
            if (this.serialPortStr == null || this.serialPortStr.length() < 4 || !this.isMatchAvailablePorts(this.serialPortStr)) {
                if (DeviceCommPort.availablePorts.size() != 1 || this.serialPortStr == null || this.isMatchAvailablePorts(this.serialPortStr)) throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0010"));
                if (64 != this.application.openYesNoMessageDialogSync(Messages.getString("GDE_MSGE0010") + GDE.LINE_SEPARATOR + Messages.getString("GDE_MSGT0194", new String[]{this.serialPortStr = DeviceCommPort.availablePorts.firstKey()}))) throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0010"));
                this.serialPortStr = DeviceCommPort.availablePorts.firstKey();
                this.deviceConfig.setPort(this.serialPortStr);
                this.deviceConfig.storeDeviceProperties();
                this.application.updateTitleBar();
            }
            log.logp(Level.FINE, $CLASS_NAME, "open", String.format("serialPortString = %s; baudeRate = %d; dataBits = %s; stopBits = %s; parity = %s; flowControlMode = %s; RTS = %s; DTR = %s", new Object[]{this.serialPortStr, this.deviceConfig.getBaudeRate(), this.deviceConfig.getDataBits(), this.deviceConfig.getStopBits(), this.deviceConfig.getParity(), this.deviceConfig.getFlowCtrlMode(), this.deviceConfig.isRTS(), this.deviceConfig.isDTR()}));
            this.portId = CommPortIdentifier.getPortIdentifier((String)this.serialPortStr);
            this.serialPort = (SerialPort)this.portId.open("DataExplorer", 1000);
            this.serialPort.setSerialPortParams(this.deviceConfig.getBaudeRate().intValue(), this.deviceConfig.getDataBits().ordinal() + 5, this.deviceConfig.getStopBits().ordinal() + 1, this.deviceConfig.getParity().ordinal());
            this.serialPort.setFlowControlMode(this.deviceConfig.getFlowCtrlMode());
            this.serialPort.setInputBufferSize(2064);
            this.serialPort.setOutputBufferSize(2064);
            this.serialPort.setRTS(this.deviceConfig.isRTS());
            this.serialPort.setDTR(this.deviceConfig.isDTR());
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.isConnected = true;
            if (this.application == null) return this.serialPort;
            this.application.setPortConnected(true);
            return this.serialPort;
        }
        catch (ApplicationConfigurationException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "open", e.getMessage(), e);
            if (this.serialPort == null) throw e;
            this.serialPort.close();
            throw e;
        }
        catch (IOException e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", en.getMessage(), en);
            if (this.serialPort == null) throw en;
            this.serialPort.close();
            throw en;
        }
        catch (NoSuchPortException e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", en.getMessage(), en);
            if (this.serialPort == null) throw en;
            this.serialPort.close();
            throw en;
        }
        catch (UnsupportedCommOperationException e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", en.getMessage(), en);
            if (this.serialPort == null) throw en;
            this.serialPort.close();
            throw en;
        }
        catch (PortInUseException e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", en.getMessage(), en);
            if (this.serialPort == null) throw en;
            this.serialPort.close();
            throw en;
        }
    }

    @Override
    public synchronized void write(byte[] writeBuffer) throws IOException {
        String $METHOD_NAME = "write";
        try {
            if (this.application != null) {
                this.application.setSerialTxOn();
            }
            this.cleanInputStream();
            this.outputStream.write(writeBuffer);
            if (GDE.IS_LINUX && GDE.IS_ARCH_DATA_MODEL_64) {
                this.outputStream.flush();
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "write", "Write : " + StringHelper.byte2Hex2CharString(writeBuffer, writeBuffer.length));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "write", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialTxOff();
            }
        }
    }

    @Override
    public synchronized void write(byte[] writeBuffer, long gap_ms) throws IOException {
        String $METHOD_NAME = "write";
        try {
            if (this.application != null) {
                this.application.setSerialTxOn();
            }
            this.cleanInputStream();
            for (int i = 0; i < writeBuffer.length; ++i) {
                this.outputStream.write(writeBuffer[i]);
                WaitTimer.delay(gap_ms);
            }
            if (GDE.IS_LINUX && GDE.IS_ARCH_DATA_MODEL_64) {
                this.outputStream.flush();
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "write", "Write : " + StringHelper.byte2Hex2CharString(writeBuffer, writeBuffer.length));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "write", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialTxOff();
            }
        }
    }

    @Override
    public int cleanInputStream() throws IOException {
        String $METHOD_NAME = "cleanInputStream";
        int num = 0;
        num = this.inputStream.available();
        if (num != 0) {
            this.inputStream.read(new byte[num]);
            log.logp(Level.WARNING, $CLASS_NAME, "cleanInputStream", "clean inputStream left bytes -> " + num);
        }
        return num;
    }

    public void serialEvent(SerialPortEvent event) {
        String $METHOD_NAME = "serialEvent";
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (!log.isLoggable(Level.FINE)) break;
                log.logp(Level.FINE, $CLASS_NAME, "serialEvent", "OUTPUT_BUFFER_EMPTY");
                break;
            }
            case 1: {
                if (!log.isLoggable(Level.FINE)) break;
                log.logp(Level.FINE, $CLASS_NAME, "serialEvent", "DATA_AVAILABLE");
            }
        }
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 2;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / (sleepTime + 18);
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            this.wait4Bytes(bytes, timeout_msec - timeout_msec / 5);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (this.inputStream.available() > 0) {
                    readBytes += this.inputStream.read(readBuffer, 0 + readBytes, bytes - readBytes);
                }
                if (bytes != readBytes) {
                    WaitTimer.delay(sleepTime);
                }
                if (timeOutCounter > 0) continue;
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, boolean checkFailedQuery) throws IOException, FailedQueryException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 10;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / (sleepTime + 18);
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            WaitTimer.delay(2L);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (this.inputStream.available() > 0) {
                    readBytes += this.inputStream.read(readBuffer, 0 + readBytes, bytes - readBytes);
                }
                if (bytes != readBytes) {
                    WaitTimer.delay(sleepTime);
                }
                if (timeOutCounter > 0) continue;
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, Vector<Long> waitTimes) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            long startTime_ms = new Date().getTime();
            this.wait4Bytes(timeout_msec);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (bytes == (readBytes += this.inputStream.read(readBuffer, readBytes, bytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            long ms = new Date().getTime() - startTime_ms;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "waitTime = " + ms);
            }
            waitTimes.add(ms);
            log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public long wait4Bytes(int timeout_msec) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "wait4Bytes";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        while (0 == this.inputStream.available()) {
            WaitTimer.delay(sleepTime);
            if (timeOutCounter-- > 0) continue;
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
            log.logp(Level.WARNING, $CLASS_NAME, "wait4Bytes", e.getMessage(), e);
            throw e;
        }
        return System.currentTimeMillis();
    }

    @Override
    public int wait4Bytes(int numBytes, int timeout_msec) throws IOException {
        String $METHOD_NAME = "wait4Bytes";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int resBytes = 0;
        while ((resBytes = this.inputStream.available()) < numBytes) {
            WaitTimer.delay(sleepTime);
            if (--timeOutCounter > 0) continue;
            log.logp(Level.WARNING, $CLASS_NAME, "wait4Bytes", String.format("only %d of %d Bytes are available in %d msec", resBytes, numBytes, timeout_msec));
            break;
        }
        return resBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int numAvailableBytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry");
        }
        if (stableIndex >= timeOutCounter) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", Messages.getString("GDE_MSGE0013"));
        }
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            if ((numAvailableBytes = this.waitForStableReceiveBuffer(numAvailableBytes, timeout_msec, stableIndex)) > readBuffer.length) {
                readBuffer = new byte[numAvailableBytes];
            }
            while (readBytes < numAvailableBytes && timeOutCounter-- > 0) {
                if (numAvailableBytes == (readBytes += this.inputStream.read(readBuffer, 0 + readBytes, numAvailableBytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{numAvailableBytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (readBytes < readBuffer.length) {
                byte[] tmpBuffer = new byte[readBytes];
                System.arraycopy(readBuffer, 0, tmpBuffer, 0, readBytes);
                readBuffer = tmpBuffer;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex, int minCountBytes) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int expectedBytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        if (stableIndex >= timeOutCounter) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", Messages.getString("GDE_MSGE0013"));
        }
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            expectedBytes = this.waitForStableReceiveBuffer(expectedBytes, timeout_msec, stableIndex, minCountBytes);
            while (readBytes < expectedBytes && timeOutCounter-- > 0) {
                if (expectedBytes == (readBytes += this.inputStream.read(readBuffer, 0 + readBytes, expectedBytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (readBytes < readBuffer.length) {
                byte[] tmpBuffer = new byte[readBytes];
                System.arraycopy(readBuffer, 0, tmpBuffer, 0, readBytes);
                readBuffer = tmpBuffer;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "waitForStableReceiveBuffer";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int stableCounter = stableIndex;
        boolean isStable = false;
        boolean isTimedOut = false;
        int byteCounter = 0;
        int numBytesAvailable = 0;
        while (byteCounter < expectedBytes && !isStable && !isTimedOut) {
            WaitTimer.delay(sleepTime);
            numBytesAvailable = this.inputStream.available();
            if (byteCounter == numBytesAvailable && byteCounter > 0) {
                if (log.isLoggable(Level.FINER)) {
                    log.logp(Level.FINER, $CLASS_NAME, "waitForStableReceiveBuffer", "stableCounter = " + stableCounter + " byteCounter = " + byteCounter);
                }
                --stableCounter;
            } else {
                stableCounter = stableIndex;
            }
            if (stableCounter == 0) {
                isStable = true;
            }
            byteCounter = numBytesAvailable;
            if (--timeOutCounter != 0) continue;
            log.logp(Level.SEVERE, $CLASS_NAME, "waitForStableReceiveBuffer", String.format("byteCounter = %d numBytesAvailable = %d", byteCounter, numBytesAvailable));
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
            throw e;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "waitForStableReceiveBuffer", "byteCounter = " + byteCounter + " timeOutCounter = " + timeOutCounter);
        }
        return byteCounter;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex, int minCount) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "waitForStableReceiveBuffer";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int stableCounter = stableIndex;
        boolean isStable = false;
        boolean isTimedOut = false;
        int byteCounter = 0;
        int numBytesAvailable = 0;
        while (byteCounter < expectedBytes && !isStable && !isTimedOut) {
            WaitTimer.delay(sleepTime);
            numBytesAvailable = this.inputStream.available();
            if (byteCounter == numBytesAvailable && byteCounter > minCount) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, $CLASS_NAME, "waitForStableReceiveBuffer", "stableCounter = " + stableCounter + " byteCounter = " + byteCounter);
                }
                --stableCounter;
            } else {
                stableCounter = stableIndex;
            }
            if (stableCounter == 0) {
                isStable = true;
            }
            byteCounter = numBytesAvailable;
            if (--timeOutCounter != 0) continue;
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
            log.logp(Level.SEVERE, $CLASS_NAME, "waitForStableReceiveBuffer", e.getMessage(), e);
            throw e;
        }
        log.logp(Level.FINE, $CLASS_NAME, "waitForStableReceiveBuffer", "byteCounter = " + byteCounter + " timeOutCounter = " + timeOutCounter);
        return byteCounter;
    }

    public void checkForLeftBytes() throws ReadWriteOutOfSyncException, IOException {
        String $METHOD_NAME = "checkForLeftBytes";
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "checkForLeftBytes", "inputStream available bytes = " + this.inputStream.available());
        }
        if (this.inputStream.available() != 0) {
            throw new ReadWriteOutOfSyncException(Messages.getString("GDE_MSGE0014"));
        }
    }

    @Override
    public synchronized void close() {
        String $METHOD_NAME = "close";
        if (this.isConnected && this.serialPort != null) {
            this.isConnected = false;
            this.closeThread = new Thread("closePort"){

                @Override
                public void run() {
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "entry");
                    try {
                        Thread.sleep(5L);
                        byte[] buf = new byte[DeviceSerialPortImpl.this.getInputStream().available()];
                        if (buf.length > 0) {
                            DeviceSerialPortImpl.this.getInputStream().read(buf);
                        }
                        DeviceSerialPortImpl.this.getOutputStream().flush();
                        Thread.sleep(5L);
                    }
                    catch (Throwable e) {
                        log.logp(Level.WARNING, $CLASS_NAME, "close", e.getMessage(), e);
                    }
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "before close");
                    DeviceSerialPortImpl.this.serialPort.close();
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "after close");
                    DeviceSerialPortImpl.this.isConnected = false;
                    if (DeviceSerialPortImpl.this.application != null) {
                        DeviceSerialPortImpl.this.application.setPortConnected(false);
                    }
                    log.logp(Level.CONFIG, $CLASS_NAME, "close", "exit");
                }
            };
            try {
                this.closeThread.start();
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    @Override
    public int getAvailableBytes() throws IOException {
        return this.inputStream.available();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public String getSerialPortStr() {
        return this.serialPortStr == null ? this.deviceConfig.getPort() : this.serialPortStr;
    }

    @Override
    public int getXferErrors() {
        return this.xferErrors;
    }

    @Override
    public void addXferError() {
        ++this.xferErrors;
    }

    @Override
    public void addTimeoutError() {
        ++this.timeoutErrors;
    }

    @Override
    public int getTimeoutErrors() {
        return this.timeoutErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block10: {
            Logger logger = Logger.getLogger("");
            logger.setLevel(Level.OFF);
            byte[] buffer = new byte[1024];
            try (DeviceSerialPortImpl impl = new DeviceSerialPortImpl();){
                if (args.length <= 0 || !args[0].startsWith("COM")) break block10;
                impl.portId = CommPortIdentifier.getPortIdentifier((String)args[0].trim());
                impl.serialPort = (SerialPort)impl.portId.open("Test", 1000);
                impl.serialPort.setSerialPortParams(19200, 8, 1, 0);
                impl.serialPort.setFlowControlMode(0);
                impl.serialPort.setInputBufferSize(1024);
                impl.serialPort.setOutputBufferSize(1024);
                impl.serialPort.setRTS(false);
                impl.serialPort.setDTR(false);
                impl.inputStream = impl.serialPort.getInputStream();
                impl.outputStream = impl.serialPort.getOutputStream();
                impl.isConnected = true;
                if (args.length > 1 && args[1].equals("sender")) {
                    for (int i = 1; i < 126; ++i) {
                        impl.write(new byte[]{(byte)i});
                    }
                    impl.wait4Bytes(1000);
                    int numBytes = 0;
                    int redBytes = 0;
                    while ((numBytes = impl.inputStream.available()) != 0) {
                        byte[] readBuffer = new byte[numBytes];
                        impl.read(readBuffer, 1000);
                        System.arraycopy(readBuffer, 0, buffer, redBytes, numBytes);
                        redBytes += numBytes;
                    }
                    System.out.println(StringHelper.byte2CharString(buffer, redBytes));
                    impl.close();
                    break block10;
                }
                while (true) {
                    impl.wait4Bytes(1000);
                    int numBytes = 0;
                    int redBytes = 0;
                    while ((numBytes = impl.inputStream.available()) != 0) {
                        byte[] readBuffer = new byte[numBytes];
                        impl.read(readBuffer, 1000);
                        System.arraycopy(readBuffer, 0, buffer, redBytes, numBytes);
                        redBytes += numBytes;
                    }
                    System.out.println(StringHelper.byte2CharString(buffer, redBytes));
                }
            }
        }
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId) throws UsbException {
        return null;
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        return null;
    }

    @Override
    public void dumpUsbDevices(short vendorId, short productId) throws UsbException {
    }

    @Override
    public UsbInterface openUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        return null;
    }

    @Override
    public DeviceHandle openLibUsbPort(IDevice activeDevice) throws LibUsbException, UsbException {
        return null;
    }

    @Override
    public void closeUsbPort(UsbInterface usbInterface) throws UsbClaimException, UsbException {
    }

    @Override
    public void closeLibUsbPort(DeviceHandle libUsbDeviceHanlde, boolean cacheSelectedUsbDevice) throws LibUsbException, UsbException {
    }

    @Override
    public int write(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data, int timeout_msec) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public void write(DeviceHandle handle, byte outEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
    }

    @Override
    public int read(DeviceHandle handle, byte inEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        return 0;
    }
}

