/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.GeniusWizard;
import gde.device.graupner.HoTTbinReader;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class GeniusWizardLogReader
extends HoTTbinReader {
    static final String $CLASS_NAMEX = GeniusWizardLogReader.class.getName();
    static final String PPRODUCT_NAME = "product_name";
    static final String PPRODUCT_CODE = "product_code";
    static final String PPRODUCT_VERSION = "product_version";
    static final String LOG_DATA_TYPE = "log_data_type";
    static final String LOG_DATA_COUNT = "log_data_count";
    static final String LOG_DATA_OFFSET = "log_data_offset";
    static final String LAP_DATA_SIZE = "lap_data_size";
    static final int headerSize = 128;
    static final Map<String, Object> header = new HashMap<String, Object>();
    static final int logDataSize = 51;
    static final StringBuilder lapData = new StringBuilder();
    static int[] points;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void read(String filePath) throws Exception {
        block10: {
            File inputFile = new File(filePath);
            FileInputStream file_input = new FileInputStream(inputFile);
            try (DataInputStream data_in = new DataInputStream(file_input);){
                if (inputFile.exists()) {
                    byte[] buffer = new byte[128];
                    data_in.read(buffer);
                    if (new String(buffer).contains("GENIUS")) {
                        byte[] flag = new byte[4];
                        System.arraycopy(buffer, 0, flag, 0, 4);
                        byte[] flagReverse = new byte[4];
                        System.arraycopy(buffer, 4, flagReverse, 0, 4);
                        for (int i = 0; i < flag.length; ++i) {
                            flag[i] = (byte)(255 - flag[i]);
                        }
                        byte[] productname = new byte[33];
                        System.arraycopy(buffer, 9, productname, 0, 33);
                        log.fine(() -> String.format("product name = %s", new String(productname)));
                        header.put(PPRODUCT_NAME, new String(productname));
                        byte[] logdatatype = new byte[4];
                        System.arraycopy(buffer, 49, logdatatype, 0, 4);
                        log.fine(() -> String.format("logdatatype = %s", StringHelper.byte2Hex2CharString((byte[])logdatatype)));
                        header.put(LOG_DATA_TYPE, StringHelper.byte2Hex2CharString((byte[])logdatatype));
                        byte[] logdatacount = new byte[4];
                        System.arraycopy(buffer, 53, logdatacount, 0, 4);
                        log.fine(() -> String.format("logdatacount = %d", DataParser.parse2Int((byte[])logdatacount, (int)0)));
                        header.put(LOG_DATA_COUNT, DataParser.parse2Int((byte[])logdatacount, (int)0));
                        header.put(LOG_DATA_OFFSET, inputFile.length() - (long)(DataParser.parse2Int((byte[])logdatacount, (int)0) * 51));
                        log.fine(() -> String.format("logdataoffset = %d", header.get(LOG_DATA_OFFSET)));
                        byte[] lapdatasize = new byte[4];
                        System.arraycopy(buffer, 57, lapdatasize, 0, 4);
                        log.fine(() -> String.format("lapdatasize = %d", DataParser.parse2Int((byte[])lapdatasize, (int)0)));
                        header.put(LAP_DATA_SIZE, DataParser.parse2Int((byte[])lapdatasize, (int)0));
                        if ((Integer)header.get(LAP_DATA_SIZE) > 0) {
                            // empty if block
                        }
                        GeniusWizardLogReader.readSingle(new File(filePath));
                        break block10;
                    }
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2408"));
                    throw new DataTypeException(Messages.getString((String)"GDE_MSGW2408"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGW2409"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void readSingle(File file) throws IOException, DataInconsitsentException {
        String $METHOD_NAME = "readSingle";
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        GeniusWizard device = (GeniusWizard)application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        String recordSetName = "";
        Channel channel = null;
        recordSetESC = null;
        points = new int[device.getNumberOfMeasurements(1)];
        double startLogTimeStamp_ms = 0.0;
        double lastLogTimeStamp_ms = 0.0;
        int numTimeStamps = 0;
        buf = new byte[51];
        long numberDatablocks = (fileSize - 128L - (long)((Integer)header.get(LAP_DATA_SIZE)).intValue()) / 51L;
        long startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        try {
            HoTTbinReader.recordSets.clear();
            channel = (Channel)channels.get((Object)1);
            channel.setFileDescription(application.isObjectoriented() ? date + " " + application.getObjectKey() : date);
            recordSetName = String.format("%d) %s[%s]", recordSetNumber, device.getRecordSetStateNameReplacement(1), file.getName().substring(0, file.getName().lastIndexOf(46)));
            recordSetESC = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)1, (boolean)true, (boolean)true, (boolean)true);
            channel.put((Object)recordSetName, (Object)recordSetESC);
            recordSetESC = (RecordSet)channel.get((Object)recordSetName);
            recordSetESC.setRecordSetDescription(String.format("%s - %s %s\n%s", device.getName(), Messages.getString((String)"GDE_MSGT0129"), dateTime, header.get(PPRODUCT_NAME)));
            recordSetESC.setStartTimeStamp(startTimeStamp_ms);
            if (GDE.isWithUi()) {
                channel.applyTemplate(recordSetName, false);
            }
            data_in.skip(128 - (Integer)header.get(LAP_DATA_SIZE));
            int i = 0;
            while ((long)i < numberDatablocks) {
                block10: {
                    block12: {
                        double logTimeStamp_ms;
                        block11: {
                            data_in.read(buf);
                            if (log.isLoggable(Level.FINE)) {
                                log.logp(Level.FINE, $CLASS_NAMEX, "readSingle", StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                            }
                            if ((logTimeStamp_ms = (double)DataParser.parse2Int((byte[])buf, (int)46) * 10.0) != 0.0 && startLogTimeStamp_ms == 0.0) {
                                startLogTimeStamp_ms = logTimeStamp_ms;
                            }
                            if (!(logTimeStamp_ms > lastLogTimeStamp_ms)) break block11;
                            recordSetESC.addPoints(device.convertDataBytes(points, buf), logTimeStamp_ms - startLogTimeStamp_ms);
                            lastLogTimeStamp_ms = logTimeStamp_ms;
                            if (i % progressIndicator != 0) break block10;
                            break block12;
                        }
                        if (logTimeStamp_ms == lastLogTimeStamp_ms) {
                            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGW2411", (Object[])new Object[]{++numTimeStamps}), 3);
                            break block10;
                        } else {
                            if (numTimeStamps == 0) {
                                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGW2412"), 3);
                                break;
                            }
                            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGW2413", (Object[])new Object[]{numTimeStamps}), 3);
                            break;
                        }
                    }
                    GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                }
                ++i;
            }
            if (!GDE.isWithUi()) return;
            channel.applyTemplate(recordSetName, true);
            recordSetESC.descriptionAppendFilename(file.getName());
            channel.setActiveRecordSet(recordSetESC);
            menuToolBar.updateChannelSelector();
            menuToolBar.updateRecordSetSelectCombo();
            GDE.getUiNotification().setProgress(100);
            return;
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    protected static String getRecordSetExtend(File file) {
        String recordSetNameExtend;
        block6: {
            recordSetNameExtend = "";
            if (file.getName().contains("_")) {
                try {
                    Integer.parseInt(file.getName().substring(0, file.getName().lastIndexOf(95)));
                    recordSetNameExtend = " [" + file.getName().substring(0, file.getName().lastIndexOf(95)) + "]";
                }
                catch (Exception e) {
                    if (file.getName().substring(0, file.getName().lastIndexOf(95)).length() <= 8) {
                        recordSetNameExtend = " [" + file.getName().substring(0, file.getName().lastIndexOf(95)) + "]";
                    }
                    break block6;
                }
            }
            try {
                Integer.parseInt(file.getName().substring(0, 4));
                recordSetNameExtend = " [" + file.getName().substring(0, 4) + "]";
            }
            catch (Exception e) {
                if (file.getName().substring(0, file.getName().length()).length() > 12) break block6;
                recordSetNameExtend = " [" + file.getName().substring(0, file.getName().length() - 4) + "]";
            }
        }
        return recordSetNameExtend;
    }
}

