/*
 * Decompiled with CFR 0.152.
 */
package gde.device.devention;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.devention.DevoAdapter;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.MissMatchDeviceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Logger;

public class CSVReaderWriter {
    static Logger log = Logger.getLogger(CSVReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;
    static final String OFFSET_TIMER = "offset timer entries";
    static int hour;
    static int minute;
    static int second;
    static int year;
    static int month;
    static int day;
    static long startTimeStamp;
    static long lastTimeStamp;

    public static HashMap<String, String> getHeader(char separator, String filePath) throws NotSupportedFileFormatException, IOException {
        String line = "*";
        HashMap<String, String> header = new HashMap<String, String>();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
            line = reader.readLine();
            String[] headerData = line.split("" + separator);
            if (headerData.length > 2 || headerData.length < 1) {
                String tmpHeaderLine = application.getActiveDevice().getName() + separator + channels.getActiveChannel().getChannelConfigKey();
                headerData = tmpHeaderLine.split("" + separator);
            }
            for (int i = 0; i < headerData.length; ++i) {
                if (i == 0) {
                    header.put("DeviceName : ", headerData[i].split("\\r")[0].trim());
                }
                if (i != 1) continue;
                header.put("Channel/Configuration Name: ", headerData[i].split(" ")[0].split("\\r")[0].trim());
            }
            log.log(Level.FINE, "DeviceName : " + (String)header.get("DeviceName : "));
            log.log(Level.FINE, "Channel/Configuration Name: " + (header.get("Channel/Configuration Name: ") != null ? (String)header.get("Channel/Configuration Name: ") : ""));
            log.log(Level.FINE, "CSV_data_header : " + (header.get("CSV_data_header : ") != null ? (String)header.get("CSV_data_header : ") : ""));
            while (!line.toLowerCase().startsWith("timer") && (line = reader.readLine()) != null) {
            }
            header.put("CSV_data_header : ", line);
        }
        return header;
    }

    public static HashMap<String, String> evaluateType(char separator, HashMap<String, String> header, DeviceConfiguration deviceConfig) {
        StringBuilder sb_measurements = new StringBuilder();
        StringBuilder sb_units = new StringBuilder();
        int offsetTimer = 0;
        String headerLine = header.get("CSV_data_header : ");
        String[] headerLineArray = headerLine.split("" + separator);
        header.put("CSV_data_type : ", "raw");
        log.log(Level.FINE, "CSV_data_type : " + header.get("CSV_data_type : "));
        String channelConfig = header.get("Channel/Configuration Name: ");
        int channelNumber = channels.getChannelNumber(channelConfig);
        if (channelConfig != null && !channels.getActiveChannel().getChannelConfigKey().equals(channelConfig) && channelNumber >= 1 && channelNumber <= deviceConfig.getChannelCount()) {
            channels.setActiveChannelNumber(channelNumber);
        } else {
            channelConfig = channels.getActiveChannel().getChannelConfigKey();
            channels.setActiveChannelNumber(channels.getActiveChannelNumber());
            channelNumber = channels.getActiveChannelNumber();
        }
        header.put("Channel/Configuration Name: ", channelConfig);
        header.put("Channel/Configuration Number : ", "" + channels.getActiveChannelNumber());
        log.log(Level.FINE, "Channel/Configuration Name: " + header.get("Channel/Configuration Number : ") + " : " + header.get("Channel/Configuration Name: "));
        for (String element : headerLineArray) {
            if (element.toLowerCase().startsWith("timer")) {
                header.put(OFFSET_TIMER, ++offsetTimer + "");
                continue;
            }
            String mappedMeasurement = DevoAdapter.properties.getProperty(element);
            if (mappedMeasurement == null) {
                mappedMeasurement = String.format("%s [-]", element);
            }
            int count = 1;
            for (String measurement : sb_measurements.toString().split(";")) {
                if (!mappedMeasurement.split("\\[|]")[0].trim().equals(measurement)) continue;
                mappedMeasurement = String.format("%s %d [%s]", mappedMeasurement.split("\\[|]")[0].trim().indexOf(32) > 0 ? mappedMeasurement.substring(0, mappedMeasurement.indexOf(32)) : mappedMeasurement.split("\\[|]")[0].trim(), count++, mappedMeasurement.split("\\[|]")[1]);
            }
            log.log(Level.FINE, "corrected mappedMeasurement = " + mappedMeasurement);
            String[] inHeaderMeasurement = mappedMeasurement.trim().split("\\[|]");
            String inMeasurement = inHeaderMeasurement.length >= 1 ? inHeaderMeasurement[0].trim() : "---";
            String inUnit = inHeaderMeasurement.length == 2 ? inHeaderMeasurement[1].trim() : "---";
            sb_measurements.append(inMeasurement).append(";");
            sb_units.append(inUnit).append(";");
        }
        header.put("CSV_data_header_measurements : ", sb_measurements.toString());
        header.put("CSV_data_header_units : ", sb_units.toString());
        return header;
    }

    public static RecordSet read(char separator, String filePath, String recordSetNameExtend) throws NotSupportedFileFormatException, MissMatchDeviceException, IOException, DataInconsitsentException, DataTypeException {
        RecordSet recordSet;
        block29: {
            String line = "";
            String startLine = null;
            recordSet = null;
            long inputFileSize = new File(filePath).length();
            int progressLineLength = Math.abs(application.getActiveDevice().getDataBlockSize(InputTypes.FILE_IO));
            IDevice device = application.getActiveDevice();
            Channel activeChannel = null;
            lastTimeStamp = 0L;
            try {
                int i;
                HashMap<String, String> fileHeader = CSVReaderWriter.getHeader(separator, filePath);
                activeChannel = (Channel)channels.get((Object)channels.getChannelNumber(fileHeader.get("Channel/Configuration Name: ")));
                Channel channel = activeChannel = activeChannel == null ? channels.getActiveChannel() : activeChannel;
                if (activeChannel == null) break block29;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0134") + filePath);
                GDE.getUiNotification().setProgress(0);
                int time_ms = 0;
                if (!application.getActiveDevice().getName().equals(fileHeader.get("DeviceName : "))) {
                    MissMatchDeviceException e = new MissMatchDeviceException(Messages.getString((String)"GDE_MSGW0013", (Object[])new Object[]{fileHeader.get("DeviceName : ")}));
                    log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    throw e;
                }
                fileHeader = CSVReaderWriter.evaluateType(separator, fileHeader, (DeviceConfiguration)device);
                log.log(Level.FINE, "device name check ok, channel/configuration ok");
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                while (!line.toLowerCase().startsWith("timer") && (line = reader.readLine()) != null) {
                }
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                String[] tmpRecordNames = fileHeader.get("CSV_data_header_measurements : ").split(";");
                String[] tmpRecordUnits = fileHeader.get("CSV_data_header_units : ").split(";");
                String[] tmpRecordSymbols = new String[tmpRecordNames.length];
                for (i = 0; i < tmpRecordNames.length; ++i) {
                    tmpRecordSymbols[i] = "";
                }
                recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannel.getNumber(), (String[])tmpRecordNames, (String[])tmpRecordSymbols, (String[])tmpRecordUnits, (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
                recordSetName = recordSet.getName();
                for (i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    if (record.getUnit().equals("km/h") || record.getUnit().equals("m/s")) {
                        record.setDataType(Record.DataType.GPS_SPEED);
                        continue;
                    }
                    if (record.getUnit().equals("m") && (record.getName().toLowerCase().contains("alti") || record.getName().toLowerCase().contains("h\u00f6he"))) {
                        record.setDataType(Record.DataType.GPS_ALTITUDE);
                        continue;
                    }
                    if (record.getUnit().contains("\u00b0") && record.getUnit().contains("'") && (record.getName().toLowerCase().contains("long") || record.getName().toLowerCase().contains("l\u00e4nge"))) {
                        record.setDataType(Record.DataType.GPS_LONGITUDE);
                        continue;
                    }
                    if (record.getUnit().contains("\u00b0") && record.getUnit().contains("'") && (record.getName().toLowerCase().contains("lat") || record.getName().toLowerCase().contains("breit"))) {
                        record.setDataType(Record.DataType.GPS_LATITUDE);
                        continue;
                    }
                    if (!record.getName().contains("GPS") || !record.getName().toLowerCase().contains("time")) continue;
                    record.setDataType(Record.DataType.GPS_TIME);
                }
                startTimeStamp = (long)((double)new File(filePath).lastModified() - recordSet.getMaxTime_ms());
                int offsetTimerEntries = Integer.valueOf(fileHeader.get(OFFSET_TIMER));
                int gpsTimeRecordOrdinal = recordSet.getRecordOrdinalOfDataType(Record.DataType.GPS_TIME);
                if (gpsTimeRecordOrdinal >= 0) {
                    while ((line = reader.readLine()) != null) {
                        if (Integer.valueOf(line.split("" + separator)[0].replace(":", "")) == 0) {
                            startLine = line;
                            continue;
                        }
                        String gpsTime = startLine.split("" + separator)[gpsTimeRecordOrdinal + offsetTimerEntries];
                        hour = Integer.parseInt(gpsTime.substring(0, 2));
                        minute = Integer.parseInt(gpsTime.substring(3, 5));
                        second = Integer.parseInt(gpsTime.substring(6, 8));
                        year = Integer.parseInt(gpsTime.substring(9, 13));
                        month = Integer.parseInt(gpsTime.substring(14, 16));
                        day = Integer.parseInt(gpsTime.substring(17));
                        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                        startTimeStamp = calendar.getTimeInMillis();
                        recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                        break;
                    }
                } else {
                    recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                }
                recordSet.setStartTimeStamp(startTimeStamp);
                activeChannel.setFileDescription(new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp).substring(0, 10) + activeChannel.getFileDescription().substring(10));
                GregorianCalendar date = new GregorianCalendar();
                date.setTime(new Date(recordSet.getStartTimeStamp()));
                year = date.get(1);
                month = date.get(2) + 1;
                day = date.get(5);
                String[] updateRecordNames = recordSet.getRecordNames();
                int[] points = new int[updateRecordNames.length];
                int lineNumber = 0;
                for (int i2 = 0; i2 < 2; ++i2) {
                    CSVReaderWriter.parseLineAddPoints(recordSet, offsetTimerEntries, updateRecordNames, points, i2 == 0 ? startLine : line, "" + separator);
                    ++lineNumber;
                }
                while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    String[] dataStr = line.split("" + separator);
                    String data = dataStr[0].trim().replace(',', '.');
                    if (data.contains(":")) {
                        int secondAdd;
                        int minuteAdd = Integer.parseInt(data.substring(0, 2));
                        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute + minuteAdd, second + (secondAdd = Integer.parseInt(data.substring(3, 5))));
                        long timeStamp = calendar.getTimeInMillis() + (long)(data.contains(".") ? Integer.parseInt(data.substring(data.lastIndexOf(46) + 1)) : 0);
                        if (lastTimeStamp > timeStamp) continue;
                        time_ms = (int)(lastTimeStamp == 0L ? 0L : (long)time_ms + (timeStamp - lastTimeStamp));
                        lastTimeStamp = timeStamp;
                        if (startTimeStamp == 0L) {
                            startTimeStamp = timeStamp;
                        }
                    } else {
                        time_ms = Integer.valueOf(data);
                    }
                    CSVReaderWriter.parseLineAddPoints(recordSet, offsetTimerEntries, updateRecordNames, points, line, "" + separator);
                    int progress = (int)((long)(lineNumber * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length())));
                    if (progress > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                    GDE.getUiNotification().setProgress(progress);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                recordSet.setSaved(true);
                activeChannel.put((Object)recordSetName, (Object)recordSet);
                activeChannel.setActiveRecordSet(recordSetName);
                activeChannel.applyTemplate(recordSetName, true);
                recordSet.updateVisibleAndDisplayableRecordsForTable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet(recordSetName);
                }
                reader.close();
                reader = null;
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new UnsupportedEncodingException(Messages.getString((String)"GDE_MSGW0010"));
            }
            catch (FileNotFoundException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
            }
            finally {
                GDE.getUiNotification().setProgress(100);
                GDE.getUiNotification().setStatusMessage("");
                if (GDE.isWithUi()) {
                    application.getMenuToolBar().updateChannelSelector();
                    application.getMenuToolBar().updateRecordSetSelectCombo();
                }
            }
        }
        return recordSet;
    }

    protected static void parseLineAddPoints(RecordSet recordSet, int offsetTimer, String[] updateRecordNames, int[] points, String line, String separator) throws DataInconsitsentException {
        String[] dataStr = line.split(separator);
        String strValue = dataStr[0].trim();
        int minuteAdd = Integer.parseInt(strValue.substring(0, 2));
        int secondAdd = Integer.parseInt(strValue.substring(3, 5));
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute + minuteAdd, second + secondAdd);
        long timeStamp = calendar.getTimeInMillis() + (long)(strValue.contains(".") ? Integer.parseInt(strValue.substring(strValue.lastIndexOf(46) + 1)) : 0);
        int time_ms = 0;
        if (lastTimeStamp > timeStamp) {
            return;
        }
        time_ms = (int)(lastTimeStamp == 0L ? 0L : (long)time_ms + (timeStamp - lastTimeStamp));
        lastTimeStamp = timeStamp;
        block8: for (int i = 0; i < updateRecordNames.length; ++i) {
            try {
                strValue = dataStr[i + offsetTimer].trim();
            }
            catch (Exception e) {
                strValue = "0";
                log.log(Level.WARNING, String.format("Check line = %s", line));
            }
            switch (recordSet.get(i).getDataType()) {
                case GPS_LONGITUDE: 
                case GPS_LATITUDE: {
                    int latLong = Integer.valueOf(strValue.replace(" ", "").replace(".", ""));
                    int grad = latLong / 10000000;
                    int minuten = (latLong - grad * 10000000) / 100000;
                    double seconds = ((double)latLong - (double)grad * 1.0E7 - (double)minuten * 100000.0) / 1000.0;
                    points[i] = (int)(((double)grad + ((double)minuten + seconds / 60.0) / 100.0) * 1000000.0);
                    continue block8;
                }
                case GPS_TIME: {
                    int hourNew = Integer.valueOf(strValue.substring(0, 2));
                    int minuteNew = Integer.parseInt(strValue.substring(3, 5));
                    int secondNew = Integer.parseInt(strValue.substring(6, 8));
                    calendar = new GregorianCalendar(year, month - 1, day, hourNew, minuteNew, secondNew);
                    long timeStampNew = calendar.getTimeInMillis();
                    points[i] = (int)(timeStampNew - startTimeStamp);
                    continue block8;
                }
                default: {
                    try {
                        points[i] = Double.valueOf(Double.valueOf(strValue) * 1000.0).intValue();
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        points[i] = 0;
                    }
                }
            }
        }
        recordSet.addPoints(points, (double)((minuteAdd * 60 + secondAdd) * 1000));
    }

    public static void write(char separator, String recordSetKey, String filePath, boolean isRaw) throws Exception {
        try {
            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0138", (Object[])new String[]{"csv", filePath}));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "ISO-8859-1"));
            char decimalSeparator = Settings.getInstance().getDecimalSeparator();
            df3.setGroupingUsed(false);
            sb = new StringBuffer();
            RecordSet recordSet = (RecordSet)Channels.getInstance().getActiveChannel().get((Object)recordSetKey);
            IDevice device = DataExplorer.getInstance().getActiveDevice();
            sb.append(device.getName()).append(separator).append(recordSet.getChannelConfigName()).append(lineSep);
            writer.write(sb.toString());
            log.log(Level.FINE, "written header line = " + sb.toString());
            sb = new StringBuffer();
            sb.append(Messages.getString((String)"GDE_MSGT0137")).append(separator);
            for (int i = 0; i < recordSet.size(); ++i) {
                MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), i);
                Record record = recordSet.get(i);
                log.log(Level.FINEST, "append " + record.getName());
                if (isRaw) {
                    if (measurement.isCalculation()) continue;
                    sb.append(record.getName()).append(" [---]").append(separator);
                    log.log(Level.FINEST, "append " + record.getName());
                    continue;
                }
                sb.append(record.getName()).append(" [").append(record.getUnit()).append(']').append(separator);
                log.log(Level.FINEST, "append " + record.getName());
            }
            sb.deleteCharAt(sb.length() - 1).append(lineSep);
            log.log(Level.FINER, "header line = " + sb.toString());
            writer.write(sb.toString());
            long startTime = new Date(recordSet.getTime(0)).getTime();
            int recordEntries = recordSet.getRecordDataSize(true);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            for (int i = 0; i < recordEntries; ++i) {
                sb = new StringBuffer();
                String[] row = recordSet.getExportRow(i, true);
                sb.append(row[0].replace('.', decimalSeparator)).append(separator).append(" ");
                for (int j = 0; j < recordSet.size(); ++j) {
                    MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), j);
                    if (isRaw) {
                        if (measurement.isCalculation()) continue;
                        if (recordSet.isRaw()) {
                            sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                            continue;
                        }
                        sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                        continue;
                    }
                    sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                }
                sb.deleteCharAt(sb.length() - 1).append(lineSep);
                writer.write(sb.toString());
                if (i % 50 == 0) {
                    GDE.getUiNotification().setProgress(++progressCycle * 5000 / recordEntries);
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "data line = " + sb.toString());
            }
            sb = null;
            log.log(Level.TIME, "CSV file = " + filePath + " erfolgreich geschiebenwrite time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
            writer.flush();
            writer.close();
            writer = null;
            GDE.getUiNotification().setProgress(100);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0006", (Object[])new Object[]{"csv", filePath, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
        hour = 0;
        minute = 0;
        second = 0;
        year = 0;
        month = 0;
        day = 0;
        startTimeStamp = 0L;
        lastTimeStamp = 0L;
    }
}

