/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.smmodellbau.UniLog;
import gde.device.smmodellbau.UniLogDialog;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.CalculationThread;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniLogConfigTab
extends Composite {
    static final Logger log = Logger.getLogger(UniLogConfigTab.class.getName());
    Button reveiverVoltageButton;
    CLabel receiverVoltageSymbol;
    CLabel receiverVoltageUnit;
    Button voltageButton;
    CLabel voltageSymbol;
    CLabel voltageUnit;
    Button currentButton;
    CLabel currentSymbol;
    CLabel currentUnit;
    Button currentInvertButton;
    CLabel revolutionSymbol;
    CLabel revolutionUnit;
    CLabel heightSymbol;
    CLabel heightUnit;
    CLabel prop100WUnit;
    CLabel numCellLabel;
    Group powerGroup;
    Text prop100WInput;
    Text numCellInput;
    CLabel etaUnit;
    CLabel etaSymbol;
    CLabel slopeUnit;
    CLabel slopeSymbol;
    CLabel etaButton;
    CLabel slopeLabel;
    Button revolutionButton;
    Button heightButton;
    CLabel capacityLabel;
    CLabel currentOffsetLabel;
    Text currentOffset;
    CLabel voltagePerCellUnit;
    CLabel voltagePerCellSymbol;
    CLabel energyUnit;
    CLabel energySymbol;
    CLabel powerUnit;
    CLabel powerSymbol;
    CLabel capacityUnit;
    CLabel capacitySymbol;
    CLabel voltagePerCellLabel;
    CLabel energyLabel;
    CLabel powerLabel;
    CLabel prop100WLabel;
    Group deviceConfigGroup;
    CLabel setConfigurationLabel;
    Button setConfigButton;
    Group axModusGroup;
    CLabel axName;
    CLabel axUnit;
    CLabel axOffset;
    CLabel axFactor;
    Button a1Button;
    Button a2Button;
    Button a3Button;
    Text a1Text;
    Text a2Text;
    Text a3Text;
    Text a1Unit;
    Text a2Unit;
    Text a3Unit;
    Text a1Factor;
    Text a2Factor;
    Text a3Factor;
    Text a1Offset;
    Text a2Offset;
    Text a3Offset;
    boolean isActiveUe;
    boolean isActiveU;
    boolean isActiveI;
    double offsetCurrent;
    boolean isActiveRPM;
    boolean isActiveHeight;
    int prop100WValue;
    int numCellValue;
    String slopeTypeSelection;
    int slopeTimeSelection;
    boolean isA1ModusAvailable;
    boolean isActiveA1;
    boolean isActiveA2;
    boolean isActiveA3;
    String nameA1;
    String nameA2;
    String nameA3;
    String unitA1;
    String unitA2;
    String unitA3;
    double offsetA1;
    double offsetA2;
    double offsetA3;
    double factorA1;
    double factorA2;
    double factorA3;
    String configName;
    final int configNumber;
    CLabel calculationTypeLabel;
    CCombo slopeCalculationTypeCombo;
    CCombo regressionTime;
    RecordSet lastActiveRecordSet;
    final UniLogDialog dialog;
    final UniLog device;
    final DataExplorer application;
    final Channels channels;

    public UniLogConfigTab(CTabFolder parent, UniLog useDevice, String tabName) {
        super((Composite)parent, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.isActiveUe = false;
        this.isActiveU = false;
        this.isActiveI = false;
        this.offsetCurrent = 0.0;
        this.isActiveRPM = false;
        this.isActiveHeight = false;
        this.prop100WValue = 3400;
        this.numCellValue = 12;
        this.slopeTypeSelection = CalculationThread.REGRESSION_TYPE_CURVE;
        this.isA1ModusAvailable = false;
        this.isActiveA1 = false;
        this.isActiveA2 = false;
        this.isActiveA3 = false;
        this.nameA1 = "-";
        this.nameA2 = "-";
        this.nameA3 = "-";
        this.unitA1 = "-";
        this.unitA2 = "-";
        this.unitA3 = "-";
        this.offsetA1 = 0.0;
        this.offsetA2 = 0.0;
        this.offsetA3 = 0.0;
        this.factorA1 = 1.0;
        this.factorA2 = 1.0;
        this.factorA3 = 1.0;
        this.lastActiveRecordSet = null;
        this.device = useDevice;
        this.configName = tabName;
        this.configNumber = parent.getItemCount() - 1;
        this.dialog = useDevice.getDialog();
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.initGUI();
        this.initialize();
    }

    private void initGUI() {
        try {
            FillLayout thisLayout = new FillLayout(256);
            this.setLayout((Layout)thisLayout);
            this.setSize(630, 340);
            this.setLayout(null);
            this.powerGroup = new Group((Composite)this, 0);
            this.powerGroup.setBounds(5, 2, 299, 331);
            this.powerGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.powerGroup.setText(Messages.getString((String)"GDE_MSGT1336"));
            this.powerGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1337"));
            this.powerGroup.addMouseTrackListener((MouseTrackListener)this.device.getDialog().mouseTrackerEnterFadeOut);
            this.powerGroup.setLayout((Layout)new RowLayout(256));
            this.reveiverVoltageButton = new Button((Composite)this.powerGroup, 16416);
            this.reveiverVoltageButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reveiverVoltageButton.setLayoutData((Object)new RowData(120, 18));
            this.reveiverVoltageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "reveiverVoltageButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveUe = UniLogConfigTab.this.reveiverVoltageButton.getSelection();
                    if (UniLogConfigTab.this.channels.getActiveChannel() != null && (activeRecordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                        activeRecordSet.get(0).setActive(Boolean.valueOf(UniLogConfigTab.this.isActiveUe));
                        activeRecordSet.get(0).setDisplayable(UniLogConfigTab.this.reveiverVoltageButton.getSelection());
                        UniLogConfigTab.this.application.updateGraphicsWindow();
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.receiverVoltageSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.receiverVoltageSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.receiverVoltageSymbol.setLayoutData((Object)new RowData(40, 18));
            this.receiverVoltageUnit = new CLabel((Composite)this.powerGroup, 0);
            this.receiverVoltageUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.receiverVoltageUnit.setLayoutData((Object)new RowData(40, 18));
            this.voltageButton = new Button((Composite)this.powerGroup, 16416);
            this.voltageButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageButton.setLayoutData((Object)new RowData(120, 18));
            this.voltageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "voltageButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveU = UniLogConfigTab.this.voltageButton.getSelection();
                    UniLogConfigTab.this.updateStateVoltageAndCurrentDependent(UniLogConfigTab.this.isActiveU && UniLogConfigTab.this.isActiveI);
                    UniLogConfigTab.this.updateStateVoltageCurrentRevolutionDependent(UniLogConfigTab.this.voltageButton.getSelection() && UniLogConfigTab.this.currentButton.getSelection() && UniLogConfigTab.this.revolutionButton.getSelection());
                    if (UniLogConfigTab.this.channels.getActiveChannel() != null && (activeRecordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                        activeRecordSet.get(1).setActive(Boolean.valueOf(UniLogConfigTab.this.voltageButton.getSelection()));
                        activeRecordSet.get(1).setDisplayable(UniLogConfigTab.this.voltageButton.getSelection());
                        UniLogConfigTab.this.application.updateGraphicsWindow();
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.voltageSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.voltageSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageSymbol.setLayoutData((Object)new RowData(40, 18));
            this.voltageUnit = new CLabel((Composite)this.powerGroup, 0);
            this.voltageUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageUnit.setLayoutData((Object)new RowData(60, 18));
            this.currentButton = new Button((Composite)this.powerGroup, 16416);
            this.currentButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentButton.setLayoutData((Object)new RowData(80, 18));
            this.currentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "currentButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveI = UniLogConfigTab.this.currentButton.getSelection();
                    UniLogConfigTab.this.updateStateCurrentDependent(UniLogConfigTab.this.isActiveI);
                    UniLogConfigTab.this.updateStateVoltageAndCurrentDependent(UniLogConfigTab.this.voltageButton.getSelection() && UniLogConfigTab.this.currentButton.getSelection());
                    UniLogConfigTab.this.updateStateVoltageCurrentRevolutionDependent(UniLogConfigTab.this.voltageButton.getSelection() && UniLogConfigTab.this.currentButton.getSelection() && UniLogConfigTab.this.revolutionButton.getSelection());
                    if (UniLogConfigTab.this.channels.getActiveChannel() != null && (activeRecordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                        activeRecordSet.get(2).setActive(Boolean.valueOf(UniLogConfigTab.this.currentButton.getSelection()));
                        activeRecordSet.get(2).setDisplayable(UniLogConfigTab.this.currentButton.getSelection());
                        UniLogConfigTab.this.application.updateGraphicsWindow();
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.currentInvertButton = new Button((Composite)this.powerGroup, 0x1000008);
            this.currentInvertButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentInvertButton.setLayoutData((Object)new RowData(35, 18));
            this.currentInvertButton.setText(Messages.getString((String)"GDE_MSGT1338"));
            this.currentInvertButton.setToolTipText(Messages.getString((String)"GDE_MSGT1339"));
            this.currentInvertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Channel activeChannel;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "currentButton.widgetSelected, event=" + evt);
                    }
                    if ((activeChannel = UniLogConfigTab.this.channels.getActiveChannel()) != null && activeChannel.getActiveRecordSet() != null) {
                        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                        Record currentRecord = activeRecordSet.get(2);
                        UniLogConfigTab.this.device.invertRecordData(currentRecord);
                        UniLogConfigTab.this.application.updateAllTabs(true);
                    }
                }
            });
            this.currentSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.currentSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentSymbol.setLayoutData((Object)new RowData(40, 18));
            this.currentUnit = new CLabel((Composite)this.powerGroup, 0);
            this.currentUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentUnit.setLayoutData((Object)new RowData(20, 18));
            this.currentOffsetLabel = new CLabel((Composite)this.powerGroup, 16384);
            this.currentOffsetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentOffsetLabel.setLayoutData((Object)new RowData(35, 18));
            this.currentOffsetLabel.setText(Messages.getString((String)"GDE_MSGT1340"));
            this.currentOffset = new Text((Composite)this.powerGroup, 2048);
            this.currentOffset.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentOffset.setLayoutData((Object)new RowData(40, 16));
            this.currentOffset.setToolTipText(Messages.getString((String)"GDE_MSGT1341"));
            this.currentOffset.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "currentOffset.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.offsetCurrent = Double.valueOf(UniLogConfigTab.this.currentOffset.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.capacityLabel = new CLabel((Composite)this.powerGroup, 16416);
            this.capacityLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityLabel.setLayoutData((Object)new RowData(120, 18));
            this.capacitySymbol = new CLabel((Composite)this.powerGroup, 0);
            this.capacitySymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacitySymbol.setLayoutData((Object)new RowData(40, 18));
            this.capacityUnit = new CLabel((Composite)this.powerGroup, 0);
            this.capacityUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityUnit.setLayoutData((Object)new RowData(40, 18));
            this.powerLabel = new CLabel((Composite)this.powerGroup, 16416);
            this.powerLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.powerLabel.setLayoutData((Object)new RowData(120, 18));
            this.powerSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.powerSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.powerSymbol.setLayoutData((Object)new RowData(40, 18));
            this.powerUnit = new CLabel((Composite)this.powerGroup, 0);
            this.powerUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.powerUnit.setLayoutData((Object)new RowData(40, 18));
            this.energyLabel = new CLabel((Composite)this.powerGroup, 16416);
            this.energyLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyLabel.setLayoutData((Object)new RowData(120, 18));
            this.energySymbol = new CLabel((Composite)this.powerGroup, 0);
            this.energySymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energySymbol.setLayoutData((Object)new RowData(40, 18));
            this.energyUnit = new CLabel((Composite)this.powerGroup, 0);
            this.energyUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyUnit.setLayoutData((Object)new RowData(40, 18));
            this.voltagePerCellLabel = new CLabel((Composite)this.powerGroup, 16416);
            this.voltagePerCellLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltagePerCellLabel.setLayoutData((Object)new RowData(120, 18));
            this.voltagePerCellSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.voltagePerCellSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltagePerCellSymbol.setLayoutData((Object)new RowData(40, 18));
            this.voltagePerCellUnit = new CLabel((Composite)this.powerGroup, 0);
            this.voltagePerCellUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltagePerCellUnit.setLayoutData((Object)new RowData(40, 18));
            this.numCellLabel = new CLabel((Composite)this.powerGroup, 16384);
            this.numCellLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numCellLabel.setLayoutData((Object)new RowData(120, 18));
            this.numCellLabel.setText(Messages.getString((String)"GDE_MSGT1342"));
            this.numCellInput = new Text((Composite)this.powerGroup, 18432);
            this.numCellInput.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numCellInput.setLayoutData((Object)new RowData(40, 16));
            this.numCellInput.setToolTipText(Messages.getString((String)"GDE_MSGT1343"));
            this.numCellInput.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "numCellInput.keyReleased, event=" + evt);
                    }
                    try {
                        if (evt.character == '\r') {
                            RecordSet recordSet;
                            UniLogConfigTab.this.setConfigButton.setEnabled(true);
                            UniLogConfigTab.this.numCellValue = Integer.valueOf(UniLogConfigTab.this.numCellInput.getText().trim());
                            UniLogConfigTab.this.numCellInput.setText(" " + UniLogConfigTab.this.numCellValue);
                            UniLogConfigTab.this.prop100WValue = Integer.valueOf(UniLogConfigTab.this.prop100WInput.getText().trim());
                            UniLogConfigTab.this.prop100WInput.setText(" " + UniLogConfigTab.this.prop100WValue);
                            if (UniLogConfigTab.this.channels.getActiveChannel() != null && (recordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                                Record record = recordSet.get(6);
                                PropertyType property = record.getProperty(UniLog.NUMBER_CELLS);
                                if (property != null) {
                                    property.setValue((Object)UniLogConfigTab.this.numCellValue);
                                } else {
                                    record.createProperty(UniLog.NUMBER_CELLS, DataTypes.INTEGER, (Object)UniLogConfigTab.this.numCellValue);
                                }
                                record = recordSet.get(8);
                                property = record.getProperty(UniLog.PROP_N_100_W);
                                if (property != null) {
                                    property.setValue((Object)UniLogConfigTab.this.prop100WValue);
                                } else {
                                    record.createProperty(UniLog.PROP_N_100_W, DataTypes.INTEGER, (Object)UniLogConfigTab.this.prop100WValue);
                                }
                                recordSet.setRecalculationRequired();
                                UniLogConfigTab.this.device.makeInActiveDisplayable(recordSet);
                                UniLogConfigTab.this.application.updateGraphicsWindow();
                                UniLogConfigTab.this.application.updateStatisticsData();
                                UniLogConfigTab.this.application.updateDataTable(recordSet.getName(), true);
                                recordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                            }
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.revolutionButton = new Button((Composite)this.powerGroup, 16416);
            this.revolutionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.revolutionButton.setLayoutData((Object)new RowData(120, 18));
            this.revolutionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "revolutionButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveRPM = UniLogConfigTab.this.revolutionButton.getSelection();
                    UniLogConfigTab.this.updateStateVoltageCurrentRevolutionDependent(UniLogConfigTab.this.isActiveU && UniLogConfigTab.this.isActiveI && UniLogConfigTab.this.isActiveRPM);
                    if (UniLogConfigTab.this.channels.getActiveChannel() != null && (activeRecordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                        activeRecordSet.get(7).setActive(Boolean.valueOf(UniLogConfigTab.this.revolutionButton.getSelection()));
                        activeRecordSet.get(7).setDisplayable(UniLogConfigTab.this.revolutionButton.getSelection());
                        UniLogConfigTab.this.application.updateGraphicsWindow();
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.revolutionSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.revolutionSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.revolutionSymbol.setLayoutData((Object)new RowData(40, 18));
            this.revolutionUnit = new CLabel((Composite)this.powerGroup, 0);
            this.revolutionUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.revolutionUnit.setLayoutData((Object)new RowData(50, 18));
            this.prop100WLabel = new CLabel((Composite)this.powerGroup, 16384);
            this.prop100WLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.prop100WLabel.setLayoutData((Object)new RowData(120, 18));
            this.prop100WLabel.setText(Messages.getString((String)"GDE_MSGT1344"));
            this.prop100WInput = new Text((Composite)this.powerGroup, 18432);
            this.prop100WInput.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.prop100WInput.setLayoutData((Object)new RowData(40, 16));
            this.prop100WInput.setToolTipText(Messages.getString((String)"GDE_MSGT1345"));
            this.prop100WInput.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "prop100WInput.keyReleased, event=" + evt);
                    }
                    try {
                        if (evt.character == '\r') {
                            RecordSet recordSet;
                            UniLogConfigTab.this.setConfigButton.setEnabled(true);
                            UniLogConfigTab.this.prop100WValue = Integer.valueOf(UniLogConfigTab.this.prop100WInput.getText().trim());
                            UniLogConfigTab.this.prop100WInput.setText(" " + UniLogConfigTab.this.prop100WValue);
                            UniLogConfigTab.this.numCellValue = Integer.valueOf(UniLogConfigTab.this.numCellInput.getText().trim());
                            UniLogConfigTab.this.numCellInput.setText(" " + UniLogConfigTab.this.numCellValue);
                            if (UniLogConfigTab.this.channels.getActiveChannel() != null && (recordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                                Record record = recordSet.get(8);
                                PropertyType property = record.getProperty(UniLog.PROP_N_100_W);
                                if (property != null) {
                                    property.setValue((Object)UniLogConfigTab.this.prop100WValue);
                                } else {
                                    record.createProperty(UniLog.PROP_N_100_W, DataTypes.INTEGER, (Object)UniLogConfigTab.this.prop100WValue);
                                }
                                record = recordSet.get(6);
                                property = record.getProperty(UniLog.NUMBER_CELLS);
                                if (property != null) {
                                    property.setValue((Object)UniLogConfigTab.this.numCellValue);
                                } else {
                                    record.createProperty(UniLog.NUMBER_CELLS, DataTypes.INTEGER, (Object)UniLogConfigTab.this.numCellValue);
                                }
                                recordSet.setRecalculationRequired();
                                UniLogConfigTab.this.device.makeInActiveDisplayable(recordSet);
                                UniLogConfigTab.this.application.updateGraphicsWindow();
                                UniLogConfigTab.this.application.updateStatisticsData();
                                UniLogConfigTab.this.application.updateDataTable(recordSet.getName(), true);
                                recordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                            }
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.prop100WUnit = new CLabel((Composite)this.powerGroup, 0);
            this.prop100WUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.prop100WUnit.setLayoutData((Object)new RowData(88, 18));
            this.prop100WUnit.setText(Messages.getString((String)"GDE_MSGT1346"));
            this.etaButton = new CLabel((Composite)this.powerGroup, 16416);
            this.etaButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.etaButton.setLayoutData((Object)new RowData(120, 18));
            this.etaSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.etaSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.etaSymbol.setLayoutData((Object)new RowData(40, 18));
            this.etaUnit = new CLabel((Composite)this.powerGroup, 0);
            this.etaUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.etaUnit.setLayoutData((Object)new RowData(40, 18));
            this.heightButton = new Button((Composite)this.powerGroup, 16416);
            this.heightButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightButton.setLayoutData((Object)new RowData(120, 18));
            this.heightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RecordSet activeRecordSet;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "heightButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveHeight = UniLogConfigTab.this.heightButton.getSelection();
                    UniLogConfigTab.this.updateHeightDependent(UniLogConfigTab.this.isActiveHeight);
                    if (UniLogConfigTab.this.channels.getActiveChannel() != null && (activeRecordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet()) != null) {
                        activeRecordSet.get(9).setActive(Boolean.valueOf(UniLogConfigTab.this.heightButton.getSelection()));
                        activeRecordSet.get(9).setDisplayable(UniLogConfigTab.this.heightButton.getSelection());
                        UniLogConfigTab.this.application.updateGraphicsWindow();
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.heightSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.heightSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightSymbol.setLayoutData((Object)new RowData(40, 18));
            this.heightUnit = new CLabel((Composite)this.powerGroup, 0);
            this.heightUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightUnit.setLayoutData((Object)new RowData(40, 18));
            this.slopeLabel = new CLabel((Composite)this.powerGroup, 16416);
            this.slopeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeLabel.setLayoutData((Object)new RowData(120, 18));
            this.slopeSymbol = new CLabel((Composite)this.powerGroup, 0);
            this.slopeSymbol.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeSymbol.setLayoutData((Object)new RowData(40, 18));
            this.slopeUnit = new CLabel((Composite)this.powerGroup, 0);
            this.slopeUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeUnit.setLayoutData((Object)new RowData(60, 18));
            this.calculationTypeLabel = new CLabel((Composite)this.powerGroup, 0);
            this.calculationTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.calculationTypeLabel.setLayoutData((Object)new RowData(120, 18));
            this.calculationTypeLabel.setText(Messages.getString((String)"GDE_MSGT1347"));
            this.slopeCalculationTypeCombo = new CCombo((Composite)this.powerGroup, 2048);
            this.slopeCalculationTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.slopeCalculationTypeCombo.setLayoutData((Object)new RowData(90, 20));
            this.slopeCalculationTypeCombo.setItems(new String[]{" " + Messages.getString((String)"GDE_MSGT1379"), " " + Messages.getString((String)"GDE_MSGT1380")});
            this.slopeCalculationTypeCombo.setToolTipText(Messages.getString((String)"GDE_MSGT1348"));
            this.slopeCalculationTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "slopeCalculationTypeCombo.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.slopeTypeSelection = UniLogConfigTab.this.slopeCalculationTypeCombo.getSelectionIndex() == 1 ? CalculationThread.REGRESSION_TYPE_CURVE : CalculationThread.REGRESSION_TYPE_LINEAR;
                    RecordSet recordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
                    if (recordSet != null) {
                        Record record = recordSet.get(10);
                        PropertyType property = record.getProperty(CalculationThread.REGRESSION_TYPE);
                        if (property != null) {
                            property.setValue((Object)UniLogConfigTab.this.slopeTypeSelection);
                        } else {
                            record.createProperty(CalculationThread.REGRESSION_TYPE, DataTypes.STRING, (Object)UniLogConfigTab.this.slopeTypeSelection);
                        }
                        recordSet.setRecalculationRequired();
                        UniLogConfigTab.this.device.makeInActiveDisplayable(recordSet);
                        UniLogConfigTab.this.application.updateStatisticsData();
                        UniLogConfigTab.this.application.updateDataTable(recordSet.getName(), true);
                        recordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.regressionTime = new CCombo((Composite)this.powerGroup, 2048);
            this.regressionTime.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.regressionTime.setLayoutData((Object)new RowData(60, 20));
            this.regressionTime.setItems(new String[]{" 1 s", " 2 s", " 3 s", " 4 s", " 5 s", " 6 s", " 7 s", " 8 s", " 9 s", "10 s", "11 s", "12 s", "13 s", "14 s", "15 s", "16 s", "17 s", "18 s", "19 s", "20 s", "21 s", "22 s", "23 s", "24 s", "25 s", "26 s", "27 s", "28 s", "29 s", "30 s"});
            this.regressionTime.setToolTipText(Messages.getString((String)"GDE_MSGT1349"));
            this.regressionTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "regressionTime.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.slopeTimeSelection = UniLogConfigTab.this.regressionTime.getSelectionIndex() + 1;
                    RecordSet recordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
                    if (recordSet != null) {
                        Record record = recordSet.get(10);
                        PropertyType property = record.getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
                        if (property != null) {
                            property.setValue((Object)UniLogConfigTab.this.slopeTimeSelection);
                        } else {
                            record.createProperty(CalculationThread.REGRESSION_INTERVAL_SEC, DataTypes.INTEGER, (Object)UniLogConfigTab.this.slopeTimeSelection);
                        }
                        recordSet.setRecalculationRequired();
                        UniLogConfigTab.this.device.makeInActiveDisplayable(recordSet);
                        UniLogConfigTab.this.application.updateStatisticsData();
                        UniLogConfigTab.this.application.updateDataTable(recordSet.getName(), true);
                        recordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
            });
            this.powerGroup.layout();
            this.axModusGroup = new Group((Composite)this, 0);
            this.axModusGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.axModusGroup.setText(Messages.getString((String)"GDE_MSGT1350"));
            this.axModusGroup.setBounds(313, 2, GDE.IS_LINUX ? 330 : 310, 135);
            this.axModusGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1351"));
            this.axModusGroup.addMouseTrackListener((MouseTrackListener)this.device.getDialog().mouseTrackerEnterFadeOut);
            this.axModusGroup.setLayout((Layout)new GridLayout(5, false));
            new Composite((Composite)this.axModusGroup, 0).setLayoutData((Object)new GridData(40, 20));
            this.axName = new CLabel((Composite)this.axModusGroup, 16384);
            this.axName.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.axName.setLayoutData((Object)new GridData(105, 20));
            this.axName.setText(Messages.getString((String)"GDE_MSGT1353"));
            this.axUnit = new CLabel((Composite)this.axModusGroup, 16384);
            this.axUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.axUnit.setLayoutData((Object)new GridData(40, 20));
            this.axUnit.setText(Messages.getString((String)"GDE_MSGT1354"));
            this.axOffset = new CLabel((Composite)this.axModusGroup, 16384);
            this.axOffset.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.axOffset.setLayoutData((Object)new GridData(40, 20));
            this.axOffset.setText(Messages.getString((String)"GDE_MSGT1355"));
            this.axFactor = new CLabel((Composite)this.axModusGroup, 16384);
            this.axFactor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.axFactor.setLayoutData((Object)new GridData(40, 20));
            this.axFactor.setText(Messages.getString((String)"GDE_MSGT1356"));
            this.a1Button = new Button((Composite)this.axModusGroup, 16416);
            this.a1Button.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Button.setLayoutData((Object)new GridData(40, 20));
            this.a1Button.setText(Messages.getString((String)"GDE_MSGT1357"));
            this.a1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a1ValueButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveA1 = UniLogConfigTab.this.a1Button.getSelection();
                    UniLogConfigTab.this.checkUpdateAnalog();
                }
            });
            this.a1Text = new Text((Composite)this.axModusGroup, 2048);
            this.a1Text.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Text.setLayoutData((Object)new GridData(105, 16));
            this.a1Text.setToolTipText(Messages.getString((String)"GDE_MSGT1358"));
            this.a1Text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a1Text.keyReleased, event=" + evt);
                    }
                    UniLogConfigTab.this.nameA1 = UniLogConfigTab.this.a1Text.getText().trim();
                    if (evt.character == '\r') {
                        UniLogConfigTab.this.checkUpdateAnalog();
                    }
                }
            });
            this.a1Unit = new Text((Composite)this.axModusGroup, 0x1000800);
            this.a1Unit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Unit.setLayoutData((Object)new GridData(30, 16));
            this.a1Unit.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a1Unit.keyReleased, event=" + evt);
                    }
                    UniLogConfigTab.this.unitA1 = UniLogConfigTab.this.a1Unit.getText().replace('[', ' ').replace(']', ' ').trim();
                    if (evt.character == '\r') {
                        UniLogConfigTab.this.checkUpdateAnalog();
                    }
                }
            });
            this.a1Offset = new Text((Composite)this.axModusGroup, 2048);
            this.a1Offset.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Offset.setLayoutData((Object)new GridData(30, 16));
            this.a1Offset.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a1Offset.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.offsetA1 = Double.valueOf(UniLogConfigTab.this.a1Offset.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.a1Factor = new Text((Composite)this.axModusGroup, 2048);
            this.a1Factor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Factor.setLayoutData((Object)new GridData(30, 16));
            this.a1Factor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a1Factor.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.factorA1 = Double.valueOf(UniLogConfigTab.this.a1Factor.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.a2Button = new Button((Composite)this.axModusGroup, 16416);
            this.a2Button.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Button.setLayoutData((Object)new GridData(40, 20));
            this.a2Button.setText(Messages.getString((String)"GDE_MSGT1359"));
            this.a2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a2ValueButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveA2 = UniLogConfigTab.this.a2Button.getSelection();
                    UniLogConfigTab.this.checkUpdateAnalog();
                }
            });
            this.a2Text = new Text((Composite)this.axModusGroup, 2048);
            this.a2Text.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Text.setLayoutData((Object)new GridData(105, 16));
            this.a2Text.setToolTipText(Messages.getString((String)"GDE_MSGT1360"));
            this.a2Text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a2Text.keyReleased, event=" + evt);
                    }
                    UniLogConfigTab.this.nameA2 = UniLogConfigTab.this.a2Text.getText().trim();
                    if (evt.character == '\r') {
                        UniLogConfigTab.this.checkUpdateAnalog();
                    }
                }
            });
            this.a2Unit = new Text((Composite)this.axModusGroup, 0x1000800);
            this.a2Unit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Unit.setLayoutData((Object)new GridData(30, 16));
            this.a2Unit.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a2Unit.keyReleased, event=" + evt);
                    }
                    UniLogConfigTab.this.unitA2 = UniLogConfigTab.this.a2Unit.getText().replace('[', ' ').replace(']', ' ').trim();
                    if (evt.character == '\r') {
                        UniLogConfigTab.this.checkUpdateAnalog();
                    }
                }
            });
            this.a2Offset = new Text((Composite)this.axModusGroup, 2048);
            this.a2Offset.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Offset.setLayoutData((Object)new GridData(30, 16));
            this.a2Offset.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a2Offset.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.offsetA2 = Double.valueOf(UniLogConfigTab.this.a2Offset.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.a2Factor = new Text((Composite)this.axModusGroup, 2048);
            this.a2Factor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Factor.setLayoutData((Object)new GridData(30, 16));
            this.a2Factor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a2Factor.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.factorA2 = Double.valueOf(UniLogConfigTab.this.a2Factor.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.a3Button = new Button((Composite)this.axModusGroup, 16416);
            this.a3Button.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Button.setLayoutData((Object)new GridData(40, 20));
            this.a3Button.setText(Messages.getString((String)"GDE_MSGT1361"));
            this.a3Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a3ValueButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.isActiveA3 = UniLogConfigTab.this.a3Button.getSelection();
                    UniLogConfigTab.this.checkUpdateAnalog();
                }
            });
            this.a3Text = new Text((Composite)this.axModusGroup, 2048);
            this.a3Text.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Text.setLayoutData((Object)new GridData(105, 16));
            this.a3Text.setToolTipText(Messages.getString((String)"GDE_MSGT1362"));
            this.a3Text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a3Text.keyReleased, event=" + evt);
                    }
                    UniLogConfigTab.this.nameA3 = UniLogConfigTab.this.a3Text.getText().trim();
                    if (evt.character == '\r') {
                        UniLogConfigTab.this.checkUpdateAnalog();
                    }
                }
            });
            this.a3Unit = new Text((Composite)this.axModusGroup, 0x1000800);
            this.a3Unit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Unit.setLayoutData((Object)new GridData(30, 16));
            this.a3Unit.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a3Unit.keyReleased, event=" + evt);
                    }
                    UniLogConfigTab.this.unitA3 = UniLogConfigTab.this.a3Unit.getText().replace('[', ' ').replace(']', ' ').trim();
                    if (evt.character == '\r') {
                        UniLogConfigTab.this.checkUpdateAnalog();
                    }
                }
            });
            this.a3Offset = new Text((Composite)this.axModusGroup, 2048);
            this.a3Offset.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Offset.setLayoutData((Object)new GridData(30, 16));
            this.a3Offset.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a3Offset.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.offsetA3 = Double.valueOf(UniLogConfigTab.this.a3Offset.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.a3Factor = new Text((Composite)this.axModusGroup, 2048);
            this.a3Factor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Factor.setLayoutData((Object)new GridData(30, 16));
            this.a3Factor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "a3Factor.keyReleased, event=" + evt);
                    }
                    try {
                        UniLogConfigTab.this.factorA3 = Double.valueOf(UniLogConfigTab.this.a3Factor.getText().trim().replace(',', '.'));
                        if (evt.character == '\r') {
                            UniLogConfigTab.this.checkUpdateAnalog();
                        }
                    }
                    catch (Exception e) {
                        UniLogConfigTab.this.application.openMessageDialog(UniLogConfigTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.axModusGroup.layout();
            this.deviceConfigGroup = new Group((Composite)this, 0);
            this.deviceConfigGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.deviceConfigGroup.setText(Messages.getString((String)"GDE_MSGT1381"));
            this.deviceConfigGroup.setBounds(313, 145, GDE.IS_LINUX ? 330 : 310, 188);
            this.deviceConfigGroup.addMouseTrackListener((MouseTrackListener)this.device.getDialog().mouseTrackerEnterFadeOut);
            this.deviceConfigGroup.setLayout((Layout)new GridLayout(1, true));
            this.setConfigurationLabel = new CLabel((Composite)this.deviceConfigGroup, 0x1000000);
            this.setConfigurationLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.setConfigurationLabel.setText(Messages.getString((String)"GDE_MSGT1382"));
            GridData labelGridData = new GridData(300, 100);
            labelGridData.grabExcessHorizontalSpace = true;
            labelGridData.horizontalAlignment = 0x1000000;
            this.setConfigurationLabel.setLayoutData((Object)labelGridData);
            this.setConfigButton = new Button((Composite)this.deviceConfigGroup, 0x1000008);
            this.setConfigButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            GridData buttonGridData = new GridData(300, 40);
            buttonGridData.grabExcessHorizontalSpace = true;
            buttonGridData.horizontalAlignment = 0x1000000;
            this.setConfigButton.setLayoutData((Object)buttonGridData);
            this.setConfigButton.setText(Messages.getString((String)"GDE_MSGT1364"));
            this.setConfigButton.setToolTipText(Messages.getString((String)"GDE_MSGT1365"));
            this.setConfigButton.setEnabled(false);
            this.setConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "setConfigButton.widgetSelected, event=" + evt);
                    }
                    UniLogConfigTab.this.collectAndUpdateConfiguration();
                    UniLogConfigTab.this.setConfigButton.setEnabled(false);
                }
            });
            this.deviceConfigGroup.layout();
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updateStateVoltageCurrentRevolutionDependent(boolean enabled) {
        RecordSet activeRecordSet;
        if (this.channels.getActiveChannel() != null && (activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null) {
            activeRecordSet.get(8).setDisplayable(enabled);
            activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
        }
        this.prop100WLabel.setEnabled(enabled);
        this.prop100WInput.setEnabled(enabled);
        this.prop100WUnit.setEnabled(enabled);
        this.etaButton.setEnabled(enabled);
        this.etaSymbol.setEnabled(enabled);
        this.etaUnit.setEnabled(enabled);
        if (enabled) {
            this.prop100WLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.prop100WInput.setForeground(SWTResourceManager.getColor((int)2));
            this.prop100WUnit.setForeground(SWTResourceManager.getColor((int)2));
            this.etaButton.setForeground(SWTResourceManager.getColor((int)2));
            this.etaSymbol.setForeground(SWTResourceManager.getColor((int)2));
            this.etaUnit.setForeground(SWTResourceManager.getColor((int)2));
        } else {
            this.prop100WLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.prop100WInput.setForeground(SWTResourceManager.getColor((int)33));
            this.prop100WUnit.setForeground(SWTResourceManager.getColor((int)33));
            this.etaButton.setForeground(SWTResourceManager.getColor((int)33));
            this.etaSymbol.setForeground(SWTResourceManager.getColor((int)33));
            this.etaUnit.setForeground(SWTResourceManager.getColor((int)33));
        }
    }

    void updateHeightDependent(boolean enabled) {
        RecordSet activeRecordSet;
        if (this.channels.getActiveChannel() != null && (activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null) {
            activeRecordSet.get(10).setDisplayable(enabled);
            activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
        }
        this.slopeLabel.setEnabled(enabled);
        this.slopeSymbol.setEnabled(enabled);
        this.slopeUnit.setEnabled(enabled);
        if (enabled) {
            this.slopeLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.slopeSymbol.setForeground(SWTResourceManager.getColor((int)2));
            this.slopeUnit.setForeground(SWTResourceManager.getColor((int)2));
            this.calculationTypeLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.slopeCalculationTypeCombo.setForeground(SWTResourceManager.getColor((int)2));
            this.regressionTime.setForeground(SWTResourceManager.getColor((int)2));
        } else {
            this.slopeLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.slopeSymbol.setForeground(SWTResourceManager.getColor((int)33));
            this.slopeUnit.setForeground(SWTResourceManager.getColor((int)33));
            this.calculationTypeLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.slopeCalculationTypeCombo.setForeground(SWTResourceManager.getColor((int)33));
            this.regressionTime.setForeground(SWTResourceManager.getColor((int)33));
        }
    }

    void updateStateCurrentDependent(boolean enabled) {
        RecordSet activeRecordSet;
        if (this.channels.getActiveChannel() != null && (activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null) {
            activeRecordSet.get(3).setDisplayable(enabled);
            activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
        }
        this.capacityLabel.setEnabled(enabled);
        this.capacitySymbol.setEnabled(enabled);
        this.capacityUnit.setEnabled(enabled);
        if (enabled) {
            this.capacityLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.capacitySymbol.setForeground(SWTResourceManager.getColor((int)2));
            this.capacityUnit.setForeground(SWTResourceManager.getColor((int)2));
        } else {
            this.capacityLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.capacitySymbol.setForeground(SWTResourceManager.getColor((int)33));
            this.capacityUnit.setForeground(SWTResourceManager.getColor((int)33));
        }
    }

    void updateStateVoltageAndCurrentDependent(boolean enabled) {
        RecordSet activeRecordSet;
        if (this.channels.getActiveChannel() != null && (activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null) {
            activeRecordSet.get(4).setDisplayable(enabled);
            activeRecordSet.get(5).setDisplayable(enabled);
            activeRecordSet.get(6).setDisplayable(enabled);
            activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
        }
        this.powerLabel.setEnabled(enabled);
        this.powerUnit.setEnabled(enabled);
        this.powerSymbol.setEnabled(enabled);
        this.energyLabel.setEnabled(enabled);
        this.energyUnit.setEnabled(enabled);
        this.energySymbol.setEnabled(enabled);
        this.voltagePerCellLabel.setEnabled(enabled);
        this.voltagePerCellUnit.setEnabled(enabled);
        this.voltagePerCellSymbol.setEnabled(enabled);
        this.numCellLabel.setEnabled(enabled);
        this.numCellInput.setEnabled(enabled);
        if (enabled) {
            this.powerLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.powerUnit.setForeground(SWTResourceManager.getColor((int)2));
            this.powerSymbol.setForeground(SWTResourceManager.getColor((int)2));
            this.energyLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.energyUnit.setForeground(SWTResourceManager.getColor((int)2));
            this.energySymbol.setForeground(SWTResourceManager.getColor((int)2));
            this.voltagePerCellLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.voltagePerCellUnit.setForeground(SWTResourceManager.getColor((int)2));
            this.voltagePerCellSymbol.setForeground(SWTResourceManager.getColor((int)2));
            this.numCellLabel.setForeground(SWTResourceManager.getColor((int)2));
            this.numCellInput.setForeground(SWTResourceManager.getColor((int)2));
        } else {
            this.powerLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.powerUnit.setForeground(SWTResourceManager.getColor((int)33));
            this.powerSymbol.setForeground(SWTResourceManager.getColor((int)33));
            this.energyLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.energyUnit.setForeground(SWTResourceManager.getColor((int)33));
            this.energySymbol.setForeground(SWTResourceManager.getColor((int)33));
            this.voltagePerCellLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.voltagePerCellUnit.setForeground(SWTResourceManager.getColor((int)33));
            this.voltagePerCellSymbol.setForeground(SWTResourceManager.getColor((int)33));
            this.numCellLabel.setForeground(SWTResourceManager.getColor((int)33));
            this.numCellInput.setForeground(SWTResourceManager.getColor((int)33));
        }
    }

    void collectAndUpdateConfiguration() {
        MeasurementType measurement = this.device.getMeasurement(this.configNumber, 0);
        measurement.setActive(Boolean.valueOf(this.reveiverVoltageButton.getSelection()));
        measurement = this.device.getMeasurement(this.configNumber, 1);
        measurement.setActive(Boolean.valueOf(this.voltageButton.getSelection()));
        measurement = this.device.getMeasurement(this.configNumber, 2);
        measurement.setActive(Boolean.valueOf(this.currentButton.getSelection()));
        measurement.setOffset(Double.valueOf(this.currentOffset.getText().replace(',', '.').trim()).doubleValue());
        this.device.setMeasurementPropertyValue(this.configNumber, 6, UniLog.NUMBER_CELLS, DataTypes.INTEGER, this.numCellValue);
        measurement = this.device.getMeasurement(this.configNumber, 7);
        measurement.setActive(Boolean.valueOf(this.revolutionButton.getSelection()));
        this.device.setMeasurementPropertyValue(this.configNumber, 8, UniLog.PROP_N_100_W, DataTypes.INTEGER, this.prop100WValue);
        measurement = this.device.getMeasurement(this.configNumber, 9);
        measurement.setActive(Boolean.valueOf(this.heightButton.getSelection()));
        this.device.setMeasurementPropertyValue(this.configNumber, 10, CalculationThread.REGRESSION_TYPE, DataTypes.STRING, this.slopeTypeSelection);
        this.device.setMeasurementPropertyValue(this.configNumber, 10, CalculationThread.REGRESSION_INTERVAL_SEC, DataTypes.INTEGER, this.slopeTimeSelection);
        measurement = this.device.getMeasurement(this.configNumber, 11);
        measurement.setActive(Boolean.valueOf(this.a1Button.getSelection()));
        measurement.setName(this.a1Text.getText().trim());
        measurement.setUnit(this.a1Unit.getText().replace('[', ' ').replace(']', ' ').trim());
        measurement.setOffset(Double.valueOf(this.a1Offset.getText().trim().replace(',', '.').trim()).doubleValue());
        measurement.setFactor(Double.valueOf(this.a1Factor.getText().trim().replace(',', '.').trim()).doubleValue());
        measurement = this.device.getMeasurement(this.configNumber, 12);
        measurement.setActive(Boolean.valueOf(this.a2Button.getSelection()));
        measurement.setName(this.a2Text.getText().trim());
        measurement.setUnit(this.a2Unit.getText().replace('[', ' ').replace(']', ' ').trim());
        measurement.setOffset(Double.valueOf(this.a2Offset.getText().trim().replace(',', '.').trim()).doubleValue());
        measurement.setFactor(Double.valueOf(this.a2Factor.getText().trim().replace(',', '.').trim()).doubleValue());
        measurement = this.device.getMeasurement(this.configNumber, 13);
        measurement.setActive(Boolean.valueOf(this.a3Button.getSelection()));
        measurement.setName(this.a3Text.getText().trim());
        measurement.setUnit(this.a3Unit.getText().replace('[', ' ').replace(']', ' ').trim());
        measurement.setOffset(Double.valueOf(this.a3Offset.getText().trim().replace(',', '.').trim()).doubleValue());
        measurement.setFactor(Double.valueOf(this.a3Factor.getText().trim().replace(',', '.').trim()).doubleValue());
        this.device.setChangePropery(true);
        this.device.storeDeviceProperties();
    }

    public void setA1ModusAvailable(boolean enable) {
        this.isA1ModusAvailable = enable;
    }

    public boolean getConfigButtonStatus() {
        return this.setConfigButton.getEnabled();
    }

    public void setConfigName(String newConfigName) {
        this.configName = newConfigName;
    }

    void initEditable() {
        PropertyType property = null;
        Record record = null;
        RecordSet recordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
        if (recordSet != null) {
            this.isActiveUe = recordSet.get(0).isActive();
            this.isActiveU = recordSet.get(1).isActive();
            this.isActiveI = recordSet.get(2).isActive();
            this.offsetCurrent = recordSet.get(2).getOffset();
            property = recordSet.get(6).getProperty(UniLog.NUMBER_CELLS);
            this.numCellValue = property != null ? Integer.valueOf(property.getValue().trim()) : 4;
            this.isActiveRPM = recordSet.get(7).isActive();
            property = recordSet.get(8).getProperty(UniLog.PROP_N_100_W);
            this.prop100WValue = property != null ? Integer.valueOf(property.getValue().trim()) : 10000;
            this.isActiveHeight = recordSet.get(9).isActive();
            property = recordSet.get(10).getProperty(CalculationThread.REGRESSION_TYPE);
            this.slopeTypeSelection = property != null ? property.getValue() : CalculationThread.REGRESSION_TYPE_CURVE;
            property = recordSet.get(10).getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
            this.slopeTimeSelection = property != null ? Integer.valueOf(property.getValue().trim()) : 10;
            record = recordSet.get(11);
            this.isActiveA1 = record.isActive();
            this.nameA1 = record.getName();
            this.unitA1 = record.getUnit();
            this.offsetA1 = record.getOffset();
            this.factorA1 = record.getFactor();
            record = recordSet.get(12);
            this.isActiveA2 = record.isActive();
            this.nameA2 = record.getName();
            this.unitA2 = record.getUnit();
            this.offsetA2 = record.getOffset();
            this.factorA2 = record.getFactor();
            record = recordSet.get(13);
            this.isActiveA3 = record.isActive();
            this.nameA3 = record.getName();
            this.unitA3 = record.getUnit();
            this.offsetA3 = record.getOffset();
            this.factorA3 = record.getFactor();
        } else {
            MeasurementType measurement = this.device.getMeasurement(this.configNumber, 0);
            this.isActiveUe = measurement.isActive();
            measurement = this.device.getMeasurement(this.configNumber, 1);
            this.isActiveU = measurement.isActive();
            measurement = this.device.getMeasurement(this.configNumber, 2);
            this.isActiveI = measurement.isActive();
            this.offsetCurrent = measurement.getOffset();
            property = this.device.getMeasruementProperty(this.configNumber, 6, UniLog.NUMBER_CELLS);
            this.numCellValue = property != null ? Integer.valueOf(property.getValue().trim()) : 4;
            measurement = this.device.getMeasurement(this.configNumber, 7);
            this.isActiveRPM = measurement.isActive();
            property = this.device.getMeasruementProperty(this.configNumber, 8, UniLog.PROP_N_100_W);
            this.prop100WValue = property != null ? Integer.valueOf(property.getValue().trim()) : 10000;
            measurement = this.device.getMeasurement(this.configNumber, 9);
            this.isActiveHeight = measurement.isActive();
            property = this.device.getMeasruementProperty(this.configNumber, 10, CalculationThread.REGRESSION_TYPE);
            this.slopeTypeSelection = property != null ? property.getValue() : CalculationThread.REGRESSION_TYPE_CURVE;
            property = this.device.getMeasruementProperty(this.configNumber, 10, CalculationThread.REGRESSION_INTERVAL_SEC);
            int n = this.slopeTimeSelection = property != null ? Integer.valueOf(property.getValue().trim()) : 10;
            if (this.nameA1.equals("-")) {
                measurement = this.device.getMeasurement(this.configNumber, 11);
                this.isActiveA1 = measurement.isActive();
                this.nameA1 = measurement.getName();
                this.unitA1 = measurement.getUnit();
                this.offsetA1 = this.device.getMeasurementOffset(this.configNumber, 11);
                this.factorA1 = this.device.getMeasurementFactor(this.configNumber, 11);
            }
            if (this.nameA2.equals("-")) {
                measurement = this.device.getMeasurement(this.configNumber, 12);
                this.isActiveA2 = measurement.isActive();
                this.nameA2 = measurement.getName();
                this.unitA2 = measurement.getUnit();
                this.offsetA2 = this.device.getMeasurementOffset(this.configNumber, 12);
                this.factorA2 = this.device.getMeasurementFactor(this.configNumber, 12);
            }
            if (this.nameA3.equals("-")) {
                measurement = this.device.getMeasurement(this.configNumber, 13);
                this.isActiveA3 = measurement.isActive();
                this.nameA3 = measurement.getName();
                this.unitA3 = measurement.getUnit();
                this.offsetA3 = this.device.getMeasurementOffset(this.configNumber, 13);
                this.factorA3 = this.device.getMeasurementFactor(this.configNumber, 13);
            }
        }
    }

    public void checkUpdateAnalog() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "visit checkUpdateAnalog");
        }
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                UniLogConfigTab.this.powerGroup.redraw();
                UniLogConfigTab.this.axModusGroup.redraw();
                if (UniLogConfigTab.this.channels.getActiveChannel() != null) {
                    RecordSet activeRecordSet = UniLogConfigTab.this.channels.getActiveChannel().getActiveRecordSet();
                    if (activeRecordSet != null) {
                        activeRecordSet.get(2).setOffset(Double.valueOf(UniLogConfigTab.this.currentOffset.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(11).setActive(Boolean.valueOf(UniLogConfigTab.this.a1Button.getSelection()));
                        activeRecordSet.get(11).setDisplayable(UniLogConfigTab.this.a1Button.getSelection());
                        activeRecordSet.get(11).setName(UniLogConfigTab.this.a1Text.getText().trim());
                        activeRecordSet.get(11).setUnit(UniLogConfigTab.this.a1Unit.getText().replace('[', ' ').replace(']', ' ').trim());
                        activeRecordSet.get(11).setOffset(Double.valueOf(UniLogConfigTab.this.a1Offset.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(11).setFactor(Double.valueOf(UniLogConfigTab.this.a1Factor.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(12).setActive(Boolean.valueOf(UniLogConfigTab.this.a2Button.getSelection()));
                        activeRecordSet.get(12).setDisplayable(UniLogConfigTab.this.a2Button.getSelection());
                        activeRecordSet.get(12).setName(UniLogConfigTab.this.a2Text.getText().trim());
                        activeRecordSet.get(12).setUnit(UniLogConfigTab.this.a2Unit.getText().replace('[', ' ').replace(']', ' ').trim());
                        activeRecordSet.get(12).setOffset(Double.valueOf(UniLogConfigTab.this.a2Offset.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(12).setFactor(Double.valueOf(UniLogConfigTab.this.a2Factor.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(13).setActive(Boolean.valueOf(UniLogConfigTab.this.a3Button.getSelection()));
                        activeRecordSet.get(13).setDisplayable(UniLogConfigTab.this.a3Button.getSelection());
                        activeRecordSet.get(13).setName(UniLogConfigTab.this.a3Text.getText().trim());
                        activeRecordSet.get(13).setUnit(UniLogConfigTab.this.a3Unit.getText().replace('[', ' ').replace(']', ' ').trim());
                        activeRecordSet.get(13).setOffset(Double.valueOf(UniLogConfigTab.this.a3Offset.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(13).setFactor(Double.valueOf(UniLogConfigTab.this.a3Factor.getText().trim().replace(',', '.')).doubleValue());
                        activeRecordSet.get(13).setName(UniLogConfigTab.this.a3Text.getText().trim());
                        UniLogConfigTab.this.application.updateGraphicsWindow();
                        activeRecordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                    }
                    UniLogConfigTab.this.setConfigButton.setEnabled(true);
                }
                UniLogConfigTab.this.powerGroup.redraw();
                UniLogConfigTab.this.axModusGroup.redraw();
            }
        });
    }

    void initialize() {
        this.initEditable();
        MeasurementType measurement = this.device.getMeasurement(this.configNumber, 0);
        this.reveiverVoltageButton.setSelection(this.isActiveUe);
        this.reveiverVoltageButton.setText(measurement.getName());
        this.receiverVoltageSymbol.setText(measurement.getSymbol());
        this.receiverVoltageUnit.setText("[" + measurement.getUnit() + "]");
        measurement = this.device.getMeasurement(this.configNumber, 1);
        this.voltageButton.setSelection(this.isActiveU);
        this.voltageButton.setText(measurement.getName());
        this.voltageSymbol.setText(measurement.getSymbol());
        this.voltageUnit.setText("[" + measurement.getUnit() + "]");
        measurement = this.device.getMeasurement(this.configNumber, 2);
        this.currentButton.setSelection(this.isActiveI);
        this.currentButton.setText(measurement.getName());
        this.currentSymbol.setText(" " + measurement.getSymbol());
        this.currentUnit.setText("[" + measurement.getUnit() + "]");
        this.currentOffset.setText(String.format("%.3f", this.offsetCurrent));
        measurement = this.device.getMeasurement(this.configNumber, 3);
        this.capacityLabel.setText(measurement.getName());
        this.capacitySymbol.setText(measurement.getSymbol());
        this.capacityUnit.setText("[" + measurement.getUnit() + "]");
        measurement = this.device.getMeasurement(this.configNumber, 4);
        this.powerLabel.setText(measurement.getName());
        this.powerSymbol.setText(measurement.getSymbol());
        this.powerUnit.setText("[" + measurement.getUnit() + "]");
        measurement = this.device.getMeasurement(this.configNumber, 5);
        this.energyLabel.setText(measurement.getName());
        this.energySymbol.setText(measurement.getSymbol());
        this.energyUnit.setText("[" + measurement.getUnit() + "]");
        this.updateStateCurrentDependent(this.currentButton.getSelection());
        this.updateStateVoltageAndCurrentDependent(this.voltageButton.getSelection() && this.currentButton.getSelection());
        measurement = this.device.getMeasurement(this.configNumber, 6);
        this.voltagePerCellLabel.setText(measurement.getName());
        this.voltagePerCellSymbol.setText(measurement.getSymbol());
        this.voltagePerCellUnit.setText("[" + measurement.getUnit() + "]");
        this.numCellInput.setText(" " + this.numCellValue);
        measurement = this.device.getMeasurement(this.configNumber, 7);
        this.revolutionButton.setSelection(this.isActiveRPM);
        this.revolutionButton.setText(measurement.getName());
        this.revolutionSymbol.setText(measurement.getSymbol());
        this.revolutionUnit.setText("[" + measurement.getUnit() + "]");
        measurement = this.device.getMeasurement(this.configNumber, 8);
        this.etaButton.setText(measurement.getName());
        this.etaSymbol.setText(measurement.getSymbol());
        this.etaUnit.setText("[" + measurement.getUnit() + "]");
        this.prop100WInput.setText(" " + this.prop100WValue);
        this.updateStateVoltageCurrentRevolutionDependent(this.voltageButton.getSelection() && this.currentButton.getSelection() && this.revolutionButton.getSelection());
        measurement = this.device.getMeasurement(this.configNumber, 9);
        this.heightButton.setSelection(this.isActiveHeight);
        this.heightButton.setText(measurement.getName());
        this.heightSymbol.setText(measurement.getSymbol());
        this.heightUnit.setText("[" + measurement.getUnit() + "]");
        measurement = this.device.getMeasurement(this.configNumber, 10);
        this.slopeLabel.setText(measurement.getName());
        this.slopeSymbol.setText(measurement.getSymbol());
        this.slopeUnit.setText("[" + measurement.getUnit() + "]");
        this.updateHeightDependent(this.heightButton.getSelection());
        this.regressionTime.select(this.slopeTimeSelection - 1);
        this.slopeCalculationTypeCombo.select(this.slopeTypeSelection.equals(CalculationThread.REGRESSION_TYPE_CURVE) ? 1 : 0);
        this.a1Button.setSelection(this.isActiveA1);
        this.a1Text.setText(this.nameA1);
        this.a1Unit.setText("[" + this.unitA1 + "]");
        this.a1Offset.setText(String.format("%.3f", this.offsetA1));
        this.a1Factor.setText(String.format("%.3f", this.factorA1));
        this.a2Button.setSelection(this.isActiveA2);
        this.a2Text.setText(this.nameA2);
        this.a2Unit.setText("[" + this.unitA2 + "]");
        this.a2Offset.setText(String.format("%.3f", this.offsetA2));
        this.a2Factor.setText(String.format("%.3f", this.factorA2));
        this.a3Button.setSelection(this.isActiveA3);
        this.a3Text.setText(this.nameA3);
        this.a3Unit.setText("[" + this.unitA3 + "]");
        this.a3Offset.setText(String.format("%.3f", this.offsetA3));
        this.a3Factor.setText(String.format("%.3f", this.factorA3));
    }
}

