/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.gja.proj.utils;

import gde.GDE;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.TimeLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TelemetryData {
    static Logger log = Logger.getLogger(TelemetryData.class.getName());
    static final Charset WINDOWS_1250 = Charset.forName("Windows-1250");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final int T_DATA8 = 0;
    public static final int T_DATA16 = 1;
    public static final int T_DATA24 = 4;
    public static final int T_TIME = 5;
    public static final int T_DATA32 = 8;
    public static final int T_GPS = 9;
    public static final int T_DATA37 = 12;
    public static final int T_EVENT = 16;
    long startTimeStamp = 0L;
    public static Map<Integer, Integer> idMap = new HashMap<Integer, Integer>();
    static TimeVector timeSteps;
    private TreeSet<TelemetrySensor> data = new TreeSet();
    private double maxTimestamp = 0.0;
    private String modelName = "";

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public TelemetryData() {
        timeSteps = new TimeVector();
    }

    public TreeSet<TelemetrySensor> getData() {
        return this.data;
    }

    public String getModelName() {
        return this.modelName;
    }

    public TelemetrySensor getSensor(long id) {
        for (TelemetrySensor s : this.data) {
            if (s.id != id) continue;
            return s;
        }
        return null;
    }

    public double getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean loadData(String file) {
        idMap.clear();
        this.maxTimestamp = 0.0;
        int mid = file.lastIndexOf(".");
        String ext = file.substring(mid + 1, file.length());
        if (ext.equalsIgnoreCase("log")) {
            this.data.clear();
            if (!this.loadCSV(file)) {
                return false;
            }
        } else if (ext.equalsIgnoreCase("jml")) {
            this.data.clear();
            if (!this.loadJML(file)) {
                return false;
            }
        } else {
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGE2900", (Object[])new String[]{file}));
            return false;
        }
        for (TelemetrySensor s : this.data) {
            for (TelemetryVar d : s.variables) {
                this.maxTimestamp = Math.max(this.maxTimestamp, d.normamlizeItems());
            }
        }
        return true;
    }

    boolean loadJML(String filename) {
        try {
            File file = new File(filename);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList sensors = doc.getElementsByTagName("dataStorage");
            for (int s = 0; s < sensors.getLength(); ++s) {
                int progress;
                Node sensor = sensors.item(s);
                if (sensor.getNodeType() == 1) {
                    Element varElem;
                    Node var;
                    int i;
                    Element fstElmnt = (Element)sensor;
                    long ID = Long.parseLong(fstElmnt.getAttribute("dataStorageID"));
                    TelemetrySensor tel = new TelemetrySensor(ID, "-");
                    this.data.add(tel);
                    NodeList elements = fstElmnt.getElementsByTagName("attrDescription");
                    for (i = 0; i < elements.getLength(); ++i) {
                        var = elements.item(i);
                        if (var.getNodeType() != 1) continue;
                        varElem = (Element)var;
                        int varId = Integer.parseInt(varElem.getAttribute("attrID"));
                        String name = varElem.getAttribute("name");
                        String unit = varElem.getAttribute("units");
                        TelemetryVar telvar = new TelemetryVar(varId, name, unit);
                        tel.addVariable(telvar);
                    }
                    elements = fstElmnt.getElementsByTagName("entity");
                    for (i = 0; i < elements.getLength(); ++i) {
                        var = elements.item(i);
                        if (var.getNodeType() != 1) continue;
                        varElem = (Element)var;
                        String row = String.valueOf(ID) + ";" + varElem.getAttribute("plainData");
                        String[] rowData = row.split(";");
                        if (rowData.length <= 2) continue;
                        String tmp = rowData[1];
                        rowData[1] = rowData[0];
                        rowData[0] = tmp;
                        this.parseLineParams(rowData);
                    }
                }
                if ((progress = s * 100 / (sensors.getLength() * 2 / 3)) > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                GDE.getUiNotification().setProgress(progress);
                try {
                    Thread.sleep(2L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Exception e) {
            this.getData().clear();
            log.log(Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGE2901", (Object[])new String[]{filename}));
            return false;
        }
    }

    boolean loadCSV(String file) {
        int line = 0;
        try {
            String strLine;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader in = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            long inputFileSize = new File(file).length();
            int progressLineLength = 0;
            BufferedReader br = new BufferedReader(in);
            while ((strLine = br.readLine()) != null) {
                ++line;
                if (strLine.startsWith("#")) {
                    this.modelName = strLine.substring(1).trim();
                    continue;
                }
                int progress = (int)((long)(line * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > strLine.length() ? progressLineLength : strLine.length())));
                if (progress <= 90 && progress > GDE.getUiNotification().getProgressPercentage() && progress % 10 == 0) {
                    GDE.getUiNotification().setProgress(progress);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArrayList<String> array = new ArrayList<String>();
                array.addAll(Arrays.asList(strLine.replace("|", ";").split(";")));
                if (array == null || array.size() <= 0) continue;
                if (array.size() == 4) {
                    log.log(Level.WARNING, String.format("Sensor variable missing unit! - %s", array));
                    array.add("");
                }
                this.parseLineParams(array.toArray(new String[5]));
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.getData().clear();
            log.log(Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGE2902", (Object[])new String[]{file, String.valueOf(line)}));
            return false;
        }
    }

    void parseLineParams(String[] params) {
        boolean ST_TIME = false;
        boolean ST_DEVICE_ID = true;
        int ST_PARAM_NUM = 2;
        int ST_DATATYPE = 3;
        int ST_DECIMALS = 4;
        int ST_VALUE = 5;
        int ST_LABEL = 6;
        int ST_UNIT = 7;
        int state = 0;
        long timestamp = 0L;
        long deviceId = 0L;
        int paramId = 0;
        int dataType = 0;
        int decimals = 0;
        String label = "";
        String unit = "";
        if (params == null) {
            return;
        }
        block14: for (String param : params) {
            switch (state) {
                case 0: {
                    timestamp = Long.parseLong(param);
                    state = 1;
                    continue block14;
                }
                case 1: {
                    try {
                        deviceId = Long.parseLong(!param.startsWith(" ") || !param.endsWith("0") ? param.replace(' ', '0') : param);
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.WARNING, "skip | param = " + param);
                    }
                    state = 2;
                    continue block14;
                }
                case 2: {
                    paramId = Integer.parseInt(param);
                    if (timestamp == 0L) {
                        state = 6;
                        continue block14;
                    }
                    state = 3;
                    continue block14;
                }
                case 6: {
                    label = param;
                    if (timestamp == 0L && paramId == 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "adding sensor " + label);
                        }
                        TelemetrySensor sensor = new TelemetrySensor(deviceId, label);
                        this.data.add(sensor);
                        return;
                    }
                    state = 7;
                    continue block14;
                }
                case 7: {
                    unit = param;
                    TelemetryVar var = new TelemetryVar(paramId, label, unit);
                    TelemetrySensor s = this.getSensor(deviceId);
                    if (s != null) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("%d add variable %s[%s] ID=%d", deviceId, var.name, unit, paramId));
                        }
                        s.addVariable(var);
                    }
                    return;
                }
                case 3: {
                    dataType = Integer.parseInt(param);
                    state = 4;
                    continue block14;
                }
                case 4: {
                    decimals = Integer.parseInt(param);
                    state = 5;
                    continue block14;
                }
                case 5: {
                    TelemetryVar par;
                    long val = 0L;
                    try {
                        val = Long.parseLong(param);
                    }
                    catch (NumberFormatException e) {
                        if (param.length() > 3 && this.startTimeStamp > 0L) {
                            TelemetryVar par2;
                            String utf8String = new String(param.getBytes(ISO_8859_1));
                            String message = TimeLine.getFomatedTimeWithUnit((double)timestamp) + " - " + utf8String;
                            log.log(Level.WARNING, message);
                            GDE.getUiNotification().setStatusMessage(message, 3);
                            deviceId = 0L;
                            TelemetrySensor sensor = this.getSensor(deviceId);
                            if (sensor == null) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "adding sensor " + label);
                                }
                                sensor = new TelemetrySensor(deviceId, label);
                                this.data.add(sensor);
                            }
                            label = utf8String;
                            paramId = TelemetryData.getParameterIdByName(sensor, label);
                            dataType = 0;
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "deviceId = " + deviceId + ", paramId = " + paramId + ", untit = " + unit + ", dataType = " + dataType + ", state = " + state + ", decimals = " + decimals);
                            }
                            if ((par2 = sensor.getVar(paramId)) == null) {
                                par2 = new TelemetryVar(paramId, label, unit);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "add variable " + par2.name);
                                }
                                sensor.addVariable(par2);
                                TelemetryItem item = new TelemetryItem(dataType, decimals, 0, this.startTimeStamp);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "add sensor variable value " + par2.getName() + "=" + item.getInt());
                                }
                                par2 = sensor.getVar(paramId);
                                par2.addItem(item, true);
                            }
                            par2.addItem(new TelemetryItem(dataType, decimals, par2.getItems().get(par2.getItems().size() - 1).getInt(), timestamp - 5L), true);
                            par2.addItem(new TelemetryItem(dataType, decimals, (int)(par2.maxValue += 1.0), timestamp), true);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "add sensor variable value " + par2.getName() + "=" + par2.getItems().get(par2.getItems().size() - 1).getInt());
                                log.log(Level.FINE, "add sensor variable value count " + par2.getItems().size());
                            }
                        }
                        state = 2;
                        continue block14;
                    }
                    short intval = 0;
                    intval = dataType == 1 ? (short)val : (dataType == 0 ? (short)((byte)val) : (short)val);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("TelemetryData: deviceId=%d, paramId=%d, untit='%s', dataType=%d, state=%d, decimals=%d, value=%d, timeStamp=%d", deviceId, paramId, unit, dataType, state, decimals, (int)intval, timestamp));
                    }
                    TelemetryItem item = new TelemetryItem(dataType, decimals, intval, timestamp);
                    TelemetrySensor sen = this.getSensor(deviceId);
                    if (sen != null && (par = sen.getVar(paramId)) != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "add sensor variable value " + par.name + "=" + item.value);
                        }
                        par.addItem(item, false);
                        if (this.startTimeStamp == 0L) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "set startTimeStamp = " + timestamp);
                            }
                            this.startTimeStamp = timestamp;
                        }
                    }
                    state = 2;
                }
            }
        }
    }

    public static int getParameterIdByName(TelemetrySensor sensor, String label) {
        int labelParamId = 0;
        for (int i = 0; i < label.length(); ++i) {
            labelParamId += label.charAt(i);
        }
        if (idMap.get(labelParamId) == null) {
            int newPartamId = sensor.getVariables().size() + 1;
            idMap.put(labelParamId, newPartamId);
        }
        return idMap.get(labelParamId);
    }

    public long getMinTimeStep() {
        return timeSteps.getMinValue();
    }

    public long getMaxTimeStep() {
        return timeSteps.getMaxValue();
    }

    public long getSigmaTimeStep() {
        return timeSteps.getSigmaValue();
    }

    public long getAvgTimeStep() {
        return timeSteps.getAvgValue();
    }

    public static class TimeVector
    extends Vector<Long> {
        private static final long serialVersionUID = 4860628311229067111L;
        long firstTimeStamp = 0L;
        long lastTimeStamp = 0L;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long avgValue = Long.MIN_VALUE;
        long sigmaValue = Long.MIN_VALUE;
        long maxTimeStamp = 0L;

        @Override
        public synchronized boolean add(Long timeStamp) {
            boolean isAdded = false;
            if (timeStamp != 0L) {
                if (this.lastTimeStamp != 0L && this.lastTimeStamp < timeStamp) {
                    long delta = timeStamp - this.lastTimeStamp;
                    if (super.size() == 0) {
                        this.minValue = this.maxValue = delta;
                    } else if (delta > this.maxValue) {
                        this.maxValue = delta;
                        this.maxTimeStamp = this.lastTimeStamp - this.firstTimeStamp;
                    } else if (delta < this.minValue) {
                        this.minValue = delta;
                    }
                    isAdded = super.add(delta);
                } else {
                    this.firstTimeStamp = timeStamp;
                }
                this.lastTimeStamp = timeStamp;
            }
            return isAdded;
        }

        public long getMaxValueTimeStamp() {
            return this.maxTimeStamp;
        }

        public long getAvgValue() {
            this.setAvgValue();
            return this.avgValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAvgValue() {
            TimeVector timeVector = this;
            synchronized (timeVector) {
                if (this.size() >= 2) {
                    long sum = 0L;
                    int zeroCount = 0;
                    for (Long xi : this) {
                        if (xi != 0L) {
                            sum += xi.longValue();
                            continue;
                        }
                        ++zeroCount;
                    }
                    this.avgValue = this.size() - zeroCount != 0 ? (long)Long.valueOf(sum / (long)(this.size() - zeroCount)).intValue() : 0L;
                }
            }
        }

        public long getSigmaValue() {
            this.setSigmaValue();
            return this.sigmaValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSigmaValue() {
            TimeVector timeVector = this;
            synchronized (timeVector) {
                if (super.size() >= 2) {
                    long average = this.getAvgValue();
                    double sumPoweredValues = 0.0;
                    for (Long xi : this) {
                        sumPoweredValues += Math.pow(xi - average, 2.0);
                    }
                    this.sigmaValue = Double.valueOf(Math.sqrt(sumPoweredValues / (double)(this.size() - 1))).intValue();
                }
            }
        }

        public long getMinValue() {
            return this.minValue;
        }

        public long getMaxValue() {
            return this.maxValue;
        }
    }

    public static class TelemetrySensor
    implements Comparable<TelemetrySensor> {
        long id;
        String name;
        TreeSet<TelemetryVar> variables = new TreeSet();

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public TelemetrySensor(long _id, String _name) {
            this.id = _id;
            this.name = _name;
        }

        public void addVariable(TelemetryVar v) {
            this.variables.add(new TelemetryVar(v));
        }

        public TreeSet<TelemetryVar> getVariables() {
            return this.variables;
        }

        public TelemetryVar getVar(int param) {
            for (TelemetryVar v : this.variables) {
                if (v.param != param) continue;
                return v;
            }
            return null;
        }

        @Override
        public int compareTo(TelemetrySensor o) {
            if (this.id > o.id) {
                return 1;
            }
            if (this.id == o.id) {
                return 0;
            }
            return -1;
        }
    }

    public static class TelemetryVar
    implements Comparable<TelemetryVar> {
        int param;
        String name;
        String unit;
        ArrayList<TelemetryItem> data;
        double maxValue = 0.0;
        double minValue = 0.0;
        TimeVector timeSteps;

        TelemetryVar(int _param, String _name, String _unit) {
            this.param = _param;
            this.name = _name;
            this.unit = _unit;
            this.data = new ArrayList();
            this.timeSteps = new TimeVector();
        }

        public TelemetryVar(TelemetryVar e) {
            this.param = e.param;
            this.name = e.name;
            this.unit = e.unit;
            this.data = new ArrayList<TelemetryItem>(e.data);
            this.timeSteps = new TimeVector();
        }

        public void addItem(TelemetryItem i, boolean skip) {
            this.data.add(new TelemetryItem(i));
            if (!skip) {
                this.timeSteps.add(i.getTimestamp());
                timeSteps.add(i.getTimestamp());
            }
        }

        public void addItem(int index, TelemetryItem i, boolean skip) {
            this.data.add(index, new TelemetryItem(i));
            if (!skip) {
                this.timeSteps.add(i.getTimestamp());
                timeSteps.add(i.getTimestamp());
            }
        }

        public TimeVector getTimeSteps() {
            return this.timeSteps;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getName() {
            return this.name;
        }

        public double getMax() {
            return this.maxValue;
        }

        public double getMin() {
            return this.minValue;
        }

        public String toString() {
            return this.name + " \t[" + this.unit + "]";
        }

        public double normamlizeItems() {
            this.maxValue = 0.0;
            this.minValue = 0.0;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            Collections.sort(this.data);
            long timeFINEset = 0L;
            if (this.data.size() > 0) {
                timeFINEset = this.data.get(0).getTimestamp();
                for (TelemetryItem row : this.data) {
                    double val = row.getDouble();
                    min = Math.min(val, min);
                    max = Math.max(val, max);
                    row.setTimestamp(row.getTimestamp() - timeFINEset);
                }
                this.maxValue = max;
                this.minValue = min;
                return (double)this.data.get(this.data.size() - 1).timestamp / 1000.0;
            }
            return 0.0;
        }

        @Override
        public int compareTo(TelemetryVar o) {
            return this.param - o.param;
        }

        public int getDecimals() {
            if (this.data.size() > 0) {
                return this.data.get(0).getDecimals();
            }
            return 0;
        }

        public int getType() {
            if (this.data.size() > 0) {
                return this.data.get(0).getType();
            }
            return 0;
        }

        public double getDoubleAt(double time_ms) {
            if (this.data.size() == 0) {
                return 0.0;
            }
            if (time_ms >= (double)this.data.get(this.data.size() - 1).timestamp) {
                return this.data.get(this.data.size() - 1).getDouble();
            }
            if (time_ms <= 0.0) {
                return this.data.get(0).getDouble();
            }
            for (int i = 0; i < this.data.size() - 1; ++i) {
                TelemetryItem i1 = this.data.get(i);
                TelemetryItem i2 = this.data.get(i + 1);
                if (!((double)i1.timestamp <= time_ms) || !((double)i2.timestamp > time_ms)) continue;
                if (i1.timestamp == i2.timestamp) {
                    return i1.getDouble();
                }
                double interv = (time_ms - (double)i1.timestamp) / (double)(i2.timestamp - i1.timestamp);
                return i1.getDouble() + interv * (i2.getDouble() - i1.getDouble());
            }
            return 0.0;
        }

        public double getDoubleCourseAt(double time_ms) {
            if (this.data.size() == 0) {
                return 0.0;
            }
            if (time_ms >= (double)this.data.get(this.data.size() - 1).timestamp) {
                return this.data.get(this.data.size() - 1).getDouble();
            }
            if (time_ms <= 0.0) {
                return this.data.get(0).getDouble();
            }
            for (int i = 0; i < this.data.size() - 1; ++i) {
                TelemetryItem i1 = this.data.get(i);
                TelemetryItem i2 = this.data.get(i + 1);
                if (!((double)i1.timestamp <= time_ms) || !((double)i2.timestamp > time_ms)) continue;
                if (i1.timestamp == i2.timestamp) {
                    return i1.getDouble();
                }
                double interv = (time_ms - (double)i1.timestamp) / (double)(i2.timestamp - i1.timestamp);
                double d1 = i1.getDouble();
                double d2 = i2.getDouble();
                if (Math.abs(d2 - d1) > 180.0) {
                    return d1 + interv * (d2 - d1 + (double)(d2 > d1 ? -360 : 360));
                }
                return d1 + interv * (d2 - d1);
            }
            return 0.0;
        }

        public int getNextIntFrom(double time_ms) {
            if (this.data.size() == 0) {
                return 0;
            }
            if (time_ms >= (double)this.data.get(this.data.size() - 1).timestamp) {
                return this.data.get(this.data.size() - 1).getInt();
            }
            if (time_ms <= 0.0) {
                return this.data.get(0).getInt();
            }
            for (int i = 0; i < this.data.size() - 1; ++i) {
                TelemetryItem i1 = this.data.get(i);
                TelemetryItem i2 = this.data.get(i + 1);
                if (!((double)i1.timestamp <= time_ms) || !((double)i2.timestamp > time_ms)) continue;
                if (i1.timestamp == i2.timestamp) {
                    return i1.getInt();
                }
                return i1.getInt();
            }
            return 0;
        }

        public int getIntAt(double time_ms) {
            if (this.data.size() == 0) {
                return 0;
            }
            if (time_ms >= (double)this.data.get(this.data.size() - 1).timestamp) {
                return this.data.get(this.data.size() - 1).getInt();
            }
            if (time_ms <= 0.0) {
                return this.data.get(0).getInt();
            }
            for (int i = 0; i < this.data.size(); ++i) {
                TelemetryItem i1 = this.data.get(i);
                if (!((double)i1.timestamp >= time_ms)) continue;
                return i1.getInt();
            }
            return 0;
        }

        public int getIntValueAt(double time_ms) {
            if (this.data.size() == 0) {
                return 0;
            }
            if (time_ms >= (double)this.data.get(this.data.size() - 1).timestamp) {
                return this.data.get(this.data.size() - 1).getIntValue();
            }
            if (time_ms <= 0.0) {
                return this.data.get(0).getIntValue();
            }
            for (int i = 0; i < this.data.size(); ++i) {
                TelemetryItem i1 = this.data.get(i);
                if (!((double)i1.timestamp >= time_ms)) continue;
                return i1.getIntValue();
            }
            return 0;
        }

        public ArrayList<TelemetryItem> getItems() {
            return this.data;
        }

        public synchronized int getParam() {
            return this.param;
        }
    }

    public static class TelemetryItem
    implements Comparable<TelemetryItem> {
        private int dataType;
        private int decimals;
        private int value;
        private long timestamp;

        public TelemetryItem(int type, int dec, int _value, long _timestamp) {
            this.dataType = type;
            this.decimals = dec;
            this.value = _value;
            this.timestamp = _timestamp;
        }

        TelemetryItem(TelemetryItem i) {
            this.dataType = i.dataType;
            this.decimals = i.decimals;
            this.value = i.value;
            this.timestamp = i.timestamp;
        }

        public int getType() {
            return this.dataType;
        }

        public double getDouble() {
            switch (this.dataType) {
                case 0: 
                case 1: 
                case 4: 
                case 8: 
                case 12: {
                    return (double)this.value * Math.pow(10.0, -this.decimals);
                }
                case 9: {
                    double minute = (double)(this.value & 0xFFFF) / 1000.0;
                    double stupne = this.value >> 16 & 0xFF;
                    return (stupne += minute / 60.0) * (double)((this.decimals >> 1 & 1) == 1 ? -1 : 1);
                }
                case 5: {
                    return (double)this.value * 1.0;
                }
            }
            return 0.0;
        }

        public int getIntValue() {
            switch (this.dataType) {
                case 0: 
                case 1: 
                case 4: 
                case 8: 
                case 12: {
                    switch (this.decimals) {
                        case 0: {
                            return this.value * 1000;
                        }
                        case 1: {
                            return this.value * 100;
                        }
                        case 2: {
                            return this.value * 10;
                        }
                        case 3: {
                            return this.value * 1;
                        }
                    }
                    return (int)((double)this.value * Math.pow(10.0, -this.decimals) * 1000.0);
                }
                case 9: {
                    double minute = (double)(this.value & 0xFFFF) / 1000.0;
                    double stupne = this.value >> 16 & 0xFF;
                    return (int)((stupne += minute / 60.0) * (double)((this.decimals >> 1 & 1) == 1 ? -1 : 1) * 1000000.0);
                }
                case 5: {
                    switch (this.decimals) {
                        case 0: {
                            return ((this.value >> 16) * 10000 + (this.value >> 8 & 0xFF) * 100 + (this.value & 0xFF)) * 1000;
                        }
                        case 1: {
                            return ((this.value & 0xFF) * 10000 + (this.value >> 8 & 0xFF) * 100 + (this.value >> 16)) * 1000;
                        }
                    }
                    return this.value * 1000;
                }
            }
            return 0;
        }

        public int getInt() {
            return this.value;
        }

        @Override
        public int compareTo(TelemetryItem o) {
            if (this.timestamp > o.timestamp) {
                return 1;
            }
            if (this.timestamp == o.timestamp) {
                return 0;
            }
            return -1;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        private void setTimestamp(long l) {
            this.timestamp = l;
        }

        private int getDecimals() {
            return this.decimals;
        }
    }
}

