/*
 * Decompiled with CFR 0.152.
 */
package gde.device.simprop;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.MissMatchDeviceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Logger;

public class CSVReaderWriter {
    static Logger log = Logger.getLogger(CSVReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();

    public static HashMap<String, String> getHeader(char separator, String filePath) throws NotSupportedFileFormatException, IOException {
        String line = "*";
        BufferedReader reader = null;
        HashMap<String, String> header = new HashMap<String, String>();
        IDevice device = application.getActiveDevice();
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
            header.put("DeviceName : ", application.getActiveDevice().getName().trim());
            header.put("Channel/Configuration Name: ", channels.getActiveChannel().getChannelConfigKey().trim());
            line = reader.readLine();
            String[] headerDataMeasurements = line.split("" + separator);
            StringBuilder sb = new StringBuilder();
            String[] measurements = device.getMeasurementNamesReplacements(application.getActiveChannelNumber());
            int j = 0;
            for (int i = 1; i < headerDataMeasurements.length; ++i) {
                if (headerDataMeasurements[i].trim().length() <= 3) continue;
                if (!headerDataMeasurements[i].trim().equals(measurements[j]) && headerDataMeasurements[i].startsWith("MSB")) {
                    sb.append(measurements[j]).append(separator);
                    sb.append(measurements[j] + "_alarm").append(separator);
                } else {
                    sb.append(headerDataMeasurements[i].trim()).append(separator);
                    sb.append(headerDataMeasurements[i].trim() + "_alarm").append(separator);
                }
                j += 2;
            }
            header.put("CSV_data_header_measurements : ", sb.toString());
            line = reader.readLine();
            String[] headerDataUnits = line.split("" + separator);
            sb = new StringBuilder();
            for (int i = 2; i < headerDataUnits.length; i += 3) {
                sb.append(headerDataUnits[i].trim().length() >= 1 ? headerDataUnits[i].trim() : " ").append(separator);
                sb.append(headerDataUnits[i].trim().length() >= 1 ? headerDataUnits[i].trim() : " ").append(separator);
            }
            header.put("CSV_data_header_units : ", sb.toString());
            log.log(java.util.logging.Level.FINE, "DeviceName : " + (String)header.get("DeviceName : "));
            log.log(java.util.logging.Level.FINE, "Channel/Configuration Name: " + (header.get("Channel/Configuration Name: ") != null ? (String)header.get("Channel/Configuration Name: ") : ""));
            log.log(java.util.logging.Level.FINE, "CSV_data_header_measurements : " + (String)header.get("CSV_data_header_measurements : "));
            log.log(java.util.logging.Level.FINE, "CSV_data_header_units : " + (String)header.get("CSV_data_header_units : "));
        }
        catch (FileNotFoundException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
        }
        catch (IOException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return header;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RecordSet read(char separator, String filePath, String recordSetNameExtend) throws NotSupportedFileFormatException, MissMatchDeviceException, IOException, DataInconsitsentException, DataTypeException {
        boolean isParsingError;
        RecordSet recordSet;
        block34: {
            String line = "*";
            recordSet = null;
            int progressLineLength = Math.abs(application.getActiveDevice().getDataBlockSize(InputTypes.FILE_IO));
            long inputFileSize = new File(filePath).length();
            IDevice device = application.getActiveDevice();
            Channel activeChannel = null;
            isParsingError = false;
            boolean isParsingErrorLine = false;
            try {
                int i;
                HashMap<String, String> fileHeader = CSVReaderWriter.getHeader(separator, filePath);
                activeChannel = (Channel)channels.get((Object)channels.getChannelNumber(fileHeader.get("Channel/Configuration Name: ")));
                Channel channel = activeChannel = activeChannel == null ? channels.getActiveChannel() : activeChannel;
                if (activeChannel == null) break block34;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0134") + filePath);
                GDE.getUiNotification().setProgress(0);
                int time_ms = 0;
                if (!application.getActiveDevice().getName().equals(fileHeader.get("DeviceName : "))) {
                    MissMatchDeviceException e = new MissMatchDeviceException(Messages.getString((String)"GDE_MSGW0013", (Object[])new Object[]{fileHeader.get("DeviceName : ")}));
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), (Throwable)e);
                    throw e;
                }
                log.log(java.util.logging.Level.FINE, "device name check ok, channel/configuration ok");
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                reader.readLine();
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                String[] tmpRecordNames = fileHeader.get("CSV_data_header_measurements : ").split(";");
                String[] tmpRecordUnits = fileHeader.get("CSV_data_header_units : ").split(";");
                String[] recordNames = new String[tmpRecordNames.length];
                String[] recordSymbols = new String[recordNames.length];
                String[] recordUnits = new String[recordNames.length];
                for (i = 0; i < tmpRecordNames.length; ++i) {
                    MeasurementType measurement = device.getMeasurement(activeChannel.getNumber(), i);
                    recordNames[i] = tmpRecordNames[i];
                    recordSymbols[i] = measurement.getSymbol();
                    recordUnits[i] = tmpRecordUnits[i];
                }
                recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannel.getNumber(), (String[])recordNames, (String[])recordSymbols, (String[])recordUnits, (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
                recordSetName = recordSet.getName();
                for (i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    if (!record.getName().startsWith("GPS")) continue;
                    if (record.getName().contains("Lon")) {
                        record.setDataType(Record.DataType.GPS_LONGITUDE);
                        record.setUnit("\u00b0");
                    }
                    if (record.getName().contains("Lat")) {
                        record.setDataType(Record.DataType.GPS_LATITUDE);
                        record.setUnit("\u00b0");
                    }
                    if (record.getName().startsWith("GPS H") || record.getName().startsWith("GPS Alt")) {
                        record.setDataType(Record.DataType.GPS_ALTITUDE);
                    }
                    if (!record.getName().startsWith("GPS Ges") && !record.getName().startsWith("GPS Spe") && !record.getName().startsWith("GPS Vit")) continue;
                    record.setDataType(Record.DataType.GPS_SPEED);
                }
                long startTimeStamp = (long)((double)new File(filePath).lastModified() - recordSet.getMaxTime_ms());
                recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                recordSet.setStartTimeStamp(startTimeStamp);
                activeChannel.setFileDescription(new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp).substring(0, 10) + activeChannel.getFileDescription().substring(10));
                for (String recordKey : recordNames) {
                    recordSet.get((Object)recordKey).setDisplayable(true);
                }
                GregorianCalendar date = new GregorianCalendar();
                date.setTime(new Date(recordSet.getStartTimeStamp()));
                int year = date.get(1);
                int month = date.get(2);
                int day = date.get(5);
                long lastTimeStamp = 0L;
                String[] updateRecordNames = recordNames;
                int[] points = new int[updateRecordNames.length];
                int lineNumber = 1;
                while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    isParsingErrorLine = false;
                    String[] dataStr = line.split("" + separator);
                    String data = dataStr[0].trim().replace(',', '.');
                    String data_alarm = dataStr[0].trim().replace(',', '.');
                    if (data.contains(":")) {
                        int second;
                        int minute;
                        int hour = Integer.parseInt(data.substring(0, 3));
                        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute = Integer.parseInt(data.substring(4, 6)), second = Integer.parseInt(data.substring(7, 9)));
                        long timeStamp = calendar.getTimeInMillis() + (long)(data.contains(".") ? Integer.parseInt(data.substring(data.lastIndexOf(46) + 1)) : 0);
                        if (lastTimeStamp >= timeStamp) continue;
                        time_ms = (int)(lastTimeStamp == 0L ? 0L : (long)time_ms + (timeStamp - lastTimeStamp));
                        lastTimeStamp = timeStamp;
                        if (startTimeStamp == 0L) {
                            startTimeStamp = timeStamp;
                        }
                    } else {
                        time_ms = Double.valueOf(Double.valueOf(data) * 1000.0).intValue();
                    }
                    int j = 1;
                    block21: for (int i2 = 0; i2 < updateRecordNames.length; i2 += 2, j += 3) {
                        try {
                            data = dataStr[j].trim().replace(',', '.').replace(" ", "");
                            data_alarm = dataStr[j + 2].trim().replace(',', '.').replace(" ", "");
                        }
                        catch (Exception e) {
                            data = "0";
                            data_alarm = "-";
                            log.log(java.util.logging.Level.WARNING, String.format("Check line = %s", line));
                        }
                        switch (recordSet.get(i2).getDataType()) {
                            case GPS_LONGITUDE: 
                            case GPS_LATITUDE: {
                                try {
                                    if (data.length() <= 0) continue block21;
                                    points[i2] = Double.valueOf(Double.valueOf(data) * 1000000.0).intValue();
                                }
                                catch (NumberFormatException e) {
                                    if (!isParsingErrorLine) {
                                        log.log(java.util.logging.Level.WARNING, Messages.getString((String)"GDE_MSGW3500", (Object[])new Object[]{lineNumber, line}));
                                    }
                                    GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGW3500", (Object[])new Object[]{lineNumber, line}), 3);
                                    isParsingErrorLine = true;
                                    isParsingError = true;
                                }
                                continue block21;
                            }
                            default: {
                                try {
                                    if (data.length() > 0) {
                                        points[i2] = Double.valueOf(Double.valueOf(data) * 1000.0).intValue();
                                    }
                                    if (data_alarm.length() <= 0 || data_alarm.equals("-")) continue block21;
                                    points[i2 + 1] = Double.valueOf(Double.valueOf(data) * 1000.0).intValue();
                                    continue block21;
                                }
                                catch (NumberFormatException e) {
                                    if (!isParsingErrorLine) {
                                        log.log(java.util.logging.Level.WARNING, Messages.getString((String)"GDE_MSGW3500", (Object[])new Object[]{lineNumber, line}));
                                    }
                                    GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGW3500", (Object[])new Object[]{lineNumber, line}), 3);
                                    isParsingErrorLine = true;
                                    isParsingError = true;
                                }
                            }
                        }
                    }
                    recordSet.addPoints(points, (double)time_ms);
                    int progress = (int)((long)(lineNumber * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length())));
                    if (progress > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                    GDE.getUiNotification().setProgress(progress);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                recordSet.setSaved(true);
                activeChannel.put((Object)recordSetName, (Object)recordSet);
                activeChannel.setActiveRecordSet(recordSetName);
                activeChannel.applyTemplate(recordSetName, true);
                recordSet.updateVisibleAndDisplayableRecordsForTable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet(recordSetName);
                }
                reader.close();
                reader = null;
            }
            catch (UnsupportedEncodingException e) {
                try {
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    throw new UnsupportedEncodingException(Messages.getString((String)"GDE_MSGW0010"));
                    catch (FileNotFoundException e2) {
                        log.log(java.util.logging.Level.SEVERE, e2.getMessage(), e2);
                        throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
                    }
                    catch (IOException e3) {
                        log.log(java.util.logging.Level.SEVERE, e3.getMessage(), e3);
                        throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
                    }
                }
                catch (Throwable throwable) {
                    GDE.getUiNotification().setProgress(100);
                    GDE.getUiNotification().setStatusMessage(isParsingError ? Messages.getString((String)"GDE_MSGW3501") : "", 3);
                    if (!GDE.isWithUi()) throw throwable;
                    application.getMenuToolBar().updateChannelSelector();
                    application.getMenuToolBar().updateRecordSetSelectCombo();
                    throw throwable;
                }
            }
        }
        GDE.getUiNotification().setProgress(100);
        GDE.getUiNotification().setStatusMessage(isParsingError ? Messages.getString((String)"GDE_MSGW3501") : "", 3);
        if (!GDE.isWithUi()) return recordSet;
        application.getMenuToolBar().updateChannelSelector();
        application.getMenuToolBar().updateRecordSetSelectCombo();
        return recordSet;
    }

    public static void write(char separator, String recordSetKey, String filePath, boolean isRaw) throws Exception {
        try {
            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0138", (Object[])new String[]{"csv", filePath}));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "ISO-8859-1"));
            char decimalSeparator = Settings.getInstance().getDecimalSeparator();
            df3.setGroupingUsed(false);
            StringBuffer sb = new StringBuffer();
            RecordSet recordSet = (RecordSet)Channels.getInstance().getActiveChannel().get((Object)recordSetKey);
            IDevice device = DataExplorer.getInstance().getActiveDevice();
            sb.append(device.getName()).append(separator).append(recordSet.getChannelConfigName()).append(lineSep);
            writer.write(sb.toString());
            log.log(java.util.logging.Level.FINE, "written header line = " + sb.toString());
            sb = new StringBuffer();
            sb.append(Messages.getString((String)"GDE_MSGT0137")).append(separator);
            for (int i = 0; i < recordSet.size(); ++i) {
                MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), i);
                Record record = recordSet.get(i);
                log.log(java.util.logging.Level.FINEST, "append " + record.getName());
                if (isRaw) {
                    if (measurement.isCalculation()) continue;
                    sb.append(record.getName()).append(" [---]").append(separator);
                    log.log(java.util.logging.Level.FINEST, "append " + record.getName());
                    continue;
                }
                sb.append(record.getName()).append(" [").append(record.getUnit()).append(']').append(separator);
                log.log(java.util.logging.Level.FINEST, "append " + record.getName());
            }
            sb.deleteCharAt(sb.length() - 1).append(lineSep);
            log.log(java.util.logging.Level.FINER, "header line = " + sb.toString());
            writer.write(sb.toString());
            long startTime = new Date(recordSet.getTime(0)).getTime();
            int recordEntries = recordSet.getRecordDataSize(true);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            for (int i = 0; i < recordEntries; ++i) {
                sb = new StringBuffer();
                String[] row = recordSet.getExportRow(i, true);
                sb.append(row[0].replace('.', decimalSeparator)).append(separator).append(" ");
                for (int j = 0; j < recordSet.size(); ++j) {
                    MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), j);
                    if (isRaw) {
                        if (measurement.isCalculation()) continue;
                        if (recordSet.isRaw()) {
                            sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                            continue;
                        }
                        sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                        continue;
                    }
                    sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                }
                sb.deleteCharAt(sb.length() - 1).append(lineSep);
                writer.write(sb.toString());
                if (i % 50 == 0) {
                    GDE.getUiNotification().setProgress(++progressCycle * 5000 / recordEntries);
                }
                if (!log.isLoggable(java.util.logging.Level.FINE)) continue;
                log.log(java.util.logging.Level.FINE, "data line = " + sb.toString());
            }
            sb = null;
            log.log(Level.TIME, "CSV file = " + filePath + " erfolgreich geschiebenwrite time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
            writer.flush();
            writer.close();
            writer = null;
            GDE.getUiNotification().setProgress(100);
        }
        catch (IOException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0006", (Object[])new Object[]{"csv", filePath, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
    }
}

