/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.TransitionType;
import gde.histo.transitions.AbstractDetector;
import gde.histo.transitions.GroupTransitions;
import gde.histo.transitions.Transition;
import gde.log.Logger;
import java.util.logging.Level;

public final class PulseDetector
extends AbstractDetector {
    static final String $CLASS_NAME = PulseDetector.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    private final RecordSet recordSet;

    public PulseDetector(RecordSet recordSet) {
        super(recordSet.getAnalyzer());
        this.recordSet = recordSet;
    }

    public GroupTransitions.TransitionChronicle findTransitions(Record record, TransitionType transitionType) {
        this.triggerState = AbstractDetector.TriggerState.WAITING;
        this.initializeDeques(record, transitionType);
        return this.findPulseTransitions(record, transitionType);
    }

    private GroupTransitions.TransitionChronicle findPulseTransitions(Record record, TransitionType transitionType) {
        GroupTransitions.TransitionChronicle transitions = new GroupTransitions.TransitionChronicle();
        IDevice device = this.analyzer.getActiveDevice();
        AbstractDetector.LevelChecker levelChecker = new AbstractDetector.LevelChecker(record, transitionType);
        block5: for (int i = 0; i < record.realSize() && record.elementAt(i) != null; ++i) {
            long timeStamp_100ns = (long)(record.getTime_ms(i) * 10.0);
            double translatedValue = device.translateValue(record, (double)((Integer)record.elementAt(i)).intValue() / 1000.0);
            switch (this.triggerState) {
                case WAITING: {
                    this.previousTriggerState = this.triggerState;
                    boolean isThresholdLevel = levelChecker.isBeyondThresholdLevel(translatedValue);
                    if (isThresholdLevel && !this.referenceDeque.isAddableInTimePeriod(timeStamp_100ns) && !levelChecker.isBeyondThresholdLevel(this.referenceDeque.getSecurityValue())) {
                        this.triggerState = AbstractDetector.TriggerState.TRIGGERED;
                        this.thresholdDeque.initialize(i);
                        this.thresholdDeque.addLast(translatedValue, timeStamp_100ns);
                        log.finer(() -> Integer.toString(transitionType.getTransitionId()) + this);
                        continue block5;
                    }
                    this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                    continue block5;
                }
                case TRIGGERED: {
                    this.previousTriggerState = this.triggerState;
                    boolean isPersistentTrigger = levelChecker.isBeyondThresholdLevel(translatedValue);
                    boolean isInThresholdTime = this.thresholdDeque.isAddableInTimePeriod(timeStamp_100ns);
                    boolean isRecovered = levelChecker.isBeyondRecoveryLevel(translatedValue);
                    if (!isInThresholdTime && isRecovered) {
                        if (!levelChecker.isBeyondRecoveryLevel(this.thresholdDeque.getSecurityValue())) {
                            this.triggerState = AbstractDetector.TriggerState.RECOVERING;
                            this.recoveryDeque.initialize(i);
                            this.recoveryDeque.addLast(translatedValue, timeStamp_100ns);
                            log.finer(() -> Integer.toString(transitionType.getTransitionId()) + this);
                            continue block5;
                        }
                        this.triggerState = AbstractDetector.TriggerState.WAITING;
                        log.log(Level.FINER, " threshold SecurityValue ", this);
                        this.thresholdDeque.clear();
                        this.referenceDeque.initialize(i);
                        this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                        continue block5;
                    }
                    if (!isPersistentTrigger && !isInThresholdTime) {
                        this.thresholdDeque.addLast(translatedValue, timeStamp_100ns);
                        continue block5;
                    }
                    if (!isPersistentTrigger && isInThresholdTime) {
                        this.triggerState = AbstractDetector.TriggerState.WAITING;
                        log.log(Level.FINER, " !isPersistentTrigger ", this);
                        this.thresholdDeque.clear();
                        this.referenceDeque.initialize(i);
                        this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                        continue block5;
                    }
                    this.thresholdDeque.addLast(translatedValue, timeStamp_100ns);
                    continue block5;
                }
                case RECOVERING: {
                    this.previousTriggerState = this.triggerState;
                    boolean isPersistentRecovery = levelChecker.isBeyondRecoveryLevel(translatedValue);
                    if (!this.recoveryDeque.isAddableInTimePeriod(timeStamp_100ns)) {
                        if (!(levelChecker.isBeyondThresholdLevel(this.referenceDeque.getSecurityValue()) || levelChecker.isBeyondRecoveryLevel(this.thresholdDeque.getSecurityValue()) || levelChecker.isBeyondThresholdLevel(this.recoveryDeque.getSecurityValue()))) {
                            this.triggerState = AbstractDetector.TriggerState.WAITING;
                            log.log(Level.FINER, Integer.toString(transitionType.getTransitionId()), this);
                            Transition transition = new Transition(this.referenceDeque.startIndex, this.referenceDeque.size(), this.thresholdDeque.startIndex, this.thresholdDeque.size(), this.recoveryDeque.startIndex, this.recoveryDeque.size(), record, transitionType);
                            transitions.put(transition.getThresholdStartTimeStamp_ms(), transition);
                            log.log(Level.FINE, ">", transition);
                            this.thresholdDeque.clear();
                            this.referenceDeque.initialize(this.recoveryDeque.getStartIndex());
                            this.referenceDeque.addLastByMoving(this.recoveryDeque);
                            this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                            continue block5;
                        }
                        log.warning(() -> String.format("%d trigger security check provoked a fallback %s: translatedValue=%f  thresholdAverage=%f", transitionType.getTransitionId(), this.thresholdDeque.getFormatedDuration(this.thresholdDeque.size() - 1), translatedValue, this.thresholdDeque.getAverageValue()));
                        this.triggerState = AbstractDetector.TriggerState.WAITING;
                        log.finer(() -> Integer.toString(transitionType.getTransitionId()) + this);
                        this.thresholdDeque.clear();
                        this.referenceDeque.initialize(this.recoveryDeque.getStartIndex());
                        this.referenceDeque.addLastByMoving(this.recoveryDeque);
                        this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                        continue block5;
                    }
                    if (!isPersistentRecovery) {
                        this.triggerState = AbstractDetector.TriggerState.WAITING;
                        log.log(Level.FINER, " !isPersistentRecovery " + transitionType.getTransitionId(), this);
                        this.thresholdDeque.clear();
                        this.referenceDeque.initialize(this.recoveryDeque.getStartIndex());
                        this.referenceDeque.addLastByMoving(this.recoveryDeque);
                        this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                        continue block5;
                    }
                    this.recoveryDeque.addLast(translatedValue, timeStamp_100ns);
                }
            }
        }
        if (this.triggerState == AbstractDetector.TriggerState.RECOVERING) {
            if (!(levelChecker.isBeyondThresholdLevel(this.referenceDeque.getSecurityValue()) || levelChecker.isBeyondRecoveryLevel(this.thresholdDeque.getSecurityValue()) || levelChecker.isBeyondThresholdLevel(this.recoveryDeque.getSecurityValue()))) {
                Transition transition = new Transition(this.referenceDeque.startIndex, this.referenceDeque.size(), this.thresholdDeque.startIndex, this.thresholdDeque.size(), this.recoveryDeque.startIndex, this.recoveryDeque.size(), record, transitionType);
                transitions.put(transition.getThresholdStartTimeStamp_ms(), transition);
                log.log(Level.FINE, ">", transition);
            }
        } else if (this.triggerState == AbstractDetector.TriggerState.TRIGGERED) {
            log.finer(() -> String.format("ends %s %s  referenceExtreme=%f ", new Object[]{this.triggerState, this.thresholdDeque.getFormatedDuration(this.thresholdDeque.size() - 1), this.referenceDeque.extremeValue}) + this.thresholdDeque.getExtremeValue() + this.thresholdDeque.getTranslatedValues());
        }
        return transitions;
    }

    private void initializeDeques(Record transitionRecord, TransitionType transitionType) {
        int referenceDequeSize = (int)((double)transitionType.getReferenceTimeMsec() / this.recordSet.getAverageTimeStep_ms());
        int thresholdDequeSize = (int)((double)transitionType.getThresholdTimeMsec() / this.recordSet.getAverageTimeStep_ms());
        int recoveryDequeSize = (int)((double)transitionType.getRecoveryTimeMsec().orElseThrow(() -> new UnsupportedOperationException("recovery time. transitionID=" + transitionType.getTransitionId())).intValue() / this.recordSet.getAverageTimeStep_ms());
        this.referenceDeque = new AbstractDetector.SettlementDeque(referenceDequeSize, transitionType.isGreater(), transitionType.getReferenceTimeMsec() * 10);
        this.thresholdDeque = new AbstractDetector.SettlementDeque(thresholdDequeSize, !transitionType.isGreater(), transitionType.getThresholdTimeMsec() * 10);
        this.recoveryDeque = new AbstractDetector.SettlementDeque(recoveryDequeSize, transitionType.isGreater(), (Integer)transitionType.getRecoveryTimeMsec().orElse(null) * 10);
        this.referenceDeque.initialize(0);
        int descriptionCutPoint = transitionRecord.getParent().getDescription().indexOf("\r");
        if (descriptionCutPoint < 0) {
            descriptionCutPoint = 11;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, transitionType.getTransitionId() + "  " + transitionRecord.getParent().getName() + "  " + transitionRecord.getParent().getDescription().substring(0, descriptionCutPoint) + String.format(" %s initialized: referenceDequeSize=%d  thresholdDequeSize=%d  recoveryDequeSize=%d", transitionRecord.getName(), referenceDequeSize, thresholdDequeSize, recoveryDequeSize));
        }
    }
}

