/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.Analyzer;
import gde.device.IChannelItem;
import gde.device.SettlementType;
import gde.device.TrailDisplayType;
import gde.device.TrailTypes;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailSelector;
import gde.log.Level;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;

public final class SettlementTrailSelector
extends TrailSelector {
    public SettlementTrailSelector(TrailRecord trailRecord) {
        super(trailRecord);
    }

    public SettlementTrailSelector(Analyzer analyzer, IChannelItem channelItem, String recordName, boolean smartStatistics) {
        super(analyzer, channelItem, recordName, smartStatistics);
    }

    @Override
    protected void setApplicableTrails() {
        if (this.channelItem.getTrailDisplay().map(TrailDisplayType::getDefaultTrail).map(TrailTypes::isSuite).orElse(false).booleanValue()) {
            throw new UnsupportedOperationException("suite trail must not be a device settlement default");
        }
        BitSet applicablePrimitiveTrails = this.getApplicablePrimitiveTrails();
        this.applicableTrailsOrdinals = new ArrayList();
        this.applicableTrailsTexts = new ArrayList();
        applicablePrimitiveTrails.stream().forEach(i -> {
            this.applicableTrailsOrdinals.add(i);
            this.applicableTrailsTexts.add(TrailTypes.VALUES[i].getDisplayName());
        });
        this.setApplicableSuiteTrails();
        log.finer(() -> this.recordName + " texts " + this.applicableTrailsTexts);
        log.finer(() -> this.recordName + " ordinals " + this.applicableTrailsOrdinals);
    }

    public BitSet getApplicablePrimitiveTrails() {
        Optional<TrailDisplayType> trailDisplay = this.channelItem.getTrailDisplay();
        if (((SettlementType)this.channelItem).getEvaluation().getTransitionAmount() != null) {
            throw new UnsupportedOperationException("TransitionAmount not implemented");
        }
        BitSet trails = new BitSet();
        TrailTypes.getPrimitives().stream().filter(t -> !t.isTriggered()).filter(t -> !TrailTypes.OPTIONAL_TRAILS.contains(t)).filter(t -> t.isSmartStatistics() == this.smartStatistics).map(Enum::ordinal).forEach(idx -> trails.set((int)idx));
        trailDisplay.ifPresent(d -> this.adaptTrailsToDisplayType(trails, (TrailDisplayType)d));
        if (trails.isEmpty()) {
            trails.set(TrailTypes.getSubstitute(this.smartStatistics).ordinal());
        }
        log.finer(() -> this.recordName + " data " + trails.toString());
        return trails;
    }

    private TrailTypes getTrailType() {
        if (this.trailTextSelectedIndex < 0) {
            log.log(Level.SEVERE, "index not defined yet ", this.trailTextSelectedIndex);
            throw new UnsupportedOperationException();
        }
        return TrailTypes.fromOrdinal((Integer)this.applicableTrailsOrdinals.get(this.trailTextSelectedIndex));
    }

    @Override
    public boolean isTrailSuite() {
        return this.getTrailType().isSuite();
    }

    @Override
    public boolean isRangePlotSuite() {
        return this.getTrailType().isRangePlot();
    }

    @Override
    public boolean isBoxPlotSuite() {
        return this.getTrailType().isBoxPlot();
    }

    @Override
    public boolean isOddRangeTrail() {
        return TrailTypes.ODD_RANGE_TRAILS.contains((Object)this.getTrailType());
    }

    @Override
    public int getSuiteMasterIndex() {
        return this.getTrailType().getSuiteMasterIndex();
    }

    @Override
    public List<TrailTypes> getSuiteMembers() {
        return this.getTrailType().getSuiteMembers();
    }
}

