/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader;

import com.monstarmike.tlmreader.FlightDefinition;
import com.monstarmike.tlmreader.IFlight;
import com.monstarmike.tlmreader.TlmParser;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.HeaderNameBlock;
import com.monstarmike.tlmreader.datablock.HeaderRpmBlock;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class TlmFlightDefinitionParser
extends TlmParser {
    private final ArrayList<IFlight> flights = new ArrayList();

    TlmFlightDefinitionParser() {
    }

    @Override
    protected void handleHeaderBlock(byte[] headerBytes, int flightNumber) {
        if (HeaderNameBlock.isHeaderName(headerBytes)) {
            this.flights.add(new FlightDefinition());
            this.getCurrentFlight().addHeaderNameBlock(new HeaderNameBlock(headerBytes));
        } else if (HeaderRpmBlock.isRpmHeader(headerBytes)) {
            this.getCurrentFlight().addRpmHeaderBlock(new HeaderRpmBlock(headerBytes));
        }
    }

    @Override
    protected void handleDataBlock(byte[] dataBytes, int flightNumber) {
        DataBlock createdDataBlock = DataBlock.createDataBlock(dataBytes, this.getCurrentFlight().getRpmHeader());
        if (createdDataBlock != null) {
            this.getCurrentFlight().addDataBlock(createdDataBlock);
        }
    }

    private IFlight getCurrentFlight() {
        if (this.flights.isEmpty()) {
            throw new RuntimeException("No current Flight available");
        }
        return this.flights.get(this.flights.size() - 1);
    }

    public List<IFlight> parseFlightDefinitions(BufferedInputStream bufferedStream) throws IOException {
        this.parseStream(bufferedStream);
        return this.flights;
    }
}

