/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channels;
import gde.device.MeasurementType;
import gde.device.smmodellbau.UniLog;
import gde.device.smmodellbau.UniLogDialog;
import gde.device.smmodellbau.UniLogSerialPort;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniLogTelemetryTab
extends Composite {
    static final Logger log = Logger.getLogger(UniLogTelemetryTab.class.getName());
    Button readTelemetryConfigurationButton;
    Text headerLabel;
    Button writeTelemtryConfigurationButton;
    Group alarmGroup;
    Button alarmButton1;
    Button alarmButton2;
    Button alarmButton3;
    Button alarmButton4;
    Button alarmButton5;
    Text alarmText1;
    Text alarmText2;
    Text alarmText3;
    Text alarmText4;
    Text alarmText5;
    Slider alarmSlider1;
    Slider alarmSlider2;
    Slider alarmSlider3;
    Slider alarmSlider4;
    Slider alarmSlider5;
    CLabel alarmLabel1;
    CLabel alarmLabel2;
    CLabel alarmLabel3;
    CLabel alarmLabel4;
    CLabel alarmLabel5;
    boolean isAlarmButton1;
    boolean isAlarmButton2;
    boolean isAlarmButton3;
    boolean isAlarmButton4;
    boolean isAlarmButton5;
    int alarmValue1;
    int alarmValue4;
    int alarmValue5;
    double alarmValue2;
    double alarmValue3;
    String voltageUnit;
    String voltageStartUnit;
    String currentUnit;
    String capacityUnit;
    String heightUnit;
    Group mLinkAddressesGroup;
    CLabel addressLabel1;
    CLabel addressLabel2;
    CLabel addressLabel3;
    CLabel addressLabel4;
    CLabel addressLabel5;
    Text addressText1;
    Text addressText2;
    Text addressText3;
    Text addressText4;
    Text addressText5;
    Slider addressSlider1;
    Slider addressSlider2;
    Slider addressSlider3;
    Slider addressSlider4;
    Slider addressSlider5;
    int addressValue1;
    int addressValue2;
    int addressValue3;
    int addressValue4;
    int addressValue5;
    String addressLabelName1;
    String addressLabelName2;
    String addressLabelName3;
    String addressLabelName4;
    String addressLabelName5;
    final UniLog device;
    final UniLogDialog dialog;
    final UniLogSerialPort serialPort;
    final DataExplorer application;
    final Channels channels;

    public UniLogTelemetryTab(CTabFolder parent, UniLog useDevice) {
        super((Composite)parent, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.isAlarmButton1 = false;
        this.isAlarmButton2 = true;
        this.isAlarmButton3 = false;
        this.isAlarmButton4 = false;
        this.isAlarmButton5 = true;
        this.alarmValue1 = 60;
        this.alarmValue4 = 2600;
        this.alarmValue5 = 300;
        this.alarmValue2 = 14.0;
        this.alarmValue3 = 12.0;
        this.addressValue1 = 3;
        this.addressValue2 = 2;
        this.addressValue3 = 5;
        this.addressValue4 = 4;
        this.addressValue5 = 6;
        this.device = useDevice;
        this.dialog = useDevice.getDialog();
        this.serialPort = this.device.getCommunicationPort();
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.initGUI();
    }

    private void initGUI() {
        try {
            FormLayout thisLayout = new FormLayout();
            this.setLayout((Layout)thisLayout);
            MeasurementType measurement = this.device.getMeasurement(1, 1);
            this.voltageUnit = measurement.getUnit();
            this.voltageStartUnit = measurement.getUnit() + "start";
            this.addressLabelName2 = measurement.getName();
            measurement = this.device.getMeasurement(1, 2);
            this.currentUnit = measurement.getUnit();
            this.addressLabelName1 = measurement.getName();
            measurement = this.device.getMeasurement(1, 3);
            this.capacityUnit = measurement.getUnit();
            this.addressLabelName4 = measurement.getName();
            measurement = this.device.getMeasurement(1, 9);
            this.heightUnit = measurement.getUnit();
            this.addressLabelName5 = measurement.getName();
            measurement = this.device.getMeasurement(1, 7);
            this.addressLabelName3 = measurement.getName();
            this.headerLabel = new Text((Composite)this, 16777288);
            FormData headerLabelLData = new FormData();
            headerLabelLData.left = new FormAttachment(0, 1000, 50);
            headerLabelLData.top = new FormAttachment(0, 1000, 10);
            headerLabelLData.right = new FormAttachment(1000, 1000, -50);
            headerLabelLData.bottom = new FormAttachment(1000, 1000, -295);
            this.headerLabel.setLayoutData((Object)headerLabelLData);
            this.headerLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.headerLabel.setText(Messages.getString((String)"GDE_MSGT1386"));
            this.headerLabel.setBackground(SWTResourceManager.getColor((int)22));
            this.readTelemetryConfigurationButton = new Button((Composite)this, 0x1000008);
            FormData readTelemetryConfigurationButtonLData = new FormData();
            readTelemetryConfigurationButtonLData.left = new FormAttachment(0, 1000, 100);
            readTelemetryConfigurationButtonLData.top = new FormAttachment(0, 1000, 56);
            readTelemetryConfigurationButtonLData.right = new FormAttachment(1000, 1000, -100);
            readTelemetryConfigurationButtonLData.bottom = new FormAttachment(1000, 1000, -244);
            readTelemetryConfigurationButtonLData.width = 429;
            readTelemetryConfigurationButtonLData.height = 40;
            this.readTelemetryConfigurationButton.setLayoutData((Object)readTelemetryConfigurationButtonLData);
            this.readTelemetryConfigurationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.readTelemetryConfigurationButton.setText(Messages.getString((String)"GDE_MSGT1387"));
            this.readTelemetryConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "readTelemetryConfigurationButton.widgetSelected, event=" + evt);
                    try {
                        UniLogTelemetryTab.this.updateTelemetryConfigurationValues(UniLogTelemetryTab.this.serialPort.readTelemetryConfiguration());
                    }
                    catch (Exception e) {
                        UniLogTelemetryTab.this.application.openMessageDialog(UniLogTelemetryTab.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.alarmGroup = new Group((Composite)this, 0);
            RowLayout alarmGroupLayout = new RowLayout(256);
            this.alarmGroup.setLayout((Layout)alarmGroupLayout);
            FormData alarmGroupLData = new FormData();
            alarmGroupLData.left = new FormAttachment(0, 1000, 10);
            alarmGroupLData.top = new FormAttachment(0, 1000, 105);
            alarmGroupLData.width = 360;
            alarmGroupLData.height = 131;
            alarmGroupLData.right = new FormAttachment(1000, 1000, -255);
            alarmGroupLData.bottom = new FormAttachment(1000, 1000, -75);
            this.alarmGroup.setLayoutData((Object)alarmGroupLData);
            this.alarmGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmGroup.setText(Messages.getString((String)"GDE_MSGT1394"));
            this.alarmButton1 = new Button((Composite)this.alarmGroup, 16416);
            RowData alarmButton1LData = new RowData();
            alarmButton1LData.width = 140;
            alarmButton1LData.height = 22;
            this.alarmButton1.setLayoutData((Object)alarmButton1LData);
            this.alarmButton1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmButton1.setText(Messages.getString((String)"GDE_MSGT1396"));
            this.alarmButton1.setSelection(this.isAlarmButton1);
            this.alarmButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmButton1.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.isAlarmButton1 = UniLogTelemetryTab.this.alarmButton1.getSelection();
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmText1 = new Text((Composite)this.alarmGroup, 133128);
            RowData alarmText1LData = new RowData();
            alarmText1LData.width = 40;
            alarmText1LData.height = 14;
            this.alarmText1.setLayoutData((Object)alarmText1LData);
            this.alarmText1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmText1.setText("" + this.alarmValue1);
            RowData alarmSlider1LData = new RowData();
            alarmSlider1LData.width = 100;
            alarmSlider1LData.height = 18;
            this.alarmSlider1 = new Slider((Composite)this.alarmGroup, 0);
            this.alarmSlider1.setLayoutData((Object)alarmSlider1LData);
            this.alarmSlider1.setMinimum(1);
            this.alarmSlider1.setMaximum(410);
            this.alarmSlider1.setIncrement(1);
            this.alarmSlider1.setSelection(this.alarmValue1);
            this.alarmSlider1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmSlider1.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.alarmValue1 = UniLogTelemetryTab.this.alarmSlider1.getSelection();
                    UniLogTelemetryTab.this.alarmText1.setText("" + UniLogTelemetryTab.this.alarmValue1);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmLabel1 = new CLabel((Composite)this.alarmGroup, 0);
            RowData alarmLabel1LData = new RowData();
            alarmLabel1LData.width = 40;
            alarmLabel1LData.height = 22;
            this.alarmLabel1.setLayoutData((Object)alarmLabel1LData);
            this.alarmLabel1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLabel1.setText(this.currentUnit);
            this.alarmButton2 = new Button((Composite)this.alarmGroup, 16416);
            RowData alarmButton2LData = new RowData();
            alarmButton2LData.width = 140;
            alarmButton2LData.height = 22;
            this.alarmButton2.setLayoutData((Object)alarmButton2LData);
            this.alarmButton2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmButton2.setText(Messages.getString((String)"GDE_MSGT1389"));
            this.alarmButton2.setSelection(this.isAlarmButton2);
            this.alarmButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmButton2.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.isAlarmButton2 = UniLogTelemetryTab.this.alarmButton2.getSelection();
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmText2 = new Text((Composite)this.alarmGroup, 133128);
            RowData alarmText2LData = new RowData();
            alarmText2LData.width = 40;
            alarmText2LData.height = 14;
            this.alarmText2.setLayoutData((Object)alarmText2LData);
            this.alarmText2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmText2.setText(String.format("%.1f", this.alarmValue2));
            RowData alarmSlider2LData = new RowData();
            alarmSlider2LData.width = 100;
            alarmSlider2LData.height = 18;
            this.alarmSlider2 = new Slider((Composite)this.alarmGroup, 0);
            this.alarmSlider2.setLayoutData((Object)alarmSlider2LData);
            this.alarmSlider2.setMinimum(10);
            this.alarmSlider2.setMaximum(610);
            this.alarmSlider2.setIncrement(1);
            this.alarmSlider2.setSelection((int)this.alarmValue2 * 10);
            this.alarmSlider2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmSlider2.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.alarmValue2 = (double)UniLogTelemetryTab.this.alarmSlider2.getSelection() / 10.0;
                    UniLogTelemetryTab.this.alarmText2.setText(String.format("%.1f", UniLogTelemetryTab.this.alarmValue2));
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmLabel2 = new CLabel((Composite)this.alarmGroup, 0);
            RowData alarmLabel2LData = new RowData();
            alarmLabel2LData.width = 40;
            alarmLabel2LData.height = 22;
            this.alarmLabel2.setLayoutData((Object)alarmLabel2LData);
            this.alarmLabel2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLabel2.setText(this.voltageStartUnit);
            this.alarmButton3 = new Button((Composite)this.alarmGroup, 16416);
            RowData alarmButton3LData = new RowData();
            alarmButton3LData.width = 140;
            alarmButton3LData.height = 22;
            this.alarmButton3.setLayoutData((Object)alarmButton3LData);
            this.alarmButton3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmButton3.setText(Messages.getString((String)"GDE_MSGT1389"));
            this.alarmButton3.setSelection(this.isAlarmButton3);
            this.alarmButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmButton3.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.isAlarmButton3 = UniLogTelemetryTab.this.alarmButton3.getSelection();
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmText3 = new Text((Composite)this.alarmGroup, 133128);
            RowData alarmText3LData = new RowData();
            alarmText3LData.width = 40;
            alarmText3LData.height = 14;
            this.alarmText3.setLayoutData((Object)alarmText3LData);
            this.alarmText3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmText3.setText(String.format("%.1f", this.alarmValue3));
            RowData alarmSlider3LData = new RowData();
            alarmSlider3LData.width = 100;
            alarmSlider3LData.height = 18;
            this.alarmSlider3 = new Slider((Composite)this.alarmGroup, 0);
            this.alarmSlider3.setLayoutData((Object)alarmSlider3LData);
            this.alarmSlider3.setMinimum(10);
            this.alarmSlider3.setMaximum(610);
            this.alarmSlider3.setIncrement(1);
            this.alarmSlider3.setSelection((int)this.alarmValue3 * 10);
            this.alarmSlider3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmSlider3.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.alarmValue3 = (double)UniLogTelemetryTab.this.alarmSlider3.getSelection() / 10.0;
                    UniLogTelemetryTab.this.alarmText3.setText(String.format("%.1f", UniLogTelemetryTab.this.alarmValue3));
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmLabel3 = new CLabel((Composite)this.alarmGroup, 0);
            RowData alarmLabel3LData = new RowData();
            alarmLabel3LData.width = 40;
            alarmLabel3LData.height = 22;
            this.alarmLabel3.setLayoutData((Object)alarmLabel3LData);
            this.alarmLabel3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLabel3.setText(this.voltageUnit);
            this.alarmButton4 = new Button((Composite)this.alarmGroup, 16416);
            RowData alarmButton4LData = new RowData();
            alarmButton4LData.width = 140;
            alarmButton4LData.height = 22;
            this.alarmButton4.setLayoutData((Object)alarmButton4LData);
            this.alarmButton4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmButton4.setText(Messages.getString((String)"GDE_MSGT1391"));
            this.alarmButton4.setSelection(this.isAlarmButton4);
            this.alarmButton4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmButton4.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.isAlarmButton4 = UniLogTelemetryTab.this.alarmButton4.getSelection();
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmText4 = new Text((Composite)this.alarmGroup, 133128);
            RowData alarmText4LData = new RowData();
            alarmText4LData.width = 40;
            alarmText4LData.height = 14;
            this.alarmText4.setLayoutData((Object)alarmText4LData);
            this.alarmText4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmText4.setText("" + this.alarmValue4);
            RowData alarmSlider4LData = new RowData();
            alarmSlider4LData.width = 100;
            alarmSlider4LData.height = 18;
            this.alarmSlider4 = new Slider((Composite)this.alarmGroup, 0);
            this.alarmSlider4.setLayoutData((Object)alarmSlider4LData);
            this.alarmSlider4.setMinimum(10);
            this.alarmSlider4.setMaximum(1010);
            this.alarmSlider4.setIncrement(5);
            this.alarmSlider4.setSelection(this.alarmValue4 / 10);
            this.alarmSlider4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmSlider4.widgetSelected, selection=" + UniLogTelemetryTab.this.alarmSlider4.getSelection());
                    UniLogTelemetryTab.this.alarmValue4 = UniLogTelemetryTab.this.alarmSlider4.getSelection() * 10;
                    UniLogTelemetryTab.this.alarmValue4 -= UniLogTelemetryTab.this.alarmValue4 % 50;
                    UniLogTelemetryTab.this.alarmText4.setText("" + UniLogTelemetryTab.this.alarmValue4);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmLabel4 = new CLabel((Composite)this.alarmGroup, 0);
            RowData alarmLabel4LData = new RowData();
            alarmLabel4LData.width = 40;
            alarmLabel4LData.height = 22;
            this.alarmLabel4.setLayoutData((Object)alarmLabel4LData);
            this.alarmLabel4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLabel4.setText(this.capacityUnit);
            this.alarmButton5 = new Button((Composite)this.alarmGroup, 16416);
            RowData alarmButton5LData = new RowData();
            alarmButton5LData.width = 140;
            alarmButton5LData.height = 22;
            this.alarmButton5.setLayoutData((Object)alarmButton5LData);
            this.alarmButton5.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmButton5.setText(Messages.getString((String)"GDE_MSGT1392"));
            this.alarmButton5.setSelection(this.isAlarmButton5);
            this.alarmButton5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmButton5.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.isAlarmButton5 = UniLogTelemetryTab.this.alarmButton5.getSelection();
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmText5 = new Text((Composite)this.alarmGroup, 133128);
            RowData alarmText5LData = new RowData();
            alarmText5LData.width = 40;
            alarmText5LData.height = 14;
            this.alarmText5.setLayoutData((Object)alarmText5LData);
            this.alarmText5.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmText5.setText("" + this.alarmValue5);
            RowData alarmSlider5LData = new RowData();
            alarmSlider5LData.width = 100;
            alarmSlider5LData.height = 18;
            this.alarmSlider5 = new Slider((Composite)this.alarmGroup, 0);
            this.alarmSlider5.setLayoutData((Object)alarmSlider5LData);
            this.alarmSlider5.setMinimum(10);
            this.alarmSlider5.setMaximum(1010);
            this.alarmSlider5.setIncrement(10);
            this.alarmSlider5.setSelection(this.alarmValue5);
            this.alarmSlider5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmSlider5.widgetSelected, selection=" + UniLogTelemetryTab.this.alarmSlider5.getSelection());
                    UniLogTelemetryTab.this.alarmValue5 = UniLogTelemetryTab.this.alarmSlider5.getSelection();
                    UniLogTelemetryTab.this.alarmValue5 -= UniLogTelemetryTab.this.alarmValue5 % 10;
                    UniLogTelemetryTab.this.alarmText5.setText("" + UniLogTelemetryTab.this.alarmValue5);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.alarmLabel5 = new CLabel((Composite)this.alarmGroup, 0);
            RowData alarmLabel5LData = new RowData();
            alarmLabel5LData.width = 40;
            alarmLabel5LData.height = 22;
            this.alarmLabel5.setLayoutData((Object)alarmLabel5LData);
            this.alarmLabel5.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLabel5.setText(this.heightUnit);
            this.mLinkAddressesGroup = new Group((Composite)this, 0);
            RowLayout mLinkAddressesGroupLayout = new RowLayout(256);
            this.mLinkAddressesGroup.setLayout((Layout)mLinkAddressesGroupLayout);
            FormData mLinkAddressesGroupLData = new FormData();
            mLinkAddressesGroupLData.left = new FormAttachment(0, 1000, 375);
            mLinkAddressesGroupLData.top = new FormAttachment(0, 1000, 105);
            mLinkAddressesGroupLData.width = 249;
            mLinkAddressesGroupLData.height = 130;
            mLinkAddressesGroupLData.right = new FormAttachment(1000, 1000, 0);
            mLinkAddressesGroupLData.bottom = new FormAttachment(1000, 1000, -75);
            this.mLinkAddressesGroup.setLayoutData((Object)mLinkAddressesGroupLData);
            this.mLinkAddressesGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mLinkAddressesGroup.setText(Messages.getString((String)"GDE_MSGT1393"));
            this.addressLabel1 = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData addressLabel1LData = new RowData();
            addressLabel1LData.width = 80;
            addressLabel1LData.height = 22;
            this.addressLabel1.setLayoutData((Object)addressLabel1LData);
            this.addressLabel1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressLabel1.setText(this.addressLabelName1);
            this.addressText1 = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            RowData addressText1LData = new RowData();
            addressText1LData.width = 40;
            addressText1LData.height = 14;
            this.addressText1.setLayoutData((Object)addressText1LData);
            this.addressText1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressText1.setText("" + this.addressValue1);
            RowData addressSlider1LData = new RowData();
            addressSlider1LData.width = 100;
            addressSlider1LData.height = 18;
            this.addressSlider1 = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressSlider1.setLayoutData((Object)addressSlider1LData);
            this.addressSlider1.setMinimum(1);
            this.addressSlider1.setMaximum(26);
            this.addressSlider1.setIncrement(1);
            this.addressSlider1.setSelection(this.addressValue1);
            this.addressSlider1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider1.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.addressValue1 = UniLogTelemetryTab.this.addressSlider1.getSelection();
                    UniLogTelemetryTab.this.addressText1.setText("" + UniLogTelemetryTab.this.addressValue1);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.addressLabel2 = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData addressLabel2LData = new RowData();
            addressLabel2LData.width = 80;
            addressLabel2LData.height = 22;
            this.addressLabel2.setLayoutData((Object)addressLabel2LData);
            this.addressLabel2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressLabel2.setText(this.addressLabelName2);
            this.addressText2 = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            RowData addressText2LData = new RowData();
            addressText2LData.width = 40;
            addressText2LData.height = 14;
            this.addressText2.setLayoutData((Object)addressText2LData);
            this.addressText2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressText2.setText("" + this.addressValue2);
            RowData addressSlider2LData = new RowData();
            addressSlider2LData.width = 100;
            addressSlider2LData.height = 18;
            this.addressSlider2 = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressSlider2.setLayoutData((Object)addressSlider2LData);
            this.addressSlider2.setMinimum(1);
            this.addressSlider2.setMaximum(26);
            this.addressSlider2.setIncrement(1);
            this.addressSlider2.setSelection(this.addressValue2);
            this.addressSlider2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider2.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.addressValue2 = UniLogTelemetryTab.this.addressSlider2.getSelection();
                    UniLogTelemetryTab.this.addressText2.setText("" + UniLogTelemetryTab.this.addressValue2);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.addressLabel3 = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData addressLabel3LData = new RowData();
            addressLabel3LData.width = 80;
            addressLabel3LData.height = 22;
            this.addressLabel3.setLayoutData((Object)addressLabel3LData);
            this.addressLabel3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressLabel3.setText(this.addressLabelName3);
            this.addressText3 = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            RowData addressText3LData = new RowData();
            addressText3LData.width = 40;
            addressText3LData.height = 14;
            this.addressText3.setLayoutData((Object)addressText3LData);
            this.addressText3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressText3.setText("" + this.addressValue3);
            RowData addressSlider3LData = new RowData();
            addressSlider3LData.width = 100;
            addressSlider3LData.height = 18;
            this.addressSlider3 = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressSlider3.setLayoutData((Object)addressSlider3LData);
            this.addressSlider3.setMinimum(1);
            this.addressSlider3.setMaximum(26);
            this.addressSlider3.setIncrement(1);
            this.addressSlider3.setSelection(this.addressValue3);
            this.addressSlider3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.addressValue3 = UniLogTelemetryTab.this.addressSlider3.getSelection();
                    UniLogTelemetryTab.this.addressText3.setText("" + UniLogTelemetryTab.this.addressValue3);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.addressLabel4 = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData addressLabel4LData = new RowData();
            addressLabel4LData.width = 80;
            addressLabel4LData.height = 22;
            this.addressLabel4.setLayoutData((Object)addressLabel4LData);
            this.addressLabel4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressLabel4.setText(this.addressLabelName4);
            this.addressText4 = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            RowData addressText4LData = new RowData();
            addressText4LData.width = 40;
            addressText4LData.height = 14;
            this.addressText4.setLayoutData((Object)addressText4LData);
            this.addressText4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressText4.setText("" + this.addressValue4);
            RowData addressSlider4LData = new RowData();
            addressSlider4LData.width = 100;
            addressSlider4LData.height = 18;
            this.addressSlider4 = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressSlider4.setLayoutData((Object)addressSlider4LData);
            this.addressSlider4.setMinimum(1);
            this.addressSlider4.setMaximum(26);
            this.addressSlider4.setIncrement(1);
            this.addressSlider4.setSelection(this.addressValue4);
            this.addressSlider4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider4.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.addressValue4 = UniLogTelemetryTab.this.addressSlider4.getSelection();
                    UniLogTelemetryTab.this.addressText4.setText("" + UniLogTelemetryTab.this.addressValue4);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.addressLabel5 = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData addressLabel5LData = new RowData();
            addressLabel5LData.width = 80;
            addressLabel5LData.height = 22;
            this.addressLabel5.setLayoutData((Object)addressLabel5LData);
            this.addressLabel5.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressLabel5.setText(this.addressLabelName5);
            this.addressText5 = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            RowData addressText5LData = new RowData();
            addressText5LData.width = 40;
            addressText5LData.height = 14;
            this.addressText5.setLayoutData((Object)addressText5LData);
            this.addressText5.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.addressText5.setText("" + this.addressValue5);
            RowData addressSlider5LData = new RowData();
            addressSlider5LData.width = 100;
            addressSlider5LData.height = 18;
            this.addressSlider5 = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressSlider5.setLayoutData((Object)addressSlider5LData);
            this.addressSlider5.setMinimum(1);
            this.addressSlider5.setMaximum(26);
            this.addressSlider5.setIncrement(1);
            this.addressSlider5.setSelection(this.addressValue5);
            this.addressSlider5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider5.widgetSelected, event=" + evt);
                    UniLogTelemetryTab.this.addressValue5 = UniLogTelemetryTab.this.addressSlider5.getSelection();
                    UniLogTelemetryTab.this.addressText5.setText("" + UniLogTelemetryTab.this.addressValue5);
                    UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                }
            });
            this.writeTelemtryConfigurationButton = new Button((Composite)this, 0x1000008);
            FormData writeTelemtryConfigurationButtonLData = new FormData();
            writeTelemtryConfigurationButtonLData.left = new FormAttachment(0, 1000, 100);
            writeTelemtryConfigurationButtonLData.top = new FormAttachment(0, 1000, 280);
            writeTelemtryConfigurationButtonLData.bottom = new FormAttachment(1000, 1000, -20);
            writeTelemtryConfigurationButtonLData.right = new FormAttachment(1000, 1000, -100);
            this.writeTelemtryConfigurationButton.setLayoutData((Object)writeTelemtryConfigurationButtonLData);
            this.writeTelemtryConfigurationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.writeTelemtryConfigurationButton.setText(Messages.getString((String)"GDE_MSGT1395"));
            this.writeTelemtryConfigurationButton.setEnabled(false);
            this.writeTelemtryConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "writeTelemtryConfigurationButton.widgetSelected, event=" + evt);
                    try {
                        if (UniLogTelemetryTab.this.serialPort.setConfiguration(UniLogTelemetryTab.this.buildTelemetryConfigurationBuffer())) {
                            UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(false);
                        } else {
                            UniLogTelemetryTab.this.writeTelemtryConfigurationButton.setEnabled(true);
                        }
                    }
                    catch (Exception e) {
                        UniLogTelemetryTab.this.application.openMessageDialog(UniLogTelemetryTab.this.dialog.getDialogShell(), e.getMessage());
                    }
                }
            });
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTelemetryConfigurationValues(byte[] readBuffer) {
        this.isAlarmButton1 = (readBuffer[19] & 1) == 1;
        log.log(Level.FINER, "isAlarmButton1 = " + this.isAlarmButton1);
        this.alarmButton1.setSelection(this.isAlarmButton1);
        this.isAlarmButton2 = (readBuffer[19] & 2) == 2;
        log.log(Level.FINER, "isAlarmButton2 = " + this.isAlarmButton2);
        this.alarmButton2.setSelection(this.isAlarmButton2);
        this.isAlarmButton3 = (readBuffer[19] & 4) == 4;
        log.log(Level.FINER, "isAlarmButton3 = " + this.isAlarmButton3);
        this.alarmButton3.setSelection(this.isAlarmButton3);
        this.isAlarmButton4 = (readBuffer[19] & 8) == 8;
        log.log(Level.FINER, "isAlarmButton4 = " + this.isAlarmButton4);
        this.alarmButton4.setSelection(this.isAlarmButton4);
        this.isAlarmButton5 = (readBuffer[19] & 0x10) == 16;
        log.log(Level.FINER, "isAlarmButton5 = " + this.isAlarmButton5);
        this.alarmButton5.setSelection(this.isAlarmButton5);
        this.alarmValue1 = ((readBuffer[5] & 0xFF) << 8) + (readBuffer[4] & 0xFF);
        log.log(Level.FINER, "alarmValue1 = " + this.alarmValue1);
        this.alarmText1.setText("" + this.alarmValue1);
        this.alarmSlider1.setSelection(this.alarmValue1);
        this.alarmValue2 = (double)(((readBuffer[7] & 0xFF) << 8) + (readBuffer[6] & 0xFF)) / 10.0;
        log.log(Level.FINER, "alarmValue2 = " + this.alarmValue2);
        this.alarmText2.setText(String.format("%.1f", this.alarmValue2));
        this.alarmSlider2.setSelection((int)this.alarmValue2 * 10);
        this.alarmValue3 = (double)(((readBuffer[9] & 0xFF) << 8) + (readBuffer[8] & 0xFF)) / 10.0;
        log.log(Level.FINER, "alarmValue3 = " + this.alarmValue3);
        this.alarmText3.setText(String.format("%.1f", this.alarmValue3));
        this.alarmSlider3.setSelection((int)this.alarmValue3 * 10);
        this.alarmValue4 = ((readBuffer[11] & 0xFF) << 8) + (readBuffer[10] & 0xFF);
        log.log(Level.FINER, "alarmValue4 = " + this.alarmValue4);
        this.alarmText4.setText("" + this.alarmValue4);
        this.alarmSlider4.setSelection(this.alarmValue4 / 10);
        this.alarmValue5 = ((readBuffer[13] & 0xFF) << 8) + (readBuffer[12] & 0xFF);
        log.log(Level.FINER, "alarmValue5 = " + this.alarmValue5);
        this.alarmText5.setText("" + this.alarmValue5);
        this.alarmSlider5.setSelection(this.alarmValue5);
        this.addressValue1 = readBuffer[14] & 0xFF;
        log.log(Level.FINER, "addressValue1 = " + this.addressValue1);
        this.addressSlider1.setSelection(this.addressValue1);
        this.addressText1.setText("" + this.addressValue1);
        this.addressValue2 = readBuffer[15] & 0xFF;
        log.log(Level.FINER, "addressValue2 = " + this.addressValue2);
        this.addressSlider2.setSelection(this.addressValue2);
        this.addressText2.setText("" + this.addressValue2);
        this.addressValue3 = readBuffer[16] & 0xFF;
        log.log(Level.FINER, "addressValue3 = " + this.addressValue3);
        this.addressSlider3.setSelection(this.addressValue3);
        this.addressText3.setText("" + this.addressValue3);
        this.addressValue4 = readBuffer[17] & 0xFF;
        log.log(Level.FINER, "addressValue4 = " + this.addressValue4);
        this.addressSlider4.setSelection(this.addressValue4);
        this.addressText4.setText("" + this.addressValue4);
        this.addressValue5 = readBuffer[18] & 0xFF;
        log.log(Level.FINER, "addressValue5 = " + this.addressValue5);
        this.addressSlider5.setSelection(this.addressValue5);
        this.addressText5.setText("" + this.addressValue5);
        this.writeTelemtryConfigurationButton.setEnabled(false);
    }

    public byte[] buildTelemetryConfigurationBuffer() {
        int checkSum = 0;
        byte[] configUpdateBuffer = new byte[20];
        configUpdateBuffer[0] = -64;
        configUpdateBuffer[1] = 3;
        checkSum += 0xFF & configUpdateBuffer[1];
        configUpdateBuffer[2] = 5;
        checkSum += 0xFF & configUpdateBuffer[2];
        configUpdateBuffer[3] = (byte)(this.alarmValue1 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[3];
        configUpdateBuffer[4] = (byte)((this.alarmValue1 & 0xFF00) >> 8);
        checkSum += 0xFF & configUpdateBuffer[4];
        configUpdateBuffer[5] = (byte)((int)(this.alarmValue2 * 10.0) & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[5];
        configUpdateBuffer[6] = (byte)(((int)(this.alarmValue2 * 10.0) & 0xFF00) >> 8);
        checkSum += 0xFF & configUpdateBuffer[6];
        configUpdateBuffer[7] = (byte)((int)(this.alarmValue3 * 10.0) & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[7];
        configUpdateBuffer[8] = (byte)(((int)(this.alarmValue3 * 10.0) & 0xFF00) >> 8);
        checkSum += 0xFF & configUpdateBuffer[8];
        configUpdateBuffer[9] = (byte)(this.alarmValue4 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[9];
        configUpdateBuffer[10] = (byte)((this.alarmValue4 & 0xFF00) >> 8);
        checkSum += 0xFF & configUpdateBuffer[10];
        configUpdateBuffer[11] = (byte)(this.alarmValue5 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[11];
        configUpdateBuffer[12] = (byte)((this.alarmValue5 & 0xFF00) >> 8);
        checkSum += 0xFF & configUpdateBuffer[12];
        configUpdateBuffer[13] = (byte)(this.addressValue1 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[13];
        configUpdateBuffer[14] = (byte)(this.addressValue2 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[14];
        configUpdateBuffer[15] = (byte)(this.addressValue3 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[15];
        configUpdateBuffer[16] = (byte)(this.addressValue4 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[16];
        configUpdateBuffer[17] = (byte)(this.addressValue5 & 0xFF);
        checkSum += 0xFF & configUpdateBuffer[17];
        configUpdateBuffer[18] = (byte)(this.isAlarmButton1 ? 1 : 0);
        configUpdateBuffer[18] = (byte)(configUpdateBuffer[18] | (this.isAlarmButton2 ? 2 : 0));
        configUpdateBuffer[18] = (byte)(configUpdateBuffer[18] | (this.isAlarmButton3 ? 4 : 0));
        configUpdateBuffer[18] = (byte)(configUpdateBuffer[18] | (this.isAlarmButton4 ? 8 : 0));
        configUpdateBuffer[18] = (byte)(configUpdateBuffer[18] | (this.isAlarmButton5 ? 16 : 0));
        configUpdateBuffer[19] = (byte)((checkSum += 0xFF & configUpdateBuffer[18]) % 256);
        if (UniLogDialog.log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("configUpdateBuffer = [");
            for (int i = 0; i < configUpdateBuffer.length; ++i) {
                if (i == configUpdateBuffer.length - 1) {
                    sb.append(String.format("%02X", configUpdateBuffer[i]));
                    continue;
                }
                sb.append(String.format("%02X ", configUpdateBuffer[i]));
            }
            sb.append("]");
            UniLogDialog.log.log(Level.FINE, sb.toString());
        }
        return configUpdateBuffer;
    }
}

