/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.device.ChannelPropertyTypes;
import gde.device.DataTypes;
import gde.device.DeviceDialog;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2LiveGatherer;
import gde.device.graupner.HoTTAdapterDialogTabItem;
import gde.device.graupner.HoTTAdapterLiveGatherer;
import gde.device.graupner.HoTTAdapterSerialPort;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HoTTAdapterDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(HoTTAdapterDialog.class.getName());
    CTabFolder tabFolder;
    CTabItem serialComTabItem;
    Composite configMainComosite;
    Button saveButton;
    Button closeButton;
    Button helpButton;
    CLabel protocolTypesLabel;
    CLabel protocolTypesUnitLabel;
    CCombo protocolTypesCombo;
    Button inputFileButton;
    Button startLifeDataCapturing;
    Button stopLifeDataCapturing;
    Button enableChannelRecords;
    Button enableTextModusFilter;
    Button enableChannelPercent;
    Button enableFilter;
    CLabel altitudeClimbSelectLabel;
    CCombo altitudeClimbSelectCombo;
    CLabel absorptionLevelLabel;
    CLabel filterStartTimeLabel;
    CLabel filterMaxTimeLabel;
    CLabel filterLapMinTimeLabel;
    CLabel filterMinDeltaRxDbmLabel;
    CLabel filterMinDeltaDistLabel;
    CCombo absorptionLevelCombo;
    CCombo filterStartTimeCombo;
    CCombo filterMaxTimeCombo;
    CCombo filterLapMinTimeCombo;
    CCombo filterMinDeltaRxDbmCombo;
    CCombo filterMinDeltaDistCombo;
    final HoTTAdapter device;
    final Settings settings;
    final HoTTAdapterSerialPort serialPort;
    final Vector<HoTTAdapterDialogTabItem> dialogTabItems = new Vector();
    HoTTAdapterLiveGatherer lifeGatherer;
    boolean isVisibilityChanged = false;
    boolean isHoTTAdapter = false;
    boolean isHoTTAdapter2 = false;
    boolean isHoTTAdapterX = false;
    boolean isHoTTAdapterD = false;
    int measurementsCount = 0;
    int protocolTypeOrdinal = 0;
    String[] altitudeClimbSensors = new String[]{"auto", "VARIO", "GPS", "GAM", "EAM"};
    String[] filterItems = new String[]{"0", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", "70", "75", "80", "85", "90", "95", "100", "105", "110", "115", "120", "130", "140", "150", "160", "170", "180", "190", "200"};
    String[] filterMinItems = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "25", "30", "40", "50", "60", "70", "80", "90", "100", "150"};
    String[] filterMaxItems = new String[]{"50", "60", "70", "80", "90", "100", "110", "120", "130", "140", "150", "160", "170", "180", "190", "200", "210", "300", "360", "420", "480", "540", "600"};

    public HoTTAdapterDialog(Shell parent, HoTTAdapter useDevice) {
        super(parent);
        this.device = useDevice;
        this.serialPort = useDevice.getCommunicationPort();
        this.settings = Settings.getInstance();
        this.measurementsCount = 30;
        this.protocolTypeOrdinal = this.device.getBaudeRate() == 115200 ? HoTTAdapter.Protocol.TYPE_115200.ordinal() : HoTTAdapter.Protocol.TYPE_19200_V4.ordinal();
        this.serialPort.setProtocolType(HoTTAdapter.Protocol.values()[this.protocolTypeOrdinal]);
    }

    public void open() {
        try {
            this.dialogTabItems.clear();
            this.isHoTTAdapter = this.device != null && (this.device.getName().equals("HoTTAdapter") || this.device.getName().equals("HoTTAdapterM"));
            this.isHoTTAdapter2 = this.device != null && this.device.getName().startsWith("HoTTAdapter2");
            this.isHoTTAdapterX = this.device != null && this.device.getName().equals("HoTTAdapterX");
            this.isHoTTAdapterD = this.device != null && this.device.getName().startsWith("HoTTAdapterD");
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                FormData enableFilterLData;
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.setSize(620, this.isHoTTAdapterD || this.isHoTTAdapter2 && this.application.getActiveChannelNumber() == 4 ? 622 : 582);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                HoTTAdapterDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                        if (HoTTAdapterDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{HoTTAdapterDialog.this.device.getPropertiesFileName()});
                            if (HoTTAdapterDialog.this.application.openYesNoMessageDialog(HoTTAdapterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                HoTTAdapterDialog.this.device.storeDeviceProperties();
                                HoTTAdapterDialog.this.setClosePossible(true);
                            }
                        }
                        HoTTAdapterDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        HoTTAdapterDialog.this.application.openHelpDialog("HoTTAdapter", "HelpInfo.html");
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                for (int i = 0; i < this.device.getChannelCount(); ++i) {
                    this.dialogTabItems.add(new HoTTAdapterDialogTabItem(this.tabFolder, this, i + 1, this.device));
                }
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -102);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + evt);
                        int channelNumber = HoTTAdapterDialog.this.tabFolder.getSelectionIndex() + 1;
                        if (channelNumber > 0 && channelNumber <= HoTTAdapterDialog.this.device.getChannelCount()) {
                            String configKey = channelNumber + " : " + ((CTabItem)evt.item).getText();
                            Channels.getInstance().switchChannel(configKey);
                            if (!HoTTAdapterDialog.this.dialogTabItems.get(channelNumber - 1).isMeasurementTypesCreated()) {
                                HoTTAdapterDialog.this.dialogTabItems.get(channelNumber - 1).createMeasurementsControls(channelNumber);
                            }
                        }
                        if (HoTTAdapterDialog.this.isHoTTAdapterX) {
                            HoTTAdapterDialog.this.enableFilter.setVisible(false);
                            HoTTAdapterDialog.this.enableTextModusFilter.setVisible(false);
                            HoTTAdapterDialog.this.startLifeDataCapturing.setVisible(false);
                            HoTTAdapterDialog.this.stopLifeDataCapturing.setVisible(false);
                            HoTTAdapterDialog.this.protocolTypesLabel.setVisible(false);
                            HoTTAdapterDialog.this.protocolTypesCombo.setVisible(false);
                            HoTTAdapterDialog.this.protocolTypesUnitLabel.setVisible(false);
                        }
                    }
                });
                if (this.isHoTTAdapter) {
                    this.enableChannelRecords = new Button((Composite)this.dialogShell, 32);
                    enableFilterLData = new FormData();
                    enableFilterLData.height = GDE.IS_MAC ? 22 : 20;
                    enableFilterLData.left = new FormAttachment(0, 1000, 5);
                    enableFilterLData.width = 60;
                    enableFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -78 : -80);
                    this.enableChannelRecords.setLayoutData((Object)enableFilterLData);
                    this.enableChannelRecords.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.enableChannelRecords.setText(Messages.getString((String)"GDE_MSGT2424"));
                    this.enableChannelRecords.setToolTipText(Messages.getString((String)"GDE_MSGT2425"));
                    this.enableChannelRecords.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.log(Level.FINEST, "enableChannelRecords.widgetSelected, event=" + evt);
                            HoTTAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL, DataTypes.BOOLEAN, "" + HoTTAdapterDialog.this.enableChannelRecords.getSelection());
                            HoTTAdapterDialog.this.device.setChannelEnabledProperty(HoTTAdapterDialog.this.enableChannelRecords.getSelection());
                            HoTTAdapterDialog.this.enableSaveButton(true);
                        }
                    });
                }
                this.enableFilter = new Button((Composite)this.dialogShell, 32);
                enableFilterLData = new FormData();
                enableFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableFilterLData.left = new FormAttachment(0, 1000, this.isHoTTAdapter ? 75 : 15);
                enableFilterLData.width = this.isHoTTAdapter ? 55 : 70;
                enableFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -78 : -80);
                this.enableFilter.setLayoutData((Object)enableFilterLData);
                this.enableFilter.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.enableFilter.setText(Messages.getString((String)"GDE_MSGT2417"));
                this.enableFilter.setToolTipText(Messages.getString((String)"GDE_MSGT2418"));
                this.enableFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "enableFilter.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.ENABLE_FILTER, DataTypes.BOOLEAN, "" + HoTTAdapterDialog.this.enableFilter.getSelection());
                        HoTTAdapterDialog.this.device.setFilterProperties(HoTTAdapterDialog.this.enableFilter.getSelection());
                        HoTTAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.enableTextModusFilter = new Button((Composite)this.dialogShell, 32);
                FormData enableTextModusFilterLData = new FormData();
                enableTextModusFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableTextModusFilterLData.left = new FormAttachment(0, 1000, this.isHoTTAdapter ? 132 : 100);
                enableTextModusFilterLData.width = this.isHoTTAdapter ? 95 : 95;
                enableTextModusFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -78 : -80);
                this.enableTextModusFilter.setLayoutData((Object)enableTextModusFilterLData);
                this.enableTextModusFilter.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.enableTextModusFilter.setText(Messages.getString((String)"GDE_MSGT2438"));
                this.enableTextModusFilter.setToolTipText(Messages.getString((String)"GDE_MSGT2439"));
                this.enableTextModusFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "enableTextModusFilter.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.TEXT_MODE, DataTypes.BOOLEAN, "" + HoTTAdapterDialog.this.enableTextModusFilter.getSelection());
                        HoTTAdapterDialog.this.device.setTextModusFilter(HoTTAdapterDialog.this.enableTextModusFilter.getSelection());
                        HoTTAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.enableChannelPercent = new Button((Composite)this.dialogShell, 32);
                enableTextModusFilterLData = new FormData();
                enableTextModusFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableTextModusFilterLData.left = new FormAttachment(0, 1000, this.isHoTTAdapter ? 250 : 225);
                enableTextModusFilterLData.width = this.isHoTTAdapter ? 105 : 140;
                enableTextModusFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -78 : -80);
                this.enableChannelPercent.setLayoutData((Object)enableTextModusFilterLData);
                this.enableChannelPercent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.enableChannelPercent.setText(Messages.getString((String)"GDE_MSGT2451"));
                this.enableChannelPercent.setToolTipText(Messages.getString((String)"GDE_MSGT2452"));
                this.enableChannelPercent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "enableChannelPercent.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE, DataTypes.BOOLEAN, "" + HoTTAdapterDialog.this.enableChannelPercent.getSelection());
                        HoTTAdapterDialog.this.device.setChannelPercent(HoTTAdapterDialog.this.enableChannelPercent.getSelection());
                        HoTTAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.altitudeClimbSelectLabel = new CLabel((Composite)this.dialogShell, 131072);
                enableFilterLData = new FormData();
                enableFilterLData.height = GDE.IS_MAC ? 22 : 20;
                enableFilterLData.left = new FormAttachment(0, 1000, 380);
                enableFilterLData.width = this.isHoTTAdapter ? 135 : 140;
                enableFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -78 : -80);
                this.altitudeClimbSelectLabel.setLayoutData((Object)enableFilterLData);
                this.altitudeClimbSelectLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.altitudeClimbSelectLabel.setText(Messages.getString((String)"GDE_MSGT2419"));
                this.altitudeClimbSelectLabel.setToolTipText(Messages.getString((String)"GDE_MSGT2420"));
                this.altitudeClimbSelectCombo = new CCombo((Composite)this.dialogShell, 2048);
                enableFilterLData = new FormData();
                enableFilterLData.height = GDE.IS_MAC ? 18 : 16;
                enableFilterLData.left = new FormAttachment(0, 1000, 520);
                enableFilterLData.width = 62;
                enableFilterLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -80 : -80);
                this.altitudeClimbSelectCombo.setLayoutData((Object)enableFilterLData);
                this.altitudeClimbSelectCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.altitudeClimbSelectCombo.setItems(this.altitudeClimbSensors);
                this.altitudeClimbSelectCombo.setToolTipText(Messages.getString((String)"GDE_MSGT2420"));
                this.altitudeClimbSelectCombo.setEditable(false);
                this.altitudeClimbSelectCombo.setBackground(SWTResourceManager.getColor((int)1));
                this.altitudeClimbSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "filterFactorLatitudeCombo.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.device.setChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB, DataTypes.INTEGER, "" + HoTTAdapterDialog.this.altitudeClimbSelectCombo.getSelectionIndex());
                        HoTTAdapterDialog.this.device.setAltitudeClimbSelectionProperties(HoTTAdapterDialog.this.altitudeClimbSelectCombo.getSelectionIndex());
                        HoTTAdapterDialog.this.enableSaveButton(true);
                    }
                });
                this.startLifeDataCapturing = new Button((Composite)this.dialogShell, 0);
                FormData startCapturingButtonLData = new FormData();
                startCapturingButtonLData.height = GDE.IS_MAC ? 33 : 30;
                startCapturingButtonLData.left = new FormAttachment(0, 1000, 210);
                startCapturingButtonLData.width = 200;
                startCapturingButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -43 : -45);
                this.startLifeDataCapturing.setLayoutData((Object)startCapturingButtonLData);
                this.startLifeDataCapturing.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startLifeDataCapturing.setText(Messages.getString((String)"GDE_MSGT2413"));
                this.startLifeDataCapturing.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "startLifeDataCapturing.widgetSelected, event=" + evt);
                        if (HoTTAdapterDialog.this.device != null) {
                            try {
                                String toolTipText = HoTTAdapter.getImportToolTip();
                                HoTTAdapterDialog.this.device.configureSerialPortMenu(1, toolTipText, toolTipText);
                                HoTTAdapterDialog.this.lifeGatherer = HoTTAdapterDialog.this.device.getName().equals("HoTTAdapter") ? new HoTTAdapterLiveGatherer(HoTTAdapterDialog.this.application, HoTTAdapterDialog.this.device, HoTTAdapterDialog.this.serialPort, HoTTAdapterDialog.this) : new HoTTAdapter2LiveGatherer(HoTTAdapterDialog.this.application, HoTTAdapterDialog.this.device, HoTTAdapterDialog.this.serialPort, HoTTAdapterDialog.this);
                                HoTTAdapterDialog.this.lifeGatherer.start();
                                HoTTAdapterDialog.this.startLifeDataCapturing.setEnabled(false);
                                HoTTAdapterDialog.this.stopLifeDataCapturing.setEnabled(true);
                                HoTTAdapterDialog.this.protocolTypesCombo.setEnabled(false);
                                HoTTAdapterDialog.this.inputFileButton.setEnabled(false);
                            }
                            catch (Exception e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                                String toolTipText = HoTTAdapter.getImportToolTip();
                                HoTTAdapterDialog.this.device.configureSerialPortMenu(2, toolTipText, toolTipText);
                                HoTTAdapterDialog.this.serialPort.close();
                                HoTTAdapterDialog.this.startLifeDataCapturing.setEnabled(true);
                                HoTTAdapterDialog.this.stopLifeDataCapturing.setEnabled(false);
                                HoTTAdapterDialog.this.protocolTypesCombo.setEnabled(true);
                                HoTTAdapterDialog.this.inputFileButton.setEnabled(true);
                            }
                        }
                    }
                });
                this.stopLifeDataCapturing = new Button((Composite)this.dialogShell, 0);
                FormData stopCapturingButtonLData = new FormData();
                stopCapturingButtonLData.height = GDE.IS_MAC ? 33 : 30;
                stopCapturingButtonLData.left = new FormAttachment(0, 1000, 210);
                stopCapturingButtonLData.width = 200;
                stopCapturingButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.stopLifeDataCapturing.setLayoutData((Object)stopCapturingButtonLData);
                this.stopLifeDataCapturing.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopLifeDataCapturing.setText(Messages.getString((String)"GDE_MSGT2414"));
                this.stopLifeDataCapturing.setEnabled(false);
                this.stopLifeDataCapturing.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "stopLifeDataCapturing.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.serialPort.isInterruptedByUser = true;
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 10);
                inputFileButtonLData.width = 160;
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -43 : -45);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2402"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2410"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + evt);
                        if (HoTTAdapterDialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{HoTTAdapterDialog.this.device.getPropertiesFileName()});
                            if (HoTTAdapterDialog.this.application.openYesNoMessageDialog(HoTTAdapterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                HoTTAdapterDialog.this.device.storeDeviceProperties();
                            }
                        }
                        HoTTAdapterDialog.this.device.open_closeCommPort();
                    }
                });
                this.protocolTypesLabel = new CLabel((Composite)this.dialogShell, 131072);
                this.protocolTypesLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.protocolTypesLabel.setText(Messages.getString((String)"GDE_MSGT2411"));
                this.protocolTypesLabel.setToolTipText(Messages.getString((String)"GDE_MSGT2415"));
                FormData timeZoneOffsetUTCLabelLData = new FormData();
                timeZoneOffsetUTCLabelLData.width = 70;
                timeZoneOffsetUTCLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
                timeZoneOffsetUTCLabelLData.bottom = new FormAttachment(1000, 1000, -50);
                timeZoneOffsetUTCLabelLData.right = new FormAttachment(1000, 1000, -130);
                this.protocolTypesLabel.setLayoutData((Object)timeZoneOffsetUTCLabelLData);
                this.protocolTypesCombo = new CCombo((Composite)this.dialogShell, 133120);
                this.protocolTypesCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.protocolTypesCombo.setItems(HoTTAdapter.Protocol.valuesAsStingArray());
                FormData timeZoneOffsetUTCComboLData = new FormData();
                timeZoneOffsetUTCComboLData.width = 85;
                timeZoneOffsetUTCComboLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
                timeZoneOffsetUTCComboLData.bottom = new FormAttachment(1000, 1000, -50);
                timeZoneOffsetUTCComboLData.right = new FormAttachment(1000, 1000, -40);
                this.protocolTypesCombo.setLayoutData((Object)timeZoneOffsetUTCComboLData);
                this.protocolTypesCombo.select(this.protocolTypeOrdinal);
                this.protocolTypesCombo.setToolTipText(Messages.getString((String)"GDE_MSGT2415"));
                this.protocolTypesCombo.setEditable(false);
                this.protocolTypesCombo.setBackground(SWTResourceManager.getColor((int)1));
                this.protocolTypesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "timeZoneOffsetUTCCombo.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.device.setBaudeRate(Integer.parseInt(HoTTAdapterDialog.this.protocolTypesCombo.getText().trim().split(" ")[0]));
                        HoTTAdapterDialog.this.protocolTypeOrdinal = HoTTAdapterDialog.this.protocolTypesCombo.getSelectionIndex();
                        HoTTAdapterDialog.this.serialPort.setProtocolType(HoTTAdapter.Protocol.values()[HoTTAdapterDialog.this.protocolTypeOrdinal]);
                        HoTTAdapterDialog.this.saveButton.setEnabled(true);
                    }
                });
                this.protocolTypesUnitLabel = new CLabel((Composite)this.dialogShell, 131072);
                this.protocolTypesUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.protocolTypesUnitLabel.setText(Messages.getString((String)"GDE_MSGT2412"));
                this.protocolTypesUnitLabel.setToolTipText(Messages.getString((String)"GDE_MSGT2415"));
                FormData timeZoneOffsetUTCUnitLData = new FormData();
                timeZoneOffsetUTCUnitLData.width = 30;
                timeZoneOffsetUTCUnitLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
                timeZoneOffsetUTCUnitLData.bottom = new FormAttachment(1000, 1000, -50);
                timeZoneOffsetUTCUnitLData.right = new FormAttachment(1000, 1000, -3);
                this.protocolTypesUnitLabel.setLayoutData((Object)timeZoneOffsetUTCUnitLData);
                this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 105;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 10);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveButton.setLayoutData((Object)saveButtonLData);
                this.saveButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveButton.setText(Messages.getString((String)"GDE_MSGT0486"));
                this.saveButton.setEnabled(false);
                this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.device.storeDeviceProperties();
                        HoTTAdapterDialog.this.saveButton.setEnabled(false);
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, GDE.IS_MAC ? 129 : 132);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.application.openHelpDialog("HoTTAdapter", "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 160;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        HoTTAdapterDialog.this.dialogShell.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - this.dialogShell.getSize().x / 2, 0));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            if (this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue() != null && this.enableChannelRecords != null) {
                this.enableChannelRecords.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_CHANNEL).getValue()));
            }
            this.enableFilter.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.ENABLE_FILTER).getValue()));
            this.enableTextModusFilter.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue() != null ? this.device.getChannelProperty(ChannelPropertyTypes.TEXT_MODE).getValue() : "true"));
            this.enableChannelPercent.setSelection(Boolean.parseBoolean(this.device.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE).getValue() != null ? this.device.getChannelProperty(ChannelPropertyTypes.CHANNEL_PERCENTAGE).getValue() : "true"));
            if (this.isHoTTAdapter) {
                this.altitudeClimbSelectLabel.setVisible(false);
                this.altitudeClimbSelectCombo.setVisible(false);
            } else if (this.isHoTTAdapter2 || this.isHoTTAdapterD) {
                this.altitudeClimbSelectCombo.select(Integer.parseInt(this.device.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB).getValue() != null ? this.device.getChannelProperty(ChannelPropertyTypes.SENSOR_ALT_CLIMB).getValue() : "0"));
            }
            if (this.serialPort.isConnected()) {
                this.startLifeDataCapturing.setEnabled(false);
                this.stopLifeDataCapturing.setEnabled(true);
                this.protocolTypesCombo.setEnabled(false);
                this.inputFileButton.setEnabled(false);
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private int findPosition(String[] valueArray, String value, int defaultPosition) {
        for (int i = 0; i < valueArray.length; ++i) {
            if (!value.equals(valueArray[i])) continue;
            return i;
        }
        return defaultPosition;
    }

    public void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public void resetButtons() {
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            this.dialogShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String toolTipText = HoTTAdapter.getImportToolTip();
                    HoTTAdapterDialog.this.device.configureSerialPortMenu(2, toolTipText, toolTipText);
                    if (!HoTTAdapterDialog.this.isDisposed()) {
                        HoTTAdapterDialog.this.startLifeDataCapturing.setEnabled(true);
                        HoTTAdapterDialog.this.stopLifeDataCapturing.setEnabled(false);
                        HoTTAdapterDialog.this.protocolTypesCombo.setEnabled(true);
                        HoTTAdapterDialog.this.inputFileButton.setEnabled(true);
                    }
                }
            });
        }
    }

    public void selectTab(final int index) {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            this.dialogShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HoTTAdapterDialog.this.tabFolder.setSelection(index - 1);
                }
            });
        }
    }
}

