/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckFieldTransformer<T extends RealFieldElement<T>> {
    private static final Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> CACHE = new HashMap();
    private final Field<T> field;
    private final Array2DRowFieldMatrix<T> update;
    private final T[] c1;

    private AdamsNordsieckFieldTransformer(Field<T> field2, int n) {
        this.field = field2;
        int rows = n - 1;
        FieldMatrix<T> bigP = this.buildP(rows);
        FieldDecompositionSolver<T> pSolver = new FieldLUDecomposition<T>(bigP).getSolver();
        Object[] u = (RealFieldElement[])MathArrays.buildArray(field2, rows);
        Arrays.fill(u, field2.getOne());
        this.c1 = (RealFieldElement[])pSolver.solve(new ArrayFieldVector((FieldElement[])u, false)).toArray();
        FieldElement[][] shiftedP = (RealFieldElement[][])bigP.getData();
        for (int i2 = shiftedP.length - 1; i2 > 0; --i2) {
            shiftedP[i2] = shiftedP[i2 - 1];
        }
        shiftedP[0] = (RealFieldElement[])MathArrays.buildArray(field2, rows);
        Arrays.fill(shiftedP[0], field2.getZero());
        this.update = new Array2DRowFieldMatrix(pSolver.solve(new Array2DRowFieldMatrix(shiftedP, false)).getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RealFieldElement<T>> AdamsNordsieckFieldTransformer<T> getInstance(Field<T> field2, int nSteps) {
        Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> map2 = CACHE;
        synchronized (map2) {
            AdamsNordsieckFieldTransformer<RealFieldElement<Object>> t;
            Map<Field<RealFieldElement<?>>, AdamsNordsieckFieldTransformer<RealFieldElement<?>>> map3 = CACHE.get(nSteps);
            if (map3 == null) {
                map3 = new HashMap();
                CACHE.put(nSteps, map3);
            }
            if ((t = map3.get(field2)) == null) {
                t = new AdamsNordsieckFieldTransformer<T>(field2, nSteps);
                map3.put(field2, t);
            }
            return t;
        }
    }

    private FieldMatrix<T> buildP(int rows) {
        FieldElement[][] pData = (RealFieldElement[][])MathArrays.buildArray(this.field, rows, rows);
        for (int i2 = 1; i2 <= pData.length; ++i2) {
            RealFieldElement[] pI = pData[i2 - 1];
            int factor = -i2;
            RealFieldElement aj = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(factor);
            for (int j = 1; j <= pI.length; ++j) {
                pI[j - 1] = (RealFieldElement)aj.multiply(j + 1);
                aj = (RealFieldElement)aj.multiply(factor);
            }
        }
        return new Array2DRowFieldMatrix(pData, false);
    }

    public Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T h, T[] t, T[][] y, T[][] yDot) {
        FieldElement[][] a = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, this.c1.length + 1);
        FieldElement[][] b = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, y[0].length);
        T[] y0 = y[0];
        T[] yDot0 = yDot[0];
        for (int i2 = 1; i2 < y.length; ++i2) {
            RealFieldElement di2 = (RealFieldElement)t[i2].subtract(t[0]);
            RealFieldElement ratio = (RealFieldElement)di2.divide(h);
            RealFieldElement dikM1Ohk = (RealFieldElement)h.reciprocal();
            FieldElement[] aI = a[2 * i2 - 2];
            FieldElement[] aDotI = 2 * i2 - 1 < a.length ? a[2 * i2 - 1] : null;
            for (int j = 0; j < aI.length; ++j) {
                dikM1Ohk = dikM1Ohk.multiply(ratio);
                aI[j] = di2.multiply(dikM1Ohk);
                if (aDotI == null) continue;
                aDotI[j] = (RealFieldElement)dikM1Ohk.multiply(j + 2);
            }
            T[] yI = y[i2];
            T[] yDotI = yDot[i2];
            FieldElement[] bI = b[2 * i2 - 2];
            FieldElement[] bDotI = 2 * i2 - 1 < b.length ? b[2 * i2 - 1] : null;
            for (int j = 0; j < yI.length; ++j) {
                bI[j] = (RealFieldElement)((RealFieldElement)yI[j].subtract(y0[j])).subtract(di2.multiply(yDot0[j]));
                if (bDotI == null) continue;
                bDotI[j] = (RealFieldElement)yDotI[j].subtract(yDot0[j]);
            }
        }
        FieldLUDecomposition decomposition = new FieldLUDecomposition(new Array2DRowFieldMatrix(a, false));
        FieldMatrix x = decomposition.getSolver().solve(new Array2DRowFieldMatrix(b, false));
        Array2DRowFieldMatrix truncatedX = new Array2DRowFieldMatrix(this.field, x.getRowDimension() - 1, x.getColumnDimension());
        for (int i3 = 0; i3 < truncatedX.getRowDimension(); ++i3) {
            for (int j = 0; j < truncatedX.getColumnDimension(); ++j) {
                truncatedX.setEntry(i3, j, x.getEntry(i3, j));
            }
        }
        return truncatedX;
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(T[] start, T[] end, Array2DRowFieldMatrix<T> highOrder) {
        RealFieldElement[][] data2 = (RealFieldElement[][])highOrder.getDataRef();
        for (int i2 = 0; i2 < data2.length; ++i2) {
            RealFieldElement[] dataI = data2[i2];
            T c1I = this.c1[i2];
            for (int j = 0; j < dataI.length; ++j) {
                dataI[j] = (RealFieldElement)dataI[j].add(c1I.multiply(start[j].subtract(end[j])));
            }
        }
    }
}

