/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.WritableDirectElement;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatLayout {
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected float yLine;
    protected float floatLeftX;
    protected float floatRightX;
    protected float filledWidth;
    protected final ColumnText compositeColumn = new ColumnText(null);
    protected final List<Element> content;
    protected final boolean useAscender;

    public float getYLine() {
        return this.yLine;
    }

    public void setYLine(float yLine) {
        this.yLine = yLine;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float filledWidth) {
        this.filledWidth = filledWidth;
    }

    public int getRunDirection() {
        return this.compositeColumn.getRunDirection();
    }

    public void setRunDirection(int runDirection) {
        this.compositeColumn.setRunDirection(runDirection);
    }

    public FloatLayout(List<Element> elements, boolean useAscender) {
        this.compositeColumn.setUseAscender(useAscender);
        this.useAscender = useAscender;
        this.content = elements;
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury) {
        this.leftX = Math.min(llx, urx);
        this.maxY = Math.max(lly, ury);
        this.minY = Math.min(lly, ury);
        this.rightX = Math.max(llx, urx);
        this.floatLeftX = this.leftX;
        this.floatRightX = this.rightX;
        this.yLine = this.maxY;
        this.filledWidth = 0.0f;
    }

    public int layout(PdfContentByte canvas2, boolean simulate) throws DocumentException {
        List<Element> content;
        this.compositeColumn.setCanvas(canvas2);
        int status = 1;
        ArrayList<Element> floatingElements = new ArrayList<Element>();
        List<Element> list2 = content = simulate ? new ArrayList<Element>(this.content) : this.content;
        while (!content.isEmpty()) {
            if (content.get(0) instanceof PdfDiv) {
                PdfDiv floatingElement = (PdfDiv)content.get(0);
                if (floatingElement.getFloatType() == PdfDiv.FloatType.LEFT || floatingElement.getFloatType() == PdfDiv.FloatType.RIGHT) {
                    floatingElements.add(floatingElement);
                    content.remove(0);
                    continue;
                }
                if (!floatingElements.isEmpty() && ((status = this.floatingLayout(floatingElements, simulate)) & 1) == 0) break;
                content.remove(0);
                status = floatingElement.layout(canvas2, this.useAscender, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                if (floatingElement.getKeepTogether() && (status & 1) == 0 && (this.compositeColumn.getCanvas().getPdfDocument().currentHeight > 0.0f || this.yLine != this.maxY)) {
                    content.add(0, floatingElement);
                    break;
                }
                if (!simulate) {
                    canvas2.openMCBlock(floatingElement);
                    status = floatingElement.layout(canvas2, this.useAscender, simulate, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                    canvas2.closeMCBlock(floatingElement);
                }
                if (floatingElement.getActualWidth() > this.filledWidth) {
                    this.filledWidth = floatingElement.getActualWidth();
                }
                if ((status & 1) == 0) {
                    content.add(0, floatingElement);
                    this.yLine = floatingElement.getYLine();
                    break;
                }
                this.yLine -= floatingElement.getActualHeight();
                continue;
            }
            floatingElements.add(content.get(0));
            content.remove(0);
        }
        if (status & true && !floatingElements.isEmpty()) {
            status = this.floatingLayout(floatingElements, simulate);
        }
        content.addAll(0, floatingElements);
        return status;
    }

    private int floatingLayout(List<Element> floatingElements, boolean simulate) throws DocumentException {
        boolean ignoreSpacingBefore;
        int status = 1;
        float minYLine = this.yLine;
        float leftWidth = 0.0f;
        float rightWidth = 0.0f;
        ColumnText currentCompositeColumn = this.compositeColumn;
        if (simulate) {
            currentCompositeColumn = ColumnText.duplicate(this.compositeColumn);
        }
        boolean bl = ignoreSpacingBefore = this.maxY == this.yLine;
        while (!floatingElements.isEmpty()) {
            Paragraph p;
            Element nextElement = floatingElements.get(0);
            floatingElements.remove(0);
            if (nextElement instanceof PdfDiv) {
                PdfDiv floatingElement = (PdfDiv)nextElement;
                status = floatingElement.layout(this.compositeColumn.getCanvas(), this.useAscender, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                if ((status & 1) == 0) {
                    this.yLine = minYLine;
                    this.floatLeftX = this.leftX;
                    this.floatRightX = this.rightX;
                    status = floatingElement.layout(this.compositeColumn.getCanvas(), this.useAscender, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                    if ((status & 1) == 0) {
                        floatingElements.add(0, floatingElement);
                        break;
                    }
                }
                if (floatingElement.getFloatType() == PdfDiv.FloatType.LEFT) {
                    status = floatingElement.layout(this.compositeColumn.getCanvas(), this.useAscender, simulate, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                    this.floatLeftX += floatingElement.getActualWidth();
                    leftWidth += floatingElement.getActualWidth();
                } else if (floatingElement.getFloatType() == PdfDiv.FloatType.RIGHT) {
                    status = floatingElement.layout(this.compositeColumn.getCanvas(), this.useAscender, simulate, this.floatRightX - floatingElement.getActualWidth() - 0.01f, this.minY, this.floatRightX, this.yLine);
                    this.floatRightX -= floatingElement.getActualWidth();
                    rightWidth += floatingElement.getActualWidth();
                }
                minYLine = Math.min(minYLine, this.yLine - floatingElement.getActualHeight());
            } else {
                if (this.minY > minYLine) {
                    status = 2;
                    floatingElements.add(0, nextElement);
                    if (currentCompositeColumn == null) break;
                    currentCompositeColumn.setText(null);
                    break;
                }
                if (!(!(nextElement instanceof Spaceable) || ignoreSpacingBefore && currentCompositeColumn.isIgnoreSpacingBefore() && ((Spaceable)((Object)nextElement)).getPaddingTop() == 0.0f)) {
                    this.yLine -= ((Spaceable)((Object)nextElement)).getSpacingBefore();
                }
                if (simulate) {
                    if (nextElement instanceof PdfPTable) {
                        currentCompositeColumn.addElement(new PdfPTable((PdfPTable)nextElement));
                    } else {
                        currentCompositeColumn.addElement(nextElement);
                    }
                } else {
                    currentCompositeColumn.addElement(nextElement);
                }
                if (this.yLine > minYLine) {
                    currentCompositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, minYLine);
                } else {
                    currentCompositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, this.minY);
                }
                currentCompositeColumn.setFilledWidth(0.0f);
                status = currentCompositeColumn.go(simulate);
                if (this.yLine > minYLine && (this.floatLeftX > this.leftX || this.floatRightX < this.rightX) && (status & 1) == 0) {
                    this.yLine = minYLine;
                    this.floatLeftX = this.leftX;
                    this.floatRightX = this.rightX;
                    if (leftWidth != 0.0f && rightWidth != 0.0f) {
                        this.filledWidth = this.rightX - this.leftX;
                    } else {
                        if (leftWidth > this.filledWidth) {
                            this.filledWidth = leftWidth;
                        }
                        if (rightWidth > this.filledWidth) {
                            this.filledWidth = rightWidth;
                        }
                    }
                    leftWidth = 0.0f;
                    rightWidth = 0.0f;
                    if (simulate && nextElement instanceof PdfPTable) {
                        currentCompositeColumn.addElement(new PdfPTable((PdfPTable)nextElement));
                    }
                    currentCompositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, this.minY);
                    status = currentCompositeColumn.go(simulate);
                    this.yLine = minYLine = currentCompositeColumn.getYLine() + currentCompositeColumn.getDescender();
                    if (currentCompositeColumn.getFilledWidth() > this.filledWidth) {
                        this.filledWidth = currentCompositeColumn.getFilledWidth();
                    }
                } else {
                    if (rightWidth > 0.0f) {
                        rightWidth += currentCompositeColumn.getFilledWidth();
                    } else if (leftWidth > 0.0f) {
                        leftWidth += currentCompositeColumn.getFilledWidth();
                    } else if (currentCompositeColumn.getFilledWidth() > this.filledWidth) {
                        this.filledWidth = currentCompositeColumn.getFilledWidth();
                    }
                    minYLine = Math.min(currentCompositeColumn.getYLine() + currentCompositeColumn.getDescender(), minYLine);
                    this.yLine = currentCompositeColumn.getYLine() + currentCompositeColumn.getDescender();
                }
                if ((status & 1) == 0) {
                    if (!simulate) {
                        floatingElements.addAll(0, currentCompositeColumn.getCompositeElements());
                        currentCompositeColumn.getCompositeElements().clear();
                        break;
                    }
                    floatingElements.add(0, nextElement);
                    currentCompositeColumn.setText(null);
                    break;
                }
                currentCompositeColumn.setText(null);
            }
            if (nextElement instanceof Paragraph) {
                p = (Paragraph)nextElement;
                for (Element e : p) {
                    WritableDirectElement writableElement;
                    if (!(e instanceof WritableDirectElement) || (writableElement = (WritableDirectElement)e).getDirectElementType() != 1 || simulate) continue;
                    PdfWriter writer = this.compositeColumn.getCanvas().getPdfWriter();
                    PdfDocument doc = this.compositeColumn.getCanvas().getPdfDocument();
                    float savedHeight = doc.currentHeight;
                    doc.currentHeight = doc.top() - this.yLine - doc.indentation.indentTop;
                    writableElement.write(writer, doc);
                    doc.currentHeight = savedHeight;
                }
            }
            if (ignoreSpacingBefore && nextElement.getChunks().size() == 0) {
                if (nextElement instanceof Paragraph) {
                    WritableDirectElement writableElement;
                    p = (Paragraph)nextElement;
                    Element e = (Element)p.get(0);
                    if (!(e instanceof WritableDirectElement) || (writableElement = (WritableDirectElement)e).getDirectElementType() == 1) continue;
                    ignoreSpacingBefore = false;
                    continue;
                }
                if (!(nextElement instanceof Spaceable)) continue;
                ignoreSpacingBefore = false;
                continue;
            }
            ignoreSpacingBefore = false;
        }
        if (leftWidth != 0.0f && rightWidth != 0.0f) {
            this.filledWidth = this.rightX - this.leftX;
        } else {
            if (leftWidth > this.filledWidth) {
                this.filledWidth = leftWidth;
            }
            if (rightWidth > this.filledWidth) {
                this.filledWidth = rightWidth;
            }
        }
        this.yLine = minYLine;
        this.floatLeftX = this.leftX;
        this.floatRightX = this.rightX;
        return status;
    }
}

