/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.device.resource.DeviceXmlResource;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.recordings.TrailRecordSection;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.utils.HistoTimeLine;
import gde.log.Logger;
import gde.messages.Messages;
import gde.utils.LocalizedDateTime;
import org.eclipse.swt.graphics.Rectangle;

public class Measure {
    private static final String $CLASS_NAME = Measure.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();
    private static final Rectangle BOUNDS = new Rectangle(0, 0, 999, 99);
    final boolean isDeltaMeasure;
    final TrailRecord measureRecord;
    private long timestampMeasure_ms;
    private long timestampDelta_ms;
    private TrailRecordSection recordSection;

    Measure(boolean isDeltaMeasuring, TrailRecord measuringRecord) {
        this.isDeltaMeasure = isDeltaMeasuring;
        this.measureRecord = measuringRecord;
        long[] timestamps_ms = this.defineInitialTimestamps_ms();
        if (timestamps_ms.length == 0) {
            throw new IllegalArgumentException();
        }
        this.setTimestampMeasure_ms(timestamps_ms[0]);
        this.setTimestampDelta_ms(isDeltaMeasuring ? timestamps_ms[1] : timestamps_ms[0]);
    }

    private long[] defineInitialTimestamps_ms() {
        HistoTimeLine timeLine = new HistoTimeLine();
        TrailRecordSet recordSet = this.measureRecord.getParent();
        timeLine.initialize(recordSet, BOUNDS);
        if (timeLine.getScalePositions().size() > 0) {
            int margin = Measure.BOUNDS.width / (timeLine.getScalePositions().size() + 1);
            long timestampMeasureNew_ms = timeLine.getAdjacentTimestamp(margin);
            long timestampDeltaNew_ms = timeLine.getAdjacentTimestamp(Measure.BOUNDS.width * 2 / 3);
            return new long[]{timestampMeasureNew_ms, timestampDeltaNew_ms};
        }
        return new long[0];
    }

    void setValidMeasureTimeStamp_ms(long proposedTimeStamp_ms) {
        long timestampMeasureNew_ms = proposedTimeStamp_ms;
        int index = this.measureRecord.getParent().getIndex(proposedTimeStamp_ms);
        Integer value = this.measureRecord.getPoints().elementAt(index);
        if (value == null) {
            log.fine(() -> String.format("timestampMeasure_ms=%d search first non-null value from the left", proposedTimeStamp_ms));
            int i = -1;
            while (value == null) {
                value = this.measureRecord.getPoints().elementAt(++i);
            }
            timestampMeasureNew_ms = this.measureRecord.getParent().getDisplayTimeStamp_ms(i);
        }
        this.setTimestampMeasure_ms(timestampMeasureNew_ms);
    }

    void setValidDeltaTimeStamp_ms(long proposedTimeStamp_ms) {
        long timestampDeltaNew_ms = proposedTimeStamp_ms;
        int index = this.measureRecord.getParent().getIndex(proposedTimeStamp_ms);
        Integer value = this.measureRecord.getPoints().elementAt(index);
        if (value == null) {
            log.fine(() -> String.format("timestampDelta_ms=%d search first non-null value from the right", proposedTimeStamp_ms));
            int i = this.measureRecord.getParent().getTimeStepSize();
            while (value == null) {
                value = this.measureRecord.getPoints().elementAt(--i);
            }
            timestampDeltaNew_ms = this.measureRecord.getParent().getDisplayTimeStamp_ms(i);
        }
        this.setTimestampDelta_ms(timestampDeltaNew_ms);
    }

    public String getCurveSurveyStatusMessage() {
        String deltaText = this.getRecordSection().getFormattedBoundsDelta();
        String unitText = this.measureRecord.getUnit();
        String avgText = this.getRecordSection().getFormattedBoundsAvg();
        String slopeText = this.getRecordSection().getFormattedBoundsSlope();
        String recordName = xmlResource.getReplacement(this.measureRecord.getName());
        return Messages.getString("GDE_MSGT0848", new Object[]{recordName, unitText, deltaText, LocalizedDateTime.getFormatedDistance(this.timestampMeasure_ms, this.timestampDelta_ms)}) + Messages.getString("GDE_MSGT0879", new Object[]{unitText, avgText, unitText, slopeText});
    }

    public String getDeltaStandardStatusMessage() {
        String deltaText = this.getRecordSection().getFormattedBoundsDelta();
        String unitText = this.measureRecord.getUnit();
        String recordName = xmlResource.getReplacement(this.measureRecord.getName());
        return Messages.getString("GDE_MSGT0848", new Object[]{recordName, unitText, deltaText, LocalizedDateTime.getFormatedDistance(this.timestampMeasure_ms, this.timestampDelta_ms)});
    }

    public String getNoDeltaCurveSurveyStatusMessage() {
        String deltaText = "*";
        String unitText = this.measureRecord.getUnit();
        String avgText = this.getRecordSection().getFormattedBoundsAvg();
        String slopeText = this.getRecordSection().getFormattedBoundsSlope();
        String recordName = xmlResource.getReplacement(this.measureRecord.getName());
        return Messages.getString("GDE_MSGT0848", new Object[]{recordName, deltaText, unitText, LocalizedDateTime.getFormatedDistance(this.timestampMeasure_ms, this.timestampDelta_ms)}) + Messages.getString("GDE_MSGT0879", new Object[]{unitText, avgText, unitText, slopeText});
    }

    public String getNoRecordsStatusMessage() {
        String recordName = xmlResource.getReplacement(this.measureRecord.getName());
        return Messages.getString("GDE_MSGT0848", new Object[]{recordName, "*"});
    }

    public String getMeasureStatusMessage() {
        String recordName = xmlResource.getReplacement(this.measureRecord.getName());
        return Messages.getString("GDE_MSGT0256", new Object[]{recordName, new TrailRecordFormatter(this.measureRecord).getMeasureValue(this.measureRecord.getParent().getIndex(this.timestampMeasure_ms)), this.measureRecord.getUnit(), LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmmss, this.timestampMeasure_ms)});
    }

    public TrailRecordSection getRecordSection() {
        if (this.recordSection == null) {
            this.setRecordSection();
        }
        return this.recordSection;
    }

    private void setRecordSection() {
        this.recordSection = new TrailRecordSection(this.measureRecord, this.timestampMeasure_ms, this.timestampDelta_ms);
    }

    public long getTimestampMeasure_ms() {
        return this.timestampMeasure_ms;
    }

    public void setTimestampMeasure_ms(long timestampMeasure_ms) {
        this.recordSection = null;
        this.timestampMeasure_ms = timestampMeasure_ms;
        if (!this.isDeltaMeasure) {
            this.timestampDelta_ms = timestampMeasure_ms;
        }
    }

    public long getTimestampDelta_ms() {
        return this.timestampDelta_ms;
    }

    public void setTimestampDelta_ms(long timestampDelta_ms) {
        this.recordSection = null;
        this.timestampDelta_ms = timestampDelta_ms;
    }

    public String toString() {
        return "[isDeltaMeasure=" + this.isDeltaMeasure + ", timestampMeasure_ms=" + this.timestampMeasure_ms + ", timestampDelta_ms=" + this.timestampDelta_ms + ", recordSection=" + this.getRecordSection() + ", measureRecord=" + this.measureRecord + " ]";
    }

    public boolean isDeltaMeasure() {
        return this.isDeltaMeasure;
    }
}

