/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin.stats;

import com.sun.marlin.stats.StatLong;

public final class Histogram
extends StatLong {
    static final int BUCKET = 2;
    static final int MAX = 20;
    static final int LAST = 19;
    static final int[] STEPS = new int[20];
    private final StatLong[] stats = new StatLong[20];

    static int bucket(int n) {
        for (int j = 1; j < 20; ++j) {
            if (n >= STEPS[j]) continue;
            return j - 1;
        }
        return 19;
    }

    public Histogram(String string2) {
        super(string2);
        for (int j = 0; j < 20; ++j) {
            this.stats[j] = new StatLong(String.format("%5s .. %5s", STEPS[j], j + 1 < 20 ? Integer.valueOf(STEPS[j + 1]) : "~"));
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int j = 0; j < 20; ++j) {
            this.stats[j].reset();
        }
    }

    @Override
    public void add(int n) {
        super.add(n);
        this.stats[Histogram.bucket(n)].add(n);
    }

    @Override
    public void add(long l) {
        this.add((int)l);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        super.toString(stringBuilder).append(" { ");
        for (int j = 0; j < 20; ++j) {
            if (this.stats[j].count == 0L) continue;
            stringBuilder.append("\n        ").append(this.stats[j].toString());
        }
        return stringBuilder.append(" }").toString();
    }

    static {
        Histogram.STEPS[0] = 0;
        Histogram.STEPS[1] = 1;
        for (int j = 2; j < 20; ++j) {
            Histogram.STEPS[j] = STEPS[j - 1] * 2;
        }
    }
}

