/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi.modbus;

import gde.device.IDevice;
import gde.device.junsi.iCharger308DUO;
import gde.device.junsi.iCharger4010DUO;
import gde.device.junsi.iCharger406DUO;
import gde.device.junsi.iChargerDX6;
import gde.device.junsi.iChargerDX8;
import gde.device.junsi.iChargerS6;
import gde.device.junsi.iChargerUsb;
import gde.device.junsi.iChargerX12;
import gde.device.junsi.iChargerX6;
import gde.device.junsi.iChargerX8;
import gde.io.DataParser;
import gde.messages.Messages;
import gde.utils.StringHelper;
import java.util.ArrayList;

public class ChargerMemory {
    public static final short CELL_MAX = 10;
    public static final short NI_ZERO_VOLT = 500;
    public static final short CAP_MIN = 0;
    public static final int CAP_MAX = 999900;
    public static final short CAP_STEP = 100;
    public static final short CAP_DEFAULT = 0;
    public static final short RUN_COUNT_MIN = 0;
    public static final short RUN_COUNT_MAX = 999;
    public static final short RUN_COUNT_STEP = 1;
    public static final short RUN_COUNT_DEFAULT = 0;
    public static final short LOG_INTERVAL_MIN = 5;
    public static final short LOG_INTERVAL_MAX = 600;
    public static final short LOG_INTERVAL_STEP = 5;
    public static final short LOG_INTERVAL_DEFAULT = 10;
    public static final short BT_TYPE_MIN = 0;
    public static final short BT_TYPE_STEP = 1;
    public static final short BT_TYPE_DEFAULT = 0;
    public static final short LI_CELLS_MIN = 0;
    public static final short LI_CELLS_MAX = 10;
    public static final short LI_CELLS_DEFAULT = 0;
    public static final short NI_CELLS_MIN = 0;
    public static final short NI_CELLS_DEFAULT = 0;
    public static final short PB_CELLS_MIN = 1;
    public static final short PB_CELLS_DEFAULT = 6;
    public static final short RESTORE_VOLT_MIN = 500;
    public static final short RESTORE_VOLT_MAX = 2500;
    public static final short RESTORE_VOLT_DEFAULT = 1000;
    public static final short RESTORE_TIME_MIN = 1;
    public static final short RESTORE_TIME_MAX = 5;
    public static final short RESTORE_TIME_DEFAULT = 3;
    public static final short RESTORE_CURRENT_MIN = 2;
    public static final short RESTORE_CURRENT_MAX = 50;
    public static final short RESTORE_CURRENT_DEFAULT = 10;
    public static final short NIZN_CELLS_MIN = 0;
    public static final short NIZN_CELLS_MAX = 10;
    public static final short NIZN_CELLS_DEFAULT = 0;
    public static final short NIZN_CHG_MIN = 1200;
    public static final short NIZN_CHG_MAX = 2000;
    public static final short NIZN_CHG_DEFAULT = 1900;
    public static final short NIZN_DCHG_MIN = 900;
    public static final short NIZN_DCHG_MAX = 1600;
    public static final short NIZN_DCHG_DEFAULT = 1100;
    public static final short NIZN_STD = 1650;
    public static final short NIZN_MIN = 500;
    public static final short NIZN_MAX = 2050;
    public static final short LIHV_CHG_MIN = 3900;
    public static final short LIHV_CHG_MAX = 4450;
    public static final short LIHV_CHG_DEFAULT = 4350;
    public static final short LIHV_STO_MIN = 3700;
    public static final short LIHV_STO_MAX = 3900;
    public static final short LIHV_STO_DEFAULT = 3850;
    public static final short LIHV_DCHG_MIN = 3000;
    public static final short LIHV_DCHG_MAX = 4100;
    public static final short LIHV_DCHG_DEFAULT = 3500;
    public static final short LIHV_STD = 3700;
    public static final short LIHV_MIN = 500;
    public static final short LIHV_MAX = 4500;
    public static final short LTO_CHG_MIN = 2400;
    public static final short LTO_CHG_MAX = 3100;
    public static final short LTO_CHG_DEFAULT = 2850;
    public static final short LTO_STO_MIN = 2200;
    public static final short LTO_STO_MAX = 2600;
    public static final short LTO_STO_DEFAULT = 2400;
    public static final short LTO_DCHG_MIN = 1500;
    public static final short LTO_DCHG_MAX = 2900;
    public static final short LTO_DCHG_DEFAULT = 1800;
    public static final short LTO_STD = 3700;
    public static final short LTO_MIN = 500;
    public static final short LTO_MAX = 3150;
    public static final short LI_BAL_VOLT_MIN = 3000;
    public static final short LI_BAL_VOLT_MAX = 4200;
    public static final short LI_BAL_VOLT_DEFAULT = 3500;
    public static final short LI_BAL_DIFF_MIN = 1;
    public static final short LI_BAL_DIFF_MAX = 10;
    public static final short LI_BAL_DIFF_DEFAULT = 5;
    public static final short LI_BAL_SETPOINT_MIN = 1;
    public static final short LI_BAL_SETPOINT_MAX = 50;
    public static final short LI_BAL_SETPOINT_DEFAULT = 5;
    public static final short LI_BAL_DELAY_MIN = 0;
    public static final short LI_BAL_DELAY_MAX = 20;
    public static final short LI_BAL_DELAY_DEFAULT = 1;
    public static final short LI_BAL_OVER_MIN = 0;
    public static final short LI_BAL_OVER_MAX = 10;
    public static final short LI_BAL_OVER_DEFAULT = 0;
    public static final short LIFE_CHG_MIN = 3300;
    public static final short LIFE_CHG_MAX = 3800;
    public static final short LIFE_CHG_DEFAULT = 3600;
    public static final short LIFE_STO_MIN = 3100;
    public static final short LIFE_STO_MAX = 3400;
    public static final short LIFE_STO_DEFAULT = 3300;
    public static final short LIFE_DCHG_MIN = 2000;
    public static final short LIFE_DCHG_MAX = 3500;
    public static final short LIFE_DCHG_DEFAULT = 2500;
    public static final short LIFE_STD = 3300;
    public static final short LIFE_MIN = 500;
    public static final short LIFE_MAX = 3850;
    public static final short LIFE_ADJ_STEP = 1;
    public static final short LIIO_CHG_MIN = 3750;
    public static final short LIIO_CHG_MAX = 4350;
    public static final short LIIO_CHG_DEFAULT = 4100;
    public static final short LIIO_STO_MIN = 3600;
    public static final short LIIO_STO_MAX = 3800;
    public static final short LIIO_STO_DEFAULT = 3750;
    public static final short LIIO_DCHG_MIN = 2500;
    public static final short LIIO_DCHG_MAX = 4000;
    public static final short LIIO_DCHG_DEFAULT = 3500;
    public static final short LIIO_STD = 3600;
    public static final short LIIO_MIN = 500;
    public static final short LIIO_MAX = 4400;
    public static final short LIIO_ADJ_STEP = 1;
    public static final short LIPO_CHG_MIN = 3850;
    public static final short LIPO_CHG_MAX = 4350;
    public static final short LIPO_CHG_DEFAULT = 4200;
    public static final short LIPO_STO_MIN = 3700;
    public static final short LIPO_STO_MAX = 3900;
    public static final short LIPO_STO_DEFAULT = 3850;
    public static final short LI_STO_COMP_MIN = 0;
    public static final short LI_STO_COMP_MAX = 200;
    public static final short LI_STO_COMP_DEFAULT = 10;
    public static final short LIPO_DCHG_MIN = 3000;
    public static final short LIPO_DCHG_MAX = 4100;
    public static final short LIPO_DCHG_DEFAULT = 3500;
    public static final short LIPO_STD = 3700;
    public static final short LIPO_MIN = 500;
    public static final short LIPO_MAX = 4400;
    public static final short LIPO_ADJ_STEP = 1;
    public static final short NI_STD = 1200;
    public static final short PB_STD = 2000;
    public static final short PB_CHG_MIN = 2000;
    public static final short PB_CHG_MAX = 2600;
    public static final short PB_CHG_DEFAULT = 2400;
    public static final short PB_FLOAT_MIN = 2200;
    public static final short PB_FLOAT_MAX = 2400;
    public static final short PB_FLOAT_DEFAULT = 2300;
    public static final short PB_DCHG_MIN = 1500;
    public static final short PB_DCHG_MAX = 2400;
    public static final short PB_DCHG_DEFAULT = 1800;
    public static final short PB_ADJ_STEP = 1;
    public static final short MEM_EMPTY = -1;
    public static final short MEM_USED = 21930;
    public static final short MEM_FIXED = 0;
    public static final short MEM_SIZE = 256;
    public static final short CYCLE_COUNT_MIN = 1;
    public static final short CYCLE_COUNT_MAX = 99;
    public static final short CYCLE_COUNT_DEFAULT = 3;
    public static final short CYCLE_TIME_MIN = 0;
    public static final short CYCLE_TIME_MAX = 9999;
    public static final short CYCLE_TIME_DEFAULT = 3;
    public static final short SAFETY_TEMP_MIN = 200;
    public static final short SAFETY_TEMP_MAX = 800;
    public static final short SAFETY_TEMP_DEFAULT = 450;
    public static final short SAFETY_CAP_MIN = 50;
    public static final short SAFETY_CAP_MAX = 200;
    public static final short SAFETY_CAP_DEFAULT = 120;
    public static final short SAFETY_TIME_MIN = 0;
    public static final short SAFETY_TIME_MAX = 9999;
    public static final short SAFETY_TIME_DEFAULT = 0;
    public static final short END_CURRENT_C_MIN = 1;
    public static final short END_CURRENT_C_MAX = 50;
    public static final short END_CURRENT_C_DEFAULT = 10;
    public static final short END_CURRENT_D_MIN = 1;
    public static final short END_CURRENT_D_MAX = 100;
    public static final short END_CURRENT_D_DEFAULT = 50;
    public static final short END_CURRENT_STO_MAX = 10;
    public static final short CURRENT_MIN = 5;
    public static final short CURRENT_DEFAULT = 200;
    public static final short VOLT_D_MIN = 100;
    public static final short VOLT_D_MAX = -25536;
    public static final short VOLT_D_DEFAULT = 10;
    public static final short NI_PEAK_SENS_MIN = 1;
    public static final short NI_PEAK_SENS_MAX = 20;
    public static final short NIMH_PEAK_SENS_DEFAULT = 3;
    public static final short NICD_PEAK_SENS_DEFAULT = 5;
    public static final short NI_PEAK_DELAY_MIN = 0;
    public static final short NI_PEAK_DELAY_MAX = 20;
    public static final short NI_PEAK_DELAY_DEFAULT = 3;
    public static final short NI_TRICKLE_CURRENT_MIN = 2;
    public static final short NI_TRICKLE_CURRENT_MAX = 100;
    public static final short NI_TRICKLE_CURRENT_DEFAULT = 5;
    public static final short NI_TRICKLE_TIME_MIN = 1;
    public static final short NI_TRICKLE_TIME_MAX = 999;
    public static final short NI_TRICKLE_TIME_DEFAULT = 5;
    public static final short BAL_DIFF_SLOW = 3;
    public static final short BAL_POINT_SLOW = 3;
    public static final short BAL_OVER_SLOW = 0;
    public static final short BAL_DELAY_SLOW = 2;
    public static final short BAL_DIFF_NORMAL = 5;
    public static final short BAL_POINT_NORMAL = 5;
    public static final short BAL_OVER_NORMAL = 0;
    public static final short BAL_DELAY_NORMAL = 1;
    public static final short BAL_DIFF_FAST = 8;
    public static final short BAL_POINT_FAST = 8;
    public static final short BAL_OVER_FAST = 5;
    public static final short BAL_DELAY_FAST = 0;
    public static final short REG_CH_VOLT_DEFAULT = 12000;
    public static final short REG_CH_CURRENT_DEFAULT = 100;
    public static final short MEM_NAME_LEN = 37;
    short useFlag;
    byte[] name = new byte[38];
    int capacity;
    byte autoSave;
    byte liBalEndMode;
    byte lockFlag;
    byte[] lockPWD = new byte[6];
    short opEnable;
    byte channelMode;
    byte saveToSD;
    short logInterval;
    short runCounter;
    byte type;
    byte liCell;
    byte niCell;
    byte pbCell;
    byte liModeC;
    byte liModeD;
    byte niModeC;
    byte niModeD;
    byte pbModeC;
    byte pbModeD;
    byte balSpeed;
    byte balStartMode;
    short balStartVolt;
    byte balDiff;
    byte balOverPoint;
    byte balSetPoint;
    byte balDelay;
    byte keepChargeEnable;
    short liPoChgCellVolt;
    short liIoChgCellVolt;
    short liFeChgCellVolt;
    short liPoStoCellVolt;
    short liLoStoCellVolt;
    short liFeStoCellVolt;
    short liPoDchgCellVolt;
    short liIoDchgCellVolt;
    short liFeDchgCellVolt;
    short chargeCurrent;
    short dischargeCurrent;
    short endCharge;
    short endDischarge;
    short regDchgMode;
    short niPeak;
    short niPeakDelay;
    short niTrickleEnable;
    short niTrickleCurrent;
    short niTrickleTime;
    short niZeroEnable;
    short niDischargeVolt;
    short pbChgCellVolt;
    short pbDchgCellVolt;
    short pbFloatEnable;
    short pbFloatCellVolt;
    short restoreVolt;
    short restoreTime;
    short restoreCurent;
    short cycleCount;
    short cycleDelay;
    byte cycleMode;
    short safetyTimeC;
    short safetyCapC;
    short safetyTempC;
    short safetyTimeD;
    short safetyCapD;
    short safetyTempD;
    byte regChMode;
    short regChVolt;
    short regChCurrent;
    byte fastSto;
    short stoCompensation;
    short niZnChgCellVolt;
    short niZnDchgCellVolt;
    byte niZnCell;
    short liHVChgCellVolt;
    short liHVStoCellVolt;
    short liHVDchgCellVolt;
    short ltoChgCellVolt;
    short ltoStoCellVolt;
    short ltoDchgCellVolt;
    short userChgCellVolt;
    short userStoCellVolt;
    short userDchgCellVolt;
    byte userCell;
    short digitPowerVolt;
    short digitPowerCurrent;
    short digitPowerSet;
    byte dump;
    static int size = 192;

    public ChargerMemory(byte[] memoryBuffer, boolean isDuo) {
        if (memoryBuffer != null && (isDuo && memoryBuffer.length >= 167 || memoryBuffer.length >= 192)) {
            this.useFlag = DataParser.parse2Short((byte)memoryBuffer[0], (byte)memoryBuffer[1]);
            System.arraycopy(memoryBuffer, 2, this.name, 0, this.name.length);
            this.capacity = DataParser.intFromBytes((byte)memoryBuffer[43], (byte)memoryBuffer[42], (byte)memoryBuffer[41], (byte)memoryBuffer[40]);
            this.autoSave = memoryBuffer[44];
            this.liBalEndMode = memoryBuffer[45];
            this.lockFlag = memoryBuffer[46];
            System.arraycopy(memoryBuffer, 47, this.lockPWD, 0, this.lockPWD.length);
            this.opEnable = DataParser.parse2Short((byte)memoryBuffer[53], (byte)memoryBuffer[54]);
            this.channelMode = memoryBuffer[55];
            this.saveToSD = memoryBuffer[56];
            this.logInterval = DataParser.parse2Short((byte)memoryBuffer[57], (byte)memoryBuffer[58]);
            this.runCounter = DataParser.parse2Short((byte)memoryBuffer[59], (byte)memoryBuffer[60]);
            this.type = memoryBuffer[61];
            this.liCell = memoryBuffer[62];
            this.niCell = memoryBuffer[63];
            this.pbCell = memoryBuffer[64];
            this.liModeC = memoryBuffer[65];
            this.liModeD = memoryBuffer[66];
            this.niModeC = memoryBuffer[67];
            this.niModeD = memoryBuffer[68];
            this.pbModeC = memoryBuffer[69];
            this.pbModeD = memoryBuffer[70];
            this.balSpeed = memoryBuffer[71];
            this.balStartMode = memoryBuffer[72];
            this.balStartVolt = DataParser.parse2Short((byte)memoryBuffer[73], (byte)memoryBuffer[74]);
            this.balDiff = memoryBuffer[75];
            this.balOverPoint = memoryBuffer[76];
            this.balSetPoint = memoryBuffer[77];
            this.balDelay = memoryBuffer[78];
            this.keepChargeEnable = memoryBuffer[79];
            this.liPoChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[80], (byte)memoryBuffer[81]);
            this.liIoChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[82], (byte)memoryBuffer[83]);
            this.liFeChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[84], (byte)memoryBuffer[85]);
            this.liPoStoCellVolt = DataParser.parse2Short((byte)memoryBuffer[86], (byte)memoryBuffer[87]);
            this.liLoStoCellVolt = DataParser.parse2Short((byte)memoryBuffer[88], (byte)memoryBuffer[89]);
            this.liFeStoCellVolt = DataParser.parse2Short((byte)memoryBuffer[90], (byte)memoryBuffer[91]);
            this.liPoDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[92], (byte)memoryBuffer[93]);
            this.liIoDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[94], (byte)memoryBuffer[95]);
            this.liFeDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[96], (byte)memoryBuffer[97]);
            this.chargeCurrent = DataParser.parse2Short((byte)memoryBuffer[98], (byte)memoryBuffer[99]);
            this.dischargeCurrent = DataParser.parse2Short((byte)memoryBuffer[100], (byte)memoryBuffer[101]);
            this.endCharge = DataParser.parse2Short((byte)memoryBuffer[102], (byte)memoryBuffer[103]);
            this.endDischarge = DataParser.parse2Short((byte)memoryBuffer[104], (byte)memoryBuffer[105]);
            this.regDchgMode = DataParser.parse2Short((byte)memoryBuffer[106], (byte)memoryBuffer[107]);
            this.niPeak = DataParser.parse2Short((byte)memoryBuffer[108], (byte)memoryBuffer[109]);
            this.niPeakDelay = DataParser.parse2Short((byte)memoryBuffer[110], (byte)memoryBuffer[111]);
            this.niTrickleEnable = DataParser.parse2Short((byte)memoryBuffer[112], (byte)memoryBuffer[113]);
            this.niTrickleCurrent = DataParser.parse2Short((byte)memoryBuffer[114], (byte)memoryBuffer[115]);
            this.niTrickleTime = DataParser.parse2Short((byte)memoryBuffer[116], (byte)memoryBuffer[117]);
            this.niZeroEnable = DataParser.parse2Short((byte)memoryBuffer[118], (byte)memoryBuffer[119]);
            this.niDischargeVolt = DataParser.parse2Short((byte)memoryBuffer[120], (byte)memoryBuffer[121]);
            this.pbChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[122], (byte)memoryBuffer[123]);
            this.pbDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[124], (byte)memoryBuffer[125]);
            this.pbFloatEnable = DataParser.parse2Short((byte)memoryBuffer[126], (byte)memoryBuffer[127]);
            this.pbFloatCellVolt = DataParser.parse2Short((byte)memoryBuffer[128], (byte)memoryBuffer[129]);
            this.restoreVolt = DataParser.parse2Short((byte)memoryBuffer[130], (byte)memoryBuffer[131]);
            this.restoreTime = DataParser.parse2Short((byte)memoryBuffer[132], (byte)memoryBuffer[133]);
            this.restoreCurent = DataParser.parse2Short((byte)memoryBuffer[134], (byte)memoryBuffer[135]);
            this.cycleCount = DataParser.parse2Short((byte)memoryBuffer[136], (byte)memoryBuffer[137]);
            this.cycleDelay = DataParser.parse2Short((byte)memoryBuffer[138], (byte)memoryBuffer[139]);
            this.cycleMode = memoryBuffer[140];
            this.safetyTimeC = DataParser.parse2Short((byte)memoryBuffer[141], (byte)memoryBuffer[142]);
            this.safetyCapC = DataParser.parse2Short((byte)memoryBuffer[143], (byte)memoryBuffer[144]);
            this.safetyTempC = DataParser.parse2Short((byte)memoryBuffer[145], (byte)memoryBuffer[146]);
            this.safetyTimeD = DataParser.parse2Short((byte)memoryBuffer[147], (byte)memoryBuffer[148]);
            this.safetyCapD = DataParser.parse2Short((byte)memoryBuffer[149], (byte)memoryBuffer[150]);
            this.safetyTempD = DataParser.parse2Short((byte)memoryBuffer[151], (byte)memoryBuffer[152]);
            this.regChMode = memoryBuffer[153];
            this.regChVolt = DataParser.parse2Short((byte)memoryBuffer[154], (byte)memoryBuffer[155]);
            this.regChCurrent = DataParser.parse2Short((byte)memoryBuffer[156], (byte)memoryBuffer[157]);
            this.fastSto = memoryBuffer[158];
            this.stoCompensation = DataParser.parse2Short((byte)memoryBuffer[159], (byte)memoryBuffer[160]);
            this.niZnChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[161], (byte)memoryBuffer[162]);
            this.niZnDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[163], (byte)memoryBuffer[164]);
            this.niZnCell = memoryBuffer[165];
            this.liHVChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[166], (byte)memoryBuffer[167]);
            this.liHVStoCellVolt = DataParser.parse2Short((byte)memoryBuffer[168], (byte)memoryBuffer[169]);
            this.liHVDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[170], (byte)memoryBuffer[171]);
            if (isDuo) {
                this.dump = memoryBuffer[172];
                return;
            }
            this.ltoChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[172], (byte)memoryBuffer[173]);
            this.ltoStoCellVolt = DataParser.parse2Short((byte)memoryBuffer[174], (byte)memoryBuffer[175]);
            this.ltoDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[176], (byte)memoryBuffer[177]);
            this.userChgCellVolt = DataParser.parse2Short((byte)memoryBuffer[178], (byte)memoryBuffer[179]);
            this.userStoCellVolt = DataParser.parse2Short((byte)memoryBuffer[180], (byte)memoryBuffer[181]);
            this.userDchgCellVolt = DataParser.parse2Short((byte)memoryBuffer[182], (byte)memoryBuffer[183]);
            this.userCell = memoryBuffer[184];
            this.digitPowerVolt = DataParser.parse2Short((byte)memoryBuffer[185], (byte)memoryBuffer[186]);
            this.digitPowerCurrent = DataParser.parse2Short((byte)memoryBuffer[187], (byte)memoryBuffer[188]);
            this.digitPowerSet = DataParser.parse2Short((byte)memoryBuffer[189], (byte)memoryBuffer[190]);
            this.dump = memoryBuffer[191];
        }
    }

    public ChargerMemory(ChargerMemory that, boolean isDuo) {
        this.useFlag = that.useFlag;
        System.arraycopy(that.name, 0, this.name, 0, that.name.length);
        this.capacity = that.capacity;
        this.autoSave = that.autoSave;
        this.liBalEndMode = that.liBalEndMode;
        this.lockFlag = that.lockFlag;
        System.arraycopy(that.lockPWD, 0, this.lockPWD, 0, that.lockPWD.length);
        this.opEnable = that.opEnable;
        this.channelMode = that.channelMode;
        this.saveToSD = that.saveToSD;
        this.logInterval = that.logInterval;
        this.runCounter = that.runCounter;
        this.type = that.type;
        this.liCell = that.liCell;
        this.niCell = that.niCell;
        this.pbCell = that.pbCell;
        this.liModeC = that.liModeC;
        this.liModeD = that.liModeD;
        this.niModeC = that.niModeC;
        this.niModeD = that.niModeD;
        this.pbModeC = that.pbModeC;
        this.pbModeD = that.pbModeD;
        this.balSpeed = that.balSpeed;
        this.balStartMode = that.balStartMode;
        this.balStartVolt = that.balStartVolt;
        this.balDiff = that.balDiff;
        this.balOverPoint = that.balOverPoint;
        this.balSetPoint = that.balSetPoint;
        this.balDelay = that.balDelay;
        this.keepChargeEnable = that.keepChargeEnable;
        this.liPoChgCellVolt = that.liPoChgCellVolt;
        this.liIoChgCellVolt = that.liIoChgCellVolt;
        this.liFeChgCellVolt = that.liFeChgCellVolt;
        this.liPoStoCellVolt = that.liPoStoCellVolt;
        this.liLoStoCellVolt = that.liLoStoCellVolt;
        this.liFeStoCellVolt = that.liFeStoCellVolt;
        this.liPoDchgCellVolt = that.liPoDchgCellVolt;
        this.liIoDchgCellVolt = that.liIoDchgCellVolt;
        this.liFeDchgCellVolt = that.liFeDchgCellVolt;
        this.chargeCurrent = that.chargeCurrent;
        this.dischargeCurrent = that.dischargeCurrent;
        this.endCharge = that.endCharge;
        this.endDischarge = that.endDischarge;
        this.regDchgMode = that.regDchgMode;
        this.niPeak = that.niPeak;
        this.niPeakDelay = that.niTrickleEnable;
        this.niTrickleEnable = that.niTrickleEnable;
        this.niTrickleCurrent = that.niTrickleCurrent;
        this.niTrickleTime = that.niTrickleTime;
        this.niZeroEnable = that.niZeroEnable;
        this.niDischargeVolt = that.niDischargeVolt;
        this.pbChgCellVolt = that.pbChgCellVolt;
        this.pbDchgCellVolt = that.pbDchgCellVolt;
        this.pbFloatEnable = that.pbFloatEnable;
        this.pbFloatCellVolt = that.pbFloatCellVolt;
        this.restoreVolt = that.restoreVolt;
        this.restoreTime = that.restoreTime;
        this.restoreCurent = that.restoreCurent;
        this.cycleCount = that.cycleCount;
        this.cycleDelay = that.cycleDelay;
        this.cycleMode = that.cycleMode;
        this.safetyTimeC = that.safetyTimeC;
        this.safetyCapC = that.safetyCapC;
        this.safetyTempC = that.safetyTempC;
        this.safetyTimeD = that.safetyTimeD;
        this.safetyCapD = that.safetyCapD;
        this.safetyTempD = that.safetyTempD;
        this.regChMode = that.regChMode;
        this.regChVolt = that.regChVolt;
        this.regChCurrent = that.regChCurrent;
        this.fastSto = that.fastSto;
        this.stoCompensation = that.stoCompensation;
        this.niZnChgCellVolt = that.niZnChgCellVolt;
        this.niZnDchgCellVolt = that.niZnDchgCellVolt;
        this.niZnCell = that.niZnCell;
        this.liHVChgCellVolt = that.liHVChgCellVolt;
        this.liHVStoCellVolt = that.liHVStoCellVolt;
        this.liHVDchgCellVolt = that.liHVDchgCellVolt;
        if (!isDuo) {
            this.ltoChgCellVolt = that.ltoChgCellVolt;
            this.ltoStoCellVolt = that.ltoStoCellVolt;
            this.ltoDchgCellVolt = that.ltoStoCellVolt;
            this.userChgCellVolt = that.userChgCellVolt;
            this.userStoCellVolt = that.userStoCellVolt;
            this.userDchgCellVolt = that.userDchgCellVolt;
            this.userCell = that.userCell;
            this.digitPowerVolt = that.digitPowerVolt;
            this.digitPowerCurrent = that.digitPowerCurrent;
            this.digitPowerSet = that.digitPowerSet;
        }
        this.dump = that.dump;
    }

    public String toString(boolean isDuo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Memory :").append("\n");
        sb.append(String.format("useFlag \t\t= 0x%04X", this.useFlag)).append("\n");
        sb.append(String.format("name \t\t\t= \"%s\"", new String(this.name).trim())).append("\n");
        sb.append(String.format("capacity \t\t= %d", this.capacity)).append("\n");
        sb.append(String.format("autoSave \t\t= %d", this.autoSave)).append("\n");
        sb.append(String.format("liBalEndMode \t\t= %d", this.liBalEndMode)).append("\n");
        sb.append(String.format("lockFlag \t\t= %d", this.lockFlag & 0xFF)).append("\n");
        sb.append(String.format("lockPWD \t\t= \"%s\"", new String(this.lockPWD))).append("\n");
        sb.append(String.format("opEnable \t\t= %s%s", StringHelper.printBinary((byte)((byte)(this.opEnable >> 8)), (boolean)false), StringHelper.printBinary((byte)((byte)(this.opEnable & 0xFF)), (boolean)false))).append("\n");
        sb.append(String.format("channelMode \t\t= %d", this.channelMode)).append("\n");
        sb.append(String.format("saveToSD \t\t= %d", this.saveToSD)).append("\n");
        sb.append(String.format("logInterval \t\t= %d", this.logInterval)).append("\n");
        sb.append(String.format("runCounter \t\t= %d", this.runCounter)).append("\n");
        sb.append(String.format("type \t\t\t= %d", this.type)).append("\n");
        sb.append(String.format("liCell \t\t\t= %d", this.liCell)).append("\n");
        sb.append(String.format("niCell \t\t\t= %d", this.niCell)).append("\n");
        sb.append(String.format("pbCell \t\t\t= %d", this.pbCell)).append("\n");
        sb.append(String.format("liModeC \t\t= %d", this.liModeC)).append("\n");
        sb.append(String.format("liModeD \t\t= %d", this.liModeD)).append("\n");
        sb.append(String.format("niModeC \t\t= %d", this.niModeC)).append("\n");
        sb.append(String.format("niModeD \t\t= %d", this.niModeD)).append("\n");
        sb.append(String.format("pbModeC \t\t= %d", this.pbModeC)).append("\n");
        sb.append(String.format("pbModeD \t\t= %d", this.pbModeD)).append("\n");
        sb.append(String.format("balSpeed \t\t= %d", this.balSpeed)).append("\n");
        sb.append(String.format("balStartMode \t\t= %d", this.balStartMode & 0xFF)).append("\n");
        sb.append(String.format("balStartVolt \t\t= %d", this.balStartVolt)).append("\n");
        sb.append(String.format("balDiff \t\t= %d", this.balDiff)).append("\n");
        sb.append(String.format("balOverPoint \t\t= %d", this.balOverPoint)).append("\n");
        sb.append(String.format("balSetPoint \t\t= %d", this.balSetPoint)).append("\n");
        sb.append(String.format("balDelay \t\t= %d", this.balDelay)).append("\n");
        sb.append(String.format("keepChargeEnable \t= %d", this.keepChargeEnable)).append("\n");
        sb.append(String.format("liPoChgCellVolt \t= %d", this.liPoChgCellVolt)).append("\n");
        sb.append(String.format("liLoChgCellVolt \t= %d", this.liIoChgCellVolt)).append("\n");
        sb.append(String.format("liFeChgCellVolt \t= %d", this.liFeChgCellVolt)).append("\n");
        sb.append(String.format("liPoStoCellVolt \t= %d", this.liPoStoCellVolt)).append("\n");
        sb.append(String.format("liLoStoCellVolt \t= %d", this.liLoStoCellVolt)).append("\n");
        sb.append(String.format("liFeStoCellVolt \t= %d", this.liFeStoCellVolt)).append("\n");
        sb.append(String.format("liPoDchgCellVolt \t= %d", this.liPoDchgCellVolt)).append("\n");
        sb.append(String.format("liLoDchgCellVolt \t= %d", this.liIoDchgCellVolt)).append("\n");
        sb.append(String.format("liFeDchgCellVolt \t= %d", this.liFeDchgCellVolt)).append("\n");
        sb.append(String.format("chargeCurrent \t\t= %d", this.chargeCurrent)).append("\n");
        sb.append(String.format("dischargeCurrent \t= %d", this.dischargeCurrent)).append("\n");
        sb.append(String.format("endCharge \t\t= %d", this.endCharge)).append("\n");
        sb.append(String.format("endDischarge \t\t= %d", this.endDischarge)).append("\n");
        sb.append(String.format("regDchgMode \t\t= %d", this.regDchgMode)).append("\n");
        sb.append(String.format("niPeak \t\t\t= %d", this.niPeak)).append("\n");
        sb.append(String.format("niPeakDelay \t\t= %d", this.niPeakDelay)).append("\n");
        sb.append(String.format("niTrickleEnable \t= %d", this.niTrickleEnable)).append("\n");
        sb.append(String.format("niTrickleCurrent \t= %d", this.niTrickleCurrent)).append("\n");
        sb.append(String.format("niTrickleTime \t\t= %d", this.niTrickleTime)).append("\n");
        sb.append(String.format("niZeroEnable \t\t= %d", this.niZeroEnable)).append("\n");
        sb.append(String.format("niDischargeVolt \t= %d", this.niDischargeVolt)).append("\n");
        sb.append(String.format("pbChgCellVolt \t\t= %d", this.pbChgCellVolt)).append("\n");
        sb.append(String.format("pbDchgCellVolt \t\t= %d", this.pbDchgCellVolt)).append("\n");
        sb.append(String.format("pbFloatEnable \t\t= %d", this.pbFloatEnable)).append("\n");
        sb.append(String.format("pbFloatCellVolt \t= %d", this.pbFloatCellVolt)).append("\n");
        sb.append(String.format("restoreVolt \t\t= %d", this.restoreVolt)).append("\n");
        sb.append(String.format("restoreTime \t\t= %d", this.restoreTime)).append("\n");
        sb.append(String.format("restoreCurent \t\t= %d", this.restoreCurent)).append("\n");
        sb.append(String.format("cycleCount \t\t= %d", this.cycleCount)).append("\n");
        sb.append(String.format("cycleDelay \t\t= %d", this.cycleDelay)).append("\n");
        sb.append(String.format("cycleMode \t\t= %d", this.cycleMode)).append("\n");
        sb.append(String.format("safetyTimeC \t\t= %d", this.safetyTimeC)).append("\n");
        sb.append(String.format("safetyCapC \t\t= %d", this.safetyCapC)).append("\n");
        sb.append(String.format("safetyTempC \t\t= %d", this.safetyTempC)).append("\n");
        sb.append(String.format("safetyTimeD \t\t= %d", this.safetyTimeD)).append("\n");
        sb.append(String.format("safetyCapD \t\t= %d", this.safetyCapD)).append("\n");
        sb.append(String.format("safetyTempD \t\t= %d", this.safetyTempD)).append("\n");
        if (isDuo) {
            sb.append(String.format("regChMode \t\t= %d", this.regChMode)).append("\n");
            sb.append(String.format("regChVolt \t\t= %d", this.regChVolt)).append("\n");
            sb.append(String.format("regChCurrent \t\t= %d", this.regChCurrent)).append("\n");
        }
        sb.append(String.format("fastSto \t\t= %d", this.fastSto)).append("\n");
        sb.append(String.format("stoCompensation \t= %d", this.stoCompensation)).append("\n");
        sb.append(String.format("niZnChgCellVolt \t= %d", this.niZnChgCellVolt)).append("\n");
        sb.append(String.format("niZnDchgCellVolt \t= %d", this.niZnDchgCellVolt)).append("\n");
        sb.append(String.format("niZnCell \t\t= %d", this.niZnCell)).append("\n");
        sb.append(String.format("liHVChgCellVolt \t= %d", this.liHVChgCellVolt)).append("\n");
        sb.append(String.format("liHVStoCellVolt \t= %d", this.liHVStoCellVolt)).append("\n");
        sb.append(String.format("liHVDchgCellVolt \t= %d", this.liHVDchgCellVolt)).append("\n");
        if (!isDuo) {
            sb.append(String.format("ltoChgCellVolt \t\t= %d", this.ltoChgCellVolt)).append("\n");
            sb.append(String.format("ltoStoCellVolt \t\t= %d", this.ltoStoCellVolt)).append("\n");
            sb.append(String.format("ltoDchgCellVolt \t= %d", this.ltoDchgCellVolt)).append("\n");
            sb.append(String.format("userChgCellVolt \t= %d", this.userChgCellVolt)).append("\n");
            sb.append(String.format("userStoCellVolt \t= %d", this.userStoCellVolt)).append("\n");
            sb.append(String.format("userDchgCellVolt \t= %d", this.userDchgCellVolt)).append("\n");
            sb.append(String.format("userCell \t\t= %d", this.userCell)).append("\n");
            sb.append(String.format("digitPowerVolt \t\t= %d", this.digitPowerVolt)).append("\n");
            sb.append(String.format("digitPowerCurrent \t= %d", this.digitPowerCurrent)).append("\n");
            sb.append(String.format("digitPowerSet \t\t= %s %s", StringHelper.printBinary((byte)((byte)(this.digitPowerSet >> 8)), (boolean)false), StringHelper.printBinary((byte)((byte)(this.digitPowerSet & 0xF)), (boolean)false))).append("\n");
        }
        sb.append(String.format("dump \t\t\t= %s", StringHelper.printBinary((byte)this.dump, (boolean)false))).append("\n");
        return sb.toString();
    }

    public static int getMaxCellsNi(IDevice device) {
        if (device instanceof iChargerX12) {
            return 33;
        }
        if (device instanceof iChargerX8 || device instanceof iCharger308DUO || device instanceof iChargerDX8) {
            return 25;
        }
        if (device instanceof iChargerX6 || device instanceof iChargerS6 || device instanceof iCharger406DUO || device instanceof iChargerDX6) {
            return 20;
        }
        if (device instanceof iCharger4010DUO) {
            return 30;
        }
        return 0;
    }

    public static int getMaxCellsPb(IDevice device) {
        if (device instanceof iChargerX12) {
            return 20;
        }
        if (device instanceof iChargerX8 || device instanceof iCharger308DUO || device instanceof iChargerDX8) {
            return 15;
        }
        if (device instanceof iChargerX6 || device instanceof iChargerS6 || device instanceof iCharger406DUO || device instanceof iChargerDX6) {
            return 12;
        }
        if (device instanceof iCharger4010DUO) {
            return 18;
        }
        if (device instanceof iChargerX12) {
            return 20;
        }
        return 0;
    }

    public byte[] getAsByteArray(boolean isDuo) {
        byte[] memoryBuffer = new byte[(size + 1) / 2 * 2];
        memoryBuffer[0] = (byte)(this.useFlag & 0xFF);
        memoryBuffer[1] = (byte)(this.useFlag >> 8);
        System.arraycopy(this.name, 0, memoryBuffer, 2, this.name.length);
        memoryBuffer[43] = (byte)(this.capacity >> 24);
        memoryBuffer[42] = (byte)((this.capacity & 0xFF0000) >> 16);
        memoryBuffer[41] = (byte)((this.capacity & 0xFF00) >> 8);
        memoryBuffer[40] = (byte)(this.capacity & 0xFF);
        memoryBuffer[44] = this.autoSave;
        memoryBuffer[45] = this.liBalEndMode;
        memoryBuffer[46] = this.lockFlag;
        System.arraycopy(this.lockPWD, 0, memoryBuffer, 47, this.lockPWD.length);
        memoryBuffer[54] = (byte)(this.opEnable >> 8);
        memoryBuffer[53] = (byte)(this.opEnable & 0xFF);
        memoryBuffer[55] = this.channelMode;
        memoryBuffer[56] = this.saveToSD;
        memoryBuffer[58] = (byte)(this.logInterval >> 8);
        memoryBuffer[57] = (byte)(this.logInterval & 0xFF);
        memoryBuffer[60] = (byte)(this.runCounter >> 8);
        memoryBuffer[59] = (byte)(this.runCounter & 0xFF);
        memoryBuffer[61] = this.type;
        memoryBuffer[62] = this.liCell;
        memoryBuffer[63] = this.niCell;
        memoryBuffer[64] = this.pbCell;
        memoryBuffer[65] = this.liModeC;
        memoryBuffer[66] = this.liModeD;
        memoryBuffer[67] = this.niModeC;
        memoryBuffer[68] = this.niModeD;
        memoryBuffer[69] = this.pbModeC;
        memoryBuffer[70] = this.pbModeD;
        memoryBuffer[71] = this.balSpeed;
        memoryBuffer[72] = this.balStartMode;
        memoryBuffer[74] = (byte)(this.balStartVolt >> 8);
        memoryBuffer[73] = (byte)(this.balStartVolt & 0xFF);
        memoryBuffer[75] = this.balDiff;
        memoryBuffer[76] = this.balOverPoint;
        memoryBuffer[77] = this.balSetPoint;
        memoryBuffer[78] = this.balDelay;
        memoryBuffer[79] = this.keepChargeEnable;
        memoryBuffer[81] = (byte)(this.liPoChgCellVolt >> 8);
        memoryBuffer[80] = (byte)(this.liPoChgCellVolt & 0xFF);
        memoryBuffer[83] = (byte)(this.liIoChgCellVolt >> 8);
        memoryBuffer[82] = (byte)(this.liIoChgCellVolt & 0xFF);
        memoryBuffer[85] = (byte)(this.liFeChgCellVolt >> 8);
        memoryBuffer[84] = (byte)(this.liFeChgCellVolt & 0xFF);
        memoryBuffer[87] = (byte)(this.liPoStoCellVolt >> 8);
        memoryBuffer[86] = (byte)(this.liPoStoCellVolt & 0xFF);
        memoryBuffer[89] = (byte)(this.liLoStoCellVolt >> 8);
        memoryBuffer[88] = (byte)(this.liLoStoCellVolt & 0xFF);
        memoryBuffer[91] = (byte)(this.liFeStoCellVolt >> 8);
        memoryBuffer[90] = (byte)(this.liFeStoCellVolt & 0xFF);
        memoryBuffer[93] = (byte)(this.liPoDchgCellVolt >> 8);
        memoryBuffer[92] = (byte)(this.liPoDchgCellVolt & 0xFF);
        memoryBuffer[95] = (byte)(this.liIoDchgCellVolt >> 8);
        memoryBuffer[94] = (byte)(this.liIoDchgCellVolt & 0xFF);
        memoryBuffer[97] = (byte)(this.liFeDchgCellVolt >> 8);
        memoryBuffer[96] = (byte)(this.liFeDchgCellVolt & 0xFF);
        memoryBuffer[99] = (byte)(this.chargeCurrent >> 8);
        memoryBuffer[98] = (byte)(this.chargeCurrent & 0xFF);
        memoryBuffer[101] = (byte)(this.dischargeCurrent >> 8);
        memoryBuffer[100] = (byte)(this.dischargeCurrent & 0xFF);
        memoryBuffer[103] = (byte)(this.endCharge >> 8);
        memoryBuffer[102] = (byte)(this.endCharge & 0xFF);
        memoryBuffer[105] = (byte)(this.endDischarge >> 8);
        memoryBuffer[104] = (byte)(this.endDischarge & 0xFF);
        memoryBuffer[107] = (byte)(this.regDchgMode >> 8);
        memoryBuffer[106] = (byte)(this.regDchgMode & 0xFF);
        memoryBuffer[109] = (byte)(this.niPeak >> 8);
        memoryBuffer[108] = (byte)(this.niPeak & 0xFF);
        memoryBuffer[111] = (byte)(this.niPeakDelay >> 8);
        memoryBuffer[110] = (byte)(this.niPeakDelay & 0xFF);
        memoryBuffer[113] = (byte)(this.niTrickleEnable >> 8);
        memoryBuffer[112] = (byte)(this.niTrickleEnable & 0xFF);
        memoryBuffer[115] = (byte)(this.niTrickleCurrent >> 8);
        memoryBuffer[114] = (byte)(this.niTrickleCurrent & 0xFF);
        memoryBuffer[117] = (byte)(this.niTrickleTime >> 8);
        memoryBuffer[116] = (byte)(this.niTrickleTime & 0xFF);
        memoryBuffer[119] = (byte)(this.niZeroEnable >> 8);
        memoryBuffer[118] = (byte)(this.niZeroEnable & 0xFF);
        memoryBuffer[121] = (byte)(this.niDischargeVolt >> 8);
        memoryBuffer[120] = (byte)(this.niDischargeVolt & 0xFF);
        memoryBuffer[123] = (byte)(this.pbChgCellVolt >> 8);
        memoryBuffer[122] = (byte)(this.pbChgCellVolt & 0xFF);
        memoryBuffer[125] = (byte)(this.pbDchgCellVolt >> 8);
        memoryBuffer[124] = (byte)(this.pbDchgCellVolt & 0xFF);
        memoryBuffer[127] = (byte)(this.pbFloatEnable >> 8);
        memoryBuffer[126] = (byte)(this.pbFloatEnable & 0xFF);
        memoryBuffer[129] = (byte)(this.pbFloatCellVolt >> 8);
        memoryBuffer[128] = (byte)(this.pbFloatCellVolt & 0xFF);
        memoryBuffer[131] = (byte)(this.restoreVolt >> 8);
        memoryBuffer[130] = (byte)(this.restoreVolt & 0xFF);
        memoryBuffer[133] = (byte)(this.restoreTime >> 8);
        memoryBuffer[132] = (byte)(this.restoreTime & 0xFF);
        memoryBuffer[135] = (byte)(this.restoreCurent >> 8);
        memoryBuffer[134] = (byte)(this.restoreCurent & 0xFF);
        memoryBuffer[137] = (byte)(this.cycleCount >> 8);
        memoryBuffer[136] = (byte)(this.cycleCount & 0xFF);
        memoryBuffer[139] = (byte)(this.cycleDelay >> 8);
        memoryBuffer[138] = (byte)(this.cycleDelay & 0xFF);
        memoryBuffer[140] = this.cycleMode;
        memoryBuffer[142] = (byte)(this.safetyTimeC >> 8);
        memoryBuffer[141] = (byte)(this.safetyTimeC & 0xFF);
        memoryBuffer[144] = (byte)(this.safetyCapC >> 8);
        memoryBuffer[143] = (byte)(this.safetyCapC & 0xFF);
        memoryBuffer[146] = (byte)(this.safetyTempC >> 8);
        memoryBuffer[145] = (byte)(this.safetyTempC & 0xFF);
        memoryBuffer[148] = (byte)(this.safetyTimeD >> 8);
        memoryBuffer[147] = (byte)(this.safetyTimeD & 0xFF);
        memoryBuffer[150] = (byte)(this.safetyCapD >> 8);
        memoryBuffer[149] = (byte)(this.safetyCapD & 0xFF);
        memoryBuffer[152] = (byte)(this.safetyTempD >> 8);
        memoryBuffer[151] = (byte)(this.safetyTempD & 0xFF);
        memoryBuffer[153] = this.regChMode;
        memoryBuffer[155] = (byte)(this.regChVolt >> 8);
        memoryBuffer[154] = (byte)(this.regChVolt & 0xFF);
        memoryBuffer[157] = (byte)(this.regChCurrent >> 8);
        memoryBuffer[156] = (byte)(this.regChCurrent & 0xFF);
        memoryBuffer[158] = this.fastSto;
        memoryBuffer[160] = (byte)(this.stoCompensation >> 8);
        memoryBuffer[159] = (byte)(this.stoCompensation & 0xFF);
        memoryBuffer[162] = (byte)(this.niZnChgCellVolt >> 8);
        memoryBuffer[161] = (byte)(this.niZnChgCellVolt & 0xFF);
        memoryBuffer[164] = (byte)(this.niZnDchgCellVolt >> 8);
        memoryBuffer[163] = (byte)(this.niZnDchgCellVolt & 0xFF);
        memoryBuffer[165] = this.niZnCell;
        memoryBuffer[167] = (byte)(this.liHVChgCellVolt >> 8);
        memoryBuffer[166] = (byte)(this.liHVChgCellVolt & 0xFF);
        memoryBuffer[169] = (byte)(this.liHVStoCellVolt >> 8);
        memoryBuffer[168] = (byte)(this.liHVStoCellVolt & 0xFF);
        memoryBuffer[171] = (byte)(this.liHVDchgCellVolt >> 8);
        memoryBuffer[170] = (byte)(this.liHVDchgCellVolt & 0xFF);
        if (isDuo) {
            memoryBuffer[172] = this.dump;
            return memoryBuffer;
        }
        memoryBuffer[173] = (byte)(this.ltoChgCellVolt >> 8);
        memoryBuffer[172] = (byte)(this.ltoChgCellVolt & 0xFF);
        memoryBuffer[175] = (byte)(this.ltoStoCellVolt >> 8);
        memoryBuffer[174] = (byte)(this.ltoStoCellVolt & 0xFF);
        memoryBuffer[177] = (byte)(this.ltoDchgCellVolt >> 8);
        memoryBuffer[176] = (byte)(this.ltoDchgCellVolt & 0xFF);
        memoryBuffer[179] = (byte)(this.userChgCellVolt >> 8);
        memoryBuffer[178] = (byte)(this.userChgCellVolt & 0xFF);
        memoryBuffer[181] = (byte)(this.userStoCellVolt >> 8);
        memoryBuffer[180] = (byte)(this.userStoCellVolt & 0xFF);
        memoryBuffer[183] = (byte)(this.userDchgCellVolt >> 8);
        memoryBuffer[182] = (byte)(this.userDchgCellVolt & 0xFF);
        memoryBuffer[184] = this.userCell;
        memoryBuffer[186] = (byte)(this.digitPowerVolt >> 8);
        memoryBuffer[185] = (byte)(this.digitPowerVolt & 0xFF);
        memoryBuffer[188] = (byte)(this.digitPowerCurrent >> 8);
        memoryBuffer[187] = (byte)(this.digitPowerCurrent & 0xFF);
        memoryBuffer[190] = (byte)(this.digitPowerSet >> 8);
        memoryBuffer[189] = (byte)(this.digitPowerSet & 0xFF);
        memoryBuffer[191] = this.dump;
        return memoryBuffer;
    }

    public int[] getMemoryValues(int[] values, boolean isDuo) {
        values[0] = this.getType();
        if (isDuo) {
            switch (this.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 7: {
                    values[1] = this.getLiCell();
                    break;
                }
                case 3: 
                case 4: {
                    values[1] = this.getNiCell();
                    break;
                }
                case 5: {
                    values[1] = this.getPbCell();
                    break;
                }
                case 6: {
                    values[1] = this.getNiZnCell();
                    break;
                }
                default: {
                    values[1] = 0;
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    values[1] = this.getLiCell();
                    break;
                }
                case 5: 
                case 6: {
                    values[1] = this.getNiCell();
                    break;
                }
                case 7: {
                    values[1] = this.getNiZnCell();
                    break;
                }
                case 8: {
                    values[1] = this.getPbCell();
                    break;
                }
                default: {
                    values[1] = 0;
                }
            }
        }
        values[2] = this.getCapacity();
        values[3] = this.getChargeCurrent();
        values[5] = this.getLiBalEndMode();
        values[6] = this.getEndCharge();
        if (isDuo) {
            switch (this.getType()) {
                case 0: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiPoChgCellVolt();
                    break;
                }
                case 1: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiIoChgCellVolt();
                    break;
                }
                case 2: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiFeChgCellVolt();
                    break;
                }
                case 3: 
                case 4: {
                    values[4] = this.getNiModeC();
                    values[7] = 0;
                    break;
                }
                case 5: {
                    values[4] = this.getPbModeC();
                    values[7] = 0;
                    break;
                }
                case 6: {
                    values[4] = this.getNiModeC();
                    values[7] = this.getNiZnChgCellVolt();
                    break;
                }
                case 7: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiHVChgCellVolt();
                    break;
                }
                default: {
                    values[7] = 0;
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 0: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiPoChgCellVolt();
                    break;
                }
                case 1: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiIoChgCellVolt();
                    break;
                }
                case 2: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiFeChgCellVolt();
                    break;
                }
                case 3: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLiHVChgCellVolt();
                    break;
                }
                case 4: {
                    values[4] = this.getLiModeC();
                    values[7] = this.getLtoChgCellVolt();
                    break;
                }
                case 5: 
                case 6: {
                    values[4] = this.getNiModeC();
                    values[7] = 0;
                    break;
                }
                case 7: {
                    values[4] = this.getNiModeC();
                    values[7] = this.getNiZnChgCellVolt();
                    break;
                }
                default: {
                    values[7] = 0;
                }
            }
        }
        values[8] = this.getSafetyTempC() / 10;
        values[9] = this.getSafetyCapC();
        values[10] = this.getSafetyTimeC();
        values[11] = this.getBalSpeed();
        values[12] = this.getBalStartMode();
        values[13] = this.getBalDiff();
        values[14] = this.getBalSetPoint();
        values[15] = this.getBalOverPoint();
        values[16] = this.getBalDelay();
        values[17] = this.getDischargeCurrent();
        values[19] = this.getEndDischarge();
        values[20] = this.getRegDchgMode();
        if (isDuo) {
            switch (this.getType()) {
                case 0: {
                    values[18] = this.getLiPoDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 1: {
                    values[18] = this.getLiIoDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 2: {
                    values[18] = this.getLiFeDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 3: 
                case 4: {
                    values[18] = this.getNiDischargeVolt();
                    values[21] = this.getNiModeD() & 1;
                    values[22] = this.getNiModeD() >> 1;
                    break;
                }
                case 5: {
                    values[18] = this.getPbDchgCellVolt();
                    values[21] = this.getPbModeD() & 1;
                    values[22] = this.getPbModeD() >> 1;
                    break;
                }
                case 6: {
                    values[18] = this.getNiZnDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 7: {
                    values[18] = this.getLiHVDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                default: {
                    values[18] = 0;
                    values[21] = 0;
                    values[22] = 0;
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 0: {
                    values[18] = this.getLiPoDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 1: {
                    values[18] = this.getLiIoDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 2: {
                    values[18] = this.getLiFeDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 3: {
                    values[18] = this.getLiHVDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 4: {
                    values[18] = this.getLtoDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 5: 
                case 6: {
                    values[18] = this.getNiDischargeVolt();
                    values[21] = this.getNiModeD() & 1;
                    values[22] = this.getNiModeD() >> 1;
                    break;
                }
                case 7: {
                    values[18] = this.getNiZnDchgCellVolt();
                    values[21] = this.getLiModeD() & 1;
                    values[22] = this.getLiModeD() >> 1;
                    break;
                }
                case 8: {
                    values[18] = this.getPbDchgCellVolt();
                    values[21] = this.getPbModeD() & 1;
                    values[22] = this.getPbModeD() >> 1;
                    break;
                }
                default: {
                    values[18] = 0;
                    values[21] = 0;
                    values[22] = 0;
                }
            }
        }
        values[23] = this.getSafetyTempD() / 10;
        values[24] = this.getSafetyCapD();
        values[25] = this.getSafetyTimeD();
        values[26] = this.getNiPeak();
        values[27] = this.getNiPeakDelay();
        values[28] = this.getNiZeroEnable();
        values[29] = this.getNiTrickleEnable();
        values[30] = this.getNiTrickleCurrent();
        values[31] = this.getNiTrickleTime();
        values[32] = this.getRestoreVolt();
        values[33] = this.getRestoreTime();
        values[34] = this.getRestoreCurent();
        values[35] = this.getKeepChargeEnable();
        if (isDuo) {
            switch (this.getType()) {
                case 0: {
                    values[36] = this.getLiPoStoCellVolt();
                    break;
                }
                case 1: {
                    values[36] = this.getLiLoStoCellVolt();
                    break;
                }
                case 2: {
                    values[36] = this.getLiFeStoCellVolt();
                    break;
                }
                case 7: {
                    values[36] = this.getLiHVStoCellVolt();
                    break;
                }
                default: {
                    values[36] = 0;
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 0: {
                    values[36] = this.getLiPoStoCellVolt();
                    break;
                }
                case 1: {
                    values[36] = this.getLiLoStoCellVolt();
                    break;
                }
                case 2: {
                    values[36] = this.getLiFeStoCellVolt();
                    break;
                }
                case 3: {
                    values[36] = this.getLiHVStoCellVolt();
                    break;
                }
                case 4: {
                    values[36] = this.getLtoStoCellVolt();
                    break;
                }
                default: {
                    values[36] = 0;
                }
            }
        }
        values[37] = this.getStoCompensation();
        values[38] = this.getFastSto();
        values[39] = this.getCycleMode();
        values[40] = this.getCycleCount();
        values[41] = this.getCycleDelay();
        values[42] = this.getDigitPowerVolt() / 100;
        values[43] = this.getDigitPowerCurrent() / 10;
        values[44] = this.getDigitPowerSet() & 1;
        values[45] = this.getDigitPowerSet() & 2;
        values[46] = this.getDigitPowerSet() & 4;
        values[47] = this.getChannelMode();
        values[48] = this.getLogInterval();
        values[49] = this.getSaveToSD();
        values[50] = this.getRegChMode();
        values[51] = this.getRegChVolt() / 100;
        values[52] = this.getRegChCurrent();
        return values;
    }

    public String getUseFlagAndName(boolean isDuo) {
        StringBuilder sb = new StringBuilder();
        if (this.name[0] == 0) {
            String replaceDeviceCopiedName = isDuo ? iChargerUsb.BatteryTypesDuo.getValues()[1 + this.getType()] : iChargerX6.BatteryTypesX.getValues()[1 + this.getType()];
            replaceDeviceCopiedName = replaceDeviceCopiedName + Messages.getString((String)"GDE_MSGT2620");
            sb.append(String.format("%-7s - %s", this.useFlag == 21930 ? "CUSTOM" : "BUILD IN", replaceDeviceCopiedName));
        } else {
            sb.append(String.format("%-7s - %s", this.useFlag == 21930 ? "CUSTOM" : "BUILD IN", new String(this.name).trim()));
        }
        return sb.toString();
    }

    public static int getSize(boolean isDuo) {
        return isDuo ? 173 : 192;
    }

    public short getUseFlag() {
        return this.useFlag;
    }

    public void setUseFlag(short useFlag) {
        this.useFlag = useFlag;
    }

    public byte[] getName() {
        return this.name;
    }

    public void setName(String newName) {
        newName = newName.length() > 37 ? newName.substring(0, 37) : newName;
        this.name = new byte[38];
        System.arraycopy(newName.getBytes(), 0, this.name, 0, newName.length());
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public byte getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(byte autoSave) {
        this.autoSave = autoSave;
    }

    public byte getLiBalEndMode() {
        return this.liBalEndMode;
    }

    public void setLiBalEndMode(byte liBalEndMode) {
        this.liBalEndMode = liBalEndMode;
    }

    public byte getLockFlag() {
        return this.lockFlag;
    }

    public void setLockFlag(byte lockFlag) {
        this.lockFlag = lockFlag;
    }

    public byte[] getLockPWD() {
        return this.lockPWD;
    }

    public void setLockPWD(byte[] lockPWD) {
        this.lockPWD = lockPWD;
    }

    public short getOpEnable() {
        return this.opEnable;
    }

    public void setOpEnable(short opEnable) {
        this.opEnable = opEnable;
    }

    public byte getChannelMode() {
        return this.channelMode;
    }

    public void setChannelMode(byte channelMode) {
        this.channelMode = channelMode;
    }

    public byte getSaveToSD() {
        return this.saveToSD;
    }

    public void setSaveToSD(byte saveToSD) {
        this.saveToSD = saveToSD;
    }

    public short getLogInterval() {
        return this.logInterval;
    }

    public void setLogInterval(short logInterval) {
        this.logInterval = logInterval;
    }

    public short getRunCounter() {
        return this.runCounter;
    }

    public void setRunCounter(short runCounter) {
        this.runCounter = runCounter;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getLiCell() {
        return this.liCell;
    }

    public void setLiCell(byte liCell) {
        this.liCell = liCell;
    }

    public byte getNiCell() {
        return this.niCell;
    }

    public void setNiCell(byte niCell) {
        this.niCell = niCell;
    }

    public byte getPbCell() {
        return this.pbCell;
    }

    public void setPbCell(byte pbCell) {
        this.pbCell = pbCell;
    }

    public byte getLiModeC() {
        return this.liModeC;
    }

    public void setLiModeC(byte liModeC) {
        this.liModeC = liModeC;
    }

    public byte getLiModeD() {
        return this.liModeD;
    }

    public void setLiModeD(byte liModeD) {
        this.liModeD = liModeD;
    }

    public byte getNiModeC() {
        return this.niModeC;
    }

    public void setNiModeC(byte niModeC) {
        this.niModeC = niModeC;
    }

    public byte getNiModeD() {
        return this.niModeD;
    }

    public void setNiModeD(byte niModeD) {
        this.niModeD = niModeD;
    }

    public byte getPbModeC() {
        return this.pbModeC;
    }

    public void setPbModeC(byte pbModeC) {
        this.pbModeC = pbModeC;
    }

    public byte getPbModeD() {
        return this.pbModeD;
    }

    public void setPbModeD(byte pbModeD) {
        this.pbModeD = pbModeD;
    }

    public byte getBalSpeed() {
        return this.balSpeed;
    }

    public void setBalSpeed(byte balSpeed) {
        this.balSpeed = balSpeed;
    }

    public byte getBalStartMode() {
        return this.balStartMode;
    }

    public void setBalStartMode(byte balStartMode) {
        this.balStartMode = balStartMode;
    }

    public short getBalStartVolt() {
        return this.balStartVolt;
    }

    public void setBalStartVolt(short balStartVolt) {
        this.balStartVolt = balStartVolt;
    }

    public byte getBalDiff() {
        return this.balDiff;
    }

    public void setBalDiff(byte balDiff) {
        this.balDiff = balDiff;
    }

    public byte getBalOverPoint() {
        return this.balOverPoint;
    }

    public void setBalOverPoint(byte balOverPoint) {
        this.balOverPoint = balOverPoint;
    }

    public byte getBalSetPoint() {
        return this.balSetPoint;
    }

    public void setBalSetPoint(byte balSetPoint) {
        this.balSetPoint = balSetPoint;
    }

    public byte getBalDelay() {
        return this.balDelay;
    }

    public void setBalDelay(byte balDelay) {
        this.balDelay = balDelay;
    }

    public byte getKeepChargeEnable() {
        return this.keepChargeEnable;
    }

    public void setKeepChargeEnable(byte keepChargeEnable) {
        this.keepChargeEnable = keepChargeEnable;
    }

    public short getLiPoChgCellVolt() {
        return this.liPoChgCellVolt;
    }

    public void setLiPoChgCellVolt(short liPoChgCellVolt) {
        this.liPoChgCellVolt = liPoChgCellVolt;
    }

    public short getLiIoChgCellVolt() {
        return this.liIoChgCellVolt;
    }

    public void setLiIoChgCellVolt(short liLoChgCellVolt) {
        this.liIoChgCellVolt = liLoChgCellVolt;
    }

    public short getLiFeChgCellVolt() {
        return this.liFeChgCellVolt;
    }

    public void setLiFeChgCellVolt(short liFeChgCellVolt) {
        this.liFeChgCellVolt = liFeChgCellVolt;
    }

    public short getLiPoStoCellVolt() {
        return this.liPoStoCellVolt;
    }

    public void setLiPoStoCellVolt(short liPoStoCellVolt) {
        this.liPoStoCellVolt = liPoStoCellVolt;
    }

    public short getLiLoStoCellVolt() {
        return this.liLoStoCellVolt;
    }

    public void setLiLoStoCellVolt(short liLoStoCellVolt) {
        this.liLoStoCellVolt = liLoStoCellVolt;
    }

    public short getLiFeStoCellVolt() {
        return this.liFeStoCellVolt;
    }

    public void setLiFeStoCellVolt(short liFeStoCellVolt) {
        this.liFeStoCellVolt = liFeStoCellVolt;
    }

    public short getLiPoDchgCellVolt() {
        return this.liPoDchgCellVolt;
    }

    public void setLiPoDchgCellVolt(short liPoDchgCellVolt) {
        this.liPoDchgCellVolt = liPoDchgCellVolt;
    }

    public short getLiIoDchgCellVolt() {
        return this.liIoDchgCellVolt;
    }

    public void setLiIoDchgCellVolt(short liLoDchgCellVolt) {
        this.liIoDchgCellVolt = liLoDchgCellVolt;
    }

    public short getLiFeDchgCellVolt() {
        return this.liFeDchgCellVolt;
    }

    public void setLiFeDchgCellVolt(short liFeDchgCellVolt) {
        this.liFeDchgCellVolt = liFeDchgCellVolt;
    }

    public short getChargeCurrent() {
        return this.chargeCurrent;
    }

    public void setChargeCurrent(short chargeCurrent) {
        this.chargeCurrent = chargeCurrent;
    }

    public short getDischargeCurrent() {
        return this.dischargeCurrent;
    }

    public void setDischargeCurrent(short dischargeCurrent) {
        this.dischargeCurrent = dischargeCurrent;
    }

    public short getEndCharge() {
        return this.endCharge;
    }

    public void setEndCharge(short endCharge) {
        this.endCharge = endCharge;
    }

    public short getEndDischarge() {
        return this.endDischarge;
    }

    public void setEndDischarge(short endDischarge) {
        this.endDischarge = endDischarge;
    }

    public short getRegDchgMode() {
        return this.regDchgMode;
    }

    public void setRegDchgMode(short regDchgMode) {
        this.regDchgMode = regDchgMode;
    }

    public short getNiPeak() {
        return this.niPeak;
    }

    public void setNiPeak(short niPeak) {
        this.niPeak = niPeak;
    }

    public short getNiPeakDelay() {
        return this.niPeakDelay;
    }

    public void setNiPeakDelay(short niPeakDelay) {
        this.niPeakDelay = niPeakDelay;
    }

    public short getNiTrickleEnable() {
        return this.niTrickleEnable;
    }

    public void setNiTrickleEnable(short niTrickleEnable) {
        this.niTrickleEnable = niTrickleEnable;
    }

    public short getNiTrickleCurrent() {
        return this.niTrickleCurrent;
    }

    public void setNiTrickleCurrent(short niTrickleCurrent) {
        this.niTrickleCurrent = niTrickleCurrent;
    }

    public short getNiTrickleTime() {
        return this.niTrickleTime;
    }

    public void setNiTrickleTime(short niTrickleTime) {
        this.niTrickleTime = niTrickleTime;
    }

    public short getNiZeroEnable() {
        return this.niZeroEnable;
    }

    public void setNiZeroEnable(short niZeroEnable) {
        this.niZeroEnable = niZeroEnable;
    }

    public short getNiDischargeVolt() {
        return this.niDischargeVolt;
    }

    public void setNiDischargeVolt(short niDischargeVolt) {
        this.niDischargeVolt = niDischargeVolt;
    }

    public short getPbChgCellVolt() {
        return this.pbChgCellVolt;
    }

    public void setPbChgCellVolt(short pbChgCellVolt) {
        this.pbChgCellVolt = pbChgCellVolt;
    }

    public short getPbDchgCellVolt() {
        return this.pbDchgCellVolt;
    }

    public void setPbDchgCellVolt(short pbDchgCellVolt) {
        this.pbDchgCellVolt = pbDchgCellVolt;
    }

    public short getPbFloatEnable() {
        return this.pbFloatEnable;
    }

    public void setPbFloatEnable(short pbFloatEnable) {
        this.pbFloatEnable = pbFloatEnable;
    }

    public short getPbFloatCellVolt() {
        return this.pbFloatCellVolt;
    }

    public void setPbFloatCellVolt(short pbFloatCellVolt) {
        this.pbFloatCellVolt = pbFloatCellVolt;
    }

    public short getRestoreVolt() {
        return this.restoreVolt;
    }

    public void setRestoreVolt(short restoreVolt) {
        this.restoreVolt = restoreVolt;
    }

    public short getRestoreTime() {
        return this.restoreTime;
    }

    public void setRestoreTime(short restoreTime) {
        this.restoreTime = restoreTime;
    }

    public short getRestoreCurent() {
        return this.restoreCurent;
    }

    public void setRestoreCurent(short restoreCurent) {
        this.restoreCurent = restoreCurent;
    }

    public short getCycleCount() {
        return this.cycleCount;
    }

    public void setCycleCount(short cycleCount) {
        this.cycleCount = cycleCount;
    }

    public short getCycleDelay() {
        return this.cycleDelay;
    }

    public void setCycleDelay(short cycleDelay) {
        this.cycleDelay = cycleDelay;
    }

    public byte getCycleMode() {
        return this.cycleMode;
    }

    public void setCycleMode(byte cycleMode) {
        this.cycleMode = cycleMode;
    }

    public short getSafetyTimeC() {
        return this.safetyTimeC;
    }

    public void setSafetyTimeC(short safetyTimeC) {
        this.safetyTimeC = safetyTimeC;
    }

    public short getSafetyCapC() {
        return this.safetyCapC;
    }

    public void setSafetyCapC(short safetyCapC) {
        this.safetyCapC = safetyCapC;
    }

    public short getSafetyTempC() {
        return this.safetyTempC;
    }

    public void setSafetyTempC(short safetyTempC) {
        this.safetyTempC = safetyTempC;
    }

    public short getSafetyTimeD() {
        return this.safetyTimeD;
    }

    public void setSafetyTimeD(short safetyTimeD) {
        this.safetyTimeD = safetyTimeD;
    }

    public short getSafetyCapD() {
        return this.safetyCapD;
    }

    public void setSafetyCapD(short safetyCapD) {
        this.safetyCapD = safetyCapD;
    }

    public short getSafetyTempD() {
        return this.safetyTempD;
    }

    public void setSafetyTempD(short safetyTempD) {
        this.safetyTempD = safetyTempD;
    }

    public byte getRegChMode() {
        return this.regChMode;
    }

    public void setRegChMode(byte regChMode) {
        this.regChMode = regChMode;
    }

    public short getRegChVolt() {
        return this.regChVolt;
    }

    public void setRegChVolt(short regChVolt) {
        this.regChVolt = regChVolt;
    }

    public short getRegChCurrent() {
        return this.regChCurrent;
    }

    public void setRegChCurrent(short regChCurrent) {
        this.regChCurrent = regChCurrent;
    }

    public byte getFastSto() {
        return this.fastSto;
    }

    public void setFastSto(byte fastSto) {
        this.fastSto = fastSto;
    }

    public short getStoCompensation() {
        return this.stoCompensation;
    }

    public void setStoCompensation(short stoCompensation) {
        this.stoCompensation = stoCompensation;
    }

    public short getNiZnChgCellVolt() {
        return this.niZnChgCellVolt;
    }

    public void setNiZnChgCellVolt(short niZnChgCellVolt) {
        this.niZnChgCellVolt = niZnChgCellVolt;
    }

    public short getNiZnDchgCellVolt() {
        return this.niZnDchgCellVolt;
    }

    public void setNiZnDchgCellVolt(short niZnDchgCellVolt) {
        this.niZnDchgCellVolt = niZnDchgCellVolt;
    }

    public byte getNiZnCell() {
        return this.niZnCell;
    }

    public void setNiZnCell(byte niZnCell) {
        this.niZnCell = niZnCell;
    }

    public short getLiHVChgCellVolt() {
        return this.liHVChgCellVolt;
    }

    public void setLiHVChgCellVolt(short liHVChgCellVolt) {
        this.liHVChgCellVolt = liHVChgCellVolt;
    }

    public short getLiHVStoCellVolt() {
        return this.liHVStoCellVolt;
    }

    public void setLiHVStoCellVolt(short liHVStoCellVolt) {
        this.liHVStoCellVolt = liHVStoCellVolt;
    }

    public short getLiHVDchgCellVolt() {
        return this.liHVDchgCellVolt;
    }

    public void setLiHVDchgCellVolt(short liHVDchgCellVolt) {
        this.liHVDchgCellVolt = liHVDchgCellVolt;
    }

    public short getLtoChgCellVolt() {
        return this.ltoChgCellVolt;
    }

    public void setLtoChgCellVolt(short ltoChgCellVolt) {
        this.ltoChgCellVolt = ltoChgCellVolt;
    }

    public short getLtoStoCellVolt() {
        return this.ltoStoCellVolt;
    }

    public void setLtoStoCellVolt(short ltoStoCellVolt) {
        this.ltoStoCellVolt = ltoStoCellVolt;
    }

    public short getLtoDchgCellVolt() {
        return this.ltoDchgCellVolt;
    }

    public void setLtoDchgCellVolt(short ltoDchgCellVolt) {
        this.ltoDchgCellVolt = ltoDchgCellVolt;
    }

    public short getUserChgCellVolt() {
        return this.userChgCellVolt;
    }

    public void setUserChgCellVolt(short userChgCellVolt) {
        this.userChgCellVolt = userChgCellVolt;
    }

    public short getUserStoCellVolt() {
        return this.userStoCellVolt;
    }

    public void setUserStoCellVolt(short userStoCellVolt) {
        this.userStoCellVolt = userStoCellVolt;
    }

    public short getUserDchgCellVolt() {
        return this.userDchgCellVolt;
    }

    public void setUserDchgCellVolt(short userDchgCellVolt) {
        this.userDchgCellVolt = userDchgCellVolt;
    }

    public byte getUserCell() {
        return this.userCell;
    }

    public void setUserCell(byte userCell) {
        this.userCell = userCell;
    }

    public short getDigitPowerVolt() {
        return this.digitPowerVolt;
    }

    public void setDigitPowerVolt(short digitPowerVolt) {
        this.digitPowerVolt = digitPowerVolt;
    }

    public short getDigitPowerCurrent() {
        return this.digitPowerCurrent;
    }

    public void setDigitPowerCurrent(short digitPowerCurrent) {
        this.digitPowerCurrent = digitPowerCurrent;
    }

    public short getDigitPowerSet() {
        return this.digitPowerSet;
    }

    public void setDigitPowerSet(short digitPowerSet) {
        this.digitPowerSet = digitPowerSet;
    }

    public byte getDump() {
        return this.dump;
    }

    public void setDump(byte dump) {
        this.dump = dump;
    }

    static enum ChannelType {
        REG_CH_TYPE_RES,
        REG_CH_TYPE_BAT;

    }

    static enum DischargeMode {
        REG_DCHG_OFF,
        REG_DCHG_INPUT,
        REG_DCHG_CH,
        REG_DCHG_AUTO;

    }

    static enum CycleMode {
        CYCLE_MODE_C2D("C->D"),
        CYCLE_MODE_D2C("D->C"),
        CYCLE_MODE_C2D2C("C->D->C"),
        CYCLE_MODE_D2C2D("D->C->D"),
        CYCLE_MODE_C2D2STO("C->D->S"),
        CYCLE_MODE_D2C2STO("D->C->S");

        String value;
        public static String[] VALUES;

        private CycleMode(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (CycleMode element : CycleMode.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = CycleMode.getValues();
        }
    }

    public static enum PbMode {
        PB_MODE_C_NORMAL("normal"),
        PB_MODE_C_REFLEX("reflex");

        String value;
        public static String[] VALUES;

        private PbMode(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (PbMode element : PbMode.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = PbMode.getValues();
        }
    }

    public static enum NiMode {
        NI_MODE_C_NORMAL("normal"),
        NI_MODE_C_REFLEX("reflex");

        String value;
        public static String[] VALUES;

        private NiMode(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (NiMode element : NiMode.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = NiMode.getValues();
        }
    }

    public static enum LiMode {
        LI_MODE_C_BAL("balancer"),
        LI_MODE_C_NOTBAL("off");

        String value;
        public static String[] VALUES;

        private LiMode(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (LiMode element : LiMode.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = LiMode.getValues();
        }
    }

    public static enum BalancerSpeed {
        BAL_SPEED_SLOW("slow"),
        BAL_SPEED_NORMAL("normal"),
        BAL_SPEED_FAST("fast"),
        BAL_SPEED_USER("user");

        String value;
        public static String[] VALUES;

        private BalancerSpeed(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (BalancerSpeed element : BalancerSpeed.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = BalancerSpeed.getValues();
        }
    }

    public static enum BalancerLiSetup {
        END_CURRENT_OFF_BAL_DETECT_ON("OFF-ON"),
        END_CURRENT_ON_BAL_DETECT_OFF("ON-OFF"),
        END_CURRENT_OR_BAL_DETECT("OR"),
        END_CURRENT_AND_BAL_DETECT("AND");

        String value;
        public static String[] VALUES;

        private BalancerLiSetup(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (BalancerLiSetup element : BalancerLiSetup.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = BalancerLiSetup.getValues();
        }
    }

    public static enum BalancerStart {
        BAL_START_CV("CV"),
        BAL_START_CV_100("CV-0.1V"),
        BAL_START_CV_200("CV-0.2V"),
        BAL_START_CV_300("CV-0.3V"),
        BAL_START_CV_400("CV-0.4V"),
        BAL_START_CV_500("CV-0.5V"),
        BAL_START_CV_600("CV-0.6V"),
        BAL_START_CV_700("CV-0.7V"),
        BAL_START_CV_800("CV-0.8V"),
        BAL_START_CV_900("CV-0.9V"),
        BAL_START_CV_1000("CV-1.0V"),
        BAL_START_ALWAY("Always");

        String value;
        public static String[] VALUES;

        private BalancerStart(String setValue) {
            this.value = setValue;
        }

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (BalancerStart element : BalancerStart.values()) {
                list.add(element.value);
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = BalancerStart.getValues();
        }
    }
}

