/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.data.Record;
import gde.data.RecordSet;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.MathUtils;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GraphicsUtils {
    private static Logger log = Logger.getLogger(GraphicsUtils.class.getName());
    static DataExplorer application = DataExplorer.getInstance();

    public static void drawVerticalTickMarks(Record record, GC gc, int x0, int y0, int height, double minValue, double maxValue, int ticklength, int miniticks, int gap, boolean isPositionLeft, int numberTickmarks, boolean isDrawNumbersInRecordColor) {
        boolean isBuildGridVector;
        double maxScaleValue;
        double minScaleValue;
        gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        int yTop = y0 - height + 1;
        double deltaScale = maxValue - minValue;
        int numberTicks = numberTickmarks == 0 ? (height / 50 >= 2 ? height / 50 : 1) : numberTickmarks;
        int maxNumberTicks = height / 25 >= 2 ? height / 25 : 1;
        double deltaScaleValue = deltaScale;
        if (record.isRoundOut() || record.isStartEndDefined()) {
            minScaleValue = minValue;
            maxScaleValue = maxValue;
        } else {
            Object[] roundResult = MathUtils.adaptRounding(minValue, maxValue, true, maxNumberTicks);
            minScaleValue = (Double)roundResult[0];
            maxScaleValue = (Double)roundResult[1];
            numberTicks = (Integer)roundResult[2];
            miniticks = (Integer)roundResult[3];
            deltaScaleValue = maxScaleValue - minScaleValue;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("deltaScaleValue = %10.6f - deltaScale = %10.6f", deltaScaleValue, deltaScale));
        }
        Vector<Integer> horizontalGrid = new Vector<Integer>();
        RecordSet recordSet = record.getParent();
        boolean bl = isBuildGridVector = recordSet.getValueGridType() != 0 && recordSet.getValueGridRecordOrdinal() == record.getOrdinal();
        if (record.getNumberScaleTicks() != numberTicks) {
            record.setNumberScaleTicks(numberTicks);
            int cleanwidth = 35;
            if (isPositionLeft) {
                gc.fillRectangle(x0 - cleanwidth, yTop, cleanwidth, height);
            } else {
                gc.fillRectangle(x0 + 1, yTop, cleanwidth, height);
            }
        }
        int dist = 10;
        if (!isPositionLeft) {
            ticklength *= -1;
            gap *= -1;
            dist *= -1;
        }
        gc.setLineWidth(1);
        if (numberTicks > 1) {
            int yPosMini;
            int yPosMini2;
            double deltaMainTickValue = deltaScaleValue / (double)numberTicks;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("minScaleValue = %10.6f; maxScaleValue = %10.6f; deltaMainTickValue = %10.6f", minScaleValue, maxScaleValue, deltaMainTickValue));
            }
            double deltaMainTickPixel = deltaScaleValue / deltaScale * (double)height / (double)numberTicks;
            double deltaPosMini = deltaMainTickPixel / (double)miniticks;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("numberTicks = %d; deltaMainTickPixel = %10.6f; deltaPosMini = %10.6f", numberTicks, deltaMainTickPixel, deltaPosMini));
            }
            double yTickPositionMin = (double)y0 - Math.abs(minScaleValue - minValue) * ((double)height / deltaScale);
            for (int j = 1; j < miniticks && (yPosMini2 = (int)(yTickPositionMin + (double)j * deltaPosMini)) < y0; ++j) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "yTickPosition=" + yTickPositionMin + ", xPosMini=" + yPosMini2);
                }
                gc.drawLine(x0, yPosMini2, x0 - ticklength / 2, yPosMini2);
            }
            for (int i = 0; i <= numberTicks; ++i) {
                int yTickPosition = (int)(yTickPositionMin - (double)i * deltaMainTickPixel);
                gc.drawLine(x0, yTickPosition, x0 - ticklength, yTickPosition);
                if (isBuildGridVector) {
                    horizontalGrid.add(yTickPosition);
                }
                for (int j = 1; j < miniticks && i < numberTicks; ++j) {
                    int yPosMini3 = yTickPosition - (int)((double)j * deltaPosMini);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "yTickPosition=" + yTickPosition + ", xPosMini=" + yPosMini3);
                    }
                    gc.drawLine(x0, yPosMini3, x0 - ticklength / 2, yPosMini3);
                }
                if (isDrawNumbersInRecordColor) {
                    gc.setForeground(SWTResourceManager.getColor(record.getRGB()));
                } else {
                    gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
                }
                GraphicsUtils.drawTextCentered(record.getFormattedScaleValue(minScaleValue + (double)i * deltaMainTickValue), x0 - ticklength - gap - dist, yTickPosition, gc, 256);
                gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
            }
            double yTickPositionMax = yTickPositionMin - (double)numberTicks * deltaMainTickPixel;
            for (double j = 1.0; j < (double)miniticks && (yPosMini = (int)(yTickPositionMax - j * deltaPosMini)) >= yTop - 1; j += 1.0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "yTickPosition=" + yTickPositionMax + ", xPosMini=" + yPosMini);
                }
                gc.drawLine(x0, yPosMini, x0 - ticklength / 2, yPosMini);
            }
        } else {
            int yTickPosition = (int)((double)y0 - (double)height / 2.0);
            gc.drawLine(x0, yTickPosition, x0 - ticklength, yTickPosition);
            if (isDrawNumbersInRecordColor) {
                gc.setForeground(SWTResourceManager.getColor(record.getRGB()));
            } else {
                gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
            }
            GraphicsUtils.drawTextCentered(record.getFormattedScaleValue((minScaleValue + minScaleValue) / 2.0), x0 - ticklength - gap - dist, yTickPosition, gc, 256);
            if (isBuildGridVector) {
                horizontalGrid.add(yTickPosition);
            }
        }
        if (isBuildGridVector) {
            recordSet.setValueGrid(horizontalGrid);
        }
    }

    public static void drawTextCentered(String string, int x, int y, GC gc, int style) {
        boolean isHorizontal;
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string);
        Image stringImage = SWTResourceManager.getImage(pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        stringGc.setForeground(gc.getForeground());
        stringGc.setBackground(gc.getBackground());
        stringGc.setFont(gc.getFont());
        stringGc.fillRectangle(0, 0, pt.x, pt.y);
        stringGc.drawText(string, 0, 0);
        boolean bl = isHorizontal = (style & 0x100) == 256;
        if (isHorizontal) {
            gc.drawImage(stringImage, x - pt.x / 2, y - pt.y / 2);
        } else {
            GraphicsUtils.drawVerticalImage(stringImage, x, y - pt.x / 2, gc, style, String.format("%s_%s_%s", string, gc.getBackground().toString(), gc.getForeground().toString()));
        }
        stringGc.dispose();
    }

    public static void drawText(String string, int x, int y, GC gc, int style) {
        boolean isHorizontal;
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string);
        Image stringImage = SWTResourceManager.getImage(pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        stringGc.setForeground(gc.getForeground());
        stringGc.setBackground(gc.getBackground());
        stringGc.setFont(gc.getFont());
        stringGc.fillRectangle(0, 0, pt.x, pt.y);
        stringGc.drawText(string, 0, 0);
        boolean bl = isHorizontal = (style & 0x100) == 256;
        if (isHorizontal) {
            gc.drawImage(stringImage, x, y);
        } else {
            GraphicsUtils.drawVerticalImage(stringImage, x, y, gc, style, string);
        }
        stringGc.dispose();
    }

    public static void drawTimeLineText(String string, int x, int y, GC gc, int style) {
        boolean isHorizontal;
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string);
        Image stringImage = SWTResourceManager.getImage(pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        stringGc.setForeground(gc.getForeground());
        stringGc.setBackground(gc.getBackground());
        stringGc.setFont(gc.getFont());
        stringGc.fillRectangle(0, 0, pt.x, pt.y);
        stringGc.drawText(string, 0, 0);
        if (string.contains(", ")) {
            int boldTextOffset = gc.textExtent((String)new StringBuilder().append((String)string.split((String)", ")[0]).append((String)", ").toString()).x;
            stringGc.setFont(SWTResourceManager.getFont(gc, 1));
            stringGc.drawText(string.split(", |]")[1].trim(), boldTextOffset, 0);
            stringGc.setFont(SWTResourceManager.getFont(gc, 0));
        }
        boolean bl = isHorizontal = (style & 0x100) == 256;
        if (isHorizontal) {
            gc.drawImage(stringImage, x - pt.x / 2, y - pt.y / 2);
        } else {
            GraphicsUtils.drawVerticalImage(stringImage, x, y - pt.x / 2, gc, style, string);
        }
        stringGc.dispose();
    }

    private static void drawVerticalImage(Image image, int x, int y, GC gc, int style, String imgKey) {
        gc.drawImage(SWTResourceManager.getRotatedImage(image, style, imgKey), x, y);
    }

    public static void drawImageCentered(String url, int x, int y, GC gc) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Image image = SWTResourceManager.getImage(url);
        Rectangle bounds = image.getBounds();
        gc.drawImage(image, x - bounds.width / 2, y - bounds.height / 2);
    }
}

