/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.GDE;
import gde.config.Settings;
import gde.device.resource.DeviceXmlResource;
import gde.histo.guard.Reminder;
import gde.histo.recordings.HistoGraphicsMapper;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.GraphicsComposite;
import gde.histo.ui.SummaryComposite;
import gde.histo.ui.data.SummarySpots;
import gde.histo.utils.ElementaryQuantile;
import gde.histo.utils.HistoTimeLine;
import gde.log.Level;
import gde.log.Logger;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.ColorUtils;
import gde.utils.GraphicsUtils;
import gde.utils.MathUtils;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class HistoCurveUtils {
    private static final String $CLASS_NAME = HistoCurveUtils.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final Settings settings = Settings.getInstance();

    public static void drawCurveAreaBorders(GC gc, Rectangle bounds, Color borderColor) {
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(borderColor);
        int xMax = bounds.x + bounds.width;
        int y0 = bounds.y + bounds.height;
        gc.drawLine(bounds.x - 1, bounds.y - 1, bounds.x - 1, y0);
        gc.drawLine(xMax + 1, bounds.y - 1, xMax + 1, y0);
    }

    public static void drawCurveGrid(TrailRecordSet recordSet, GC gc, Rectangle bounds, int[] dashLineStyle) {
        gc.setLineWidth(1);
        gc.setLineDash(dashLineStyle);
        gc.setLineStyle(6);
        gc.setForeground(recordSet.getValueGridColor());
        Vector<Integer> horizontalGridVector = recordSet.getValueGrid();
        for (int i = 0; i < horizontalGridVector.size(); i += recordSet.getValueGridType()) {
            int y = horizontalGridVector.get(i);
            if (y <= bounds.y || y >= bounds.y + bounds.height) continue;
            gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        }
    }

    public static void drawChannelItemSpread(SummarySpots summarySpots, GC gc) {
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(DataExplorer.getInstance().COLOR_LIGHT_BLUE);
        Color background = gc.getBackground();
        gc.setBackground(DataExplorer.getInstance().COLOR_LIGHT_BLUE);
        Rectangle drawStripBounds = summarySpots.getDrawStripBounds();
        int yPos = drawStripBounds.y + 1;
        int yHeight = drawStripBounds.height - 2;
        int HALF_MID_GAP = 4;
        int[] xPositions = summarySpots.defineSpreadXPositions();
        int xPos = xPositions[0];
        int xPosClipping = Math.max(1, xPositions[0]);
        int xWidth = xPositions[1] - xPositions[0];
        boolean startsBeyondLeft = xPos <= 0;
        int xWidthClipping = Math.max(0, Math.min(drawStripBounds.width - 1, (startsBeyondLeft ? xWidth + xPos : xWidth) - 4));
        log.finest(() -> "xPos=" + xPos + " xWidth=" + xWidth + " xPosClipping=" + xPosClipping + " xWidthClipping=" + xWidthClipping);
        gc.setClipping(drawStripBounds.x + xPosClipping, drawStripBounds.y, xWidthClipping, drawStripBounds.height);
        gc.fillOval(drawStripBounds.x + xPos, yPos, xWidth * 2, yHeight);
        int xWidth2 = xPositions[2] - xPositions[1];
        int xPos2 = xPositions[1] - xWidth2;
        int xPosClipping2 = Math.max(1, xPositions[1] + 4);
        boolean endsBeyondRight = xPositions[2] > drawStripBounds.width;
        xWidthClipping = Math.max(0, endsBeyondRight ? drawStripBounds.width - Math.max(0, xPositions[1] + 4) : Math.min(drawStripBounds.width, xWidth2 - 4));
        log.finest(() -> "xPosRight=" + xPos2 + " xWidthRight=" + xWidth2 + " xPosClipping=" + xPosClipping2 + " xWidthClipping=" + xWidthClipping);
        gc.setClipping(drawStripBounds.x + xPosClipping2, drawStripBounds.y, xWidthClipping, drawStripBounds.height);
        gc.fillOval(drawStripBounds.x + xPos2, yPos, xWidth2 * 2, yHeight);
        gc.setClipping((Rectangle)null);
        gc.setBackground(background);
    }

    public static void drawChannelItemBoxplot(SummaryComposite.SummaryLayout summary, GC gc, int scaleWidthSpace, boolean drawNumbersInRecordColor, boolean drawNumbers) {
        Point ptQ3;
        TrailRecordFormatter recordFormatter = new TrailRecordFormatter(summary.getTrailRecord());
        List<String> scaleTexts = Arrays.asList(summary.getTrailRecord().getFormattedScaleValue(summary.getScaleMinMax()[0]), summary.getTrailRecord().getFormattedScaleValue(summary.getScaleMinMax()[1]));
        Color tmpColor = ColorUtils.getColor(summary.getTrailRecord().getRGB());
        gc.setLineWidth(2);
        gc.setLineStyle(1);
        Rectangle drawStripBounds = summary.getSummarySpots().getDrawStripBounds();
        int x0 = drawStripBounds.x;
        int yPos = drawStripBounds.y + drawStripBounds.height / 2;
        Point pt = gc.textExtent("0");
        int scaleXGap = pt.x;
        int scaleYGap = pt.y / 2 + 1;
        int scaleY0 = drawStripBounds.y + drawStripBounds.height + scaleYGap;
        int halfStdBoxHeight = drawStripBounds.height / 2 - 5;
        int scaledHalfBoxHeight = halfStdBoxHeight + Settings.getInstance().getBoxplotScaleOrdinal() * 2;
        int[] tukeyXPositions = summary.getSummarySpots().defineTukeyXPositions();
        int xPosQ1 = x0 + tukeyXPositions[ElementaryQuantile.BoxplotItems.QUARTILE1.ordinal()];
        int xPosQ2 = x0 + tukeyXPositions[ElementaryQuantile.BoxplotItems.QUARTILE2.ordinal()];
        int xPosQ3 = x0 + tukeyXPositions[ElementaryQuantile.BoxplotItems.QUARTILE3.ordinal()];
        gc.setForeground(tmpColor);
        int boxOffset = (drawStripBounds.height - scaledHalfBoxHeight * 2) / 2;
        gc.drawLine(xPosQ2, yPos - scaledHalfBoxHeight, xPosQ2, yPos + scaledHalfBoxHeight);
        gc.drawRectangle(xPosQ1, drawStripBounds.y + boxOffset, xPosQ3 - xPosQ1, scaledHalfBoxHeight * 2);
        if (drawNumbers) {
            DecimalFormat df = summary.getDecimalFormat();
            gc.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE - 1, 0));
            Color color = drawNumbersInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_BLACK;
            gc.setForeground(color);
            double[] tukeyBoxPlot = summary.getTrailRecord().getQuantile().getTukeyBoxPlot();
            String q1Text = recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.QUARTILE1.ordinal()], df);
            Point ptQ1 = gc.textExtent(q1Text);
            if (!scaleTexts.contains(q1Text)) {
                GraphicsUtils.drawTextCentered(q1Text, xPosQ1, scaleY0, gc, 256);
            }
            String q3Text = recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.QUARTILE3.ordinal()], df);
            ptQ3 = gc.textExtent(q3Text);
            if ((ptQ3.x + ptQ1.x) / 2 + scaleXGap < xPosQ3 - xPosQ1 && !scaleTexts.contains(q3Text)) {
                GraphicsUtils.drawTextCentered(q3Text, xPosQ3, scaleY0, gc, 256);
            }
            String q2Text = recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.QUARTILE2.ordinal()], df);
            Point ptQ2 = gc.textExtent(q2Text);
            if ((ptQ2.x + ptQ1.x) / 2 + scaleXGap < xPosQ2 - xPosQ1 && (ptQ3.x + ptQ2.x) / 2 + scaleXGap < xPosQ3 - xPosQ2 && !scaleTexts.contains(q2Text)) {
                GraphicsUtils.drawTextCentered(q2Text, xPosQ2, scaleY0, gc, 256);
            }
            gc.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        }
        gc.setLineWidth(1);
        gc.setForeground(tmpColor);
        int xPosLowerWhisker = x0 + tukeyXPositions[ElementaryQuantile.BoxplotItems.LOWER_WHISKER.ordinal()];
        int xPosUpperWhisker = x0 + tukeyXPositions[ElementaryQuantile.BoxplotItems.UPPER_WHISKER.ordinal()];
        gc.drawLine(xPosLowerWhisker, yPos, xPosQ1, yPos);
        gc.drawLine(xPosUpperWhisker, yPos, xPosQ3, yPos);
        int scaledHalfAntennaHeight = (scaledHalfBoxHeight + 2) / 2;
        gc.drawLine(xPosLowerWhisker, yPos - scaledHalfAntennaHeight, xPosLowerWhisker, yPos + scaledHalfAntennaHeight);
        gc.drawLine(xPosUpperWhisker, yPos - scaledHalfAntennaHeight, xPosUpperWhisker, yPos + scaledHalfAntennaHeight);
        if (drawNumbers) {
            gc.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE - 1, 0));
            Color color = drawNumbersInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_BLACK;
            gc.setForeground(color);
            double[] tukeyBoxPlot = summary.getTrailRecord().getQuantile().getTukeyBoxPlot();
            DecimalFormat df = summary.getDecimalFormat();
            Point ptQ1 = gc.textExtent("" + recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.QUARTILE1.ordinal()], df));
            String lowerText = "" + recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.LOWER_WHISKER.ordinal()], df);
            Point ptLower = gc.textExtent(lowerText);
            if ((ptLower.x + ptQ1.x) / 2 + scaleXGap < xPosQ1 - xPosLowerWhisker && !scaleTexts.contains(lowerText)) {
                GraphicsUtils.drawTextCentered(lowerText, xPosLowerWhisker, scaleY0, gc, 256);
            }
            df = summary.getDecimalFormat();
            ptQ3 = gc.textExtent("" + recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.QUARTILE3.ordinal()], df));
            String upperText = "" + recordFormatter.getSummaryValue(tukeyBoxPlot[ElementaryQuantile.BoxplotItems.UPPER_WHISKER.ordinal()], df);
            Point ptUpper = gc.textExtent(upperText);
            if ((ptUpper.x + ptQ3.x) / 2 + scaleXGap < xPosUpperWhisker - xPosQ3 && !scaleTexts.contains(upperText)) {
                GraphicsUtils.drawTextCentered(upperText, xPosUpperWhisker, scaleY0, gc, 256);
            }
            gc.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        }
    }

    public static void drawChannelItemWarnings(SummaryComposite.SummaryLayout summary, GC gc, int scaleWidthSpace) {
        Rectangle drawStripBounds = summary.getSummarySpots().getDrawStripBounds();
        int x0 = drawStripBounds.x;
        int width = drawStripBounds.width;
        int xN = x0 + width + 1;
        int yPos = drawStripBounds.y + drawStripBounds.height / 2 - 1;
        Reminder[] minMaxWarning = summary.getMinMaxWarning();
        if (minMaxWarning[0] != null) {
            if (minMaxWarning[0].getReminderType() == Reminder.ReminderType.FAR) {
                GraphicsUtils.drawImageCentered("gde/resource/caution_portrait.png", x0 - scaleWidthSpace * 9 / 10, yPos, gc);
            } else if (minMaxWarning[0].getReminderType() == Reminder.ReminderType.CLOSE) {
                GraphicsUtils.drawImageCentered("gde/resource/caution_portrait_yellow.png", x0 - scaleWidthSpace * 9 / 10, yPos, gc);
            } else {
                GraphicsUtils.drawImageCentered("gde/resource/caution_portrait_blue.png", x0 - scaleWidthSpace * 9 / 10, yPos, gc);
            }
        }
        if (minMaxWarning[1] != null) {
            if (minMaxWarning[1].getReminderType() == Reminder.ReminderType.FAR) {
                GraphicsUtils.drawImageCentered("gde/resource/caution_portrait.png", xN + scaleWidthSpace * 9 / 10, yPos, gc);
            } else if (minMaxWarning[1].getReminderType() == Reminder.ReminderType.CLOSE) {
                GraphicsUtils.drawImageCentered("gde/resource/caution_portrait_yellow.png", xN + scaleWidthSpace * 9 / 10, yPos, gc);
            } else {
                GraphicsUtils.drawImageCentered("gde/resource/caution_portrait_blue.png", xN + scaleWidthSpace * 9 / 10, yPos, gc);
            }
        }
    }

    public static void drawChannelItemScale(SummaryComposite.SummaryLayout summary, GC gc, int scaleWidthSpace, boolean drawScaleInRecordColor, boolean drawNumbersInRecordColor) {
        boolean isCurveGridEnabled;
        SummarySpots summarySpots = summary.getSummarySpots();
        Rectangle drawStripBounds = summarySpots.getDrawStripBounds();
        int x0 = drawStripBounds.x;
        int width = drawStripBounds.width;
        gc.setLineWidth(2);
        gc.setLineStyle(1);
        int gap = -3;
        int xN = x0 + width + 1;
        int yPos = drawStripBounds.y + drawStripBounds.height / 2 - 1;
        Color tmpColor = ColorUtils.getColor(summary.getTrailRecord().getRGB());
        Color color = drawNumbersInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_BLACK;
        gc.setForeground(color);
        TrailRecordFormatter recordFormatter = new TrailRecordFormatter(summary.getTrailRecord());
        GraphicsUtils.drawTextCentered(recordFormatter.getSummaryValue(summary.getScaleMinMax()[0], summary.getDecimalFormat()), x0 - gap - scaleWidthSpace / 2, yPos, gc, 256);
        GraphicsUtils.drawTextCentered(recordFormatter.getSummaryValue(summary.getScaleMinMax()[1], summary.getDecimalFormat()), xN + gap + scaleWidthSpace / 2, yPos, gc, 256);
        boolean bl = isCurveGridEnabled = summary.getTrailRecord().getParent().getValueGridType() > 0;
        if (isCurveGridEnabled) {
            gc.setLineWidth(1);
            gc.setLineStyle(3);
            gc.setForeground(drawScaleInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_DARK_GREEN);
            for (int x : summarySpots.defineGrid(false)) {
                gc.drawLine(x, drawStripBounds.y, x, drawStripBounds.y + drawStripBounds.height);
            }
        }
    }

    public static void drawChannelItemWarnMarker(SummaryComposite.SummaryLayout summary, GC gc, int scaleWidthSpace, boolean drawNumbersInRecordColor) {
        SummarySpots summarySpots = summary.getSummarySpots();
        Rectangle drawStripBounds = summarySpots.getDrawStripBounds();
        int x0 = drawStripBounds.x;
        int width = drawStripBounds.width;
        int xN = x0 + width + 1;
        int yPos = drawStripBounds.y + drawStripBounds.height / 2 - 1;
        Color color = drawNumbersInRecordColor ? ColorUtils.getColor(summary.getTrailRecord().getRGB()) : DataExplorer.getInstance().COLOR_BLACK;
        gc.setForeground(color);
        GraphicsUtils.drawTextCentered("*", x0 - scaleWidthSpace * 9 / 10, yPos, gc, 256);
        GraphicsUtils.drawTextCentered("*", xN + scaleWidthSpace * 9 / 10, yPos, gc, 256);
    }

    public static void drawChannelItemText(SummaryComposite.SummaryLayout summary, GC gc, boolean drawNameInRecordColor) {
        String graphText;
        SummarySpots summarySpots = summary.getSummarySpots();
        Rectangle drawStripBounds = summarySpots.getDrawStripBounds();
        int x0 = drawStripBounds.x;
        int width = drawStripBounds.width;
        int yPos = drawStripBounds.y + drawStripBounds.height / 2 - 1;
        TrailRecord trailRecord = summary.getTrailRecord();
        String string = graphText = trailRecord.isScaleSyncMaster() ? trailRecord.getSyncMasterName() : DeviceXmlResource.getInstance().getReplacement(trailRecord.getName());
        if (trailRecord.getSymbol() != null && trailRecord.getSymbol().length() > 0) {
            graphText = graphText + "   " + trailRecord.getSymbol();
        }
        if (trailRecord.getUnit() != null && trailRecord.getUnit().length() > 0) {
            graphText = graphText + "   [" + trailRecord.getUnit() + "]";
        }
        Point pt = gc.textExtent(graphText);
        if ((double)pt.x / (double)width > 1.0) {
            graphText = graphText.substring(0, graphText.length() * width / pt.x);
            pt = gc.textExtent(graphText);
            pt.x -= 7;
        }
        Color color = drawNameInRecordColor ? ColorUtils.getColor(summary.getTrailRecord().getRGB()) : DataExplorer.getInstance().COLOR_BLACK;
        gc.setForeground(color);
        GraphicsUtils.drawTextCentered(graphText, x0 + pt.x / 2 + 7, yPos, gc, 257);
    }

    public static void drawHistoScale(GraphicsComposite.GraphicsLayout graphicsData, GC gc, Rectangle curveAreaBounds, int scaleWidthSpace, boolean drawScaleInRecordColor, boolean drawNameInRecordColor, boolean drawNumbersInRecordColor) {
        TrailRecord record = graphicsData.getTrailRecord();
        int x0 = curveAreaBounds.x;
        int y0 = curveAreaBounds.y + curveAreaBounds.height;
        int width = curveAreaBounds.width;
        int height = curveAreaBounds.height;
        log.finer(() -> record.getName() + "  x0=" + x0 + " y0=" + y0 + " width=" + width + " height=" + height + " horizontalSpace=" + scaleWidthSpace);
        if (record.isEmpty() && !record.isDisplayable() && !record.isScaleVisible()) {
            return;
        }
        Point pt = gc.textExtent("000,00");
        int ticklength = 5;
        int gap = 10;
        Color tmpColor = ColorUtils.getColor(record.getRGB());
        gc.setLineWidth(2);
        gc.setLineStyle(1);
        gc.setForeground(drawScaleInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_BLACK);
        if (record.isPositionLeft()) {
            int positionNumber = record.getParent().getAxisPosition(record.getName(), record.isPositionLeft());
            int xPos = x0 - 1 - positionNumber * scaleWidthSpace;
            gc.drawLine(xPos, y0 + 1, xPos, y0 - height - 1);
            log.fine(() -> "y-Achse = " + xPos + ", " + y0 + ", " + xPos + ", " + (y0 - height));
            HistoCurveUtils.drawVerticalTickMarks(record, gc, xPos, y0, height, graphicsData.getMinDisplayValue(), graphicsData.getMaxDisplayValue(), ticklength, gap, record.isPositionLeft(), drawNumbersInRecordColor);
            gc.setForeground(drawNameInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_BLACK);
            GraphicsUtils.drawTextCentered(record.getScaleText(), xPos - scaleWidthSpace + 3, y0 / 2 + (y0 - height), gc, 128);
        } else {
            int positionNumber = record.getParent().getAxisPosition(record.getName(), record.isPositionLeft());
            int xPos = x0 + 1 + width + positionNumber * scaleWidthSpace;
            gc.drawLine(xPos, y0 + 1, xPos, y0 - height - 1);
            log.fine(() -> "y-Achse = " + xPos + ", " + y0 + ", " + xPos + ", " + (y0 - height));
            HistoCurveUtils.drawVerticalTickMarks(record, gc, xPos, y0, height, graphicsData.getMinDisplayValue(), graphicsData.getMaxDisplayValue(), ticklength, gap, record.isPositionLeft(), drawNumbersInRecordColor);
            gc.setForeground(drawNameInRecordColor ? tmpColor : DataExplorer.getInstance().COLOR_BLACK);
            GraphicsUtils.drawTextCentered(record.getScaleText(), xPos + scaleWidthSpace - pt.y - 5, y0 / 2 + (y0 - height), gc, 128);
        }
    }

    private static void drawVerticalTickMarks(TrailRecord record, GC gc, int x0, int y0, int height, double minValue, double maxValue, int ticklength, int gap, boolean isPositionLeft, boolean drawNumbersInRecordColor) {
        double deltaScaleValue;
        int miniticks;
        int numberTicks;
        double maxScaleValue;
        double minScaleValue;
        gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        int yTop = y0 - height + 1;
        double deltaScale = maxValue - minValue;
        int maxNumberTicks = height / 25 >= 2 ? height / 25 : 1;
        Object[] roundResult = MathUtils.adaptRounding(minValue, maxValue, true, maxNumberTicks);
        if (record.isStartEndDefined()) {
            minScaleValue = minValue;
            maxScaleValue = maxValue;
            numberTicks = (Integer)roundResult[2];
            miniticks = (Integer)roundResult[3];
            deltaScaleValue = maxScaleValue - minScaleValue;
        } else {
            minScaleValue = (Double)roundResult[0];
            maxScaleValue = (Double)roundResult[1];
            numberTicks = (Integer)roundResult[2];
            miniticks = (Integer)roundResult[3];
            deltaScaleValue = maxScaleValue - minScaleValue;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("deltaScaleValue = %10.6f - deltaScale = %10.6f", deltaScaleValue, deltaScale));
        }
        Vector<Integer> horizontalGrid = new Vector<Integer>();
        TrailRecordSet recordSet = record.getParent();
        boolean isBuildGridVector = recordSet.getValueGridType() != 0 && recordSet.isValueGridRecord(record);
        int dist = 10;
        if (!isPositionLeft) {
            ticklength *= -1;
            gap *= -1;
            dist *= -1;
        }
        Color tmpColor = ColorUtils.getColor(record.getRGB());
        gc.setLineWidth(1);
        if (numberTicks > 1) {
            int yPosMini;
            int yPosMini2;
            double deltaMainTickValue = deltaScaleValue / (double)numberTicks;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("minScaleValue = %10.6f; maxScaleValue = %10.6f; deltaMainTickValue = %10.6f", minScaleValue, maxScaleValue, deltaMainTickValue));
            }
            double deltaMainTickPixel = deltaScaleValue / deltaScale * (double)height / (double)numberTicks;
            double deltaPosMini = deltaMainTickPixel / (double)miniticks;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("numberTicks = %d; deltaMainTickPixel = %10.6f; deltaPosMini = %10.6f", numberTicks, deltaMainTickPixel, deltaPosMini));
            }
            double yTickPositionMin = (double)y0 - Math.abs(minScaleValue - minValue) * ((double)height / deltaScale);
            for (int j = 1; j < miniticks && (yPosMini2 = (int)(yTickPositionMin + (double)j * deltaPosMini)) < y0; ++j) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "yTickPosition=" + yTickPositionMin + ", xPosMini=" + yPosMini2);
                }
                gc.drawLine(x0, yPosMini2, x0 - ticklength / 2, yPosMini2);
            }
            for (int i = 0; i <= numberTicks; ++i) {
                int yTickPosition = (int)(yTickPositionMin - (double)i * deltaMainTickPixel);
                gc.drawLine(x0, yTickPosition, x0 - ticklength, yTickPosition);
                if (isBuildGridVector) {
                    horizontalGrid.add(yTickPosition);
                }
                for (int j = 1; j < miniticks && i < numberTicks; ++j) {
                    int yPosMini3 = yTickPosition - (int)((double)j * deltaPosMini);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "yTickPosition=" + yTickPosition + ", xPosMini=" + yPosMini3);
                    }
                    gc.drawLine(x0, yPosMini3, x0 - ticklength / 2, yPosMini3);
                }
                if (drawNumbersInRecordColor) {
                    gc.setForeground(tmpColor);
                } else {
                    gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
                }
                GraphicsUtils.drawTextCentered(record.getFormattedScaleValue(minScaleValue + (double)i * deltaMainTickValue), x0 - ticklength - gap - dist, yTickPosition, gc, 256);
                gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
            }
            double yTickPositionMax = yTickPositionMin - (double)numberTicks * deltaMainTickPixel;
            for (double j = 1.0; j < (double)miniticks && (yPosMini = (int)(yTickPositionMax - j * deltaPosMini)) >= yTop - 1; j += 1.0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "yTickPosition=" + yTickPositionMax + ", xPosMini=" + yPosMini);
                }
                gc.drawLine(x0, yPosMini, x0 - ticklength / 2, yPosMini);
            }
        } else {
            int yTickPosition = (int)((double)y0 - (double)height / 2.0);
            gc.drawLine(x0, yTickPosition, x0 - ticklength, yTickPosition);
            if (drawNumbersInRecordColor) {
                gc.setForeground(tmpColor);
            } else {
                gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
            }
            GraphicsUtils.drawTextCentered(record.getFormattedScaleValue((minScaleValue + minScaleValue) / 2.0), x0 - ticklength - gap - dist, yTickPosition, gc, 256);
            if (isBuildGridVector) {
                horizontalGrid.add(yTickPosition);
            }
        }
        if (isBuildGridVector) {
            recordSet.setValueGrid(horizontalGrid);
        }
    }

    public static void drawHistoCurve(GraphicsComposite.GraphicsLayout graphicsData, GC gc, Rectangle curveAreaBounds, HistoTimeLine timeLine) {
        TrailRecord trailRecord = graphicsData.getTrailRecord();
        gc.setForeground(ColorUtils.getColor(trailRecord.getRGB()));
        gc.setLineWidth(trailRecord.getLineWidth());
        gc.setLineStyle(trailRecord.getLineStyle());
        graphicsData.setDisplayScaleFactorValue(curveAreaBounds.height);
        StringBuffer sb = new StringBuffer();
        Point[] points = HistoGraphicsMapper.getDisplayPoints(graphicsData, timeLine);
        Point oldPoint = null;
        int displayableSize = trailRecord.size();
        log.fine(() -> "displayableSize = " + displayableSize);
        for (int j = 0; j < points.length && j <= displayableSize && displayableSize >= 1; ++j) {
            Point newPoint = points[j];
            if (newPoint == null) continue;
            HistoCurveUtils.drawHistoMarker(gc, newPoint, timeLine.getDensity());
            if (oldPoint != null) {
                if (log.isLoggable(java.util.logging.Level.FINEST)) {
                    sb.append(GDE.LINE_SEPARATOR).append(newPoint.toString());
                }
                gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
            }
            oldPoint = newPoint;
        }
        log.finest(() -> sb.toString());
    }

    public static void drawHistoSuite(GraphicsComposite.GraphicsLayout graphicsData, GC gc, Rectangle curveAreaBounds, HistoTimeLine timeLine) {
        TrailRecord record = graphicsData.getTrailRecord();
        log.fine(() -> String.format("MinScaleValue=%f   MaxScaleValue=%f   MinDisplayValue=%f   MaxDisplayValue=%f", record.getMinScaleValue(), record.getMaxScaleValue(), graphicsData.getMinDisplayValue(), graphicsData.getMaxDisplayValue()));
        gc.setForeground(ColorUtils.getColor(record.getRGB()));
        gc.setLineWidth(record.getLineWidth());
        gc.setLineStyle(record.getLineStyle());
        graphicsData.setDisplayScaleFactorValue(curveAreaBounds.height);
        if (record.getTrailSelector().isBoxPlotSuite()) {
            HistoCurveUtils.drawBoxPlot(graphicsData, gc, timeLine);
        } else if (record.getTrailSelector().isRangePlotSuite()) {
            HistoCurveUtils.drawRangePlot(graphicsData, gc, timeLine);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void drawRangePlot(GraphicsComposite.GraphicsLayout graphicsData, GC gc, HistoTimeLine timeLine) {
        StringBuffer sb = new StringBuffer();
        List<HistoGraphicsMapper.PointArray> suitePoints = HistoGraphicsMapper.getSuiteDisplayPoints(graphicsData, timeLine);
        HistoGraphicsMapper.PointArray oldPoints = null;
        for (HistoGraphicsMapper.PointArray pointArray : suitePoints) {
            if (pointArray == null) continue;
            int posX = pointArray.getX();
            HistoCurveUtils.drawHistoMarker(gc, new Point(posX, pointArray.getY(0).intValue()), timeLine.getDensity());
            if (oldPoints != null) {
                int oldPosX = oldPoints.getX();
                if (log.isLoggable(java.util.logging.Level.FINEST)) {
                    sb.append(GDE.LINE_SEPARATOR).append(Arrays.toString((Object[])pointArray.getY()));
                }
                gc.drawLine(oldPosX, oldPoints.getY(0).intValue(), posX, pointArray.getY(0).intValue());
                gc.setLineStyle(2);
                HistoCurveUtils.drawNullableLine(gc, new Point(oldPosX, oldPoints.getY(1).intValue()), new Point(posX, pointArray.getY(1).intValue()));
                HistoCurveUtils.drawNullableLine(gc, new Point(oldPosX, oldPoints.getY(2).intValue()), new Point(posX, pointArray.getY(2).intValue()));
            }
            gc.setLineStyle(6);
            gc.setLineDash(new int[]{2, 9});
            HistoCurveUtils.drawNullableLine(gc, new Point(posX, pointArray.getY(1).intValue()), new Point(posX, pointArray.getY(2).intValue()));
            gc.setLineStyle(1);
            oldPoints = pointArray;
        }
        log.finest(() -> sb.toString());
    }

    public static void drawBoxPlot(GraphicsComposite.GraphicsLayout graphicsData, GC gc, HistoTimeLine timeLine) {
        StringBuffer sb = new StringBuffer();
        List<HistoGraphicsMapper.PointArray> suitePoints = HistoGraphicsMapper.getSuiteDisplayPoints(graphicsData, timeLine);
        TrailRecord record = graphicsData.getTrailRecord();
        List<Integer> durations_mm = record.getParent().getDurations_mm();
        double averageDuration = durations_mm.parallelStream().mapToDouble(d -> d.intValue()).average().getAsDouble();
        Iterator<Integer> durationIterator = durations_mm.iterator();
        int boxWidth = timeLine.getDensity().getScaledBoxWidth();
        double boxSizeFactor = (double)(timeLine.getDensity().boxWidthAmplitude * settings.getBoxplotSizeAdaptationOrdinal()) / 3.0;
        for (HistoGraphicsMapper.PointArray pointArray : suitePoints) {
            if (pointArray == null) continue;
            if (log.isLoggable(java.util.logging.Level.FINEST)) {
                sb.append(GDE.LINE_SEPARATOR).append(Arrays.toString((Object[])pointArray.getY()));
            }
            int posX = pointArray.getX();
            int q0PosY = pointArray.getY(0);
            int q1PosY = pointArray.getY(1);
            int q2PosY = pointArray.getY(2);
            int q3PosY = pointArray.getY(3);
            int q4PosY = pointArray.getY(4);
            int qLowerWhiskerY = pointArray.getY(5);
            int qUpperWhiskerY = pointArray.getY(6);
            int interQuartileRange = q1PosY - q3PosY;
            int halfBoxWidth = (int)((double)boxWidth * (1.0 + (Math.sqrt((double)durationIterator.next().intValue() / averageDuration) - 1.0) * boxSizeFactor) / 2.0);
            halfBoxWidth = halfBoxWidth < 1 ? 1 : halfBoxWidth;
            gc.drawRectangle(posX - halfBoxWidth, q3PosY, halfBoxWidth * 2, interQuartileRange);
            gc.drawLine(posX - halfBoxWidth, q2PosY, posX + halfBoxWidth, q2PosY);
            if (q0PosY > qLowerWhiskerY) {
                HistoCurveUtils.drawHistoMarker(gc, new Point(posX, pointArray.getY(0).intValue()), timeLine.getDensity());
            }
            gc.drawLine(posX, qLowerWhiskerY, posX, q1PosY);
            gc.drawLine(posX - halfBoxWidth / 2, qLowerWhiskerY, posX + halfBoxWidth / 2, qLowerWhiskerY);
            if (q4PosY < qUpperWhiskerY) {
                HistoCurveUtils.drawHistoMarker(gc, new Point(posX, pointArray.getY(4).intValue()), timeLine.getDensity());
            }
            gc.drawLine(posX, qUpperWhiskerY, posX, q3PosY);
            gc.drawLine(posX - halfBoxWidth / 2, qUpperWhiskerY, posX + halfBoxWidth / 2, qUpperWhiskerY);
        }
        log.finest(() -> sb.toString());
    }

    private static void drawNullableLine(GC gc, Point posA, Point posB) {
        if (posA != null && posB != null) {
            gc.drawLine(posA.x, posA.y, posB.x, posB.y);
        }
    }

    private static void drawHistoMarker(GC gc, Point newPoint, HistoTimeLine.Density density) {
        if (density == HistoTimeLine.Density.LOW) {
            gc.drawOval(newPoint.x - 3, newPoint.y - 3, 6, 6);
        } else if (density == HistoTimeLine.Density.MEDIUM) {
            gc.drawOval(newPoint.x - 2, newPoint.y - 2, 4, 4);
        } else if (density == HistoTimeLine.Density.HIGH) {
            gc.drawOval(newPoint.x - 1, newPoint.y - 1, 2, 2);
        } else if (density == HistoTimeLine.Density.EXTREME) {
            gc.drawOval(newPoint.x - 1, newPoint.y - 1, 2, 2);
        }
    }
}

