/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.config.Settings;
import gde.data.AbstractRecord;
import gde.data.AbstractRecordSet;
import gde.data.IRecord;
import gde.data.RecordSet;
import gde.data.TimeSteps;
import gde.device.DataTypes;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.ObjectFactory;
import gde.device.PropertyType;
import gde.device.StatisticsType;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.ColorUtils;
import gde.utils.StringHelper;
import gde.utils.TimeLine;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Record
extends AbstractRecord
implements IRecord {
    static final String $CLASS_NAME = Record.class.getName();
    static final long serialVersionUID = 26031957L;
    static final Logger log = Logger.getLogger(Record.class.getName());
    public static final String DELIMITER = "|-|";
    public static final String END_MARKER = "|:-:|";
    String channelConfigKey;
    String keyName;
    TimeSteps timeStep_ms = null;
    protected IDevice device;
    protected int ordinal;
    protected RecordSet parent;
    protected String name;
    String unit;
    String symbol;
    String description = " ";
    protected Boolean isActive;
    boolean isDisplayable;
    boolean isVisible = true;
    StatisticsType statistics = null;
    Boolean triggerIsGreater = null;
    Integer triggerLevel = null;
    Integer minTriggerTimeSec = null;
    boolean isMerged = false;
    TriggerRange tmpTriggerRange = null;
    Vector<TriggerRange> triggerRanges = null;
    List<PropertyType> properties = new ArrayList<PropertyType>();
    boolean isPositionLeft = true;
    String rgb = "0,0,0";
    int lineWidth = 1;
    int lineStyle = 1;
    protected boolean isRoundOut = false;
    protected boolean isStartpointZero = false;
    protected boolean isStartEndDefined = false;
    protected DecimalFormat df;
    protected int numberFormat = -1;
    protected int maxValue = 0;
    protected int minValue = 0;
    protected int maxValueTimeStampIndex = 0;
    protected int minValueTimeStampIndex = 0;
    protected double maxScaleValue = this.maxValue;
    protected double minScaleValue = this.minValue;
    DataType dataType = DataType.DEFAULT;
    protected int syncMaxValue = 0;
    protected int syncMinValue = 0;
    int scopeMin = 0;
    int scopeMax = 0;
    int maxValueTriggered = Integer.MIN_VALUE;
    int minValueTriggered = Integer.MAX_VALUE;
    int avgValue = Integer.MIN_VALUE;
    int sigmaValue = Integer.MIN_VALUE;
    int avgValueTriggered = Integer.MIN_VALUE;
    int sigmaValueTriggered = Integer.MIN_VALUE;
    double drawLimit_ms = 2.147483647E9;
    double zoomTimeOffset = 0.0;
    int zoomOffset = 0;
    double drawTimeWidth = 0.0;
    double tmpMaxZoomScaleValue = this.maxScaleValue;
    double tmpMinZoomScaleValue = this.minScaleValue;
    double maxZoomScaleValue = this.maxScaleValue;
    double minZoomScaleValue = this.minScaleValue;
    int numberScaleTicks = 0;
    double displayScaleFactorTime;
    protected double displayScaleFactorValue;
    protected double syncMasterFactor = 1.0;
    protected double minDisplayValue;
    protected double maxDisplayValue;
    boolean isVoltageRecord = false;
    int voltageValuesSize = 9;
    int[] voltageValues = new int[this.voltageValuesSize];
    int voltageValuesAvg = 0;
    boolean isCurrentRecord = false;
    int dropStartIndex = 0;
    int dropEndIndex = 0;
    boolean dropIndexWritten = true;
    boolean isMeasurementMode = false;
    boolean isDeltaMeasurementMode = false;
    public static final String NAME = "_name";
    public static final String UNIT = "_unit";
    public static final String SYMBOL = "_symbol";
    public static final String IS_ACTIVE = "_isActive";
    public static final String IS_DIPLAYABLE = "_isDisplayable";
    public static final String IS_VISIBLE = "_isVisible";
    public static final String IS_POSITION_LEFT = "_isPositionLeft";
    public static final String COLOR = "_color";
    public static final String LINE_WITH = "_lineWidth";
    public static final String LINE_STYLE = "_lineStyle";
    public static final String IS_ROUND_OUT = "_isRoundOut";
    public static final String IS_START_POINT_ZERO = "_isStartpointZero";
    public static final String IS_START_END_DEFINED = "_isStartEndDefined";
    public static final String NUMBER_FORMAT = "_numberFormat";
    public static final String MAX_VALUE = "_maxValue";
    public static final String DEFINED_MAX_VALUE = "_defMaxValue";
    public static final String MIN_VALUE = "_minValue";
    public static final String DEFINED_MIN_VALUE = "_defMinValue";
    public static final String DATA_TYPE = "_dataType";
    public static final String TRAIL_TEXT_ORDINAL = "_trailTextOrdinal";
    public static final String[] propertyKeys = new String[]{"_name", "_unit", "_symbol", "_isActive", "_isDisplayable", "_isVisible", "_isPositionLeft", "_color", "_lineWidth", "_lineStyle", "_isRoundOut", "_isStartpointZero", "_isStartEndDefined", "_numberFormat", "_maxValue", "_defMaxValue", "_minValue", "_defMinValue", "_dataType", "_trailTextOrdinal"};
    public static final int TYPE_AXIS_END_VALUES = 0;
    public static final int TYPE_AXIS_NUMBER_FORMAT = 1;
    public static final int TYPE_AXIS_SCALE_POSITION = 2;

    public Record(IDevice newDevice, int newOrdinal, String newName, String newSymbol, String newUnit, boolean isActiveValue, StatisticsType newStatistic, List<PropertyType> newProperties, int initialCapacity) {
        super(initialCapacity);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, newName + " Record(IDevice, int, String, String, String, boolean, StatisticsType, List<PropertyType>, int)");
        }
        this.device = newDevice;
        this.ordinal = newOrdinal;
        this.name = newName;
        this.symbol = newSymbol;
        this.unit = newUnit;
        this.isActive = isActiveValue;
        this.isDisplayable = isActiveValue;
        this.statistics = newStatistic;
        this.triggerIsGreater = newStatistic != null && newStatistic.getTrigger() != null ? Boolean.valueOf(newStatistic.getTrigger().isGreater()) : null;
        this.triggerLevel = newStatistic != null && newStatistic.getTrigger() != null ? newStatistic.getTrigger().getLevel() : null;
        this.minTriggerTimeSec = newStatistic != null && newStatistic.getTrigger() != null ? newStatistic.getTrigger().getMinTimeSec() : null;
        this.initializeProperties(this, newProperties);
        this.df = new DecimalFormat("0.0");
        this.isCurrentRecord = this.unit.equalsIgnoreCase("A") && this.symbol.toUpperCase().contains("I");
        this.isVoltageRecord = this.unit.equalsIgnoreCase("V") && this.symbol.equalsIgnoreCase("u");
    }

    private Record(Record record) {
        super(record);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, record.name + " Record(Record)");
        }
        this.parent = record.parent;
        this.ordinal = record.ordinal;
        this.name = record.name;
        this.symbol = record.symbol;
        this.unit = record.unit;
        this.timeStep_ms = record.timeStep_ms == null ? record.parent.timeStep_ms.clone() : record.timeStep_ms.clone();
        this.drawTimeWidth = record.drawTimeWidth;
        this.isActive = record.isActive;
        this.isDisplayable = record.isDisplayable;
        this.dataType = record.dataType;
        this.statistics = record.statistics;
        this.triggerIsGreater = record.triggerIsGreater;
        this.triggerLevel = record.triggerLevel;
        this.minTriggerTimeSec = record.minTriggerTimeSec;
        this.triggerRanges = null;
        this.initializeProperties(record, record.properties);
        this.maxValue = record.maxValue;
        this.minValue = record.minValue;
        this.maxValueTimeStampIndex = record.maxValueTimeStampIndex;
        this.minValueTimeStampIndex = record.minValueTimeStampIndex;
        this.df = (DecimalFormat)record.df.clone();
        this.numberFormat = record.numberFormat;
        this.isVisible = record.isVisible;
        this.isPositionLeft = record.isPositionLeft;
        this.rgb = record.rgb;
        this.lineWidth = record.lineWidth;
        this.lineStyle = record.lineStyle;
        this.isRoundOut = record.isRoundOut;
        this.isStartpointZero = record.isStartpointZero;
        this.isStartEndDefined = record.isStartEndDefined;
        this.maxScaleValue = record.maxScaleValue;
        this.minScaleValue = record.minScaleValue;
        this.isCurrentRecord = record.isCurrentRecord;
        this.isVoltageRecord = record.isVoltageRecord;
        this.channelConfigKey = record.channelConfigKey;
        this.keyName = record.keyName;
        this.device = record.device;
    }

    @Override
    public synchronized Record clone() {
        super.clone();
        return new Record(this);
    }

    public Record clone(String newName) {
        Record newRecord = new Record(this);
        newRecord.name = newName;
        if (newRecord.parent.timeStep_ms != null) {
            newRecord.timeStep_ms = null;
        }
        return newRecord;
    }

    private Record(Record record, int dataIndex, boolean isFromBegin) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, record.name + " Record(Record, int, boolean)");
        }
        this.parent = record.parent;
        this.parent.setZoomMode(false);
        this.ordinal = record.ordinal;
        this.name = record.name;
        this.symbol = record.symbol;
        this.unit = record.unit;
        this.isActive = record.isActive;
        this.isDisplayable = record.isDisplayable;
        this.dataType = record.dataType;
        this.statistics = record.statistics;
        this.triggerIsGreater = record.triggerIsGreater;
        this.triggerLevel = record.triggerLevel;
        this.minTriggerTimeSec = record.minTriggerTimeSec;
        this.triggerRanges = null;
        this.initializeProperties(record, record.properties);
        this.maxValue = 0;
        this.minValue = 0;
        this.maxValueTimeStampIndex = 0;
        this.minValueTimeStampIndex = 0;
        this.isCurrentRecord = record.isCurrentRecord;
        this.isVoltageRecord = record.isVoltageRecord;
        this.device = record.device;
        this.clear();
        this.trimToSize();
        if (isFromBegin) {
            for (int i = dataIndex; i < record.realSize(); ++i) {
                this.add((int)record.realGet(i));
            }
        } else {
            for (int i = 0; i < dataIndex; ++i) {
                this.add((int)record.realGet(i));
            }
        }
        this.timeStep_ms = record.timeStep_ms != null && !record.timeStep_ms.isConstant ? record.timeStep_ms.clone(dataIndex, isFromBegin) : (record.timeStep_ms != null && record.timeStep_ms.isConstant ? record.timeStep_ms.clone() : null);
        this.drawTimeWidth = this.getMaxTime_ms();
        this.df = (DecimalFormat)record.df.clone();
        this.numberFormat = record.numberFormat;
        this.isVisible = record.isVisible;
        this.isPositionLeft = record.isPositionLeft;
        this.rgb = record.rgb;
        this.lineWidth = record.lineWidth;
        this.lineStyle = record.lineStyle;
        this.isRoundOut = record.isRoundOut;
        this.isStartpointZero = record.isStartpointZero;
        this.isStartEndDefined = record.isStartEndDefined;
        this.maxScaleValue = record.maxScaleValue;
        this.minScaleValue = record.minScaleValue;
        this.drawTimeWidth = record.getMaxTime_ms();
        this.channelConfigKey = record.channelConfigKey;
        this.keyName = record.keyName;
    }

    public Record clone(int dataIndex, boolean isFromBegin) {
        return new Record(this, dataIndex, isFromBegin);
    }

    private void initializeProperties(Record recordRef, List<PropertyType> newProperties) {
        this.properties = this.properties != null ? this.properties : new ArrayList<PropertyType>();
        for (PropertyType property : newProperties) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("%20s - %s = %s", recordRef.name, property.getName(), property.getValue()));
            }
            this.properties.add(property.clone());
        }
    }

    public void setColorDefaultsAndPosition(int recordOrdinal) {
        this.rgb = ColorUtils.getDefaultRgb(recordOrdinal);
        if (recordOrdinal % 2 == 0) {
            this.setPositionLeft(true);
        } else {
            this.setPositionLeft(false);
        }
    }

    public synchronized boolean add(Integer point, double useTimeStep_ms) {
        if (this.timeStep_ms != null) {
            this.timeStep_ms.add(useTimeStep_ms);
        }
        return this.add(point);
    }

    @Override
    public synchronized boolean add(Integer point) {
        String $METHOD_NAME = "add";
        if (super.size() == 0) {
            this.minValue = this.maxValue = point.intValue();
        } else if (point > this.maxValue) {
            this.maxValue = point;
            this.maxValueTimeStampIndex = super.size();
        } else if (point < this.minValue) {
            this.minValue = point;
            this.minValueTimeStampIndex = super.size();
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "add", this.name + " adding point = " + point);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.logp(Level.FINEST, $CLASS_NAME, "add", this.name + " minValue = " + this.minValue + " maxValue = " + this.maxValue);
        }
        switch (this.device.getCurrentSmoothIndex()) {
            case 1: {
                if (!this.isCurrentRecord || super.size() <= 5) break;
                int index = super.size();
                if (this.maxValue > 200 && point < this.maxValue >> 2) {
                    if (this.dropStartIndex == 0) {
                        this.dropStartIndex = index;
                        this.parent.currentDropShadow.add(new Integer[]{this.dropStartIndex - 2, index - 2});
                    }
                    this.dropEndIndex = index + (index - this.dropStartIndex + 1);
                    break;
                }
                if (index < this.dropEndIndex || this.dropStartIndex == 0) break;
                this.parent.currentDropShadow.add(new Integer[]{this.dropStartIndex - 2, this.dropEndIndex});
                this.dropStartIndex = 0;
                break;
            }
            case 2: {
                if (!this.isCurrentRecord || super.size() <= 5) break;
                int index = super.size();
                if (this.maxValue > 200 && point < this.maxValue >> 2) {
                    if (this.dropStartIndex == 0) {
                        this.dropStartIndex = index;
                    } else if (!this.dropIndexWritten) {
                        this.parent.currentDropShadow.add(new Integer[]{this.dropStartIndex - 2, index - 2});
                        this.dropStartIndex = index;
                        this.dropIndexWritten = true;
                    }
                    this.dropEndIndex = index + (index - this.dropStartIndex) * 4;
                    break;
                }
                if (index > this.dropEndIndex && this.dropStartIndex != 0) {
                    this.parent.currentDropShadow.add(new Integer[]{this.dropStartIndex - 2, this.dropEndIndex});
                    this.dropStartIndex = 0;
                    this.dropIndexWritten = true;
                    break;
                }
                if (this.dropStartIndex == 0) break;
                this.dropIndexWritten = false;
            }
        }
        return super.add(point);
    }

    @Override
    public synchronized Integer set(int index, Integer point) {
        String $METHOD_NAME = "set";
        if (super.size() == 0) {
            this.minValue = this.maxValue = point.intValue();
        } else if (point > this.maxValue) {
            this.maxValue = point;
        } else if (point < this.minValue) {
            this.minValue = point;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "set", this.name + " setting point = " + point);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.logp(Level.FINEST, $CLASS_NAME, "set", this.name + " minValue = " + this.minValue + " maxValue = " + this.maxValue);
        }
        return super.set(index, point);
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int newOrdinal) {
        this.ordinal = newOrdinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSyncMasterRGB() {
        Vector<Record> scaleSyncedRecords = this.parent.getScaleSyncedRecords(this.ordinal);
        for (Record tmpRecord : scaleSyncedRecords) {
            if (!tmpRecord.isVisible || !tmpRecord.isDisplayable || tmpRecord.realSize() <= 1) continue;
            return tmpRecord.rgb;
        }
        return this.rgb;
    }

    public String getSyncMasterName() {
        StringBuilder sb = new StringBuilder();
        Vector<Record> scaleSyncedRecords = this.parent.getScaleSyncedRecords(this.ordinal);
        int numberVisibleDisplayable = 0;
        for (Record tmpRecord : scaleSyncedRecords) {
            if (!tmpRecord.isVisible || !tmpRecord.isDisplayable || tmpRecord.realSize() <= 1) continue;
            if (sb.length() < 1) {
                sb.append(tmpRecord.name);
            }
            ++numberVisibleDisplayable;
        }
        if (numberVisibleDisplayable > 1) {
            sb.append(".").append(".");
            String trailer = "*";
            for (Record tmpRecord : scaleSyncedRecords) {
                if (!tmpRecord.isDisplayable || !tmpRecord.isVisible || tmpRecord.realSize() <= 1) continue;
                trailer = tmpRecord.name;
            }
            sb.append(trailer.split(" ").length > 1 ? trailer.split(" ")[1] : "*");
        }
        return sb.toString();
    }

    public void setName(String newName) {
        if (newName != null && newName.length() > 1 && !this.name.equals(newName)) {
            this.parent.replaceRecordName(this, newName);
            this.name = newName;
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String newUnit) {
        this.unit = newUnit;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String newSymbol) {
        this.symbol = newSymbol;
    }

    List<PropertyType> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyType> newProperties) {
        this.properties = new ArrayList<PropertyType>();
        for (PropertyType property : newProperties) {
            this.properties.add(property.clone());
        }
    }

    public PropertyType getProperty(String propertyKey) {
        PropertyType property = null;
        for (PropertyType propertyType : this.properties) {
            if (!propertyType.getName().equals(propertyKey)) continue;
            property = propertyType;
            break;
        }
        return property;
    }

    public PropertyType createProperty(String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        this.properties.add(newProperty);
        return newProperty;
    }

    @Override
    public double getFactor() {
        double value = 1.0;
        PropertyType property = this.getProperty(IDevice.FACTOR);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        } else {
            try {
                value = this.getDevice().getMeasurementFactor(this.getParent().parent.number, this.ordinal);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return value;
    }

    public void setFactor(double newValue) {
        PropertyType property = this.getProperty(IDevice.FACTOR);
        if (property != null) {
            property.setValue(String.format("%.4f", newValue));
        } else {
            this.createProperty(IDevice.FACTOR, DataTypes.DOUBLE, String.format(Locale.ENGLISH, "%.4f", newValue));
        }
    }

    @Override
    public double getOffset() {
        double value = 0.0;
        PropertyType property = this.getProperty(IDevice.OFFSET);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        } else {
            try {
                value = this.getDevice().getMeasurementOffset(this.getParent().parent.number, this.ordinal);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return value;
    }

    public void setOffset(double newValue) {
        PropertyType property = this.getProperty(IDevice.OFFSET);
        if (property != null) {
            property.setValue(String.format("%.4f", newValue));
        } else {
            this.createProperty(IDevice.OFFSET, DataTypes.DOUBLE, String.format(Locale.ENGLISH, "%.4f", newValue));
        }
    }

    @Override
    public double getReduction() {
        double value = 0.0;
        PropertyType property = this.getProperty(IDevice.REDUCTION);
        if (property != null) {
            value = Double.valueOf(property.getValue());
        } else {
            try {
                String strValue = (String)this.getDevice().getMeasurementPropertyValue(this.getParent().parent.number, this.ordinal, IDevice.REDUCTION);
                if (strValue != null && strValue.length() > 0) {
                    value = Double.valueOf(strValue.trim().replace(',', '.'));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return value;
    }

    public void setReduction(double newValue) {
        PropertyType property = this.getProperty(IDevice.REDUCTION);
        if (property != null) {
            property.setValue(String.format("%.4f", newValue));
        } else {
            this.createProperty(IDevice.REDUCTION, DataTypes.DOUBLE, String.format(Locale.ENGLISH, "%.4f", newValue));
        }
    }

    @Override
    public boolean isBits() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_BITS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public boolean isTokens() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_TOKENS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean enabled) {
        this.isVisible = enabled;
    }

    public int getMaxValue() {
        return this.parent.isScopeMode ? this.scopeMax : (this.maxValue == this.minValue ? this.maxValue + 100 : this.maxValue);
    }

    public int getMinValue() {
        return this.parent.isScopeMode ? this.scopeMin : (this.minValue == this.maxValue ? this.minValue - 100 : this.minValue);
    }

    public int getSyncMaxValue() {
        return this.parent.isScopeMode ? this.scopeMax : (this.syncMaxValue == this.syncMinValue ? this.syncMaxValue + 100 : this.syncMaxValue);
    }

    public int getSyncMinValue() {
        return this.parent.isScopeMode ? this.scopeMin : (this.syncMinValue == this.syncMaxValue ? this.syncMinValue - 100 : this.syncMinValue);
    }

    @Override
    public void setSyncMinMax(int newMin, int newMax) {
        this.syncMinValue = newMin;
        this.syncMaxValue = newMax;
        if (log.isLoggable(Level.FINER)) {
            log.finer(() -> this.getName() + " syncMinValue=" + newMin + " syncMaxValue=" + newMax);
        }
    }

    public int getRealMaxValue() {
        return this.maxValue;
    }

    public int getRealMinValue() {
        return this.minValue;
    }

    public long getRealMaxValueTime_ms() {
        return (long)this.parent.timeStep_ms.getTime_ms(this.maxValueTimeStampIndex);
    }

    public long getRealMinValueTime_ms() {
        return (long)this.parent.timeStep_ms.getTime_ms(this.minValueTimeStampIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxValueTriggered() {
        Record record = this;
        synchronized (record) {
            if (this.tmpTriggerRange == null) {
                this.getTriggerRanges();
            }
            if (this.maxValueTriggered == Integer.MIN_VALUE) {
                this.setMinMaxValueTriggered();
            }
            return this.maxValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinValueTriggered() {
        Record record = this;
        synchronized (record) {
            if (this.tmpTriggerRange == null) {
                this.getTriggerRanges();
            }
            if (this.minValueTriggered == Integer.MAX_VALUE) {
                this.setMinMaxValueTriggered();
            }
            return this.minValueTriggered;
        }
    }

    public Integer getMinTriggerTimeSec() {
        if (this.minTriggerTimeSec == null) {
            this.minTriggerTimeSec = this.parent.get(this.statistics.getTriggerRefOrdinal()).getMinTriggerTimeSec();
        }
        return this.minTriggerTimeSec;
    }

    public boolean getTriggerIsGreater() {
        return this.triggerIsGreater;
    }

    public boolean isTriggerRangesMerged() {
        return this.isMerged;
    }

    public void setTriggerRangesIsMerged() {
        this.isMerged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxValueTriggered(int referencedMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            if (this.tmpTriggerRange == null || this.triggerRanges == null) {
                this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            }
            if (this.maxValueTriggered == Integer.MIN_VALUE) {
                this.setMinMaxValueTriggered();
            }
            return this.maxValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxValueTriggered(int referencedMeasurementOrdinal, int referencedSecondaryMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            Vector<TriggerRange> primaryTriggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            Vector<TriggerRange> secondaryTriggerRanges = this.parent.get(referencedSecondaryMeasurementOrdinal).getTriggerRanges();
            if (primaryTriggerRanges != null && secondaryTriggerRanges != null && !this.parent.get(referencedMeasurementOrdinal).isTriggerRangesMerged()) {
                this.mergeTriggerRanges(referencedMeasurementOrdinal, referencedSecondaryMeasurementOrdinal);
            } else {
                this.triggerRanges = primaryTriggerRanges;
            }
            if (this.maxValueTriggered == Integer.MIN_VALUE) {
                this.setMinMaxValueTriggered();
            }
            return this.maxValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinValueTriggered(int referencedMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            if (this.tmpTriggerRange == null || this.triggerRanges == null) {
                this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            }
            if (this.minValueTriggered == Integer.MAX_VALUE) {
                this.setMinMaxValueTriggered();
            }
            return this.minValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinValueTriggered(int referencedMeasurementOrdinal, int referencedSecondaryMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            Vector<TriggerRange> primaryTriggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            Vector<TriggerRange> secondaryTriggerRanges = this.parent.get(referencedSecondaryMeasurementOrdinal).getTriggerRanges();
            if (primaryTriggerRanges != null && secondaryTriggerRanges != null && !this.parent.get(referencedMeasurementOrdinal).isTriggerRangesMerged()) {
                this.mergeTriggerRanges(referencedMeasurementOrdinal, referencedSecondaryMeasurementOrdinal);
            } else {
                this.triggerRanges = primaryTriggerRanges;
            }
            if (this.minValueTriggered == Integer.MAX_VALUE) {
                this.setMinMaxValueTriggered();
            }
            return this.minValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMinMaxValueTriggered() {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.getTriggerRanges();
            }
            if (this.triggerRanges != null && this.triggerRanges.size() > 0) {
                this.maxValueTriggered = Integer.MIN_VALUE;
                this.minValueTriggered = Integer.MAX_VALUE;
                for (TriggerRange range : this.triggerRanges) {
                    for (int i = range.in; i < range.out; ++i) {
                        int point = this.realGet(i);
                        if (point > this.maxValueTriggered) {
                            this.maxValueTriggered = point;
                        }
                        if (point >= this.minValueTriggered) continue;
                        this.minValueTriggered = point;
                    }
                }
            }
        }
    }

    @Override
    public synchronized int size() {
        int tmpSize = this.elementCount;
        if (this.parent.isZoomMode) {
            tmpSize = this.findBestIndex(this.zoomTimeOffset + this.drawTimeWidth) - this.zoomOffset;
        } else if (this.parent.isScopeMode) {
            tmpSize = this.parent.scopeModeSize;
        }
        return tmpSize;
    }

    public int realSize() {
        return super.size();
    }

    @Override
    public Integer getFirst() {
        return super.size() > 0 ? (Integer)super.get(0) : 0;
    }

    @Override
    public Integer getLast() {
        return super.size() > 0 ? (Integer)super.get(super.size() - 1) : 0;
    }

    @Override
    public synchronized Integer get(int index) {
        index = this.getIndex(index);
        int returnValue = (Integer)super.get(index);
        if (this.elementCount != 0) {
            if (!this.parent.isCompareSet) {
                if (this.parent.isSmoothAtCurrentDrop) {
                    for (Integer[] dropArea : this.parent.currentDropShadow) {
                        if (dropArea[0] > index || dropArea[1] < index) continue;
                        int dropStartValue = (Integer)super.get(dropArea[0]);
                        int dropEndValue = (Integer)super.get(dropArea[1]);
                        double dropDeltaValue = (double)(dropEndValue - dropStartValue) / (double)(dropArea[1] - dropArea[0]);
                        returnValue = (int)((double)dropStartValue + dropDeltaValue * (double)(index - dropArea[0]));
                    }
                }
                if (this.isVoltageRecord && this.parent.isSmoothVoltageCurve && index >= this.voltageValuesSize && super.size() > this.voltageValuesSize) {
                    this.voltageValuesAvg = 0;
                    int i = index - this.voltageValuesSize + 1;
                    int j = 0;
                    while (i <= index) {
                        this.voltageValues[j] = (Integer)super.get(i);
                        this.voltageValuesAvg += ((Integer)super.get(i)).intValue();
                        ++i;
                        ++j;
                    }
                    this.voltageValuesAvg /= this.voltageValuesSize;
                    for (i = this.voltageValuesSize - 1; i >= 0 && this.voltageValues[i] > this.voltageValuesAvg; --i) {
                    }
                    returnValue = this.voltageValues[i];
                }
            }
            return returnValue;
        }
        return 0;
    }

    public int getIndex(int index) {
        if (this.parent.isZoomMode) {
            index = (index += this.zoomOffset) > this.elementCount - 1 ? this.elementCount - 1 : index;
            index = index < 0 ? 0 : index;
        } else if (this.parent.isScopeMode) {
            index = (index += this.parent.scopeModeOffset) > this.elementCount - 1 ? this.elementCount - 1 : index;
            index = index < 0 ? 0 : index;
        } else {
            index = index > this.elementCount - 1 ? this.elementCount - 1 : index;
            index = index < 0 ? 0 : index;
        }
        return index;
    }

    public Integer realGet(int index) {
        try {
            return super.size() != 0 ? (Integer)super.get(index) : 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.log(Level.WARNING, String.format("%s - %20s: size = %d - indesx = %d", this.parent.name, this.name, super.size(), index));
            return super.size() != 0 ? (Integer)super.get(index - 1) : 0;
        }
    }

    public Vector<Double> getTranslatedValues() {
        Vector<Double> translatedValues = new Vector<Double>();
        for (Integer value : this) {
            if (value != null) {
                translatedValues.add(this.device.translateValue(this, (double)value.intValue() / 1000.0));
                continue;
            }
            translatedValues.add(null);
        }
        return translatedValues;
    }

    @Override
    public Collection<Integer> getValues() {
        return this;
    }

    @Override
    public boolean isPositionLeft() {
        return this.isPositionLeft;
    }

    @Override
    public void setPositionLeft(boolean enabled) {
        this.isPositionLeft = enabled;
    }

    @Override
    public String getRGB() {
        return this.rgb;
    }

    @Override
    public void setRGB(String rgb) {
        this.rgb = rgb;
    }

    public void setColor(Color newColor) {
        this.rgb = String.format("%d,%d,%d", newColor.getRed(), newColor.getGreen(), newColor.getBlue());
    }

    @Override
    public boolean isRoundOut() {
        return this.parent.isZoomMode ? false : this.isRoundOut;
    }

    @Override
    public void setRoundOut(boolean enabled) {
        this.isRoundOut = enabled;
    }

    @Override
    public boolean isStartpointZero() {
        return this.parent.isZoomMode ? false : this.isStartpointZero;
    }

    @Override
    public void setStartpointZero(boolean enabled) {
        this.isStartpointZero = enabled;
    }

    @Override
    public boolean isStartEndDefined() {
        return this.parent.isZoomMode ? true : this.isStartEndDefined;
    }

    @Override
    public void setStartEndDefined(boolean enabled) {
        this.isStartEndDefined = enabled;
    }

    @Override
    public void setStartEndDefined(boolean enabled, double newMinScaleValue, double newMaxScaleValue) {
        this.isStartEndDefined = enabled;
        if (enabled) {
            this.maxScaleValue = this.maxDisplayValue = newMaxScaleValue;
            this.minScaleValue = this.minDisplayValue = newMinScaleValue;
        } else {
            if (this.channelConfigKey == null || this.channelConfigKey.length() < 1) {
                this.channelConfigKey = this.parent.getChannelConfigName();
            }
            this.maxScaleValue = this.parent.getDevice().translateValue(this, (double)this.maxValue / 1000.0);
            this.minScaleValue = this.parent.getDevice().translateValue(this, (double)this.minValue / 1000.0);
        }
    }

    @Override
    public void setMinScaleValue(double newMinScaleValue) {
        if (this.parent.isZoomMode) {
            this.minZoomScaleValue = newMinScaleValue;
        } else {
            this.minScaleValue = newMinScaleValue;
        }
    }

    @Override
    public void setMaxScaleValue(double newMaxScaleValue) {
        if (this.parent.isZoomMode) {
            this.maxZoomScaleValue = newMaxScaleValue;
        } else {
            this.maxScaleValue = newMaxScaleValue;
        }
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int newLineWidth) {
        this.lineWidth = newLineWidth;
    }

    @Override
    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(int newLineStyle) {
        this.lineStyle = newLineStyle;
    }

    @Override
    public int getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setNumberFormatDirect(int newNumberFormat) {
        this.numberFormat = newNumberFormat;
    }

    @Override
    public void setNumberFormat(int newNumberFormat) {
        this.numberFormat = newNumberFormat;
        switch (newNumberFormat) {
            case -1: {
                double delta = this.maxScaleValue - this.minScaleValue == 0.0 ? this.device.translateValue(this, (double)(this.maxValue - this.minValue) / 1000.0) : this.maxScaleValue - this.minScaleValue;
                double maxValueAbs = this.device.translateValue(this, Math.abs((double)this.maxValue / 1000.0));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format(Locale.getDefault(), "%s: %.0f - %.1f", this.name, maxValueAbs, delta));
                }
                if (maxValueAbs < 100.0) {
                    if (delta < 0.1) {
                        this.df.applyPattern("0.000");
                        break;
                    }
                    if (delta <= 1.0) {
                        this.df.applyPattern("0.00");
                        break;
                    }
                    if (delta < 100.0) {
                        this.df.applyPattern("0.0");
                        break;
                    }
                    this.df.applyPattern("0");
                    break;
                }
                if (maxValueAbs < 500.0) {
                    if (delta <= 0.1) {
                        this.df.applyPattern("0.00");
                        break;
                    }
                    if (delta <= 1.0) {
                        this.df.applyPattern("0.0");
                        break;
                    }
                    this.df.applyPattern("0");
                    break;
                }
                if (delta <= 5.0) {
                    this.df.applyPattern("0.0");
                    break;
                }
                this.df.applyPattern("0");
                break;
            }
            case 0: {
                this.df.applyPattern("0");
                break;
            }
            case 1: {
                this.df.applyPattern("0.0");
                break;
            }
            default: {
                this.df.applyPattern("0.00");
                break;
            }
            case 3: {
                this.df.applyPattern("0.000");
            }
        }
        if (DataExplorer.getInstance().isWithCompareSet()) {
            this.parent.syncMasterSlaveRecords(this, 1);
        }
    }

    @Override
    public AbstractRecordSet getAbstractParent() {
        return this.parent;
    }

    public RecordSet getParent() {
        return this.parent;
    }

    public void setParent(RecordSet currentParent) {
        if (this.channelConfigKey == null || this.channelConfigKey.length() < 1) {
            this.channelConfigKey = currentParent.getChannelConfigName();
        }
        this.parent = currentParent;
    }

    @Override
    public boolean isDisplayable() {
        return this.isDisplayable;
    }

    public void setDisplayable(boolean enabled) {
        this.isDisplayable = enabled;
    }

    public boolean isActive() {
        return this.isActive == null || super.size() == 0 ? false : this.isActive;
    }

    public void setActive(Boolean newValue) {
        this.isActive = newValue;
    }

    public boolean isCalculation() {
        return this.isActive == null;
    }

    @Override
    public double getMaxScaleValue() {
        return this.parent.isZoomMode ? this.maxZoomScaleValue : this.maxScaleValue;
    }

    @Override
    public double getMinScaleValue() {
        return this.parent.isZoomMode ? this.minZoomScaleValue : this.minScaleValue;
    }

    public long getStartTimeStamp() {
        return this.timeStep_ms == null ? this.parent.timeStep_ms.getStartTimeStamp() : this.timeStep_ms.getStartTimeStamp();
    }

    public double getTime_ms(int index) {
        if (this.parent.isZoomMode) {
            return (this.timeStep_ms == null ? this.parent.timeStep_ms.getTime_ms(index + this.zoomOffset) : this.timeStep_ms.getTime_ms(index + this.zoomOffset)) - this.zoomTimeOffset;
        }
        if (this.parent.isScopeMode) {
            return this.timeStep_ms == null ? this.parent.timeStep_ms.getTime_ms(index + this.parent.scopeModeOffset) - this.parent.timeStep_ms.getTime_ms(this.parent.scopeModeOffset) : this.timeStep_ms.getTime_ms(index + this.parent.scopeModeOffset) - this.timeStep_ms.getTime_ms(this.parent.scopeModeOffset);
        }
        return this.timeStep_ms == null ? this.parent.timeStep_ms.getTime_ms(index) : this.timeStep_ms.getTime_ms(index);
    }

    public double getLastTime_ms() {
        return this.timeStep_ms == null ? (double)((Long)this.parent.timeStep_ms.lastElement()).longValue() / 10.0 : (double)((Long)this.timeStep_ms.lastElement()).longValue() / 10.0;
    }

    public double getAverageTimeStep_ms() {
        return this.timeStep_ms == null ? this.parent.getAverageTimeStep_ms() : this.timeStep_ms.getAverageTimeStep_ms();
    }

    void setTimeStep_ms(double newTimeStep_ms) {
        this.timeStep_ms = new TimeSteps(newTimeStep_ms);
    }

    public double getMaxTime_ms() {
        return this.timeStep_ms == null ? this.parent.getMaxTime_ms() : (this.timeStep_ms.isConstant ? this.timeStep_ms.getMaxTime_ms() * (double)(this.elementCount - 1) : this.timeStep_ms.getMaxTime_ms());
    }

    private int[] findBoundingIndexes(double time_ms) {
        int[] indexs;
        int[] nArray = indexs = this.timeStep_ms == null ? this.parent.timeStep_ms.findBoundingIndexes(time_ms) : this.timeStep_ms.findBoundingIndexes(time_ms);
        if (this.elementCount > 0) {
            indexs[0] = indexs[0] > this.elementCount - 1 ? this.elementCount - 1 : indexs[0];
            indexs[1] = indexs[1] > this.elementCount - 1 ? this.elementCount - 1 : indexs[1];
        }
        return indexs;
    }

    public int findBestIndex(double time_ms) {
        int index = this.timeStep_ms == null ? this.parent.timeStep_ms.findBestIndex(time_ms) : this.timeStep_ms.findBestIndex(time_ms);
        return index > this.elementCount - 1 ? this.elementCount - 1 : index;
    }

    public int getZoomOffset() {
        return this.zoomOffset;
    }

    public double getZoomTimeOffset() {
        return this.zoomTimeOffset;
    }

    public double getDrawTimeOffset_ms() {
        double timeOffset_ms = 0.0;
        if (this.parent.isScopeMode) {
            timeOffset_ms = this.timeStep_ms != null && this.timeStep_ms.isConstant || this.parent.timeStep_ms.isConstant ? (double)((this.timeStep_ms != null ? (Long)this.timeStep_ms.get(0) : (Long)this.parent.timeStep_ms.get(0)) * (long)(this.elementCount - this.parent.scopeModeSize)) / 10.0 : (this.timeStep_ms != null ? this.timeStep_ms.getTime_ms(this.elementCount - this.parent.scopeModeSize) : this.parent.timeStep_ms.getTime_ms(this.elementCount - this.parent.scopeModeSize));
        } else if (this.parent.isZoomMode) {
            timeOffset_ms = this.zoomTimeOffset;
        }
        return timeOffset_ms;
    }

    public double getDrawTimeWidth_ms() {
        if (this.elementCount > 0) {
            if (this.parent.isScopeMode) {
                this.drawTimeWidth = this.timeStep_ms != null && this.timeStep_ms.isConstant || this.parent.timeStep_ms != null && this.parent.timeStep_ms.isConstant ? (double)((this.timeStep_ms != null ? (Long)this.timeStep_ms.get(0) : (Long)this.parent.timeStep_ms.get(0)) * (long)this.parent.scopeModeSize) / 10.0 : (this.timeStep_ms != null ? this.timeStep_ms.getDeltaTime(this.elementCount - 1 - this.parent.scopeModeSize, this.elementCount - 1) : this.parent.timeStep_ms.getDeltaTime(this.elementCount - 1 - this.parent.scopeModeSize, this.elementCount - 1));
            } else if (!this.parent.isZoomMode) {
                this.drawTimeWidth = this.timeStep_ms != null && this.timeStep_ms.isConstant || this.parent.timeStep_ms != null && this.parent.timeStep_ms.isConstant ? (double)((this.timeStep_ms != null ? (Long)this.timeStep_ms.get(0) : (Long)this.parent.timeStep_ms.get(0)) * (long)(this.elementCount - 1)) / 10.0 : (double)(this.timeStep_ms != null ? (Long)this.timeStep_ms.lastElement() : (Long)this.parent.timeStep_ms.lastElement()).longValue() / 10.0;
            }
        }
        return this.drawTimeWidth;
    }

    public void setZoomTimeOffset(double newZoomTimeOffset) {
        this.zoomTimeOffset = newZoomTimeOffset;
    }

    public void setDrawTimeWidth(double newDrawTimeWidth) {
        this.drawTimeWidth = newDrawTimeWidth;
    }

    public DecimalFormat getDecimalFormat() {
        if (this.numberFormat == -1) {
            this.setNumberFormat(-1);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.isScaleSynced() + " - " + this.getAbstractParent().getSyncMasterRecordOrdinal(this.name));
        }
        return this.isScaleSynced() ? ((Record)this.getAbstractParent().get((int)this.getAbstractParent().getSyncMasterRecordOrdinal((String)this.name))).df : this.df;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String newKeyName) {
        this.keyName = newKeyName;
    }

    public IDevice getDevice() {
        if (this.device == null) {
            this.device = this.getAbstractParent().getDevice();
        }
        return this.device;
    }

    public Point getDisplayPoint(int measurementPointIndex, int xDisplayOffset, int yDisplayOffset) {
        return new Point(xDisplayOffset + Double.valueOf(this.getTime_ms(measurementPointIndex) * this.displayScaleFactorTime).intValue(), yDisplayOffset - Double.valueOf(((double)this.get(measurementPointIndex).intValue() / 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue());
    }

    public Point getGPSDisplayPoint(int measurementPointIndex, int xDisplayOffset, int yDisplayOffset) {
        int grad = this.get(measurementPointIndex) / 1000000;
        if (this.getUnit().endsWith("'")) {
            return new Point(xDisplayOffset + Double.valueOf(this.getTime_ms(measurementPointIndex) * this.displayScaleFactorTime).intValue(), yDisplayOffset - Double.valueOf((((double)grad + ((double)this.get(measurementPointIndex).intValue() / 1000000.0 - (double)grad) / 0.6) * 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue());
        }
        return new Point(xDisplayOffset + Double.valueOf(this.getTime_ms(measurementPointIndex) * this.displayScaleFactorTime).intValue(), yDisplayOffset - Double.valueOf(((double)this.get(measurementPointIndex).intValue() / 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue());
    }

    public String getFormattedMeasureValue(int index) {
        if (this.device.isGPSCoordinates(this)) {
            if (this.getUnit().endsWith("'")) {
                return this.elementAt(index) != null ? StringHelper.getFormatedWithMinutes("%2d %04.1f", this.device.translateValue(this, (double)((Integer)this.elementAt(index)).intValue() / 1000.0)).trim() : "*";
            }
            return this.elementAt(index) != null ? this.getDecimalFormat().format(this.device.translateValue(this, (double)((Integer)this.elementAt(index)).intValue() / 1000.0)) : "*";
        }
        return this.elementAt(index) != null ? this.getDecimalFormat().format(this.device.translateValue(this, (double)((Integer)this.elementAt(index)).intValue() / 1000.0)) : "*";
    }

    @Override
    public String getFormattedScaleValue(double finalValue) {
        if (this.device.isGPSCoordinates(this)) {
            if (this.getUnit().endsWith("'")) {
                return StringHelper.getFormatedWithMinutes("%2d %04.1f", finalValue);
            }
            return this.getDecimalFormat().format(finalValue);
        }
        return this.getDecimalFormat().format(finalValue);
    }

    public String getFormattedTableValue(double value) {
        String formattedValue = this.device.isGPSCoordinates(this) ? (this.getUnit().endsWith("'") ? StringHelper.getFormatedWithMinutes("%3d %07.4f", this.device.translateValue(this, value)).trim() : String.format("%9.6f", this.device.translateValue(this, value))) : this.getDecimalFormat().format(this.device.translateValue(this, value));
        return formattedValue;
    }

    public String getFormattedTableValue(int index) {
        return this.getFormattedTableValue((double)this.realGet(index).intValue() / 1000.0);
    }

    public String getFormattedStatisticsValue(double value) {
        String formattedValue = this.device.isGPSCoordinates(this) ? (this.getUnit().endsWith("'") ? StringHelper.getFormatedWithMinutes("%2d %07.4f", this.device.translateValue(this, value)).trim() : String.format("%8.6f", this.device.translateValue(this, value))) : this.getDecimalFormat().format(this.device.translateValue(this, value));
        return formattedValue;
    }

    public Point getDisplayEndPoint(int xPos) {
        return new Point(this.parent.drawAreaBounds.x + xPos, this.parent.drawAreaBounds.y + this.getVerticalDisplayPointValue(xPos));
    }

    public double getHorizontalDisplayPointTime_ms(int xPos) {
        return this.drawTimeWidth * (double)xPos / (double)this.parent.drawAreaBounds.width;
    }

    public String getHorizontalDisplayPointAsFormattedTimeWithUnit(int xPos) {
        Settings settings = this.getParent().getAnalyzer().getSettings();
        return TimeLine.getFomatedTimeWithUnit(this.getHorizontalDisplayPointTime_ms(xPos) + this.getDrawTimeOffset_ms() + (double)(settings != null && settings.isTimeFormatAbsolute() ? this.getStartTimeStamp() : 0L));
    }

    public int getHorizontalPointIndexFromDisplayPoint(int xPos) {
        return this.findBestIndex(this.getHorizontalDisplayPointTime_ms(xPos) + this.getDrawTimeOffset_ms());
    }

    public int getVerticalDisplayPointValue(int xPos) {
        int pointPosY = 0;
        try {
            double tmpTimeValue = this.getHorizontalDisplayPointTime_ms(xPos) + this.getDrawTimeOffset_ms();
            int[] indexs = this.findBoundingIndexes(tmpTimeValue);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, tmpTimeValue + "; " + indexs[0] + "; " + indexs[1]);
            }
            if (super.size() > 0) {
                if (this.getDevice().isGPSCoordinates(this)) {
                    int grad0 = this.get(indexs[0]) / 1000000;
                    if (indexs[0] == indexs[1]) {
                        pointPosY = this.getUnit().endsWith("'") ? Double.valueOf((double)this.parent.drawAreaBounds.height - (((double)grad0 + ((double)this.get(indexs[0]).intValue() / 1000000.0 - (double)grad0) / 0.6) * 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue() : Double.valueOf((double)this.parent.drawAreaBounds.height - (((double)grad0 + ((double)this.get(indexs[0]).intValue() / 1000000.0 - (double)grad0)) * 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue();
                    } else {
                        int grad1 = this.get(indexs[1]) / 1000000;
                        double deltaValueY = (double)grad1 + ((double)this.get(indexs[1]).intValue() / 1000000.0 - (double)grad1) / 0.6 - ((double)grad0 + ((double)this.get(indexs[0]).intValue() / 1000000.0 - (double)grad0) / 0.6);
                        double deltaTimeIndex01 = this.timeStep_ms != null ? this.timeStep_ms.getTime_ms(indexs[1]) - this.timeStep_ms.getTime_ms(indexs[0]) : this.parent.timeStep_ms.getTime_ms(indexs[1]) - this.parent.timeStep_ms.getTime_ms(indexs[0]);
                        double xPosDeltaTime2Index0 = tmpTimeValue - (this.timeStep_ms != null ? this.timeStep_ms.getTime_ms(indexs[0]) : this.parent.timeStep_ms.getTime_ms(indexs[0]));
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "deltyValueY = " + deltaValueY + " deltaTime = " + deltaTimeIndex01 + " deltaTimeValue = " + xPosDeltaTime2Index0);
                        }
                        pointPosY = Double.valueOf((double)this.parent.drawAreaBounds.height - (((double)grad0 + ((double)this.get(indexs[0]).intValue() / 1000000.0 - (double)grad0) / 0.6 + xPosDeltaTime2Index0 / deltaTimeIndex01 * deltaValueY) * 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue();
                    }
                } else if (indexs[0] == indexs[1]) {
                    pointPosY = Double.valueOf((double)this.parent.drawAreaBounds.height - ((double)((Integer)super.get(indexs[0])).intValue() / 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue();
                } else {
                    int deltaValueY = (Integer)super.get(indexs[1]) - (Integer)super.get(indexs[0]);
                    double deltaTimeIndex01 = this.timeStep_ms != null ? this.timeStep_ms.getTime_ms(indexs[1]) - this.timeStep_ms.getTime_ms(indexs[0]) : this.parent.timeStep_ms.getTime_ms(indexs[1]) - this.parent.timeStep_ms.getTime_ms(indexs[0]);
                    double xPosDeltaTime2Index0 = tmpTimeValue - (this.timeStep_ms != null ? this.timeStep_ms.getTime_ms(indexs[0]) : this.parent.timeStep_ms.getTime_ms(indexs[0]));
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "deltyValueY = " + deltaValueY + " deltaTime = " + deltaTimeIndex01 + " deltaTimeValue = " + xPosDeltaTime2Index0);
                    }
                    pointPosY = Double.valueOf((double)this.parent.drawAreaBounds.height - (((double)((Integer)super.get(indexs[0])).intValue() + xPosDeltaTime2Index0 / deltaTimeIndex01 * (double)deltaValueY) / 1000.0 - this.minDisplayValue * 1.0 / this.syncMasterFactor) * this.displayScaleFactorValue).intValue();
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, xPos + " -> timeValue = " + TimeLine.getFomatedTime(tmpTimeValue) + " pointPosY = " + pointPosY);
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage() + " xPos = " + xPos, e);
        }
        return pointPosY > this.parent.drawAreaBounds.height ? this.parent.drawAreaBounds.height : (pointPosY < 0 ? 0 : pointPosY);
    }

    public String getVerticalDisplayPointAsFormattedScaleValue(int yPos, Rectangle drawAreaBounds) {
        String displayPointValue = this.parent.isZoomMode ? this.df.format((Object)(this.minZoomScaleValue + (this.maxZoomScaleValue - this.minZoomScaleValue) * (double)(drawAreaBounds.height - yPos) / (double)drawAreaBounds.height)) : this.df.format((Object)(this.minScaleValue + (this.maxScaleValue - this.minScaleValue) * (double)(drawAreaBounds.height - yPos) / (double)drawAreaBounds.height));
        return displayPointValue;
    }

    public double getVerticalDisplayPointScaleValue(int yPos, Rectangle drawAreaBounds) {
        double value = this.parent.isZoomMode || this.parent.isScopeMode ? this.minZoomScaleValue + (this.maxZoomScaleValue - this.minZoomScaleValue) * (double)yPos / (double)drawAreaBounds.height : this.minScaleValue + (this.maxScaleValue - this.minScaleValue) * (double)yPos / (double)drawAreaBounds.height;
        return value;
    }

    public String getVerticalDisplayDeltaAsFormattedValue(int deltaPos, Rectangle drawAreaBounds) {
        String textValue = this.parent.isZoomMode || this.parent.isScopeMode ? this.df.format((Object)((this.maxZoomScaleValue - this.minZoomScaleValue) * (double)deltaPos / (double)drawAreaBounds.height)) : this.df.format((Object)((this.maxScaleValue - this.minScaleValue) * (double)deltaPos / (double)drawAreaBounds.height));
        return textValue;
    }

    public String getSlopeValue(Point points) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "" + points.toString());
        }
        double measureDelta = this.parent.isZoomMode ? (this.maxZoomScaleValue - this.minZoomScaleValue) * (double)points.y / (double)this.parent.drawAreaBounds.height : (this.maxScaleValue - this.minScaleValue) * (double)points.y / (double)this.parent.drawAreaBounds.height;
        double timeDelta = this.drawTimeWidth * (double)points.x / (double)this.parent.drawAreaBounds.width / 1000.0;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "measureDelta = " + measureDelta + " timeDelta = " + timeDelta);
        }
        return new DecimalFormat("0.000").format(measureDelta / timeDelta);
    }

    public void setZoomBounds(Rectangle zoomBounds) {
        this.zoomTimeOffset = this.getHorizontalDisplayPointTime_ms(zoomBounds.x) + this.getDrawTimeOffset_ms();
        if (this.zoomTimeOffset < 0.0) {
            this.zoomTimeOffset = 0.0;
        }
        this.zoomOffset = this.findBestIndex(this.zoomTimeOffset);
        this.drawTimeWidth = this.getHorizontalDisplayPointTime_ms(zoomBounds.width - 1);
        if (this.drawTimeWidth > this.getMaxTime_ms()) {
            this.drawTimeWidth = this.getMaxTime_ms();
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name + " zoomTimeOffset " + TimeLine.getFomatedTimeWithUnit(this.zoomTimeOffset) + " drawTimeWidth " + TimeLine.getFomatedTimeWithUnit(this.drawTimeWidth));
        }
        this.tmpMinZoomScaleValue = this.getVerticalDisplayPointScaleValue(zoomBounds.y, this.parent.drawAreaBounds);
        this.tmpMaxZoomScaleValue = this.getVerticalDisplayPointScaleValue(zoomBounds.height + zoomBounds.y, this.parent.drawAreaBounds);
        this.minZoomScaleValue = this.tmpMinZoomScaleValue < this.minScaleValue ? this.minScaleValue : this.tmpMinZoomScaleValue;
        double d = this.maxZoomScaleValue = this.tmpMaxZoomScaleValue > this.maxScaleValue ? this.maxScaleValue : this.tmpMaxZoomScaleValue;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name + " - minZoomScaleValue = " + this.minZoomScaleValue + "  maxZoomScaleValue = " + this.maxZoomScaleValue);
        }
    }

    public double getDisplayScaleFactorTime() {
        return this.displayScaleFactorTime;
    }

    public void setDisplayScaleFactorTime(double newDisplayScaleFactorTime) {
        this.displayScaleFactorTime = newDisplayScaleFactorTime;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format(Locale.ENGLISH, "displayScaleFactorTime = %.3f", newDisplayScaleFactorTime));
        }
    }

    public double getDisplayScaleFactorValue() {
        return this.displayScaleFactorValue;
    }

    public void setDisplayScaleFactorValue(int drawAreaHeight) {
        this.displayScaleFactorValue = 1.0 * (double)drawAreaHeight / (this.maxDisplayValue - this.minDisplayValue);
        RecordSet recordParent = this.getParent();
        if (recordParent.isOneOfSyncableRecord(this.name) && this.getFactor() / recordParent.get(recordParent.getSyncMasterRecordOrdinal(this.name)).getFactor() != 1.0) {
            this.syncMasterFactor = this.getFactor() / recordParent.get(recordParent.getSyncMasterRecordOrdinal(this.name)).getFactor();
            this.displayScaleFactorValue *= this.syncMasterFactor;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format(Locale.ENGLISH, "drawAreaHeight = %d displayScaleFactorValue = %.3f (this.maxDisplayValue - this.minDisplayValue) = %.3f", drawAreaHeight, this.displayScaleFactorValue, this.maxDisplayValue - this.minDisplayValue));
        }
    }

    public void setSyncedMinMaxDisplayValues(double newMinDisplayValue, double newMaxDisplayValue) {
        if (this.device.isGPSCoordinates(this)) {
            this.minDisplayValue = this.device.translateValue(this, newMinDisplayValue) * 1000.0;
            this.maxDisplayValue = this.device.translateValue(this, newMaxDisplayValue) * 1000.0;
        } else {
            this.minDisplayValue = newMinDisplayValue;
            this.maxDisplayValue = newMaxDisplayValue;
        }
        if (this.getAbstractParent().isOneOfSyncableRecord(this.name)) {
            for (Record record : this.getParent().getScaleSyncedRecords(this.getAbstractParent().getSyncMasterRecordOrdinal(this.name))) {
                record.minDisplayValue = this.minDisplayValue;
                record.maxDisplayValue = this.maxDisplayValue;
            }
        }
    }

    public double getMinDisplayValue() {
        return this.minDisplayValue;
    }

    public double getMaxDisplayValue() {
        return this.maxDisplayValue;
    }

    public String getFormatedMinDisplayValue() {
        return this.df.format(this.minDisplayValue);
    }

    public String getFormatedMaxDisplayValue() {
        return this.df.format(this.maxDisplayValue);
    }

    public void setMinMaxZoomScaleValues(double newMinZoomScaleValue, double newMaxZoomScaleValue) {
        this.minZoomScaleValue = newMinZoomScaleValue;
        this.maxZoomScaleValue = newMaxZoomScaleValue;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name + " - minScaleValue/minZoomScaleValue = " + this.minScaleValue + "/" + newMinZoomScaleValue + " : maxScaleValue/maxZoomScaleValue = " + this.maxScaleValue + "/" + newMaxZoomScaleValue);
        }
    }

    public boolean isMeasurementMode() {
        return this.isMeasurementMode;
    }

    public void setMeasurementMode(boolean enabled) {
        this.isMeasurementMode = enabled;
    }

    public boolean isDeltaMeasurementMode() {
        return this.isDeltaMeasurementMode;
    }

    public void setDeltaMeasurementMode(boolean enabled) {
        this.isDeltaMeasurementMode = enabled;
    }

    public String getChannelConfigKey() {
        if (this.channelConfigKey == null || this.channelConfigKey.length() < 1) {
            this.channelConfigKey = this.parent.getChannelConfigName();
        }
        return this.channelConfigKey;
    }

    public void setChannelConfigKey(String newChannelConfigKey) {
        this.channelConfigKey = newChannelConfigKey;
    }

    public void resetMinMax() {
        this.maxValue = 0;
        this.minValue = 0;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name);
        }
    }

    public void setMinMax(int newMin, int newMax) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "setMinMax :  " + newMin + "," + newMax);
        }
        this.maxValue = newMax;
        this.minValue = newMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatiticCalculationBase() {
        Record record = this;
        synchronized (record) {
            this.maxValueTriggered = Integer.MIN_VALUE;
            this.minValueTriggered = Integer.MAX_VALUE;
            this.avgValue = Integer.MIN_VALUE;
            this.sigmaValue = Integer.MIN_VALUE;
            this.avgValueTriggered = Integer.MIN_VALUE;
            this.sigmaValueTriggered = Integer.MIN_VALUE;
            this.triggerRanges = null;
            this.tmpTriggerRange = null;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, this.name);
            }
        }
    }

    public String getSerializeProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME).append("=").append(this.name).append(DELIMITER);
        sb.append(UNIT).append("=").append(this.unit == null ? "" : this.unit).append(DELIMITER);
        sb.append(SYMBOL).append("=").append(this.symbol == null || this.symbol.equals("null") ? "" : this.symbol).append(DELIMITER);
        if (this.isActive != null) {
            sb.append(IS_ACTIVE).append("=").append(this.isActive()).append(DELIMITER);
        }
        sb.append(IS_DIPLAYABLE).append("=").append(this.isDisplayable).append(DELIMITER);
        sb.append(IS_VISIBLE).append("=").append(this.isVisible).append(DELIMITER);
        sb.append(MAX_VALUE).append("=").append(this.maxValue).append(DELIMITER);
        sb.append(MIN_VALUE).append("=").append(this.minValue).append(DELIMITER);
        for (PropertyType property : this.properties) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, this.name + " - " + property.getName() + " = " + property.getValue());
            }
            sb.append(property.getName()).append("_").append((Object)property.getType()).append("=").append(property.getValue()).append(DELIMITER);
        }
        if (this.statistics != null) {
            sb.append(this.statistics.toString()).append(DELIMITER);
        }
        sb.append(DEFINED_MAX_VALUE).append("=").append(this.maxScaleValue).append(DELIMITER);
        sb.append(DEFINED_MIN_VALUE).append("=").append(this.minScaleValue).append(DELIMITER);
        sb.append(IS_POSITION_LEFT).append("=").append(this.isPositionLeft).append(DELIMITER);
        sb.append(COLOR).append("=").append(this.rgb).append(DELIMITER);
        sb.append(LINE_WITH).append("=").append(this.lineWidth).append(DELIMITER);
        sb.append(LINE_STYLE).append("=").append(this.lineStyle).append(DELIMITER);
        sb.append(IS_ROUND_OUT).append("=").append(this.isRoundOut).append(DELIMITER);
        sb.append(IS_START_POINT_ZERO).append("=").append(this.isStartpointZero).append(DELIMITER);
        sb.append(IS_START_END_DEFINED).append("=").append(this.isStartEndDefined).append(DELIMITER);
        sb.append(NUMBER_FORMAT).append("=").append(this.numberFormat).append(DELIMITER);
        if (this.dataType != null && this.dataType != DataType.DEFAULT) {
            sb.append(DATA_TYPE).append("=").append(this.dataType.value).append(DELIMITER);
        }
        return sb.substring(0, sb.lastIndexOf(DELIMITER)) + END_MARKER;
    }

    public void setSerializedProperties(String serializedRecordProperties) {
        String tmpValue;
        HashMap<String, String> recordProps;
        block19: {
            recordProps = StringHelper.splitString(serializedRecordProperties, DELIMITER, propertyKeys);
            tmpValue = null;
            tmpValue = recordProps.get(UNIT);
            this.unit = tmpValue != null && tmpValue.length() > 0 ? tmpValue.trim() : "";
            tmpValue = recordProps.get(SYMBOL);
            this.symbol = tmpValue != null && tmpValue.length() > 0 ? tmpValue.trim() : "";
            this.symbol = this.symbol.equals("null") ? "" : this.symbol;
            tmpValue = recordProps.get(IS_ACTIVE);
            if (tmpValue != null && tmpValue.length() > 0) {
                this.isActive = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(IS_DIPLAYABLE)) != null && tmpValue.length() > 0) {
                this.isDisplayable = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(IS_VISIBLE)) != null && tmpValue.length() > 0) {
                this.isVisible = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(IS_POSITION_LEFT)) != null && tmpValue.length() > 0) {
                this.isPositionLeft = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(COLOR)) != null && tmpValue.length() >= 5) {
                this.rgb = tmpValue;
            }
            if ((tmpValue = recordProps.get(LINE_WITH)) != null && tmpValue.length() > 0) {
                this.lineWidth = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(LINE_STYLE)) != null && tmpValue.length() > 0) {
                this.lineStyle = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(IS_ROUND_OUT)) != null && tmpValue.length() > 0) {
                this.isRoundOut = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(IS_START_POINT_ZERO)) != null && tmpValue.length() > 0) {
                this.isStartpointZero = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(IS_START_END_DEFINED)) != null && tmpValue.length() > 0) {
                this.isStartEndDefined = Boolean.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(NUMBER_FORMAT)) != null && tmpValue.length() > 0) {
                this.setNumberFormat(Integer.valueOf(tmpValue.trim()));
            }
            if ((tmpValue = recordProps.get(MAX_VALUE)) != null && tmpValue.length() > 0) {
                this.maxValue = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(MIN_VALUE)) != null && tmpValue.length() > 0) {
                this.minValue = Integer.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(DEFINED_MAX_VALUE)) != null && tmpValue.length() > 0) {
                this.maxScaleValue = Double.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(DEFINED_MIN_VALUE)) != null && tmpValue.length() > 0) {
                this.minScaleValue = Double.valueOf(tmpValue.trim());
            }
            if ((tmpValue = recordProps.get(DATA_TYPE)) != null && tmpValue.length() > 0) {
                try {
                    this.dataType = DataType.fromValue(tmpValue);
                }
                catch (Exception e) {
                    if (!tmpValue.startsWith("GPS") || !tmpValue.endsWith("degree")) break block19;
                    this.dataType = DataType.fromValue(tmpValue.substring(0, tmpValue.lastIndexOf(32)));
                }
            }
        }
        if ((tmpValue = recordProps.get(NAME)) != null && tmpValue.length() > 0 && !this.name.trim().equals(tmpValue.trim())) {
            this.setName(tmpValue);
        }
    }

    public void setSerializedDeviceSpecificProperties(String serializedProperties) {
        HashMap<String, String> recordDeviceProps = StringHelper.splitString(serializedProperties, DELIMITER, this.getDevice().getUsedPropertyKeys());
        StringBuilder sb = new StringBuilder().append("update: ");
        if (log.isLoggable(Level.FINE)) {
            sb.append(this.name).append(" - ");
        }
        if (recordDeviceProps.get("statistics") != null) {
            MeasurementType measurement = this.device.getMeasurement(this.parent.parent.number, this.ordinal);
            measurement.setStatistics(StatisticsType.fromString(recordDeviceProps.get("statistics")));
            this.statistics = measurement.getStatistics();
        }
        for (Map.Entry<String, String> entry : recordDeviceProps.entrySet()) {
            for (PropertyType defaultProperty : this.properties) {
                DataTypes _dataType;
                if (!defaultProperty.getName().equalsIgnoreCase(entry.getKey())) continue;
                String prop = entry.getValue();
                String type = prop.split("=")[0].substring(1);
                DataTypes dataTypes = _dataType = type != null ? DataTypes.fromValue(type) : DataTypes.STRING;
                String value = prop.split("=")[1];
                if (value == null || value.length() <= 0 || !defaultProperty.getType().equals((Object)_dataType)) continue;
                defaultProperty.setValue(value.trim());
                if (!log.isLoggable(Level.FINE)) continue;
                sb.append(entry.getKey()).append(" = ").append(value);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, sb.toString());
        }
    }

    public void setUnsaved(String reason) {
        this.parent.setUnsaved(reason);
    }

    public int getNumberScaleTicks() {
        return this.numberScaleTicks;
    }

    public void setNumberScaleTicks(int newNumberScaleTicks) {
        this.numberScaleTicks = newNumberScaleTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIntegratedValue(int referencedMeasurementOrdinal) {
        RecordSet recordSet = this.parent;
        synchronized (recordSet) {
            if (this.triggerRanges == null) {
                this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            }
            double integratedValueTriggered = 0.0;
            StringBuilder sb = new StringBuilder();
            if (log.isLoggable(Level.FINER)) {
                sb.append("\n");
            }
            if (this.triggerRanges != null) {
                for (TriggerRange range : this.triggerRanges) {
                    for (int i = range.in; i < range.out; ++i) {
                        double power_W = this.device.translateValue(this, (double)this.get(i).intValue() / 1000.0);
                        double time_min = (this.getTime_ms(i) - this.getTime_ms(i - 1)) / 1000.0 / 60.0;
                        integratedValueTriggered += power_W * time_min;
                        if (!log.isLoggable(Level.FINER)) continue;
                        sb.append(String.format("%6.2f W * %3.1f ms = %6.2f Wmin", power_W, this.getTime_ms(i) - this.getTime_ms(i - 1), integratedValueTriggered)).append(", ");
                    }
                    if (!log.isLoggable(Level.FINER)) continue;
                    sb.append("\n");
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, sb.toString());
                }
            }
            return integratedValueTriggered;
        }
    }

    public int getAvgValue() {
        this.setAvgValue();
        return this.avgValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgValueTriggered() {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.getTriggerRanges();
            }
            this.setAvgValueTriggered();
            return this.avgValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgValueTriggered(int referencedMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            }
            this.setAvgValueTriggered();
            return this.avgValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgValueTriggered(int referencedMeasurementOrdinal, int referencedSecondaryMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            Vector<TriggerRange> primaryTriggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            Vector<TriggerRange> secondaryTriggerRanges = this.parent.get(referencedSecondaryMeasurementOrdinal).getTriggerRanges();
            if (primaryTriggerRanges != null && secondaryTriggerRanges != null && !this.parent.get(referencedMeasurementOrdinal).isTriggerRangesMerged()) {
                this.mergeTriggerRanges(referencedMeasurementOrdinal, referencedSecondaryMeasurementOrdinal);
            } else {
                this.triggerRanges = primaryTriggerRanges;
            }
            this.setAvgValueTriggered();
            return this.avgValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvgValue() {
        Record record = this;
        synchronized (record) {
            if (super.size() > 0) {
                long sum = 0L;
                int zeroCount = 0;
                for (Integer xi : this) {
                    if (xi != null && xi != 0) {
                        sum += (long)xi.intValue();
                        continue;
                    }
                    ++zeroCount;
                }
                this.avgValue = super.size() - zeroCount != 0 ? Long.valueOf(sum / (long)(super.size() - zeroCount)).intValue() : 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgValue(int indexStart, int indexEnd) {
        Record record = this;
        synchronized (record) {
            int indexDelta;
            long sum = 0L;
            int zeroCount = 0;
            if (super.size() > 0) {
                for (int i = indexStart; i <= indexEnd && i < super.size(); ++i) {
                    Integer xi = this.realGet(i);
                    if (xi != null && xi != 0) {
                        sum += (long)xi.intValue();
                        continue;
                    }
                    ++zeroCount;
                }
            }
            int n = (indexDelta = indexEnd - indexStart + 1) - zeroCount > 0 ? Long.valueOf(sum / (long)(indexDelta - zeroCount)).intValue() : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvgValueTriggered() {
        Record record = this;
        synchronized (record) {
            long sum = 0L;
            int numPoints = 0;
            StringBuilder sb = new StringBuilder();
            if (log.isLoggable(Level.FINER)) {
                sb.append("\n");
            }
            if (this.triggerRanges != null) {
                for (TriggerRange range : this.triggerRanges) {
                    long startValue = this.getUnit().contains("Ah") ? (long)this.get(range.in).intValue() : 0L;
                    for (int i = range.in; i < range.out; ++i) {
                        sum += (long)this.get(i).intValue() - startValue;
                        if (log.isLoggable(Level.FINER)) {
                            sb.append((double)this.realGet(i).intValue() / 1000.0).append(", ");
                        }
                        ++numPoints;
                    }
                    if (!log.isLoggable(Level.FINER)) continue;
                    sb.append("\n");
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, sb.toString());
                }
                this.avgValueTriggered = numPoints > 1 ? Long.valueOf(sum / (long)(numPoints - 1)).intValue() : 0;
            }
        }
    }

    public int getSigmaValue() {
        this.setSigmaValue();
        return this.sigmaValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSigmaValueTriggered() {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.getTriggerRanges();
            }
            if (this.sigmaValueTriggered == Integer.MIN_VALUE) {
                this.setSigmaValueTriggered();
            }
            return this.sigmaValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSigmaValueTriggered(int referencedMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            }
            if (this.sigmaValueTriggered == Integer.MIN_VALUE) {
                this.setSigmaValueTriggered();
            }
            return this.sigmaValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSigmaValueTriggered(int referencedMeasurementOrdinal, int referencedSecondaryMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            Vector<TriggerRange> primaryTriggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            Vector<TriggerRange> secondaryTriggerRanges = this.parent.get(referencedSecondaryMeasurementOrdinal).getTriggerRanges();
            if (primaryTriggerRanges != null && secondaryTriggerRanges != null && !this.parent.get(referencedMeasurementOrdinal).isTriggerRangesMerged()) {
                this.mergeTriggerRanges(referencedMeasurementOrdinal, referencedSecondaryMeasurementOrdinal);
            } else {
                this.triggerRanges = primaryTriggerRanges;
            }
            if (this.sigmaValueTriggered == Integer.MIN_VALUE) {
                this.setSigmaValueTriggered();
            }
            return this.sigmaValueTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSigmaValue() {
        Record record = this;
        synchronized (record) {
            if (super.size() > 0) {
                double average = (double)this.getAvgValue() / 1000.0;
                double sumPoweredValues = 0.0;
                int zeroCount = 0;
                for (Integer xi : this) {
                    if (xi != null && xi != 0) {
                        sumPoweredValues += Math.pow((double)xi.intValue() / 1000.0 - average, 2.0);
                        continue;
                    }
                    ++zeroCount;
                }
                this.sigmaValue = super.size() - zeroCount - 1 != 0 ? Double.valueOf(Math.sqrt(sumPoweredValues / (double)(super.size() - zeroCount - 1)) * 1000.0).intValue() : 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSigmaValueTriggered() {
        Record record = this;
        synchronized (record) {
            double average = (double)this.getAvgValueTriggered() / 1000.0;
            double sumPoweredDeviations = 0.0;
            int numPoints = 0;
            if (this.triggerRanges != null) {
                for (TriggerRange range : this.triggerRanges) {
                    for (int i = range.in; i < range.out; ++i) {
                        sumPoweredDeviations += Math.pow((double)this.realGet(i).intValue() / 1000.0 - average, 2.0);
                        ++numPoints;
                    }
                }
                this.sigmaValueTriggered = Double.valueOf(Math.sqrt(sumPoweredDeviations / (double)(numPoints - 1)) * 1000.0).intValue();
            }
        }
    }

    public synchronized int getSumTriggeredRange() {
        if (this.triggerRanges == null) {
            this.getTriggerRanges();
        }
        return this.calculateSum();
    }

    public synchronized int getSumTriggeredRange(int referencedMeasurementOrdinal, int referencedSecondaryMeasurementOrdinal) {
        if (this.triggerRanges == null) {
            this.mergeTriggerRanges(referencedMeasurementOrdinal, referencedSecondaryMeasurementOrdinal);
        }
        return this.calculateSum();
    }

    private void mergeTriggerRanges(int referencedMeasurementOrdinal, int referencedSecondaryMeasurementOrdinal) {
        if (this.triggerRanges == null || this.triggerRanges != null && !this.isTriggerRangesMerged()) {
            Vector primaryTriggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            primaryTriggerRanges = primaryTriggerRanges == null ? new Vector() : primaryTriggerRanges;
            Vector secondaryTriggerRanges = this.parent.get(referencedSecondaryMeasurementOrdinal).getTriggerRanges();
            Vector vector = secondaryTriggerRanges = secondaryTriggerRanges == null ? new Vector() : secondaryTriggerRanges;
            if (log.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder().append(String.format("build trigger ranges for %s(%d)\n", this.name, this.ordinal));
                sb.append(String.format("primaryTriggerRanges for %s\n", this.parent.get((int)referencedMeasurementOrdinal).name));
                for (TriggerRange range : primaryTriggerRanges) {
                    sb.append(String.format("range in %d, out %d\n", range.in, range.out));
                }
                sb.append(String.format("secondaryTriggerRanges for %s\n", this.parent.get((int)referencedSecondaryMeasurementOrdinal).name));
                for (TriggerRange range : secondaryTriggerRanges) {
                    sb.append(String.format("range in %d, out %d\n", range.in, range.out));
                }
                log.log(Level.INFO, sb.toString());
            }
            this.triggerRanges = new Vector();
            boolean isGreaterSecondary = this.parent.get(referencedSecondaryMeasurementOrdinal).getTriggerIsGreater();
            Iterator primaryIterator = primaryTriggerRanges.iterator();
            block2: while (primaryIterator.hasNext() && secondaryTriggerRanges != null) {
                TriggerRange secondaryRange;
                Iterator secondaryIterator = secondaryTriggerRanges.iterator();
                boolean isMatchRanges = false;
                TriggerRange primaryRange = (TriggerRange)primaryIterator.next();
                if (isGreaterSecondary) {
                    while (!isMatchRanges && secondaryIterator.hasNext()) {
                        secondaryRange = (TriggerRange)secondaryIterator.next();
                        if (secondaryRange.in + 10 < primaryRange.in || secondaryRange.in >= primaryRange.out || secondaryRange.out < primaryRange.out || secondaryRange.out > primaryRange.out + (primaryRange.out - primaryRange.in)) continue;
                        this.triggerRanges.add(new TriggerRange(primaryRange.in, secondaryRange.out));
                        isMatchRanges = true;
                    }
                    if (isMatchRanges) continue;
                    this.triggerRanges.add(primaryRange);
                    continue;
                }
                while (secondaryIterator.hasNext()) {
                    secondaryRange = (TriggerRange)secondaryIterator.next();
                    if (secondaryRange.in > primaryRange.out) continue block2;
                    if (primaryRange.in >= secondaryRange.out) continue;
                    if (secondaryRange.in >= primaryRange.in && secondaryRange.in < primaryRange.out && secondaryRange.out > primaryRange.in && secondaryRange.out < primaryRange.out) {
                        this.triggerRanges.add(new TriggerRange(secondaryRange.in, secondaryRange.out));
                        continue;
                    }
                    if (secondaryRange.in < primaryRange.in && secondaryRange.in < primaryRange.out && secondaryRange.out > primaryRange.in && secondaryRange.out < primaryRange.out || secondaryRange.out == primaryRange.out) {
                        this.triggerRanges.add(new TriggerRange(primaryRange.in, secondaryRange.out));
                        continue;
                    }
                    if (secondaryRange.in < primaryRange.in) {
                        this.triggerRanges.add(new TriggerRange(primaryRange.in, primaryRange.out));
                        continue;
                    }
                    this.triggerRanges.add(new TriggerRange(secondaryRange.in, primaryRange.out));
                }
            }
            if (log.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("trigger rages merged for %s and %s\n", this.parent.get((int)referencedMeasurementOrdinal).name, this.parent.get((int)referencedSecondaryMeasurementOrdinal).name));
                for (TriggerRange range : this.triggerRanges) {
                    sb.append(String.format("range in %d, out %d\n", range.in, range.out));
                }
                log.log(Level.INFO, sb.toString());
            }
            this.setTriggerRangesIsMerged();
        }
    }

    public synchronized int getSumTriggeredRange(int referencedMeasurementOrdinal) {
        if (this.triggerRanges == null) {
            this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
        }
        return this.calculateSum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calculateSum() {
        Record record = this;
        synchronized (record) {
            int sum = 0;
            int min = 0;
            int max = 0;
            if (this.triggerRanges != null) {
                for (TriggerRange range : this.triggerRanges) {
                    for (int i = range.in; i < range.out; ++i) {
                        if (i == range.in) {
                            min = max = this.realGet(i).intValue();
                            continue;
                        }
                        int point = this.realGet(i);
                        if (point > max) {
                            max = point;
                        }
                        if (point >= min) continue;
                        min = point;
                    }
                    sum += max - min;
                }
            }
            return sum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeSumTriggeredRange() {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.getTriggerRanges();
            }
            return TimeLine.getFomatedTimeWithUnit(this.calculateTimeSum_ms());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeSumTriggeredRange_ms() {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.getTriggerRanges();
            }
            return (int)this.calculateTimeSum_ms();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeSumTriggeredRange(int referencedMeasurementOrdinal) {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null) {
                this.triggerRanges = this.parent.get(referencedMeasurementOrdinal).getTriggerRanges();
            }
            return TimeLine.getFomatedTimeWithUnit(this.calculateTimeSum_ms());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    String calculateTimeSum() {
        Record record = this;
        synchronized (record) {
            double sum = 0.0;
            if (this.triggerRanges != null) {
                for (TriggerRange range : this.triggerRanges) {
                    sum += this.getTime_ms(range.out) - this.getTime_ms(range.in);
                }
            }
            return TimeLine.getFomatedTimeWithUnit(sum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double calculateTimeSum_ms() {
        Record record = this;
        synchronized (record) {
            double sum = 0.0;
            if (this.triggerRanges != null) {
                for (TriggerRange range : this.triggerRanges) {
                    sum += this.getTime_ms(range.out) - this.getTime_ms(range.in);
                }
            }
            return sum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TriggerRange> getTriggerRanges() {
        Record record = this;
        synchronized (record) {
            if (this.triggerRanges == null && this.isDisplayable && this.triggerIsGreater != null && this.triggerLevel != null) {
                log.log(Level.FINE, this.name);
                int deviceTriggerlevel = Double.valueOf(this.device.reverseTranslateValue(this, (double)this.triggerLevel.intValue() / 1000.0) * 1000.0).intValue();
                for (int i = 0; i < this.realSize(); ++i) {
                    int point = this.realGet(i);
                    if (this.triggerIsGreater.booleanValue()) {
                        if (point > deviceTriggerlevel) {
                            if (this.tmpTriggerRange != null) continue;
                            if (this.triggerRanges == null) {
                                this.triggerRanges = new Vector();
                            }
                            this.tmpTriggerRange = new TriggerRange(i);
                            continue;
                        }
                        if (this.triggerRanges == null || this.tmpTriggerRange == null) continue;
                        this.tmpTriggerRange.setOut(i);
                        this.triggerRanges.add(this.tmpTriggerRange);
                        this.tmpTriggerRange = null;
                        continue;
                    }
                    if (point < deviceTriggerlevel) {
                        if (this.tmpTriggerRange != null) continue;
                        if (this.triggerRanges == null) {
                            this.triggerRanges = new Vector();
                        }
                        this.tmpTriggerRange = new TriggerRange(i);
                        continue;
                    }
                    if (this.triggerRanges == null || this.tmpTriggerRange == null) continue;
                    this.tmpTriggerRange.setOut(i);
                    this.triggerRanges.add(this.tmpTriggerRange);
                    this.tmpTriggerRange = null;
                }
                if (this.triggerRanges != null && this.tmpTriggerRange != null) {
                    this.tmpTriggerRange.setOut(this.realSize() - 1);
                    this.triggerRanges.add(this.tmpTriggerRange);
                }
                if (log.isLoggable(Level.FINE)) {
                    if (this.triggerRanges != null) {
                        for (TriggerRange range : this.triggerRanges) {
                            log.log(Level.FINE, this.name + " trigger range = " + range.in + "(" + TimeLine.getFomatedTime(this.getTime_ms(range.in)) + "), " + range.out + "(" + TimeLine.getFomatedTime(this.getTime_ms(range.out)) + ")");
                        }
                    } else {
                        log.log(Level.FINE, this.name + " triggerRanges = null or size = 0");
                    }
                }
                if (this.triggerRanges != null && this.triggerRanges.size() > 0) {
                    Iterator<TriggerRange> iterator = this.triggerRanges.iterator();
                    int rangeOut = 0;
                    TriggerRange rangeLast = null;
                    while (iterator.hasNext()) {
                        TriggerRange range = iterator.next();
                        if (this.triggerIsGreater.booleanValue()) {
                            if (this.getTime_ms(range.out) - this.getTime_ms(range.in) < (double)(this.getMinTriggerTimeSec() * 1000)) {
                                iterator.remove();
                            }
                        } else {
                            if (range.in != 0 && this.getTime_ms(range.in) - this.getTime_ms(rangeOut) < (double)(this.getMinTriggerTimeSec() * 1000)) {
                                iterator.remove();
                                if (rangeLast != null) {
                                    rangeLast.setOut(range.out);
                                }
                            } else {
                                rangeLast = range;
                            }
                            rangeOut = range.out;
                        }
                        if (rangeLast != null) continue;
                        rangeLast = range;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        if (this.triggerRanges != null) {
                            log.log(Level.FINE, this.name + " evaluate trigger ranges to meet minTimeSec requirement");
                            for (TriggerRange range : this.triggerRanges) {
                                log.log(Level.FINE, this.name + " trigger range = " + range.in + " to " + range.out + " = " + TimeLine.getFomatedTime(this.getTime_ms(range.out) - this.getTime_ms(range.in)) + " sec");
                            }
                        } else {
                            log.log(Level.FINE, this.name + " triggerRanges = null");
                        }
                    }
                }
            }
            return this.triggerRanges;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggerRanges(Vector<TriggerRange> newTriggerRanges) {
        Record record = this;
        synchronized (record) {
            this.triggerRanges = newTriggerRanges;
        }
    }

    public boolean isScaleSynced() {
        return this.getAbstractParent().isOneOfSyncableRecord(this.name);
    }

    public boolean isScaleSyncMaster() {
        return this.getAbstractParent().scaleSyncedRecords.containsKey(this.ordinal);
    }

    @Override
    public boolean isScaleVisible() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name + " isScaleSyncMaster=" + this.isScaleSyncMaster() + " isOneOfSyncableRecord=" + this.getAbstractParent().isOneOfSyncableRecord(this.name));
        }
        return this.isScaleSyncMaster() ? this.getAbstractParent().isOneSyncableVisible(this.ordinal) : !this.getAbstractParent().isOneOfSyncableRecord(this.name) && this.isVisible && this.isDisplayable;
    }

    public void setScopeMinMax(int newScopeMin, int newScopeMax) {
        this.scopeMin = newScopeMin;
        this.scopeMax = newScopeMax;
    }

    public double getCompareSetDrawLimit_ms() {
        return this.drawLimit_ms;
    }

    public void setCompareSetDrawLimit_ms(double newDrawLimit) {
        this.drawLimit_ms = newDrawLimit;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasReasonableData() {
        return this.realSize() > 0 && (this.minValue != this.maxValue || this.device.translateValue(this, (double)this.maxValue / 1000.0) != 0.0);
    }

    @Override
    public DataType getDataType() {
        return this.dataType == null ? DataType.DEFAULT : this.dataType;
    }

    public void setDataType() {
        this.dataType = DataType.guess(this.name);
    }

    public void setDataType(DataType newDataType) {
        this.dataType = newDataType;
    }

    public int getVoltageValuesSize() {
        return this.voltageValuesSize;
    }

    public void setVoltageValuesSize(int newVoltageValuesSize) {
        this.voltageValuesSize = newVoltageValuesSize;
    }

    @Override
    public DecimalFormat getRealDf() {
        return this.df;
    }

    @Override
    public void setRealDf(DecimalFormat realDf) {
        this.df = realDf;
    }

    @Override
    public int getSyncMasterRecordOrdinal() {
        PropertyType syncProperty;
        PropertyType propertyType = this.parent.isUtilitySet ? this.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) : (syncProperty = this.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) != null ? this.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) : this.device.getMeasruementProperty(this.parent.parent.number, this.ordinal, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()));
        if (syncProperty != null && !syncProperty.getValue().equals("")) {
            return Integer.parseInt(syncProperty.getValue());
        }
        return -1;
    }

    public IChannelItem getChannelItem() {
        return this.device.getMeasurement(this.parent.parent.number, this.ordinal);
    }

    static class TriggerRange {
        int in = -1;
        int out = -1;

        public TriggerRange(int newIn, int newOut) {
            this.in = newIn;
            this.out = newOut;
        }

        public TriggerRange(int newIn) {
            this.in = newIn;
        }

        public int getIn() {
            return this.in;
        }

        public void setIn(int newIn) {
            this.in = newIn;
        }

        public int getOut() {
            return this.out;
        }

        public void setOut(int newOut) {
            this.out = newOut;
        }

        public boolean isComplete() {
            return this.in >= 0 && this.out > 0;
        }

        public String toString() {
            return this.in + ", " + this.out;
        }
    }

    public static enum DataType {
        DEFAULT("default"),
        GPS_LATITUDE("GPS latitude"),
        GPS_LONGITUDE("GPS longitude"),
        GPS_LATITUDE_DEGREE("GPS latitude degree"),
        GPS_LONGITUDE_DEGREE("GPS longitude degree"),
        GPS_ALTITUDE("GPS altitude"),
        GPS_AZIMUTH("GPS azimuth"),
        GPS_TIME("GPS time"),
        GPS_SPEED("GPS speed"),
        AIR_SPEED("AIR speed"),
        DATE_TIME("date time"),
        CURRENT("current"),
        VOLTAGE("voltage");

        private final String value;

        private DataType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static DataType fromValue(String v) {
            for (DataType c : DataType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            return DEFAULT;
        }

        public static List<DataType> getAsList() {
            ArrayList<DataType> dataTypes = new ArrayList<DataType>();
            for (DataType type : DataType.values()) {
                dataTypes.add(type);
            }
            return dataTypes;
        }

        public static List<String> getValuesAsList() {
            ArrayList<String> dataTypeValues = new ArrayList<String>();
            for (DataType type : DataType.values()) {
                dataTypeValues.add(type.value);
            }
            return dataTypeValues;
        }

        public static DataType getBestGuess(Record record) {
            if (record.getDataType() == DEFAULT) {
                DataType guess = DataType.guess(record.getName());
                return guess != null ? guess : DEFAULT;
            }
            return record.getDataType();
        }

        public static DataType guess(String name) {
            DataType dataType = null;
            if (DataType.isLatitude(name)) {
                dataType = GPS_LATITUDE;
            } else if (DataType.isLongitude(name)) {
                dataType = GPS_LONGITUDE;
            } else if (DataType.isHeight(name)) {
                dataType = GPS_ALTITUDE;
            } else if (DataType.isSpeed(name)) {
                dataType = GPS_SPEED;
            }
            return dataType;
        }

        public static boolean isSpeed(String name) {
            return name.toUpperCase().contains("GPS") && (name.toLowerCase().contains("speed") || name.toLowerCase().contains("geschw"));
        }

        public static boolean isHeight(String name) {
            return !(!name.toUpperCase().contains("GPS") && !name.toUpperCase().contains("ABS") || !name.toLowerCase().contains("hoehe") && !name.toLowerCase().contains("h\u00f6he") && !name.toLowerCase().contains("height") && !name.toLowerCase().contains("alt"));
        }

        public static boolean isLongitude(String name) {
            return name.equalsIgnoreCase("Longitude") || name.contains("GPS_Long") || name.equalsIgnoreCase("L\u00e4ngengrad") || name.equalsIgnoreCase("Laengengrad") || name.toLowerCase().contains("delka");
        }

        public static boolean isLatitude(String name) {
            return name.equalsIgnoreCase("Latitude") || name.contains("GPS_Lat") || name.equalsIgnoreCase("Breitengrad") || name.toLowerCase().contains("sirka");
        }
    }
}

