/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.data.AbstractRecord;
import gde.data.TimeSteps;
import gde.device.IDevice;
import gde.log.Level;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CellVoltageValues;
import gde.utils.StringHelper;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractRecordSet
extends LinkedHashMap<String, AbstractRecord> {
    protected static final String $CLASS_NAME = AbstractRecordSet.class.getName();
    protected static final long serialVersionUID = 26031957L;
    protected static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final int MAX_NAME_LENGTH = 40;
    protected static final int INITIAL_RECORD_CAPACITY = 55;
    protected static final String DESCRIPTION_TEXT_LEAD = Messages.getString("GDE_MSGT0129");
    protected SyncedRecords<? extends AbstractRecord> scaleSyncedRecords = new SyncedRecords(2);
    protected String name;
    protected TimeSteps timeStep_ms;
    protected String header = null;
    protected String[] recordNames;
    protected String description = "";
    protected boolean hasDisplayableData = false;
    protected boolean isSmoothAtCurrentDrop = false;
    protected Vector<Integer[]> currentDropShadow = new Vector(0);
    public static final String SMOOTH_AT_CURRENT_DROP = "RecordSet_smoothAtCurrentDrop";
    protected boolean isSmoothVoltageCurve = false;
    public static final String SMOOTH_VOLTAGE_CURVE = "RecordSet_smoothVoltageCurve";
    int[] voltageLimits = CellVoltageValues.getVoltageLimits();
    public static final String VOLTAGE_LIMITS = "RecordSet_voltageLimits";
    protected Vector<? extends AbstractRecord> visibleAndDisplayableRecords;
    protected Vector<? extends AbstractRecord> displayRecords;
    public static final String TIME_STEP_MS = "timeStep_ms";
    public static final String START_TIME_STAMP = "startTimeStamp";
    protected static final String TIME = "time";
    protected static final String TIME_GRID_TYPE = "RecordSet_timeGridType";
    protected static final String TIME_GRID_COLOR = "RecordSet_timeGridColor";
    protected static final String TIME_GRID_LINE_STYLE = "RecordSet_timeGridLineStyle";
    public static final int TIME_GRID_NONE = 0;
    public static final int TIME_GRID_MAIN = 1;
    public static final int TIME_GRID_MOD60 = 2;
    protected int timeGridType = 0;
    protected Vector<Integer> timeGrid = new Vector();
    protected Color timeGridColor;
    protected int timeGridLineStyle;
    public static final String SMART_STATISTICS = "RecordSet_smartStatistics";
    protected static final String CHART_WEIGHT = "RecordSet_chartWeight";
    @Deprecated
    protected static final String VALUE_GRID_RECORD = "RecordSet_horizontalGridRecord";
    protected static final String VALUE_GRID_RECORD_ORDINAL = "RecordSet_horizontalGridRecordOrdinal";
    protected static final String VALUE_GRID_RECORD_NAME = "RecordSet_horizontalGridRecordName";
    protected static final String VALUE_GRID_TYPE = "RecordSet_horizontalGridType";
    protected static final String VALUE_GRID_COLOR = "RecordSet_horizontalGridColor";
    protected static final String VALUE_GRID_LINE_STYLE = "RecordSet_horizontalGridLineStyle";
    public static final int VALUE_GRID_NONE = 0;
    public static final int VALUE_GRID_EVERY = 1;
    public static final int VALUE_GRID_SECOND = 2;
    protected int valueGridType;
    protected Vector<Integer> valueGrid;
    protected Color valueGridColor;
    protected int valueGridLineStyle;
    protected int valueGridRecordOrdinal;
    protected String valueGridRecordName;

    protected AbstractRecordSet(IDevice useDevice, String newName, String[] recordNames) {
        this.timeGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.timeGridLineStyle = 3;
        this.valueGridType = 0;
        this.valueGrid = new Vector();
        this.valueGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.valueGridLineStyle = 2;
        this.valueGridRecordOrdinal = -1;
        this.valueGridRecordName = "";
        this.name = newName;
        this.recordNames = recordNames;
    }

    protected AbstractRecordSet(IDevice useDevice, String newName, String[] measurementNames, TimeSteps newTimeSteps) {
        super(measurementNames.length);
        this.timeGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.timeGridLineStyle = 3;
        this.valueGridType = 0;
        this.valueGrid = new Vector();
        this.valueGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.valueGridLineStyle = 2;
        this.valueGridRecordOrdinal = -1;
        this.valueGridRecordName = "";
        this.name = newName.length() <= 40 ? newName : newName.substring(0, 30);
        this.recordNames = (String[])measurementNames.clone();
        this.timeStep_ms = newTimeSteps;
        this.description = (useDevice != null ? useDevice.getName() + " - " : "") + DESCRIPTION_TEXT_LEAD + StringHelper.getDateAndTime();
    }

    protected AbstractRecordSet(AbstractRecordSet recordSet) {
        super(recordSet);
        this.timeGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.timeGridLineStyle = 3;
        this.valueGridType = 0;
        this.valueGrid = new Vector();
        this.valueGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.valueGridLineStyle = 2;
        this.valueGridRecordOrdinal = -1;
        this.valueGridRecordName = "";
        this.name = recordSet.name;
    }

    protected AbstractRecordSet(AbstractRecordSet recordSet, String[] recordNames) {
        super(recordSet);
        this.timeGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.timeGridLineStyle = 3;
        this.valueGridType = 0;
        this.valueGrid = new Vector();
        this.valueGridColor = DataExplorer.getInstance().COLOR_GREY;
        this.valueGridLineStyle = 2;
        this.valueGridRecordOrdinal = -1;
        this.valueGridRecordName = "";
        this.name = recordSet.name.length() < 40 ? recordSet.name + "_" : recordSet.name.substring(0, 39) + "_";
        this.recordNames = recordNames;
    }

    public String[] getRecordNames() {
        return (String[])this.recordNames.clone();
    }

    public abstract void updateVisibleAndDisplayableRecordsForTable();

    public Vector<? extends AbstractRecord> getVisibleAndDisplayableRecords() {
        return this.visibleAndDisplayableRecords;
    }

    public Vector<? extends AbstractRecord> getDisplayRecords() {
        return this.displayRecords;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    protected static void printRecordNames(String methodName, String[] recordNames) {
        StringBuilder sb = new StringBuilder();
        for (String recordName : recordNames) {
            sb.append(recordName).append(" - ");
        }
        sb.delete(sb.length() - 3, sb.length());
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, methodName, sb.toString());
        }
    }

    public int getAxisPosition(String recordKey, boolean isLeft) {
        int value = -1;
        if (isLeft) {
            for (String recordName : this.recordNames) {
                AbstractRecord tmpRecord = (AbstractRecord)this.get(recordName);
                if (tmpRecord.isPositionLeft() && tmpRecord.isScaleVisible()) {
                    ++value;
                }
                if (!recordName.equals(recordKey)) {
                    continue;
                }
                break;
            }
        } else {
            for (String recordName : this.recordNames) {
                log.log(Level.FINER, "record name = " + recordName);
                AbstractRecord tmpRecord = (AbstractRecord)this.get(recordName);
                if (!tmpRecord.isPositionLeft() && tmpRecord.isScaleVisible()) {
                    ++value;
                }
                if (!recordName.equals(recordKey)) {
                    continue;
                }
                break;
            }
        }
        return value;
    }

    public AbstractRecord get(int recordOrdinal) {
        try {
            return (AbstractRecord)this.get(this.recordNames[recordOrdinal]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return super.size() > 0 ? this.get(0) : null;
        }
    }

    public double getTime_ms(int index) {
        return this.timeStep_ms.getTime_ms(index);
    }

    public double getMaxTime_ms() {
        return this.timeStep_ms == null ? 0.0 : (this.timeStep_ms.isConstant ? this.timeStep_ms.getMaxTime_ms() * (double)(this.get(0).size() - 1) : this.timeStep_ms.getMaxTime_ms());
    }

    public abstract int getChannelConfigNumber();

    public abstract int getValueGridRecordOrdinal();

    public void setValueGridRecordOrdinal(int newValueGridRecordOrdinal) {
        int tmpOrdinal = newValueGridRecordOrdinal;
        if (tmpOrdinal >= this.size()) {
            tmpOrdinal = 0;
        }
        this.valueGridRecordOrdinal = this.scaleSyncedRecords.isOneOfSyncableRecord(this.get(tmpOrdinal).getName()) ? this.scaleSyncedRecords.getSyncMasterRecordOrdinal(this.get(tmpOrdinal).getName()) : tmpOrdinal;
    }

    public int getValueGridType() {
        return this.valueGridType;
    }

    public void setValueGridType(int newValueGridType) {
        this.valueGridType = newValueGridType;
    }

    public Vector<Integer> getValueGrid() {
        return this.valueGrid;
    }

    public void setValueGrid(Vector<Integer> newValueGrid) {
        this.valueGrid = new Vector<Integer>(newValueGrid);
    }

    public Color getValueGridColor() {
        return this.valueGridColor;
    }

    public void setValueGridColor(Color newHorizontalGridColor) {
        this.valueGridColor = newHorizontalGridColor;
    }

    public int getValueGridLineStyle() {
        return this.valueGridLineStyle;
    }

    public void setValueGridLineStyle(int newValueGridLineStyle) {
        this.valueGridLineStyle = newValueGridLineStyle;
    }

    public abstract IDevice getDevice();

    public boolean isSmoothAtCurrentDrop() {
        return this.isSmoothAtCurrentDrop;
    }

    public void setSmoothAtCurrentDrop(boolean enable) {
        this.isSmoothAtCurrentDrop = enable;
    }

    public boolean isSmoothVoltageCurve() {
        return this.isSmoothVoltageCurve;
    }

    public void setSmoothVoltageCurve(boolean enable) {
        this.isSmoothVoltageCurve = enable;
    }

    public void syncScaleOfSyncableRecords() {
        this.scaleSyncedRecords.initSyncedScales(this);
    }

    public void syncMasterSlaveRecords(AbstractRecord syncInputRecord, int type) {
        this.scaleSyncedRecords.syncMasterSlaveRecords(syncInputRecord, type);
    }

    public boolean isOneSyncableVisible(int syncMasterOrdinal) {
        return this.scaleSyncedRecords.isOneSyncableVisible(syncMasterOrdinal);
    }

    public abstract Vector<? extends AbstractRecord> getScaleSyncedRecords(int var1);

    public int realSize() {
        return super.size();
    }

    public boolean isOneOfSyncableRecord(String recordName) {
        return this.scaleSyncedRecords.isOneOfSyncableRecord(recordName);
    }

    public int getSyncMasterRecordOrdinal(String recordName) {
        return this.scaleSyncedRecords.getSyncMasterRecordOrdinal(recordName);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return "AbstractRecordSet [realSize=" + this.realSize() + ", hasDisplayableData=" + this.hasDisplayableData + ", visibleAndDisplayableRecordSize=" + this.visibleAndDisplayableRecords.size() + ", displayRecordSize=" + this.displayRecords.size() + "]";
    }

    public static class SyncedRecords<T extends AbstractRecord>
    extends HashMap<Integer, Vector<T>> {
        private static final long serialVersionUID = -1231656159005000097L;
        private final Logger log = Logger.getLogger(SyncedRecords.class.getName());

        protected SyncedRecords(int initialCapacity) {
            super(initialCapacity);
        }

        boolean isOneOfSyncableRecord(String recordName) {
            return this.getSyncMasterRecordOrdinal(recordName) >= 0;
        }

        int getSyncMasterRecordOrdinal(String recordName) {
            for (Integer syncRecordOrdinal : this.keySet()) {
                if (!this.isRecordContained(syncRecordOrdinal, recordName)) continue;
                return syncRecordOrdinal;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isRecordContained(int syncMasterRecordOrdinal, String recordName) {
            String $METHOD_NAME = "isRecordContained";
            boolean isContained = false;
            SyncedRecords syncedRecords = this;
            synchronized (syncedRecords) {
                if (this.get(syncMasterRecordOrdinal) != null) {
                    for (AbstractRecord tempRecord : (Vector)this.get(syncMasterRecordOrdinal)) {
                        if (this.log.isLoggable(Level.FINER)) {
                            this.log.logp(Level.FINER, $CLASS_NAME, "isRecordContained", "compare " + tempRecord.getName() + " with " + recordName);
                        }
                        if (!tempRecord.getName().equals(recordName)) continue;
                        isContained = true;
                        break;
                    }
                }
            }
            return isContained;
        }

        public void initSyncedScales(AbstractRecordSet recordSet) {
            int i;
            this.clear();
            for (i = 0; i < recordSet.size(); ++i) {
                AbstractRecord tmpRecord = recordSet.get(i);
                int syncMasterRecordOrdinal = tmpRecord.getSyncMasterRecordOrdinal();
                if (syncMasterRecordOrdinal < 0) continue;
                AbstractRecord syncMasterRecord = recordSet.get(syncMasterRecordOrdinal);
                if (this.get(syncMasterRecordOrdinal) == null) {
                    this.put(syncMasterRecordOrdinal, new Vector());
                    ((Vector)this.get(syncMasterRecordOrdinal)).add(syncMasterRecord);
                    syncMasterRecord.setSyncMinMax(Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                if (this.isRecordContained(syncMasterRecordOrdinal, tmpRecord.getName())) continue;
                if (Math.abs(i - syncMasterRecordOrdinal) >= ((Vector)this.get(syncMasterRecordOrdinal)).size()) {
                    ((Vector)this.get(syncMasterRecordOrdinal)).add(tmpRecord);
                } else {
                    ((Vector)this.get(syncMasterRecordOrdinal)).add(Math.abs(i - syncMasterRecordOrdinal), tmpRecord);
                }
                if (!this.log.isLoggable(Level.FINER)) continue;
                this.log.finer(() -> "add " + tmpRecord.getName());
            }
            for (i = 0; i < recordSet.size(); ++i) {
                int syncMasterRecordOrdinal = recordSet.get(i).getSyncMasterRecordOrdinal();
                if (syncMasterRecordOrdinal < 0) continue;
                AbstractRecord syncMasterRecord = recordSet.get(syncMasterRecordOrdinal);
                this.syncMasterSlaveRecords(syncMasterRecord, 0);
                this.syncMasterSlaveRecords(syncMasterRecord, 1);
                this.syncMasterSlaveRecords(syncMasterRecord, 2);
            }
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                for (Integer syncRecordOrdinal : this.keySet()) {
                    sb.append("\n").append(syncRecordOrdinal).append(":");
                    for (AbstractRecord tmpRecord : (Vector)this.get(syncRecordOrdinal)) {
                        sb.append(tmpRecord.getName()).append(";");
                    }
                }
                this.log.log(Level.FINE, sb.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void syncMasterSlaveRecords(AbstractRecord syncInputRecord, int type) {
            block14: for (Integer syncRecordOrdinal : this.keySet()) {
                if (!this.isRecordContained(syncRecordOrdinal, syncInputRecord.getName())) continue;
                switch (type) {
                    case 0: {
                        boolean tmpIsRoundout = syncInputRecord.isRoundOut();
                        boolean tmpIsStartpointZero = syncInputRecord.isStartpointZero();
                        boolean tmpIsStartEndDefined = syncInputRecord.isStartEndDefined();
                        double minScaleValue = syncInputRecord.getMinScaleValue();
                        double maxScaleValue = syncInputRecord.getMaxScaleValue();
                        this.log.log(Level.FINER, "", ((Vector)this.get(syncRecordOrdinal)).size() + " " + ((Vector)this.get(syncRecordOrdinal)).stream().map(r -> r.getName()).collect(Collectors.joining(",")));
                        Iterator iterator = ((Vector)this.get(syncRecordOrdinal)).iterator();
                        while (iterator.hasNext()) {
                            AbstractRecord tmpRecord;
                            AbstractRecord abstractRecord = tmpRecord = (AbstractRecord)iterator.next();
                            synchronized (abstractRecord) {
                                tmpRecord.setRoundOut(tmpIsRoundout);
                                tmpRecord.setStartpointZero(tmpIsStartpointZero);
                                tmpRecord.setStartEndDefined(tmpIsStartEndDefined);
                                tmpRecord.setMinScaleValue(minScaleValue);
                                tmpRecord.setMaxScaleValue(maxScaleValue);
                            }
                            if (!this.log.isLoggable(Level.FINER)) continue;
                            this.log.log(Level.FINER, String.format("%d %s minScaleValue=%.2f maxScaleValue=%.2f isStartEndDefined=%b", syncRecordOrdinal, tmpRecord.getName(), tmpRecord.getMinScaleValue(), tmpRecord.getMaxScaleValue(), tmpIsStartEndDefined));
                        }
                        continue block14;
                    }
                    case 1: {
                        DecimalFormat tmpDf = syncInputRecord.getRealDf();
                        int numberFormat = syncInputRecord.getNumberFormat();
                        Iterator iterator = ((Vector)this.get(syncRecordOrdinal)).iterator();
                        while (iterator.hasNext()) {
                            AbstractRecord tmpRecord;
                            AbstractRecord abstractRecord = tmpRecord = (AbstractRecord)iterator.next();
                            synchronized (abstractRecord) {
                                tmpRecord.setRealDf((DecimalFormat)tmpDf.clone());
                                tmpRecord.setNumberFormatDirect(numberFormat);
                            }
                        }
                        continue block14;
                    }
                    case 2: {
                        boolean tmpIsPositionLeft = syncInputRecord.isPositionLeft();
                        Iterator iterator = ((Vector)this.get(syncRecordOrdinal)).iterator();
                        while (iterator.hasNext()) {
                            AbstractRecord tmpRecord;
                            AbstractRecord abstractRecord = tmpRecord = (AbstractRecord)iterator.next();
                            synchronized (abstractRecord) {
                                tmpRecord.setPositionLeft(tmpIsPositionLeft);
                            }
                        }
                        break;
                    }
                }
            }
        }

        boolean isOneSyncableVisible() {
            for (Integer syncRecordOrdinal : this.keySet()) {
                for (AbstractRecord tmpRecord : (Vector)this.get(syncRecordOrdinal)) {
                    if (tmpRecord == null || !tmpRecord.isVisible()) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isOneSyncableVisible(int syncMasterOrdinal) {
            for (AbstractRecord tmpRecord : (Vector)this.get(syncMasterOrdinal)) {
                if (tmpRecord == null || !tmpRecord.isVisible() || !tmpRecord.isDisplayable()) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "SyncedRecords [isOneSyncableVisible()=" + this.isOneSyncableVisible() + ", size()=" + this.size() + ", keySet()=" + this.keySet() + "]";
        }
    }
}

