/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Polaron;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class PolaronPro
extends Polaron {
    public PolaronPro(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public PolaronPro(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public Polaron.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Polaron.GraupnerDeviceType.PolaronPro;
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVoltage = Integer.MIN_VALUE;
        int minVoltage = Integer.MAX_VALUE;
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        if (deviceDataBufferSize == dataBuffer.length) {
            try {
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)35);
                points[4] = Double.valueOf((double)(points[1] * points[2]) / 1000.0).intValue();
                points[5] = Double.valueOf((double)(points[1] * points[3]) / 1000.0).intValue();
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)37);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[6] = -1 * points[6];
                }
                points[7] = 0;
                int i = 0;
                int j = 0;
                while (i < 7) {
                    points[i + 8] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45));
                    if (points[i + 8] > 0) {
                        maxVoltage = points[i + 8] > maxVoltage ? points[i + 8] : maxVoltage;
                        minVoltage = points[i + 8] < minVoltage ? points[i + 8] : minVoltage;
                    }
                    ++i;
                    j += 2;
                }
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 15] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 159));
                    if (points[i + 15] > 0) {
                        maxVoltage = points[i + 15] > maxVoltage ? points[i + 15] : maxVoltage;
                        minVoltage = points[i + 15] < minVoltage ? points[i + 15] : minVoltage;
                    }
                    ++i;
                    j += 2;
                }
                points[7] = maxVoltage != Integer.MIN_VALUE && minVoltage != Integer.MAX_VALUE ? maxVoltage - minVoltage : 0;
                points[22] = DataParser.parse2Short((byte[])dataBuffer, (int)91);
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 23] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 59));
                    ++i;
                    j += 2;
                }
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 30] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 173));
                    ++i;
                    j += 2;
                }
            }
            catch (Exception e) {
                Polaron.log.log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            try {
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)35);
                points[4] = Double.valueOf((double)(points[0] * points[1]) / 1000.0).intValue();
                points[5] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)37);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[6] = -1 * points[6];
                }
                points[7] = DataParser.parse2Short((byte[])dataBuffer, (int)91);
            }
            catch (NumberFormatException e) {
                Polaron.log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (recordSet.getChannelConfigNumber() == 1) {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                Polaron.log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                points[5] = Double.valueOf((double)points[1] / 1000.0 * (double)points[3]).intValue();
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[7] = 0;
                int j = 0;
                int k = 0;
                while (j < 14) {
                    points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                    if (points[j + 8] > 0) {
                        maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                        minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                points[22] = DataParser.parse2Short((byte[])dataBuffer, (int)91);
                j = 0;
                k = 0;
                while (j < 8) {
                    points[j + 15] = ((convertBuffer[k + 48] & 0xFF) << 24) + ((convertBuffer[k + 49] & 0xFF) << 16) + ((convertBuffer[k + 50] & 0xFF) << 8) + ((convertBuffer[k + 51] & 0xFF) << 0);
                    ++j;
                    k += 4;
                }
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        } else {
            for (int i = 0; i < recordDataSize; ++i) {
                Polaron.log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                points[5] = Double.valueOf((double)points[1] / 1000.0 * (double)points[3]).intValue();
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[7] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{1, 3};
    }

    @Override
    public boolean isLinkedMode(byte[] dataBuffer) {
        return false;
    }
}

