/*
 * Decompiled with CFR 0.152.
 */
package gde.device.igc;

import gde.device.igc.GpsLap;
import gde.utils.StringHelper;
import java.util.HashMap;
import java.util.Vector;

public class GpsTaskResult
extends HashMap<String, String> {
    private static final long serialVersionUID = 3386446540799897163L;
    private Vector<GpsLap> gpsLaps = new Vector();

    public GpsTaskResult() {
    }

    public GpsTaskResult(String input) {
        this.add(input);
    }

    public void addLap(GpsLap lap) {
        this.gpsLaps.add(lap);
    }

    public void add(String input) {
        String[] entries;
        for (String entry : entries = input.substring(input.indexOf(123) + 1, input.length() - 1).split(",")) {
            String[] value = entry.split(":");
            if (value.length != 2) continue;
            this.put(value[0].substring(1, value[0].length() - 1), value[1]);
        }
    }

    public double getAllTrianglesAvgSpeed() {
        return Double.parseDouble((String)this.get("allTrianglesAvgSpeed"));
    }

    public int getAverageTriangleTime() {
        return Double.valueOf((String)this.get("averageTriangleTime")).intValue();
    }

    public long getCurrentTime() {
        return Long.parseLong((String)this.get("currentTime"));
    }

    public double getDistanceCovered() {
        return Double.parseDouble((String)this.get("distanceCovered"));
    }

    public long getFlightStart() {
        return Long.parseLong((String)this.get("flightStart"));
    }

    public int getLaps() {
        return Integer.parseInt((String)this.get("laps"));
    }

    public Vector<GpsLap> getLapsStats() {
        return this.gpsLaps;
    }

    public void addGpsLap(GpsLap lap) {
        this.gpsLaps.add(lap);
    }

    public double getLastStartAltitude() {
        return Double.parseDouble((String)this.get("lastStartAltitude"));
    }

    public long getLastStartCrossing() {
        return Long.parseLong((String)this.get("lastStartCrossing"));
    }

    public double getLastTriangleAvgSpeed() {
        return Double.parseDouble((String)this.get("lastTriangleAvgSpeed"));
    }

    public double getLastTriangleIndex() {
        return Double.parseDouble((String)this.get("lastTriangleIndex"));
    }

    public double getLastTriangleTime() {
        return Double.parseDouble((String)this.get("lastTriangleTime"));
    }

    public int getScoringCode() {
        return Integer.parseInt((String)this.get("scoringCode"));
    }

    public double getStartAltitude() {
        return Double.parseDouble((String)this.get("startAltitude"));
    }

    public double getStartEntryAlti() {
        return Double.parseDouble((String)this.get("startEntryAlti"));
    }

    public double getStartEntrySpeed() {
        return Double.parseDouble((String)this.get("startEntrySpeed"));
    }

    public boolean getSignatureValid() {
        return Boolean.parseBoolean((String)this.get("signatureValid"));
    }

    public int getStartPenaltyPoints() {
        return Integer.parseInt((String)this.get("startPenaltyPoints"));
    }

    public int getTaskHeight() {
        return Integer.parseInt((String)this.get("taskHeight"));
    }

    public int getTaskLength() {
        return Integer.parseInt((String)this.get("taskLength"));
    }

    public int getTimeElapsedSeconds() {
        return Integer.parseInt((String)this.get("timeElapsedSeconds"));
    }

    public double getTriangleAlt() {
        return Double.parseDouble((String)this.get("triangleAlt"));
    }

    public boolean getZoneEntered() {
        return Boolean.parseBoolean((String)this.get("zoneEntered"));
    }

    public String getFormatedTime(int time) {
        int minutes = time / 60;
        return String.format("%2d:%02d", minutes, time - minutes * 60);
    }

    public String toString(String taskType) {
        StringBuilder sb = new StringBuilder("\n\n");
        sb.append(String.format("Task: %s  Date Time: %s  Duration: %s [mm:ss]\n", taskType, StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)this.getFlightStart()), this.getFormatedTime(this.getTimeElapsedSeconds())));
        sb.append(String.format("Start Alt/Speed: %3.0f m/%6.2f km/h  Penalty: %d  SavetyZoneHit: %b\n", this.getStartEntryAlti(), this.getStartEntrySpeed() * 3.6, this.getStartPenaltyPoints(), this.getZoneEntered()));
        sb.append(String.format("Laps: %2d  AvgSpeed: %5.2f km/h  AvgLapTime: %s\n", this.getLaps(), this.getAllTrianglesAvgSpeed() * 3.6, this.getFormatedTime(this.getAverageTriangleTime())));
        sb.append("\nLAP INDEX DURATION LAP-TIME  ALT  \u2206ALT\n");
        int lapNo = 1;
        Double duration = 0.0;
        for (GpsLap lap : this.gpsLaps) {
            sb.append(lap.toString(lapNo++, duration));
            duration = duration + lap.getTime();
        }
        return sb.toString();
    }
}

