/*
 * Decompiled with CFR 0.152.
 */
package gde.device.gpx;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.gpx.GPXAdapter;
import gde.exception.DataInconsitsentException;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GPXDataReaderWriter {
    static Logger log = Logger.getLogger(GPXDataReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber) {
        Channel activeChannel = null;
        int lineNumber = 0;
        String recordSetNameExtend = device.getRecordSetStemNameReplacement();
        RecordSet channelRecordSet = null;
        MenuToolBar menuToolBar = application.getMenuToolBar();
        GDE.getUiNotification().setProgress(0);
        GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT1776") + filePath);
        try {
            activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
            channelConfigNumber = channels.getActiveChannelNumber();
            if (activeChannel != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, device.getChannelCount() + " - data for channel = " + channelConfigNumber);
                }
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                recordSetName = recordNameExtend.length() > 2 ? recordSetName + " [" + recordNameExtend + "]" : recordSetName;
                GDE.getUiNotification().setProgress(30);
                GPXDataReaderWriter.parseInputXML(filePath, device, activeChannel, recordSetName);
                channelRecordSet = (RecordSet)activeChannel.get((Object)recordSetName);
                if (channelRecordSet != null) {
                    channelRecordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                }
                GDE.getUiNotification().setProgress(100);
                if (GDE.isWithUi()) {
                    Channels.getInstance().switchChannel(activeChannel.getName());
                    activeChannel.switchRecordSet(recordSetName);
                    device.updateVisibilityStatus(channelRecordSet, true);
                    channelRecordSet.updateVisibleAndDisplayableRecordsForTable();
                    menuToolBar.updateChannelSelector();
                    menuToolBar.updateRecordSetSelectCombo();
                }
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            if (activeChannel != null && activeChannel.size() > 0) {
                String recordSetName = activeChannel.getFirstRecordSetName();
                activeChannel.setActiveRecordSet(recordSetName);
                device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet(recordSetName);
                }
            }
            String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
            log.log(Level.WARNING, msg, e);
            application.openMessageDialog(msg);
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
        return channelRecordSet;
    }

    public static void parseInputXML(String localUnixFullQualifiedPath, final IDevice device, final Channel activeChannel, final String recordSetName) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", "file:/resource/gpx.xsd");
        DefaultHandler handler = new DefaultHandler(){
            boolean isDescription = false;
            boolean isDescription2 = false;
            boolean isElevation = false;
            boolean isTime = false;
            boolean isDateSet = false;
            boolean isNumSatelites = false;
            boolean isSpeed = false;
            Boolean isExtensionFirstCalled = null;
            boolean isExtension = false;
            final int[] date = new int[3];
            final int[] time = new int[3];
            long timeStamp = 0L;
            long startTimeStamp = 0L;
            final Map<String, String> tmpPoints = new LinkedHashMap<String, String>();
            final Vector<String> extensionNames = new Vector();
            String extensionName = "";
            int[] points = new int[device.getNumberOfMeasurements(activeChannel.getNumber())];
            int pointsIndex = 0;
            RecordSet activeRecordSet;
            String recordSetDescription = "";

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Start Element :" + qName);
                }
                if (qName != null && qName.length() > 1) {
                    if (qName.equalsIgnoreCase("text")) {
                        this.isDescription = true;
                    } else if (qName.equalsIgnoreCase("desc")) {
                        this.isDescription2 = true;
                    } else if (qName.equalsIgnoreCase("trkpt")) {
                        if (attributes.getLength() == 2) {
                            this.tmpPoints.put("lat", attributes.getValue("lat"));
                            this.tmpPoints.put("lon", attributes.getValue("lon"));
                        }
                    } else if (qName.equalsIgnoreCase("ele")) {
                        this.isElevation = true;
                    } else if (qName.equalsIgnoreCase("time")) {
                        this.isTime = true;
                    } else if (qName.equalsIgnoreCase("sat")) {
                        this.isNumSatelites = true;
                    } else if (qName.equalsIgnoreCase("speed")) {
                        this.isSpeed = true;
                    } else if (qName.equalsIgnoreCase("extensions")) {
                        this.isExtension = true;
                        if (this.isExtensionFirstCalled == null) {
                            this.isExtensionFirstCalled = true;
                        }
                    } else if (this.isExtension) {
                        this.extensionName = qName;
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "End Element :" + qName);
                }
                if (qName.equalsIgnoreCase("trkpt")) {
                    this.pointsIndex = 0;
                    this.points[this.pointsIndex++] = (int)(Double.valueOf(this.tmpPoints.get("lat").replace("+", "").trim()) * 1000000.0);
                    this.points[this.pointsIndex++] = (int)(Double.valueOf(this.tmpPoints.get("lon").replace("+", "").trim()) * 1000000.0);
                    this.points[this.pointsIndex++] = this.tmpPoints.get("ele") != null ? (int)(Double.valueOf(this.tmpPoints.get("ele").trim()) * 1000.0) : 0;
                    this.points[this.pointsIndex++] = this.tmpPoints.get("sat") != null ? Integer.valueOf(this.tmpPoints.get("sat").trim()) * 1000 : 0;
                    int n = this.points[this.pointsIndex++] = this.tmpPoints.get("speed") != null ? (int)(Double.valueOf(this.tmpPoints.get("speed").trim()) * 1000.0) : 0;
                    if (this.isExtensionFirstCalled != null || !this.isExtension) {
                        if (this.isExtensionFirstCalled == null || this.isExtensionFirstCalled.booleanValue()) {
                            int measurementSize = device.getNumberOfMeasurements(activeChannel.getNumber());
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "measurementSize = " + measurementSize);
                            }
                            Vector<String> vecRecordNames = new Vector<String>();
                            for (int i = 0; i < 5; ++i) {
                                vecRecordNames.add(device.getMeasurementNamesReplacements(activeChannel.getNumber())[i]);
                            }
                            for (String tmpExtensionName : this.extensionNames) {
                                if (GPXAdapter.ignoreMap.get(tmpExtensionName.split(" ")[0]) != null) continue;
                                String[] values = this.tmpPoints.get(tmpExtensionName).split(",");
                                for (int i = 0; i < values.length && this.points.length - this.pointsIndex > 0; ++i) {
                                    String newRecordName = tmpExtensionName + (values.length > 1 ? " " + (i + 1) : "");
                                    vecRecordNames.add(newRecordName);
                                    try {
                                        this.points[this.pointsIndex] = (int)(Double.valueOf(values[i].trim()) * 1000.0);
                                    }
                                    catch (NumberFormatException e) {
                                        try {
                                            if (values[i].indexOf(120) >= 0) {
                                                this.points[this.pointsIndex] = Integer.valueOf(values[i].substring(values[i].indexOf(120) + 1).trim(), 16) * 1000;
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    ++this.pointsIndex;
                                }
                            }
                            String[] recordNames = vecRecordNames.toArray(new String[0]);
                            String[] recordSymbols = new String[recordNames.length];
                            String[] recordUnits = new String[recordNames.length];
                            String referenceName = "";
                            int referenceOrdinal = -1;
                            for (int i = 0; i < recordNames.length; ++i) {
                                MeasurementType measurement = device.getMeasurement(activeChannel.getNumber(), i);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, recordNames[i]);
                                }
                                measurement.setName(recordNames[i]);
                                recordSymbols[i] = measurement.getSymbol();
                                recordUnits[i] = measurement.getUnit();
                                if (GPXAdapter.unitMap.size() > 0 && i > 3) {
                                    if (GPXAdapter.unitMap.get(recordNames[i].split(" ")[0]) != null) {
                                        recordUnits[i] = GPXAdapter.unitMap.get(recordNames[i].split(" ")[0]);
                                        measurement.setUnit(recordUnits[i]);
                                    } else if (!measurement.getUnit().isEmpty()) {
                                        measurement.setUnit("");
                                    }
                                }
                                if (GPXAdapter.symbolMap.size() > 0 && i > 3) {
                                    if (GPXAdapter.symbolMap.get(recordNames[i].split(" ")[0]) != null) {
                                        recordUnits[i] = GPXAdapter.symbolMap.get(recordNames[i].split(" ")[0]);
                                        measurement.setSymbol(recordUnits[i]);
                                    } else if (!measurement.getSymbol().isEmpty()) {
                                        measurement.setSymbol("");
                                    }
                                }
                                if (GPXAdapter.factorMap.size() > 0 && i > 3) {
                                    if (GPXAdapter.factorMap.get(recordNames[i].split(" ")[0]) != null) {
                                        measurement.setFactor(GPXAdapter.factorMap.get(recordNames[i].split(" ")[0]).doubleValue());
                                    } else if (measurement.getFactor() != 1.0) {
                                        measurement.setFactor(1.0);
                                    }
                                }
                                if (GPXAdapter.offsetMap.size() > 0 && i > 3) {
                                    if (GPXAdapter.offsetMap.get(recordNames[i].split(" ")[0]) != null) {
                                        measurement.setOffset(GPXAdapter.factorMap.get(recordNames[i].split(" ")[0]).doubleValue());
                                    } else if (measurement.getOffset() != 0.0) {
                                        measurement.setOffset(0.0);
                                    }
                                }
                                if (GPXAdapter.reductionMap.size() > 0 && i > 3) {
                                    if (GPXAdapter.reductionMap.get(recordNames[i].split(" ")[0]) != null) {
                                        measurement.setReduction(GPXAdapter.factorMap.get(recordNames[i].split(" ")[0]).doubleValue());
                                    } else if (measurement.getReduction() != 0.0) {
                                        measurement.setReduction(0.0);
                                    }
                                }
                                if (GPXAdapter.syncMap.size() > 0 && i > 3) {
                                    if (GPXAdapter.syncMap.get(recordNames[i].split(" ")[0]) != null && recordNames[i].split(" ").length > 1 && recordNames[i].split(" ")[1] != null && recordNames[i].split(" ")[1].equals("1")) {
                                        referenceName = recordNames[i].split(" ")[0];
                                        referenceOrdinal = i;
                                    } else if (GPXAdapter.syncMap.get(recordNames[i].split(" ")[0]) != null && recordNames[i].split(" ")[0].equals(referenceName) && recordNames[i].split(" ")[1] != null && recordNames[i].split(" ").length > 1 && !recordNames[i].split(" ")[1].equals("1")) {
                                        device.setMeasurementPropertyValue(activeChannel.getNumber(), i, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, (Object)referenceOrdinal);
                                    } else {
                                        ((DeviceConfiguration)device).removeMeasruementProperty(activeChannel.getNumber(), i, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value());
                                    }
                                }
                                if (GPXAdapter.languageMap.get(recordNames[i].split(" ")[0]) == null) continue;
                                recordNames[i] = GPXAdapter.languageMap.get(recordNames[i].split(" ")[0]) + (recordNames[i].split(" ").length > 1 ? recordNames[i].substring(recordNames[i].indexOf(32)) : " ");
                                measurement.setName(recordNames[i]);
                            }
                            this.activeRecordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannel.getNumber(), (String[])recordNames, (String[])recordSymbols, (String[])recordUnits, (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
                            String correctedRecordSetName = this.activeRecordSet.getName();
                            activeChannel.put((Object)correctedRecordSetName, (Object)this.activeRecordSet);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, correctedRecordSetName + " created for channel " + activeChannel.getName());
                            }
                            activeChannel.setActiveRecordSet(correctedRecordSetName);
                            this.activeRecordSet = (RecordSet)activeChannel.get((Object)recordSetName);
                            activeChannel.applyTemplate(recordSetName, false);
                            int[] newPoints = new int[this.activeRecordSet.size()];
                            for (int i = 0; i < newPoints.length; ++i) {
                                newPoints[i] = this.points[i];
                            }
                            this.points = newPoints;
                            this.isExtensionFirstCalled = false;
                        } else if (!this.isExtensionFirstCalled.booleanValue()) {
                            for (String tmpExtensionName : this.extensionNames) {
                                if (GPXAdapter.ignoreMap.get(tmpExtensionName.split(" ")[0]) != null) continue;
                                String[] values = this.tmpPoints.get(tmpExtensionName).split(",");
                                for (int i = 0; i < values.length && this.points.length - this.pointsIndex > 0; ++i) {
                                    try {
                                        this.points[this.pointsIndex] = (int)(Double.valueOf(values[i].trim()) * 1000.0);
                                    }
                                    catch (NumberFormatException e) {
                                        try {
                                            if (values[i].indexOf(120) >= 0) {
                                                this.points[this.pointsIndex] = Integer.valueOf(values[i].substring(values[i].indexOf(120) + 1).trim(), 16) * 1000;
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    ++this.pointsIndex;
                                }
                            }
                        }
                    }
                    try {
                        if (this.startTimeStamp == 0L) {
                            this.startTimeStamp = this.timeStamp;
                        }
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "" + (double)(this.timeStamp - this.startTimeStamp) * 1.0);
                        }
                        if (this.activeRecordSet != null) {
                            this.activeRecordSet.addPoints(this.points, (double)(this.timeStamp - this.startTimeStamp) * 1.0);
                        }
                    }
                    catch (DataInconsitsentException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                String values = new String(ch, start, length);
                if (!values.contains("\n") && !values.contains("\r")) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, values);
                    }
                    if (this.isDescription) {
                        this.recordSetDescription = GDE.LINE_SEPARATOR + new String(ch, start, length);
                        this.isDescription = false;
                    } else if (this.isDescription2) {
                        this.recordSetDescription = this.recordSetDescription.length() > 1 ? this.recordSetDescription + ":" + " " + new String(ch, start, length) : GDE.LINE_SEPARATOR + new String(ch, start, length);
                        this.isDescription2 = false;
                    } else if (this.isElevation) {
                        this.tmpPoints.put("ele", new String(ch, start, length));
                        this.isElevation = false;
                    } else if (this.isTime) {
                        String dateTime = new String(ch, start, length);
                        if (!this.isDateSet) {
                            String strDate = dateTime.split("T")[0];
                            this.date[0] = Integer.parseInt(strDate.substring(0, 4));
                            this.date[1] = Integer.parseInt(strDate.substring(5, 7));
                            this.date[2] = Integer.parseInt(strDate.substring(8, 10));
                        }
                        String strValueTime = dateTime.split("T|Z")[1];
                        this.time[0] = Integer.parseInt(strValueTime.substring(0, 2));
                        this.time[1] = Integer.parseInt(strValueTime.substring(3, 5));
                        this.time[2] = Integer.parseInt(strValueTime.substring(6, 8));
                        GregorianCalendar calendar = new GregorianCalendar(this.date[0], this.date[1] - 1, this.date[2], this.time[0], this.time[1], this.time[2]);
                        this.timeStamp = calendar.getTimeInMillis() + (long)(strValueTime.contains(".") ? Integer.parseInt(strValueTime.substring(strValueTime.indexOf(46) + 1)) : 0);
                        if (!this.isDateSet && this.isExtensionFirstCalled != null) {
                            String description = this.activeRecordSet.getRecordSetDescription();
                            this.activeRecordSet.setRecordSetDescription(description.substring(0, description.indexOf(58) + 2) + StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)this.startTimeStamp) + this.recordSetDescription);
                            this.activeRecordSet.setStartTimeStamp(this.startTimeStamp);
                            this.isDateSet = true;
                        }
                        this.isTime = false;
                    } else if (this.isNumSatelites) {
                        this.tmpPoints.put("sat", new String(ch, start, length));
                        this.isNumSatelites = false;
                    } else if (this.isSpeed) {
                        this.tmpPoints.put("speed", new String(ch, start, length));
                        this.isSpeed = false;
                    } else if (this.isExtension && this.extensionName.length() > 3) {
                        if (this.isExtensionFirstCalled != null && this.isExtensionFirstCalled.booleanValue()) {
                            this.extensionNames.add(this.extensionName);
                        }
                        this.tmpPoints.put(this.extensionName, new String(ch, start, length));
                    }
                }
            }
        };
        saxParser.parse(localUnixFullQualifiedPath, handler);
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

