/*
 * Decompiled with CFR 0.152.
 */
package gde.device.ardupilot;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.ardupilot.ArduPilotLogReader;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ArduPilot
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(ArduPilot.class.getName());
    protected final DataExplorer application;
    protected final Channels channels;
    protected final Settings settings = Settings.getInstance();

    public static Object parseValue(String fmt, String value) throws NumberFormatException {
        switch (fmt.charAt(0)) {
            case 'a': {
                short[] parsedValue = new short[32];
                int index = 0;
                for (byte b : value.getBytes()) {
                    parsedValue[index++] = b;
                }
                return parsedValue;
            }
            case 'B': 
            case 'b': {
                return Byte.valueOf(value) * 1000;
            }
            case 'H': 
            case 'h': {
                return Short.valueOf(value) * 1000;
            }
            case 'I': 
            case 'i': {
                return Integer.valueOf(value) * 1000;
            }
            case 'f': {
                return Float.valueOf(value).intValue() * 1000;
            }
            case 'd': {
                return Double.valueOf(value).intValue() * 1000;
            }
            case 'n': {
                char[] char4 = new char[4];
                for (int i = 0; i < char4.length; ++i) {
                    char4[i] = (char)value.getBytes()[i];
                }
                return char4;
            }
            case 'N': {
                char[] char16 = new char[16];
                for (int i = 0; i < char16.length; ++i) {
                    char16[i] = (char)value.getBytes()[i];
                }
                return char16;
            }
            case 'Z': {
                char[] char64 = new char[64];
                for (int i = 0; i < char64.length; ++i) {
                    char64[i] = (char)value.getBytes()[i];
                }
                return char64;
            }
            case 'C': 
            case 'c': {
                return Short.valueOf(value.replace(".", "")) * 1000;
            }
            case 'E': 
            case 'e': {
                return Integer.valueOf(value.replace(".", "")) * 1000;
            }
            default: {
                return Integer.valueOf(value.replace(".", ""));
            }
            case 'M': {
                return Byte.valueOf(value) * 1000;
            }
            case 'Q': 
            case 'q': 
        }
        return Long.valueOf(value) * 1000L;
    }

    public static String getUnit(String s) {
        switch (s.charAt(0)) {
            case '-': {
                return "";
            }
            case '?': {
                return "UNKNOWN";
            }
            case 'A': {
                return "A";
            }
            case 'd': {
                return "\u00b0";
            }
            case 'b': {
                return "B";
            }
            case 'k': {
                return "\u00b0/s";
            }
            case 'D': {
                return "\u00b0";
            }
            case 'e': {
                return "\u00b0/s/s";
            }
            case 'E': {
                return "rad/s";
            }
            case 'G': {
                return "Gauss";
            }
            case 'h': {
                return "\u00b0";
            }
            case 'i': {
                return "A.s";
            }
            case 'J': {
                return "W.s";
            }
            case 'L': {
                return "rad/s/s";
            }
            case 'm': {
                return "m";
            }
            case 'n': {
                return "m/s";
            }
            case 'o': {
                return "m/s/s";
            }
            case 'O': {
                return "\u00b0C";
            }
            case '%': {
                return "%";
            }
            case 'S': {
                return "satellites";
            }
            case 's': {
                return "s";
            }
            case 'q': {
                return "rpm";
            }
            case 'r': {
                return "rad";
            }
            case 'U': {
                return "\u00b0";
            }
            case 'u': {
                return "ppm";
            }
            case 'Y': {
                return "us";
            }
            case 'v': {
                return "V";
            }
            case 'P': {
                return "Pa";
            }
            case 'w': {
                return "\u03a9";
            }
            case 'z': {
                return "Hz";
            }
        }
        return "";
    }

    public static double getMults(String s) {
        switch (s.charAt(0)) {
            case '-': {
                return 0.0;
            }
            case '?': {
                return 1.0;
            }
            case '2': {
                return 100.0;
            }
            case '1': {
                return 10.0;
            }
            case '0': {
                return 1.0;
            }
            case 'A': {
                return 0.1;
            }
            case 'B': {
                return 0.01;
            }
            case 'C': {
                return 0.001;
            }
            case 'D': {
                return 1.0E-4;
            }
            case 'E': {
                return 1.0E-5;
            }
            case 'F': {
                return 1.0E-6;
            }
            case 'G': {
                return 1.0E-7;
            }
            case '!': {
                return 3.6;
            }
            case '/': {
                return 3600.0;
            }
        }
        return 0.0;
    }

    public ArduPilot(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.ardupilot.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT4000"), Messages.getString((String)"GDE_MSGT4000"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
    }

    public ArduPilot(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.ardupilot.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT4000"), Messages.getString((String)"GDE_MSGT4000"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT4005", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT4005"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "importDeviceLogItem action performed! " + e);
                    ArduPilot.this.importLogFiles();
                }
            });
        }
    }

    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT4002"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZ3DRelativeItem action performed! " + e);
                    ArduPilot.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT4003"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZDAbsoluteItem action performed! " + e);
                    ArduPilot.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT4004"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZDAbsoluteItem action performed! " + e);
                    ArduPilot.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT4001"), this.findRecordByType(activeRecordSet, Record.DataType.GPS_LONGITUDE), this.findRecordByType(activeRecordSet, Record.DataType.GPS_LATITUDE), this.findRecordByType(activeRecordSet, Record.DataType.GPS_ALTITUDE), this.findRecordByUnit(activeRecordSet, "km/h"), this.findRecordByUnit(activeRecordSet, "m/s"), this.findRecordByUnit(activeRecordSet, "km"), -1, type == 0, type == 2);
    }

    private int findRecordByUnit(RecordSet recordSet, String unit) {
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (!record.getUnit().equalsIgnoreCase(unit)) continue;
            return record.getOrdinal();
        }
        return -1;
    }

    private int findRecordByType(RecordSet recordSet, Record.DataType dataType) {
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (!record.getDataType().equals((Object)dataType) || !record.hasReasonableData()) continue;
            return record.getOrdinal();
        }
        return -1;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            exportFileName = new FileHandler().exportFileKMZ(activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_ALTITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED), -1, -1, -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return null;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return null;
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(java.util.logging.Level.FINER)) {
                log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        return recordSet.getRecordNames();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double factor = record.getFactor();
                Record.DataType dataType = record.getDataType();
                dataTableRow[index + 1] = dataType == Record.DataType.GPS_LATITUDE || dataType == Record.DataType.GPS_LONGITUDE ? String.format("%09.6f", (double)record.realGet(rowIndex).intValue() * factor) : record.getDecimalFormat().format(offset + (double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        Record.DataType dataType = record.getDataType();
        double newValue = dataType == Record.DataType.GPS_LATITUDE || dataType == Record.DataType.GPS_LONGITUDE ? 1000.0 * value * factor : value * factor;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        Record.DataType dataType = record.getDataType();
        double newValue = dataType == Record.DataType.GPS_LATITUDE || dataType == Record.DataType.GPS_LONGITUDE ? 1000.0 * value / factor : value / factor;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (String measurementKey : recordSet.keySet()) {
                    Record record = recordSet.get((Object)measurementKey);
                    if (!record.isActive() || record.getOrdinal() > 6 && !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        recordSet.setAllDisplayable();
        for (i = 0; i < recordSet.realSize(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (!log.isLoggable(java.util.logging.Level.FINER)) continue;
            log.log(java.util.logging.Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(java.util.logging.Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.FACTOR, Record.DataType.GPS_LATITUDE.value(), Record.DataType.GPS_LONGITUDE.value(), Record.DataType.GPS_ALTITUDE.value(), Record.DataType.GPS_AZIMUTH.value(), Record.DataType.GPS_SPEED.value(), "statistics"};
    }

    public boolean isVariableMeasurementSize() {
        return true;
    }

    public String[] getNoneCalculationMeasurementNames(int channelConfigNumber, String[] validMeasurementNames) {
        return validMeasurementNames;
    }

    public void open_closeCommPort() {
        this.importLogFiles();
    }

    public void importLogFiles() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT4000"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArduPilot.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            RecordSet activeRecordSet = ArduPilotLogReader.read(ArduPilot.this.getDataBlockSeparator().value().charAt(0), selectedImportFile, ArduPilot.this.getRecordSetStemNameReplacement());
                            ArduPilot.this.updateVisibilityStatus(activeRecordSet, true);
                            activeRecordSet.descriptionAppendFilename(selectedImportFile);
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    ArduPilot.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getDataType() == Record.DataType.GPS_LATITUDE || record.getDataType() == Record.DataType.GPS_LONGITUDE;
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.containsGPSdata();
        }
        return containsGPSdata;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        RecordSet activeRecordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && this.isActualRecordSetWithGpsData()) {
            int recordOrdinal = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED);
            return recordOrdinal >= 0 ? recordOrdinal : activeRecordSet.findRecordOrdinalByUnit(new String[]{"km/h", "kph"});
        }
        return -1;
    }

    public static enum ARSP {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Airspeed("f", "n", "0"),
        DiffPress("f", "P", "0"),
        Temp("f", "O", "B"),
        RawPress("f", "P", "0"),
        Offset("f", "P", "0"),
        U("B", "-", "-"),
        Health("B", "-", "-"),
        Primary("B", "-", "-");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final ARSP[] VALUES;

        private ARSP(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (ARSP arsp : VALUES) {
                if (!arsp.name().equals(entry)) continue;
                return arsp.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (ARSP arsp : VALUES) {
                if (!arsp.name().equals(entry)) continue;
                return arsp.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (ARSP arsp : VALUES) {
                if (!arsp.name().equals(entry)) continue;
                return ArduPilot.getUnit(arsp.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (ARSP arsp : VALUES) {
                if (!arsp.name().equals(entry)) continue;
                return ArduPilot.getMults(arsp.mults);
            }
            return 1.0;
        }

        static {
            VALUES = ARSP.values();
        }
    }

    public static enum CURR_CELL {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Volt("f", "v", "0"),
        V1("H", "v", "0"),
        V2("H", "v", "0"),
        V3("H", "v", "0"),
        V4("H", "v", "0"),
        V5("H", "v", "0"),
        V6("H", "v", "0"),
        V7("H", "v", "0"),
        V8("H", "v", "0"),
        V9("H", "v", "0"),
        V10("H", "v", "0");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final CURR_CELL[] VALUES;

        private CURR_CELL(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (CURR_CELL cell : VALUES) {
                if (!cell.name().equals(entry)) continue;
                return cell.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (CURR_CELL cell : VALUES) {
                if (!cell.name().equals(entry)) continue;
                return cell.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (CURR_CELL cell : VALUES) {
                if (!cell.name().equals(entry)) continue;
                return ArduPilot.getUnit(cell.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (CURR_CELL cell : VALUES) {
                if (!cell.name().equals(entry)) continue;
                return ArduPilot.getMults(cell.mults);
            }
            return 1.0;
        }

        static {
            VALUES = CURR_CELL.values();
        }
    }

    public static enum CURR {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Volt("f", "v", "0"),
        VoltR("f", "v", "0"),
        Curr("f", "A", "0"),
        CurrTot("f", "?", "?"),
        EnrgTot("f", "J", "/"),
        Temp("c", "O", "?"),
        Res("f", "w", "0");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final CURR[] VALUES;

        private CURR(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (CURR curr : VALUES) {
                if (!curr.name().equals(entry)) continue;
                return curr.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (CURR curr : VALUES) {
                if (!curr.name().equals(entry)) continue;
                return curr.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (CURR curr : VALUES) {
                if (!curr.name().equals(entry)) continue;
                return ArduPilot.getUnit(curr.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (CURR curr : VALUES) {
                if (!curr.name().equals(entry)) continue;
                return ArduPilot.getMults(curr.mults);
            }
            return 1.0;
        }

        static {
            VALUES = CURR.values();
        }
    }

    public static enum QUAT {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Q1("f", "?", "?"),
        Q2("f", "?", "?"),
        Q3("f", "?", "?"),
        Q4("f", "?", "?");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final QUAT[] VALUES;

        private QUAT(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (QUAT quad : VALUES) {
                if (!quad.name().equals(entry)) continue;
                return quad.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (QUAT quat : VALUES) {
                if (!quat.name().equals(entry)) continue;
                return quat.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (QUAT quat : VALUES) {
                if (!quat.name().equals(entry)) continue;
                return ArduPilot.getUnit(quat.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (QUAT quat : VALUES) {
                if (!quat.name().equals(entry)) continue;
                return ArduPilot.getMults(quat.mults);
            }
            return 1.0;
        }

        static {
            VALUES = QUAT.values();
        }
    }

    public static enum PID {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Des("f", "-", "-"),
        Act("f", "-", "-"),
        P("f", "-", "-"),
        I("f", "-", "-"),
        D("f", "-", "-"),
        FF("f", "-", "-");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final PID[] VALUES;

        private PID(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (PID pid : VALUES) {
                if (!pid.name().equals(entry)) continue;
                return pid.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (PID pid : VALUES) {
                if (!pid.name().equals(entry)) continue;
                return pid.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (PID pid : VALUES) {
                if (!pid.name().equals(entry)) continue;
                return ArduPilot.getUnit(pid.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (PID pid : VALUES) {
                if (!pid.name().equals(entry)) continue;
                return ArduPilot.getMults(pid.mults);
            }
            return 1.0;
        }

        static {
            VALUES = PID.values();
        }
    }

    public static enum MAG {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        MagX("h", "G", "C"),
        MagY("h", "G", "C"),
        MagZ("h", "G", "C"),
        OfsX("h", "G", "C"),
        OfsY("h", "G", "C"),
        OfsZ("h", "G", "C"),
        MOfsX("h", "G", "C"),
        MOfsY("h", "G", "C"),
        MOfsZ("h", "G", "C"),
        Health("B", "-", "-"),
        S("I", "s", "F");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final MAG[] VALUES;

        private MAG(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (MAG mag : VALUES) {
                if (!mag.name().equals(entry)) continue;
                return mag.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (MAG mag : VALUES) {
                if (!mag.name().equals(entry)) continue;
                return mag.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (MAG mag : VALUES) {
                if (!mag.name().equals(entry)) continue;
                return ArduPilot.getUnit(mag.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (MAG mag : VALUES) {
                if (!mag.name().equals(entry)) continue;
                return ArduPilot.getMults(mag.mults);
            }
            return 1.0;
        }

        static {
            VALUES = MAG.values();
        }
    }

    public static enum IMU {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        GyrX("f", "E", "0"),
        GyrY("f", "E", "0"),
        GyrZ("f", "E", "0"),
        AccX("f", "o", "0"),
        AccY("f", "o", "0"),
        AccZ("f", "o", "0"),
        EG("I", "-", "-"),
        EA("I", "-", "-"),
        T("f", "O", "-"),
        GH("B", "-", "-"),
        AH("B", "-", "-"),
        GHz("H", "z", "0"),
        AHz("H", "z", "0");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final IMU[] VALUES;

        private IMU(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (IMU imu : VALUES) {
                if (!imu.name().equals(entry)) continue;
                return imu.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (IMU imu : VALUES) {
                if (!imu.name().equals(entry)) continue;
                return imu.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (IMU imu : VALUES) {
                if (!imu.name().equals(entry)) continue;
                return ArduPilot.getUnit(imu.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (IMU imu : VALUES) {
                if (!imu.name().equals(entry)) continue;
                return ArduPilot.getMults(imu.mults);
            }
            return 1.0;
        }

        static {
            VALUES = IMU.values();
        }
    }

    public static enum ISBD {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        N("H", "-", "-"),
        seqno("H", "-", "-"),
        x("a", "o", "?"),
        y("a", "o", "?"),
        z("a", "o", "?");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final ISBD[] VALUES;

        private ISBD(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (ISBD isbd : VALUES) {
                if (!isbd.name().equals(entry)) continue;
                return isbd.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (ISBD isbd : VALUES) {
                if (!isbd.name().equals(entry)) continue;
                return isbd.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (ISBD isbd : VALUES) {
                if (!isbd.name().equals(entry)) continue;
                return ArduPilot.getUnit(isbd.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (ISBD isbd : VALUES) {
                if (!isbd.name().equals(entry)) continue;
                return ArduPilot.getMults(isbd.mults);
            }
            return 1.0;
        }

        static {
            VALUES = ISBD.values();
        }
    }

    public static enum ISBH {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        N("H", "-", "-"),
        type("B", "-", "-"),
        instance("B", "-", "-"),
        mul("H", "-", "-"),
        smp_cnt("H", "-", "-"),
        SampleUS("Q", "s", "F"),
        Sample("Q", "s", "F"),
        smp_rate("f", "z", "-");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final ISBH[] VALUES;

        private ISBH(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (ISBH isbh : VALUES) {
                if (!isbh.name().equals(entry)) continue;
                return isbh.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (ISBH isbh : VALUES) {
                if (!isbh.name().equals(entry)) continue;
                return isbh.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (ISBH isbh : VALUES) {
                if (!isbh.name().equals(entry)) continue;
                return ArduPilot.getUnit(isbh.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (ISBH isbh : VALUES) {
                if (!isbh.name().equals(entry)) continue;
                return ArduPilot.getMults(isbh.mults);
            }
            return 1.0;
        }

        static {
            VALUES = ISBH.values();
        }
    }

    public static enum IMT {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        DelT("f", "s", "F"),
        DelvT("f", "s", "0"),
        DelaT("f", "s", "0"),
        DelAX("f", "r", "0"),
        DelAY("f", "r", "0"),
        DelAZ("f", "r", "0"),
        DelVX("f", "n", "0"),
        DelVY("f", "n", "0"),
        DelVZ("f", "n", "0");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final IMT[] VALUES;

        private IMT(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (IMT imt : VALUES) {
                if (!imt.name().equals(entry)) continue;
                return imt.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (IMT imt : VALUES) {
                if (!imt.name().equals(entry)) continue;
                return imt.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (IMT imt : VALUES) {
                if (!imt.name().equals(entry)) continue;
                return ArduPilot.getUnit(imt.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (IMT imt : VALUES) {
                if (!imt.name().equals(entry)) continue;
                return ArduPilot.getMults(imt.mults);
            }
            return 1.0;
        }

        static {
            VALUES = IMT.values();
        }
    }

    public static enum GYR {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        SampleUS("Q", "s", "F"),
        Sample("Q", "s", "F"),
        GyrX("f", "E", "0"),
        GyrY("f", "E", "0"),
        GyrZ("f", "E", "0");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final GYR[] VALUES;

        private GYR(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (GYR gyr : VALUES) {
                if (!gyr.name().equals(entry)) continue;
                return gyr.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (GYR gyr : VALUES) {
                if (!gyr.name().equals(entry)) continue;
                return gyr.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (GYR gyr : VALUES) {
                if (!gyr.name().equals(entry)) continue;
                return ArduPilot.getUnit(gyr.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (GYR gyr : VALUES) {
                if (!gyr.name().equals(entry)) continue;
                return ArduPilot.getMults(gyr.mults);
            }
            return 1.0;
        }

        static {
            VALUES = GYR.values();
        }
    }

    public static enum GPS {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Status("B", "-", "-"),
        GMS("I", "-", "-"),
        GWk("H", "-", "-"),
        NSats("B", "S", "0"),
        HDop("c", "m", "B"),
        Lat("L", "D", "G"),
        Lng("L", "U", "G"),
        Alt("e", "m", "B"),
        RelAlt("e", "m", "B"),
        Spd("f", "n", "0"),
        GCrs("f", "h", "0"),
        VZ("f", "n", "0"),
        U("B", "-", "-");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final GPS[] VALUES;

        private GPS(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (GPS gps : VALUES) {
                if (!gps.name().equals(entry)) continue;
                return gps.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (GPS gps : VALUES) {
                if (!gps.name().equals(entry)) continue;
                return gps.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (GPS gps : VALUES) {
                if (!gps.name().equals(entry)) continue;
                return ArduPilot.getUnit(gps.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (GPS gps : VALUES) {
                if (!gps.name().equals(entry)) continue;
                return ArduPilot.getMults(gps.mults);
            }
            return 1.0;
        }

        static {
            VALUES = GPS.values();
        }
    }

    public static enum GPA {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        VDop("C", "m", "B"),
        HAcc("C", "m", "B"),
        VAcc("C", "m", "B"),
        SAcc("C", "n", "B"),
        VV("B", "-", "-"),
        SMS("I", "s", "C"),
        Delta("H", "s", "F");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final GPA[] VALUES;

        private GPA(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (GPA gpa : VALUES) {
                if (!gpa.name().equals(entry)) continue;
                return gpa.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (GPA gpa : VALUES) {
                if (!gpa.name().equals(entry)) continue;
                return gpa.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (GPA gpa : VALUES) {
                if (!gpa.name().equals(entry)) continue;
                return ArduPilot.getUnit(gpa.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (GPA gpa : VALUES) {
                if (!gpa.name().equals(entry)) continue;
                return ArduPilot.getMults(gpa.mults);
            }
            return 1.0;
        }

        static {
            VALUES = GPA.values();
        }
    }

    public static enum ESC {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        RPM("e", "q", "B"),
        Volt("C", "v", "B"),
        Curr("C", "A", "B"),
        Temp("c", "O", "B"),
        CTot("H", "-", "-");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final ESC[] VALUES;

        private ESC(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (ESC esc : VALUES) {
                if (!esc.name().equals(entry)) continue;
                return esc.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (ESC esc : VALUES) {
                if (!esc.name().equals(entry)) continue;
                return esc.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (ESC esc : VALUES) {
                if (!esc.name().equals(entry)) continue;
                return ArduPilot.getUnit(esc.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (ESC esc : VALUES) {
                if (!esc.name().equals(entry)) continue;
                return ArduPilot.getMults(esc.mults);
            }
            return 1.0;
        }

        static {
            VALUES = ESC.values();
        }
    }

    public static enum BARO {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        Alt("f", "m", "0"),
        Press("f", "P", "0"),
        Temp("c", "O", "B"),
        CRt("f", "n", "0"),
        SMS("I", "s", "C"),
        Offset("f", "m", "?"),
        GndTemp("f", "O", "0");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final BARO[] VALUES;

        private BARO(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (BARO baro : VALUES) {
                if (!baro.name().equals(entry)) continue;
                return baro.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (BARO baro : VALUES) {
                if (!baro.name().equals(entry)) continue;
                return baro.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (BARO baro : VALUES) {
                if (!baro.name().equals(entry)) continue;
                return ArduPilot.getUnit(baro.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (BARO baro : VALUES) {
                if (!baro.name().equals(entry)) continue;
                return ArduPilot.getMults(baro.mults);
            }
            return 1.0;
        }

        static {
            VALUES = BARO.values();
        }
    }

    public static enum ACC {
        TimeUS("Q", "s", "F"),
        Time("Q", "s", "F"),
        SampleUS("Q", "s", "F"),
        Sample("Q", "s", "F"),
        AccX("B", "-", "-"),
        AccY("I", "-", "-"),
        AccZ("H", "-", "-");

        private final String fmt;
        private final String unit;
        private final String mults;
        public static final ACC[] VALUES;

        private ACC(String _fmt, String _unit, String _mults) {
            this.fmt = _fmt;
            this.unit = _unit;
            this.mults = _mults;
        }

        public static String getFmt(String entry) {
            for (ACC acc : VALUES) {
                if (!acc.name().equals(entry)) continue;
                return acc.fmt;
            }
            return "i";
        }

        public static String getSymbol(String entry) {
            for (ACC acc : VALUES) {
                if (!acc.name().equals(entry)) continue;
                return acc.unit;
            }
            return "";
        }

        public static String getUnit(String entry) {
            for (ACC acc : VALUES) {
                if (!acc.name().equals(entry)) continue;
                return ArduPilot.getUnit(acc.unit);
            }
            return "";
        }

        public static double getMults(String entry) {
            for (ACC acc : VALUES) {
                if (!acc.name().equals(entry)) continue;
                return ArduPilot.getMults(acc.mults);
            }
            return 1.0;
        }

        static {
            VALUES = ACC.values();
        }
    }

    public static enum LogEntry {
        ACC,
        ARSP,
        BARO,
        CURR,
        CURR_CELL,
        ESC,
        GPA,
        GPS,
        GYR,
        IMT,
        IMU,
        ISBD,
        ISBH,
        MAG,
        PID,
        QUAT,
        UNKNOWN;

        public static final LogEntry[] VALUES;

        public static LogEntry getLogEntry(String logEntry) {
            for (LogEntry entry : VALUES) {
                if (!entry.name().equals(logEntry)) continue;
                return entry;
            }
            return UNKNOWN;
        }

        static {
            VALUES = LogEntry.values();
        }
    }
}

