/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.Analyzer;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTbinHistoReader;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTbinReader2;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.ThrowableUtils;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.VaultCollector;
import gde.histo.device.UniversalSampler;
import gde.io.DataParser;
import gde.log.Level;
import gde.utils.StringHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class HoTTbinHistoReader2
extends HoTTbinHistoReader {
    private static final String $CLASS_NAME = HoTTbinHistoReader2.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int INITIALIZE_SAMPLING_FACTOR = 3;

    public HoTTbinHistoReader2(HoTTAdapter.PickerParameters pickerParameters) {
        super(pickerParameters, pickerParameters.analyzer.getActiveChannel().getNumber() == 4, 3);
    }

    @Override
    public void read(Supplier<InputStream> inputStream, VaultCollector newTruss) throws IOException, DataTypeException, DataInconsitsentException {
        if (newTruss.getVault().getLogFileLength() <= 448000L) {
            return;
        }
        this.nanoTime = System.nanoTime();
        this.finishTime = 0L;
        this.pickTime = 0L;
        this.addTime = 0L;
        this.reviewTime = 0L;
        this.readTime = 0L;
        this.initiateTime = 0L;
        this.lastTime = System.nanoTime();
        this.truss = newTruss;
        IDevice device = this.analyzer.getActiveDevice();
        ExtendedVault vault = this.truss.getVault();
        long numberDatablocks = vault.getLogFileLength() / 64L;
        this.tmpRecordSet = RecordSet.createRecordSet((String)vault.getLogRecordsetBaseName(), (Analyzer)this.analyzer, (int)this.analyzer.getActiveChannel().getNumber(), (boolean)true, (boolean)true, (boolean)false);
        this.tmpRecordSet.setStartTimeStamp(HoTTbinReader.getStartTimeStamp(vault.getLoadFileAsPath().getFileName().toString(), vault.getLogFileLastModified(), numberDatablocks));
        this.tmpRecordSet.setRecordSetDescription(device.getName() + " - " + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss.SSS", (long)this.tmpRecordSet.getStartTimeStamp()));
        this.tmpRecordSet.descriptionAppendFilename(vault.getLoadFileAsPath().getFileName().toString());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " recordSetBaseName=" + vault.getLogRecordsetBaseName());
        }
        HashMap<String, String> header = null;
        try (BufferedInputStream info_in = new BufferedInputStream(inputStream.get());){
            header = new HoTTbinReader.InfoParser(s -> {}).getFileInfo(info_in, vault.getLoadFilePath(), vault.getLogFileLength());
            if (header == null || header.isEmpty()) {
                return;
            }
            this.detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(header.get("DETECTED SENSOR"));
            HoTTbinReader.setAltitudeClimbPickeParameter(this.pickerParameters, this.detectedSensors);
            this.read(inputStream, Boolean.parseBoolean(header.get("SD_FORMAT")));
        }
        catch (DataTypeException e) {
            log.log(Level.WARNING, String.format("%s  %s", e.getMessage(), vault.getLoadFilePath()));
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
    }

    @Override
    protected void readSingle(InputStream data_in, int initializeBlocks, UniversalSampler histoRandomSample) throws DataInconsitsentException, IOException {
        HoTTAdapter2 device = (HoTTAdapter2)this.analyzer.getActiveDevice();
        boolean isReceiverData = false;
        boolean isSensorData = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        int[] points = histoRandomSample.getPoints();
        byte[] buf = new byte[64];
        byte[] buf0 = new byte[30];
        byte[] buf1 = new byte[30];
        byte[] buf2 = new byte[30];
        byte[] buf3 = new byte[30];
        byte[] buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        boolean isTextModusSignaled = false;
        HoTTbinReader.BinParser rcvBinParser = null;
        HoTTbinReader.BinParser chnBinParser = null;
        HoTTbinReader.BinParser varBinParser = null;
        HoTTbinReader.BinParser gpsBinParser = null;
        HoTTbinReader.BinParser gamBinParser = null;
        HoTTbinReader.BinParser eamBinParser = null;
        HoTTbinReader.BinParser escBinParser = null;
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        if (this.isChannelsChannelEnabled) {
            chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        }
        if (this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) {
            varBinParser = HoTTAdapter.Sensor.VARIO.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        }
        if (this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) {
            gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        }
        if (this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) {
            gamBinParser = HoTTAdapter.Sensor.GAM.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        }
        if (this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) {
            eamBinParser = HoTTAdapter.Sensor.EAM.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        }
        if (this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) {
            escBinParser = HoTTAdapter.Sensor.ESC.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        }
        HoTTbinHistoReader.Procedure pointsAdder = initializeBlocks <= 0 ? () -> {
            this.readTimer.invoke();
            boolean isValidSample = histoRandomSample.capturePoints(timeSteps_ms[0]);
            this.reviewTimer.invoke();
            if (isValidSample) {
                try {
                    int j;
                    int[] histoRandomSamplePoints = histoRandomSample.getSamplePoints();
                    if (!isResetMinMax[4]) {
                        for (j = 10; j < 19; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[4] = true;
                    }
                    if (!isResetMinMax[3] && histoRandomSamplePoints[27] >= 3000 && histoRandomSamplePoints[20] != 0 && histoRandomSamplePoints[21] != 0) {
                        for (j = 20; j < 37; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[3] = true;
                    }
                    if (!isResetMinMax[2] && histoRandomSamplePoints[38] != 0) {
                        for (j = 38; j < 59; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[2] = true;
                    }
                    if (!isResetMinMax[1] && histoRandomSamplePoints[60] != 0) {
                        for (j = 60; j < 99; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[1] = true;
                    }
                    if (this.isChannelsChannelEnabled) {
                        if (!isResetMinMax[0] && histoRandomSamplePoints[107] != 0) {
                            for (j = 107; j < 135; ++j) {
                                this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                            }
                            isResetMinMax[0] = true;
                        }
                    } else if (!isResetMinMax[0] && histoRandomSamplePoints[87] != 0) {
                        for (j = 87; j < 115; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[0] = true;
                    }
                    this.tmpRecordSet.addPoints(histoRandomSamplePoints, (double)histoRandomSample.getSampleTimeStep_ms());
                }
                catch (DataInconsitsentException e) {
                    throw ThrowableUtils.rethrow((Throwable)e);
                }
                this.addTimer.invoke();
                this.pickTimer.invoke();
            }
        } : () -> histoRandomSample.capturePoints(timeSteps_ms[0]);
        boolean doFullRead = initializeBlocks <= 0;
        boolean doDataSkip = this.detectedSensors.size() == 1 && !this.isChannelsChannelEnabled;
        int datablocksLimit = (doFullRead ? (int)this.truss.getVault().getLogFileLength() / 64 : initializeBlocks) / (doDataSkip ? 10 : 1);
        for (int i = 0; i < datablocksLimit; ++i) {
            data_in.read(buf);
            if (log.isLoggable(Level.FINE) && i % 10 == 0) {
                log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)buf.length));
                log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
            }
            if (!this.isFilterTextModus || (buf[6] & 1) == 0) {
                if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                    }
                    ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(true);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                    }
                    if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                        rcvBinParser.parse();
                        isReceiverData = true;
                    }
                    if (chnBinParser != null) {
                        chnBinParser.parse();
                    }
                    if (buf[33] == 0) {
                        bufCopier.copyToBuffer();
                    }
                    if (this.detectedSensors.size() == 1 && chnBinParser == null) {
                        for (int j = 0; j < 9; ++j) {
                            data_in.read(buf);
                            timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        }
                        isSensorData = true;
                    }
                    switch ((byte)(buf[7] & 0xFF)) {
                        case -119: 
                        case 55: {
                            if (varBinParser == null) break;
                            bufCopier.copyToVarioBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            varBinParser.parse();
                            bufCopier.clearBuffers();
                            isSensorData = true;
                            break;
                        }
                        case -118: 
                        case 56: {
                            if (gpsBinParser == null) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            gpsBinParser.parse();
                            bufCopier.clearBuffers();
                            isSensorData = true;
                            break;
                        }
                        case -115: 
                        case 53: {
                            if (gamBinParser == null) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            gamBinParser.parse();
                            bufCopier.clearBuffers();
                            isSensorData = true;
                            break;
                        }
                        case -114: 
                        case 54: {
                            if (eamBinParser == null) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            eamBinParser.parse();
                            bufCopier.clearBuffers();
                            isSensorData = true;
                            break;
                        }
                        case -116: 
                        case 57: {
                            if (escBinParser == null) break;
                            bufCopier.copyToFreeBuffer();
                            if (!bufCopier.is4BuffersFull()) break;
                            escBinParser.parse();
                            bufCopier.clearBuffers();
                            isSensorData = true;
                        }
                    }
                    if (isSensorData) {
                        ((HoTTbinReader2.RcvBinParser)rcvBinParser).updateLossStatistics();
                    }
                    if (isSensorData || isReceiverData && this.tmpRecordSet.get(0).realSize() > 0) {
                        pointsAdder.invoke();
                        isReceiverData = false;
                        isSensorData = false;
                    } else if (chnBinParser != null) {
                        pointsAdder.invoke();
                    }
                    timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                }
                ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(false);
                if (chnBinParser != null) {
                    chnBinParser.parse();
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                continue;
            }
            if (isTextModusSignaled) continue;
            isTextModusSignaled = true;
        }
        if (doFullRead) {
            ((HoTTbinReader2.RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            PackageLoss lostPackages = ((HoTTbinReader2.RcvBinParser)rcvBinParser).getLostPackages();
            Integer[] scores = this.getScores(lostPackages, histoRandomSample, this.truss.getVault());
            device.calculateInactiveRecords(this.tmpRecordSet);
            device.updateVisibilityStatus(this.tmpRecordSet, true);
            this.truss.promoteTruss(this.tmpRecordSet, scores);
            this.finishTimer.invoke();
            this.writeFinalLog(isTextModusSignaled, lostPackages, histoRandomSample, this.truss.getVault());
            this.tmpRecordSet.cleanup();
        }
        log.log(Level.FINER, " > ends <  doFullRead=", doFullRead);
    }

    @Override
    protected void readMultiple(InputStream data_in, int initializeBlocks, UniversalSampler histoRandomSample) throws IOException, DataInconsitsentException {
        HoTTAdapter2 device = (HoTTAdapter2)this.analyzer.getActiveDevice();
        boolean isReceiverData = false;
        boolean isJustMigrated = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        int[] points = histoRandomSample.getPoints();
        byte[] buf = new byte[64];
        byte[] buf0 = new byte[30];
        byte[] buf1 = new byte[30];
        byte[] buf2 = new byte[30];
        byte[] buf3 = new byte[30];
        byte[] buf4 = new byte[30];
        HoTTbinReader.BufCopier bufCopier = new HoTTbinReader.BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        int actualSensor = -1;
        int lastSensor = -1;
        int logCountVario = 0;
        int logCountGPS = 0;
        int logCountGAM = 0;
        int logCountEAM = 0;
        int logCountESC = 0;
        long[] timeSteps_ms = new long[]{0L};
        boolean isTextModusSignaled = false;
        HoTTbinReader.BinParser rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf});
        HoTTbinReader.BinParser chnBinParser = this.isChannelsChannelEnabled ? HoTTAdapter.Sensor.CHANNEL.createBinParser2(this.pickerParameters, points, timeSteps_ms, new byte[][]{buf}) : null;
        HoTTbinReader.BinParser varBinParser = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO) ? HoTTAdapter.Sensor.VARIO.createBinParser2(this.pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4}) : null;
        HoTTbinReader.BinParser gpsBinParser = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS) ? HoTTAdapter.Sensor.GPS.createBinParser2(this.pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4}) : null;
        HoTTbinReader.BinParser gamBinParser = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM) ? HoTTAdapter.Sensor.GAM.createBinParser2(this.pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4}) : null;
        HoTTbinReader.BinParser eamBinParser = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM) ? HoTTAdapter.Sensor.EAM.createBinParser2(this.pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4}) : null;
        HoTTbinReader.BinParser escBinParser = this.detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC) ? HoTTAdapter.Sensor.ESC.createBinParser2(this.pickerParameters, timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4}) : null;
        HashSet<HoTTbinReader.BinParser> migrationJobs = new HashSet<HoTTbinReader.BinParser>();
        HoTTbinHistoReader.Procedure migrator = () -> {
            if (migrationJobs.contains(eamBinParser)) {
                eamBinParser.migratePoints(points);
            }
            if (migrationJobs.contains(gamBinParser)) {
                gamBinParser.migratePoints(points);
            }
            if (migrationJobs.contains(gpsBinParser)) {
                gpsBinParser.migratePoints(points);
            }
            if (migrationJobs.contains(varBinParser)) {
                varBinParser.migratePoints(points);
            }
            if (migrationJobs.contains(escBinParser)) {
                escBinParser.migratePoints(points);
            }
            migrationJobs.clear();
        };
        HoTTbinHistoReader.Procedure pointsAdder = initializeBlocks <= 0 ? () -> {
            this.readTimer.invoke();
            boolean isValidSample = histoRandomSample.capturePoints(timeSteps_ms[0]);
            this.reviewTimer.invoke();
            if (isValidSample) {
                try {
                    int j;
                    int[] histoRandomSamplePoints = histoRandomSample.getSamplePoints();
                    if (!isResetMinMax[4]) {
                        for (j = 10; j < 19; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[4] = true;
                    }
                    if (!isResetMinMax[3] && histoRandomSamplePoints[27] >= 3000 && histoRandomSamplePoints[20] != 0 && histoRandomSamplePoints[21] != 0) {
                        for (j = 20; j < 37; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[3] = true;
                    }
                    if (!isResetMinMax[2] && histoRandomSamplePoints[38] != 0) {
                        for (j = 38; j < 59; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[2] = true;
                    }
                    if (!isResetMinMax[1] && histoRandomSamplePoints[60] != 0) {
                        for (j = 60; j < 99; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[1] = true;
                    }
                    if (this.isChannelsChannelEnabled) {
                        if (!isResetMinMax[0] && histoRandomSamplePoints[107] != 0) {
                            for (j = 107; j < 135; ++j) {
                                this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                            }
                            isResetMinMax[0] = true;
                        }
                    } else if (!isResetMinMax[0] && histoRandomSamplePoints[87] != 0) {
                        for (j = 87; j < 115; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[0] = true;
                    }
                    this.tmpRecordSet.addPoints(histoRandomSamplePoints, (double)histoRandomSample.getSampleTimeStep_ms());
                }
                catch (DataInconsitsentException e) {
                    throw ThrowableUtils.rethrow((Throwable)e);
                }
                this.addTimer.invoke();
                this.pickTimer.invoke();
            }
        } : () -> histoRandomSample.capturePoints(timeSteps_ms[0]);
        this.initTimer.invoke();
        boolean doFullRead = initializeBlocks <= 0;
        int initializeBlockLimit = initializeBlocks > 0 ? initializeBlocks : Integer.MAX_VALUE;
        for (int i = 0; i < initializeBlockLimit && (long)i < this.truss.getVault().getLogFileLength() / 64L; ++i) {
            data_in.read(buf);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
            }
            if (!this.isFilterTextModus || (buf[6] & 1) == 0) {
                if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                    }
                    ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(true);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                    }
                    if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                        rcvBinParser.parse();
                        isReceiverData = true;
                    }
                    if (chnBinParser != null) {
                        chnBinParser.parse();
                    }
                    if (actualSensor == -1) {
                        byte by = (byte)(buf[7] & 0xFF);
                        actualSensor = by;
                        lastSensor = by;
                    } else {
                        actualSensor = (byte)(buf[7] & 0xFF);
                    }
                    if (actualSensor != lastSensor) {
                        if (logCountVario >= 5 || logCountGPS >= 5 || logCountGAM >= 5 || logCountEAM >= 5 || logCountESC >= 5) {
                            switch (lastSensor) {
                                case -119: 
                                case 55: {
                                    if (varBinParser == null) break;
                                    if (migrationJobs.contains(varBinParser) && isReceiverData) {
                                        migrator.invoke();
                                        isJustMigrated = true;
                                        isReceiverData = false;
                                        pointsAdder.invoke();
                                    }
                                    varBinParser.parse();
                                    migrationJobs.add(varBinParser);
                                    break;
                                }
                                case -118: 
                                case 56: {
                                    if (gpsBinParser == null) break;
                                    if (migrationJobs.contains(gpsBinParser) && isReceiverData) {
                                        migrator.invoke();
                                        isJustMigrated = true;
                                        isReceiverData = false;
                                        pointsAdder.invoke();
                                    }
                                    gpsBinParser.parse();
                                    migrationJobs.add(gpsBinParser);
                                    break;
                                }
                                case -115: 
                                case 53: {
                                    if (gamBinParser == null) break;
                                    if (migrationJobs.contains(gamBinParser) && isReceiverData) {
                                        migrator.invoke();
                                        isJustMigrated = true;
                                        isReceiverData = false;
                                        pointsAdder.invoke();
                                    }
                                    gamBinParser.parse();
                                    migrationJobs.add(gamBinParser);
                                    break;
                                }
                                case -114: 
                                case 54: {
                                    if (eamBinParser == null) break;
                                    if (migrationJobs.contains(eamBinParser) && isReceiverData) {
                                        migrator.invoke();
                                        isJustMigrated = true;
                                        isReceiverData = false;
                                        pointsAdder.invoke();
                                    }
                                    eamBinParser.parse();
                                    migrationJobs.add(eamBinParser);
                                    break;
                                }
                                case -116: 
                                case 57: {
                                    if (escBinParser == null) break;
                                    if (migrationJobs.contains(escBinParser) && isReceiverData) {
                                        migrator.invoke();
                                        isJustMigrated = true;
                                        isReceiverData = false;
                                        pointsAdder.invoke();
                                    }
                                    escBinParser.parse();
                                    migrationJobs.add(escBinParser);
                                }
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "isReceiverData " + isReceiverData + " migrationJobs " + migrationJobs);
                            }
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "logCountVario = " + logCountVario + " logCountGPS = " + logCountGPS + " logCountGeneral = " + logCountGAM + " logCountElectric = " + logCountEAM);
                        }
                        lastSensor = actualSensor;
                        logCountESC = 0;
                        logCountEAM = 0;
                        logCountGAM = 0;
                        logCountGPS = 0;
                        logCountVario = 0;
                    }
                    switch (lastSensor) {
                        case -119: 
                        case 55: {
                            ++logCountVario;
                            break;
                        }
                        case -118: 
                        case 56: {
                            ++logCountGPS;
                            break;
                        }
                        case -115: 
                        case 53: {
                            ++logCountGAM;
                            break;
                        }
                        case -114: 
                        case 54: {
                            ++logCountEAM;
                            break;
                        }
                        case -116: 
                        case 57: {
                            ++logCountESC;
                        }
                    }
                    if (isJustMigrated) {
                        ((HoTTbinReader2.RcvBinParser)rcvBinParser).updateLossStatistics();
                    }
                    if (isReceiverData && (logCountVario > 0 || logCountGPS > 0 || logCountGAM > 0 || logCountEAM > 0 || logCountESC > 0)) {
                        pointsAdder.invoke();
                        isReceiverData = false;
                    } else if (chnBinParser != null && !isJustMigrated) {
                        pointsAdder.invoke();
                    }
                    isJustMigrated = false;
                    bufCopier.copyToBuffer();
                    timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                }
                ((HoTTbinReader2.RcvBinParser)rcvBinParser).trackPackageLoss(false);
                if (chnBinParser != null) {
                    chnBinParser.parse();
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                continue;
            }
            if (isTextModusSignaled) continue;
            isTextModusSignaled = true;
        }
        if (doFullRead) {
            ((HoTTbinReader2.RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            PackageLoss lostPackages = ((HoTTbinReader2.RcvBinParser)rcvBinParser).getLostPackages();
            Integer[] scores = this.getScores(lostPackages, histoRandomSample, this.truss.getVault());
            device.calculateInactiveRecords(this.tmpRecordSet);
            device.updateVisibilityStatus(this.tmpRecordSet, true);
            this.truss.promoteTruss(this.tmpRecordSet, scores);
            this.finishTimer.invoke();
            this.writeFinalLog(isTextModusSignaled, lostPackages, histoRandomSample, this.truss.getVault());
            this.tmpRecordSet.cleanup();
        }
        log.log(Level.FINER, " > ends <  doFullRead=", doFullRead);
    }
}

