/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class MidpointStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;

    public MidpointStepInterpolator() {
    }

    MidpointStepInterpolator(MidpointStepInterpolator interpolator) {
        super(interpolator);
    }

    protected StepInterpolator doCopy() {
        return new MidpointStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) {
        double coeffDot2 = 2.0 * theta;
        double coeffDot1 = 1.0 - coeffDot2;
        if (this.previousState != null && theta <= 0.5) {
            double coeff1 = theta * oneMinusThetaH;
            double coeff2 = theta * theta * this.h;
            for (int i2 = 0; i2 < this.interpolatedState.length; ++i2) {
                double yDot1 = this.yDotK[0][i2];
                double yDot2 = this.yDotK[1][i2];
                this.interpolatedState[i2] = this.previousState[i2] + coeff1 * yDot1 + coeff2 * yDot2;
                this.interpolatedDerivatives[i2] = coeffDot1 * yDot1 + coeffDot2 * yDot2;
            }
        } else {
            double coeff1 = oneMinusThetaH * theta;
            double coeff2 = oneMinusThetaH * (1.0 + theta);
            for (int i3 = 0; i3 < this.interpolatedState.length; ++i3) {
                double yDot1 = this.yDotK[0][i3];
                double yDot2 = this.yDotK[1][i3];
                this.interpolatedState[i3] = this.currentState[i3] + coeff1 * yDot1 - coeff2 * yDot2;
                this.interpolatedDerivatives[i3] = coeffDot1 * yDot1 + coeffDot2 * yDot2;
            }
        }
    }
}

