/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt;

import de.treichels.hott.messages.Messages;
import de.treichels.hott.util.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lde/treichels/hott/mdlviewer/swt/Launcher;", "", "()V", "codeLocation", "Ljava/net/URL;", "logDir", "Ljava/io/File;", "getLogDir", "()Ljava/io/File;", "mdlDir", "getMdlDir", "programDir", "getProgramDir", "sourceFile", "version", "", "getVersion", "()Ljava/lang/String;", "launch", "", "Companion", "MdlViewer-SWT"})
public final class Launcher {
    private final URL codeLocation;
    private File sourceFile;
    @NotNull
    private final File programDir;
    @NotNull
    private final File mdlDir;
    @NotNull
    private final File logDir;
    @NotNull
    private final String version;
    @NotNull
    private static final Launcher instance;
    public static final Companion Companion;

    @NotNull
    public final File getProgramDir() {
        return this.programDir;
    }

    @NotNull
    public final File getMdlDir() {
        return this.mdlDir;
    }

    @NotNull
    public final File getLogDir() {
        return this.logDir;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void launch() {
        try {
            Class.forName("org.eclipse.swt.widgets.Composite");
        }
        catch (ClassNotFoundException e) {
            String string2;
            String string3;
            String string4 = System.getProperty("os.name");
            Intrinsics.checkExpressionValueIsNotNull(string4, "System.getProperty(\"os.name\")");
            String string5 = string3 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).toLowerCase()");
            String osName = string6;
            String string7 = System.getProperty("os.arch");
            Intrinsics.checkExpressionValueIsNotNull(string7, "System.getProperty(\"os.arch\")");
            String string8 = string2 = string7;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).toLowerCase()");
            String arch = string9;
            String name = StringsKt.startsWith$default(osName, "linux", false, 2, null) ? "linux" : (StringsKt.startsWith$default(osName, "windows", false, 2, null) ? "windows" : (StringsKt.startsWith$default(osName, "mac", false, 2, null) ? "mac" : osName));
            String swtJarName = "swt-" + name + '-' + arch + ".jar";
            File swtDir = new File(this.programDir, "swt");
            File swtJarFile = new File(swtDir, swtJarName);
            if (!(swtJarFile.exists() && swtJarFile.isFile() && swtJarFile.canRead())) {
                throw (Throwable)new ClassNotFoundException(Messages.getString("Launcher.SWTNotFound", swtJarFile.getAbsolutePath()));
            }
            URL swtJarFileURL = swtJarFile.toURI().toURL();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader instanceof URLClassLoader) {
                Method addMethod;
                Method method = addMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                Intrinsics.checkExpressionValueIsNotNull(method, "addMethod");
                method.setAccessible(true);
                addMethod.invoke((Object)systemClassLoader, swtJarFileURL);
            }
            throw (Throwable)new UnsupportedOperationException("The system classloader is not a subtype of URLClassLoader. Therefore, we cannot add SWT jar dynamically to the classpath.");
        }
        Class<?> mainClass = Class.forName("de.treichels.hott.mdlviewer.swt.SwtMdlBrowser");
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{new String[0]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Launcher() {
        super();
        v0 = this.getClass().getProtectionDomain();
        Intrinsics.checkExpressionValueIsNotNull(v0, "javaClass.protectionDomain");
        v1 = v0.getCodeSource();
        Intrinsics.checkExpressionValueIsNotNull(v1, "javaClass.protectionDomain.codeSource");
        v2 = v1.getLocation();
        Intrinsics.checkExpressionValueIsNotNull(v2, "javaClass.protectionDomain.codeSource.location");
        this.codeLocation = v2;
        this.sourceFile = new File(this.codeLocation.toURI());
        v3 = this;
        v4 = this.sourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull(v4, "sourceFile.name");
        if (StringsKt.endsWith$default(v4, ".jar", false, 2, null)) ** GOTO lbl-1000
        v5 = this.sourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull(v5, "sourceFile.name");
        if (StringsKt.endsWith$default(v5, ".exe", false, 2, null)) lbl-1000:
        // 2 sources

        {
            var1_1 = new JarFile(this.sourceFile);
            var8_2 = v3;
            var2_3 = null;
            try {
                jarfile = (JarFile)var1_1;
                v6 = jarfile.getManifest();
                Intrinsics.checkExpressionValueIsNotNull(v6, "jarfile.manifest");
                attributes = v6.getMainAttributes();
                version = attributes.getValue("Implementation-Version");
                build = attributes.getValue("Implementation-Build");
                var3_4 = Messages.getString("Launcher.Version", new Object[]{version, build});
            }
            catch (Throwable var3_5) {
                var2_3 = var3_5;
                throw var3_5;
            }
            finally {
                CloseableKt.closeFinally(var1_1, var2_3);
            }
            var9_10 = var3_4;
            v3 = var8_2;
            v7 = var9_10;
            v8 = v7;
            Intrinsics.checkExpressionValueIsNotNull(v7, "JarFile(sourceFile).use \u2026ion, build)\n            }");
        } else {
            while (Intrinsics.areEqual(this.sourceFile.getName(), "classes") ^ true) {
                Intrinsics.checkExpressionValueIsNotNull(this.sourceFile.getParentFile(), "sourceFile.parentFile");
                this.sourceFile = this.sourceFile;
            }
            v9 = System.getProperty("program.version", Messages.getString("Launcher.Unknown", new Object[0]));
            v8 = v9;
            Intrinsics.checkExpressionValueIsNotNull(v9, "System.getProperty(PROGR\u2026ring(\"Launcher.Unknown\"))");
        }
        v3.version = v8;
        v10 = parentFile = this.sourceFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull(v10, "parentFile");
        if (Intrinsics.areEqual(v10.getName(), "target")) {
            v11 = parentFile.getParentFile();
            v12 = v11;
            Intrinsics.checkExpressionValueIsNotNull(v11, "parentFile.parentFile");
        } else {
            v12 = parentFile;
        }
        this.programDir = v12;
        this.mdlDir = new File(System.getProperty("mdl.dir", this.programDir.getAbsolutePath()));
        this.logDir = new File(System.getProperty("log.dir", this.programDir.getAbsolutePath()));
        System.setProperty("program.version", this.version);
        System.setProperty("program.dir", this.programDir.getAbsolutePath());
        System.setProperty("mdl.dir", this.mdlDir.getAbsolutePath());
        System.setProperty("log.dir", this.logDir.getAbsolutePath());
        if (Util.INSTANCE.getDEBUG()) {
            System.out.printf("program.dir = %s%n", new Object[]{System.getProperty("program.dir")});
            System.out.printf("mdl.dir = %s%n", new Object[]{System.getProperty("mdl.dir")});
            System.out.printf("log.dir = %s%n", new Object[]{System.getProperty("log.dir")});
        }
    }

    static {
        Companion = new Companion(null);
        instance = new Launcher();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/treichels/hott/mdlviewer/swt/Launcher$Companion;", "", "()V", "instance", "Lde/treichels/hott/mdlviewer/swt/Launcher;", "getInstance", "()Lde/treichels/hott/mdlviewer/swt/Launcher;", "MdlViewer-SWT"})
    public static final class Companion {
        @NotNull
        public final Launcher getInstance() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

