/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.CurveSelectorContextMenu;
import gde.ui.tab.GraphicsWindow;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SelectorComposite
extends Composite {
    static final Logger log = Logger.getLogger(SelectorComposite.class.getName());
    final DataExplorer application = DataExplorer.getInstance();
    final Channels channels = Channels.getInstance();
    final SashForm parent;
    final GraphicsWindow.GraphicsType graphicsType;
    final String headerText;
    final Menu popupmenu;
    final CurveSelectorContextMenu contextMenu;
    int headerTextExtentFactor = 9;
    Button curveSelectorHeader;
    int initialSelectorHeaderWidth;
    int selectorColumnWidth;
    Table curveSelectorTable;
    TableColumn tableSelectorColumn;
    int oldSelectorColumnWidth = 0;
    Point oldSize = new Point(0, 0);

    public SelectorComposite(SashForm useParent, GraphicsWindow.GraphicsType useGraphicsType, String useHeaderText) {
        super((Composite)useParent, 0);
        this.parent = useParent;
        this.graphicsType = useGraphicsType;
        this.headerText = useHeaderText;
        SWTResourceManager.registerResourceUser((Widget)this);
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new CurveSelectorContextMenu();
        this.contextMenu.createMenu(this.popupmenu);
        this.initGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initGUI() {
        FormLayout curveSelectorLayout = new FormLayout();
        this.setLayout((Layout)curveSelectorLayout);
        GridData curveSelectorLData = new GridData();
        this.setLayoutData(curveSelectorLData);
        this.setBackground(this.application.COLOR_BACKGROUND);
        this.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "curveSelector.helpRequested " + evt);
                }
                SelectorComposite.this.application.openHelpDialog("", "HelpInfo_41.html");
            }
        });
        this.curveSelectorHeader = new Button((Composite)this, 16416);
        this.curveSelectorHeader.setText(Messages.getString("GDE_MSGT0254"));
        this.curveSelectorHeader.setToolTipText(Messages.getString("GDE_MSGT0671"));
        this.curveSelectorHeader.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 1));
        this.curveSelectorHeader.pack();
        this.initialSelectorHeaderWidth = this.curveSelectorHeader.getSize().x + 8;
        FormData curveSelectorHeaderLData = new FormData();
        curveSelectorHeaderLData.width = this.initialSelectorHeaderWidth;
        curveSelectorHeaderLData.height = 25;
        curveSelectorHeaderLData.left = new FormAttachment(0, 1000, GDE.IS_WINDOWS ? 6 : 0);
        curveSelectorHeaderLData.top = new FormAttachment(0, 1000, 0);
        this.curveSelectorHeader.setLayoutData((Object)curveSelectorHeaderLData);
        this.curveSelectorHeader.setBackground(this.application.COLOR_BACKGROUND);
        this.curveSelectorHeader.setForeground(this.application.COLOR_FOREGROUND);
        this.curveSelectorHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.WARNING, "curveSelectorHeader.widgetSelected, event=" + evt);
                }
                SelectorComposite.this.application.clearMeasurementModes();
                if (!SelectorComposite.this.curveSelectorHeader.getSelection()) {
                    for (TableItem tableItem : SelectorComposite.this.curveSelectorTable.getItems()) {
                        if (!tableItem.getChecked()) continue;
                        SelectorComposite.this.toggleRecordSelection(tableItem, false, false);
                    }
                } else {
                    for (TableItem tableItem : SelectorComposite.this.curveSelectorTable.getItems()) {
                        if (tableItem.getChecked()) continue;
                        SelectorComposite.this.toggleRecordSelection(tableItem, false, true);
                    }
                }
                SelectorComposite.this.doUpdateCurveSelectorTable();
                SelectorComposite.this.application.updateAllTabs(true, false);
            }
        });
        this.curveSelectorTable = new Table((Composite)this, 65572);
        this.curveSelectorTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.curveSelectorTable.setLinesVisible(true);
        FormData curveTableLData = new FormData();
        curveTableLData.width = 82;
        curveTableLData.height = 457;
        curveTableLData.left = new FormAttachment(0, 1000, 0);
        curveTableLData.top = new FormAttachment(0, 1000, 25);
        curveTableLData.bottom = new FormAttachment(1000, 1000, 0);
        curveTableLData.right = new FormAttachment(1000, 1000, 0);
        this.curveSelectorTable.setLayoutData((Object)curveTableLData);
        this.curveSelectorTable.setMenu(this.popupmenu);
        this.curveSelectorTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "curveSelectorTable.widgetSelected, event=" + evt);
                }
                SelectorComposite.this.resetMeasuring();
                if (evt != null && evt.item != null && !evt.item.isDisposed()) {
                    SelectorComposite.this.toggleRecordSelection((TableItem)evt.item, true, false);
                    SelectorComposite.this.application.updateAllTabs(true, false);
                }
            }
        });
        SelectorComposite selectorComposite = this;
        synchronized (selectorComposite) {
            this.tableSelectorColumn = new TableColumn(this.curveSelectorTable, 16384);
            this.tableSelectorColumn.setWidth(this.selectorColumnWidth);
        }
    }

    public synchronized void doUpdateCurveSelectorTable() {
        this.application.updateAllTabs(true, false);
        int itemWidth = this.initialSelectorHeaderWidth;
        RecordSet recordSet = null;
        switch (this.graphicsType) {
            case COMPARE: {
                recordSet = this.application.getCompareSet();
                break;
            }
            case UTIL: {
                recordSet = this.application.getUtilitySet();
                break;
            }
            default: {
                RecordSet recordSet2 = recordSet = this.channels.getActiveChannel() != null ? this.channels.getActiveChannel().getActiveRecordSet() : null;
            }
        }
        if (recordSet != null && recordSet.size() > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, recordSet.getName());
            }
            this.curveSelectorTable.removeAll();
            int checkBoxWidth = 20;
            int textSize = 10;
            boolean isOneVisible = false;
            for (int i = 0; i < recordSet.size(); ++i) {
                Record record = recordSet.get(i);
                if (record == null) continue;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, record.getName());
                }
                if (itemWidth < (textSize = record.getName().length() * 8) + checkBoxWidth) {
                    itemWidth = textSize + checkBoxWidth;
                }
                if (!record.isDisplayable()) continue;
                TableItem item = new TableItem(this.curveSelectorTable, 0);
                item.setForeground(SWTResourceManager.getColor(record.getRGB()));
                item.setText(record.getName());
                if (record.isVisible()) {
                    isOneVisible = true;
                    item.setChecked(true);
                    item.setData("oldState", (Object)true);
                    item.setData("graphics_type", (Object)this.graphicsType);
                } else {
                    item.setChecked(false);
                    item.setData("oldState", (Object)false);
                    item.setData("graphics_type", (Object)this.graphicsType);
                }
                this.setHeaderSelection(isOneVisible);
            }
            this.selectorColumnWidth = itemWidth;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "*curveSelectorTable width = " + this.selectorColumnWidth);
            }
            recordSet.updateVisibleAndDisplayableRecordsForTable();
        } else {
            this.curveSelectorTable.removeAll();
            this.selectorColumnWidth = this.initialSelectorHeaderWidth;
            this.setHeaderSelection(false);
        }
        if (this.oldSelectorColumnWidth != this.selectorColumnWidth) {
            this.curveSelectorHeader.setSize(this.selectorColumnWidth - 1, this.curveSelectorHeader.getSize().y);
            this.tableSelectorColumn.setWidth(this.selectorColumnWidth - 2);
            this.oldSelectorColumnWidth = this.selectorColumnWidth;
            this.application.setGraphicsSashFormWeights(this.selectorColumnWidth, this.graphicsType);
        }
        this.curveSelectorTable.redraw();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "curveSelectorTable width = " + this.selectorColumnWidth);
        }
    }

    public void setHeaderSelection(boolean enable) {
        this.curveSelectorHeader.setSelection(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectorColumnWidth() {
        SelectorComposite selectorComposite = this;
        synchronized (selectorComposite) {
            return this.selectorColumnWidth;
        }
    }

    public void toggleRecordSelection(TableItem item, boolean isTableSelection, boolean forceVisible) {
        String recordName = item.getText();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "selected = " + recordName);
        }
        this.popupmenu.setData("recordName", (Object)recordName);
        this.popupmenu.setData("curveSelectedItem", (Object)item);
        if (!isTableSelection || item.getChecked() != ((Boolean)item.getData("oldState")).booleanValue()) {
            Record activeRecord;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "selection state changed = " + recordName);
            }
            switch (this.graphicsType) {
                case COMPARE: {
                    activeRecord = this.application.getCompareSet().get(recordName);
                    break;
                }
                case UTIL: {
                    activeRecord = this.application.getUtilitySet().get(recordName);
                    break;
                }
                default: {
                    RecordSet activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
                    Record record = activeRecord = activeRecordSet != null ? activeRecordSet.get(recordName) : null;
                }
            }
            if (activeRecord != null) {
                if (isTableSelection && item.getChecked() || forceVisible) {
                    activeRecord.setVisible(true);
                    this.popupmenu.getItem(0).setSelection(true);
                    item.setData("oldState", (Object)true);
                    item.setData("graphics_type", (Object)this.graphicsType);
                    this.setHeaderSelection(true);
                } else {
                    activeRecord.setVisible(false);
                    this.popupmenu.getItem(0).setSelection(false);
                    item.setData("oldState", (Object)false);
                    item.setData("graphics_type", (Object)this.graphicsType);
                }
                activeRecord.getParent().syncScaleOfSyncableRecords();
                activeRecord.getParent().updateVisibleAndDisplayableRecordsForTable();
                if (activeRecord.getParent().getVisibleAndDisplayableRecords().size() == 0) {
                    this.application.clearMeasurementModes();
                }
            }
        }
    }

    public void updateColorSchema() {
        this.setBackground(this.application.COLOR_BACKGROUND);
        this.curveSelectorHeader.setBackground(this.application.COLOR_BACKGROUND);
        this.curveSelectorHeader.setForeground(this.application.COLOR_FOREGROUND);
    }

    private void resetMeasuring() {
        if (this.contextMenu != null) {
            this.contextMenu.resetMeasuring();
        }
        this.application.clearMeasurementModes();
        this.application.resetGraphicsWindowZoomAndMeasurement();
    }
}

