/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.config.Settings;
import gde.histo.recordings.HistoGraphicsMapper;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSection;
import gde.histo.ui.GraphicsComposite;
import gde.histo.ui.GraphicsMeasuring;
import gde.histo.ui.Measure;
import gde.histo.utils.ElementaryQuantile;
import gde.histo.utils.HistoTimeLine;
import gde.histo.utils.SingleResponseRegression;
import gde.histo.utils.Spot;
import gde.log.Logger;
import gde.ui.SWTResourceManager;
import gde.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public final class CurveSurvey {
    private static final String $CLASS_NAME = CurveSurvey.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int X_TOLERANCE = 1;
    private final Settings settings = Settings.getInstance();
    private final GraphicsComposite graphicsComposite;
    private final HistoTimeLine timeLine;
    private final TrailRecord trailRecord;
    private final Measure measure;
    private LinePainter linePainter;
    private GC canvasGC;

    public CurveSurvey(GraphicsComposite graphicsComposite, Measure measure) {
        this.trailRecord = measure.measureRecord;
        this.graphicsComposite = graphicsComposite;
        this.timeLine = graphicsComposite.getTimeLine();
        this.measure = measure;
    }

    public void initialize() {
        GraphicsMeasuring.xPosMeasure = Integer.MIN_VALUE;
        GraphicsMeasuring.yPosMeasure = Integer.MIN_VALUE;
        GraphicsMeasuring.xPosDelta = Integer.MIN_VALUE;
        GraphicsMeasuring.yPosDelta = Integer.MIN_VALUE;
    }

    public String drawMeasurementGraphics() {
        this.linePainter = new LinePainter(this.timeLine.getCurveAreaBounds());
        this.linePainter.drawCross(GraphicsMeasuring.xPosMeasure, GraphicsMeasuring.yPosMeasure);
        String statusMessage = GraphicsMeasuring.yPosMeasure >= Integer.MIN_VALUE ? this.measure.getMeasureStatusMessage() : this.measure.getNoRecordsStatusMessage();
        return statusMessage;
    }

    public String drawDeltaMeasurementGraphics() {
        String statusMessage;
        this.linePainter = new LinePainter(this.timeLine.getCurveAreaBounds());
        this.linePainter.drawDoubleCross(GraphicsMeasuring.xPosMeasure, GraphicsMeasuring.yPosMeasure, GraphicsMeasuring.xPosDelta, GraphicsMeasuring.yPosDelta);
        if (GraphicsMeasuring.yPosMeasure != Integer.MIN_VALUE || GraphicsMeasuring.yPosDelta != Integer.MIN_VALUE) {
            if (this.settings.isCurveSurvey()) {
                this.drawCurveSurvey();
                statusMessage = this.measure.getCurveSurveyStatusMessage();
            } else {
                statusMessage = this.measure.getDeltaStandardStatusMessage();
            }
        } else if (this.measure.getRecordSection().isValidBounds() && this.settings.isCurveSurvey()) {
            this.drawCurveSurvey();
            statusMessage = this.measure.getNoDeltaCurveSurveyStatusMessage();
        } else {
            statusMessage = this.measure.getNoRecordsStatusMessage();
        }
        return statusMessage;
    }

    private void drawCurveSurvey() {
        int height = this.timeLine.getCurveAreaBounds().height;
        TrailRecordSection recordSection = this.measure.getRecordSection();
        GraphicsComposite.GraphicsLayout graphicsData = this.graphicsComposite.getChartData(this.trailRecord);
        if (!recordSection.isBoundedParabola()) {
            int yBoundedAvg = HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, recordSection.getBoundedAvgValue());
            this.linePainter.drawAverageLine(yBoundedAvg, GraphicsMeasuring.xPosMeasure, GraphicsMeasuring.xPosDelta - GraphicsMeasuring.xPosMeasure);
            int yRegressionPosMeasure = HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, recordSection.getBoundedSlopeValue(this.measure.getTimestampMeasure_ms()));
            int yRegressionPosDelta = HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, recordSection.getBoundedSlopeValue(this.measure.getTimestampDelta_ms()));
            this.linePainter.drawLinearRegressionLine(GraphicsMeasuring.xPosMeasure, yRegressionPosMeasure, GraphicsMeasuring.xPosDelta, yRegressionPosDelta);
        } else {
            ArrayList<Spot<Integer>> points = new ArrayList<Spot<Integer>>();
            for (Spot<Double> entry : recordSection.getBoundedParabolaValues()) {
                points.add(new Spot<Integer>(this.timeLine.getXPosTimestamp((long)entry.x().doubleValue()), HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, entry.y())));
            }
            log.finer(() -> "values " + Arrays.toString(points.toArray()));
            this.linePainter.drawRegressionParabolaLine(points);
        }
        int xPosMidBounds = (GraphicsMeasuring.xPosDelta + GraphicsMeasuring.xPosMeasure) / 2;
        double[] values = recordSection.getBoundedBoxplotValues();
        int[] yPosBoxplot = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            yPosBoxplot[i] = HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, values[i]);
        }
        this.linePainter.drawBoxplot(xPosMidBounds, yPosBoxplot);
    }

    public void setMeasurePosition() {
        int height = this.timeLine.getCurveAreaBounds().height;
        GraphicsMeasuring.xPosMeasure = this.timeLine.getXPosTimestamp(this.measure.getTimestampMeasure_ms());
        GraphicsComposite.GraphicsLayout graphicsData = this.graphicsComposite.getChartData(this.trailRecord);
        GraphicsMeasuring.yPosMeasure = HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, this.trailRecord.getParent().getIndex(this.measure.getTimestampMeasure_ms()));
        log.finer(() -> String.format("timestampMeasure_ms=%d xPosMeasure=%d yPosMeasure=%d", this.measure.getTimestampMeasure_ms(), GraphicsMeasuring.xPosMeasure, GraphicsMeasuring.yPosMeasure));
    }

    public void setDeltaPosition() {
        int height = this.timeLine.getCurveAreaBounds().height;
        GraphicsMeasuring.xPosDelta = this.timeLine.getXPosTimestamp(this.measure.getTimestampDelta_ms());
        GraphicsComposite.GraphicsLayout graphicsData = this.graphicsComposite.getChartData(this.trailRecord);
        GraphicsMeasuring.yPosDelta = HistoGraphicsMapper.getVerticalDisplayPos(graphicsData, height, this.trailRecord.getParent().getIndex(this.measure.getTimestampDelta_ms()));
        log.fine(() -> String.format("timestampDelta_ms=%d xPosDelta=%d yPosDelta=%d", this.measure.getTimestampDelta_ms(), GraphicsMeasuring.xPosDelta, GraphicsMeasuring.yPosDelta));
    }

    public boolean isNearDeltaLine(int xPos) {
        return GraphicsMeasuring.xPosDelta + 1 >= xPos && GraphicsMeasuring.xPosDelta - 1 <= xPos;
    }

    public boolean isNearMeasureLine(int xPos) {
        return GraphicsMeasuring.xPosMeasure + 1 >= xPos && GraphicsMeasuring.xPosMeasure - 1 <= xPos;
    }

    public boolean isOverVerticalLine(int xPos) {
        return xPos > Integer.MIN_VALUE && GraphicsMeasuring.xPosMeasure > Integer.MIN_VALUE && this.isNearMeasureLine(xPos) || xPos > Integer.MIN_VALUE && GraphicsMeasuring.xPosDelta > Integer.MIN_VALUE && this.isNearDeltaLine(xPos);
    }

    public boolean isNewMeasureSpot(long timestampNew_ms, int yPosNew) {
        return yPosNew != Integer.MIN_VALUE && (timestampNew_ms != this.measure.getTimestampMeasure_ms() || yPosNew != GraphicsMeasuring.yPosMeasure);
    }

    public boolean isNewDeltaSpot(long timestampNew_ms, int yPosNew) {
        return yPosNew != Integer.MIN_VALUE && (timestampNew_ms != this.measure.getTimestampDelta_ms() || yPosNew != GraphicsMeasuring.yPosDelta);
    }

    public void setCanvasGC(GC canvasGC) {
        this.canvasGC = canvasGC;
    }

    public String toString() {
        return "CurveSurvey [xPosMeasure=" + GraphicsMeasuring.xPosMeasure + ", yPosMeasure=" + GraphicsMeasuring.yPosMeasure + ", xPosDelta=" + GraphicsMeasuring.xPosDelta + ", yPosDelta=" + GraphicsMeasuring.yPosDelta + "]";
    }

    private final class LinePainter {
        private final int offSetX;
        private final int offSetY;
        private final int width;
        private final int height;
        private int yLowerLimit = Integer.MIN_VALUE;
        private int yUpperLimit = Integer.MAX_VALUE;
        private int xLeftLimit = Integer.MAX_VALUE;
        private int xRightLimit = Integer.MIN_VALUE;

        public LinePainter(Rectangle curveAreaBounds) {
            this.offSetX = curveAreaBounds.x;
            this.offSetY = curveAreaBounds.y;
            this.width = curveAreaBounds.width;
            this.height = curveAreaBounds.height;
            CurveSurvey.this.canvasGC.setClipping(curveAreaBounds);
        }

        private void drawVerticalLine(int posFromLeft, int posFromTop, int length, LineMark lineMark) {
            this.setLineMark(lineMark);
            CurveSurvey.this.canvasGC.drawLine(posFromLeft + this.offSetX, posFromTop + this.offSetY, posFromLeft + this.offSetX, posFromTop + this.offSetY + length - 1);
        }

        private void drawHorizontalLine(int posFromTop, int posFromLeft, int length, LineMark lineMark) {
            log.finer(() -> String.format("posFromLeft=%d posFromTop=%d length=%d", posFromLeft, posFromTop, length));
            this.setLineMark(lineMark);
            CurveSurvey.this.canvasGC.drawLine(posFromLeft + this.offSetX, posFromTop + this.offSetY, posFromLeft + this.offSetX + length - 1, posFromTop + this.offSetY);
        }

        private void drawConnectingLine(int posFromLeft1, int posFromTop1, int posFromLeft2, int posFromTop2, LineMark lineMark) {
            log.finer(() -> "posFromLeft1=" + posFromLeft1 + " posFromTop1=" + posFromTop1 + " posFromLeft2=" + posFromLeft2 + " posFromTop2=" + posFromTop2);
            if (posFromLeft1 != posFromLeft2 || posFromTop1 != posFromTop2) {
                this.setLineMark(lineMark);
                CurveSurvey.this.canvasGC.drawLine(posFromLeft1 + this.offSetX, posFromTop1 + this.offSetY, posFromLeft2 + this.offSetX, posFromTop2 + this.offSetY);
            }
        }

        private void drawOutlier(int posFromLeft1, int posFromTop1, int radius, LineMark lineMark) {
            log.finer(() -> "posFromLeft1=" + posFromLeft1 + " posFromTop1=" + posFromTop1);
            log.finer(() -> "yUpperLimit=" + this.yUpperLimit + " yLowerLimit=" + this.yLowerLimit);
            this.setLineMark(lineMark);
            CurveSurvey.this.canvasGC.drawOval(posFromLeft1 - radius + this.offSetX, posFromTop1 - radius + this.offSetY, radius * 2, radius * 2);
        }

        public void drawAverageLine(int posFromLeft1, int posFromTop1, int length) {
            this.drawHorizontalLine(posFromLeft1, posFromTop1, length, LineMark.AVG_LINE);
        }

        public void drawLinearRegressionLine(int posFromLeft1, int posFromTop1, int posFromLeft2, int posFromTop2) {
            this.drawConnectingLine(posFromLeft1, posFromTop1, posFromLeft2, posFromTop2, LineMark.SLOPE_LINE);
            this.yLowerLimit = Math.max(this.yLowerLimit, Math.max(posFromTop1, posFromTop2));
            this.yUpperLimit = Math.min(this.yUpperLimit, Math.min(posFromTop1, posFromTop2));
            this.xLeftLimit = Math.min(this.xLeftLimit, Math.min(posFromLeft1, posFromLeft2));
            this.xRightLimit = Math.max(this.xRightLimit, Math.max(posFromLeft1, posFromLeft2));
            log.finer(() -> "xLeftLimit=" + this.xLeftLimit + " xRightLimit=" + this.xRightLimit + "yUpperLimit=" + this.yUpperLimit + " yLowerLimit=" + this.yLowerLimit);
        }

        public void drawRegressionParabolaLine(List<Spot<Integer>> points) {
            log.finer(() -> "xPos0=" + ((Spot)points.get(0)).x() + " xPosN=" + ((Spot)points.get(points.size() - 1)).x() + " yPos0=" + ((Spot)points.get(0)).y() + " yPosN=" + ((Spot)points.get(points.size() - 1)).y());
            SingleResponseRegression singleResponseRegression = new SingleResponseRegression(points, SingleResponseRegression.RegressionType.QUADRATIC);
            int xPosStart = Math.min((Integer)points.get(0).x(), (Integer)points.get(points.size() - 1).x());
            int xPosEnd = Math.max((Integer)points.get(0).x(), (Integer)points.get(points.size() - 1).x());
            if (singleResponseRegression.getGamma() == 0.0) {
                int yPosStart = (int)(singleResponseRegression.getResponse(xPosStart) + 0.5);
                int yPosEnd = (int)(singleResponseRegression.getResponse(xPosEnd) + 0.5);
                this.drawConnectingLine(xPosStart, yPosStart, xPosEnd, yPosEnd, LineMark.PARABOLA_LINE);
            } else {
                int[] pointArray = new int[(xPosEnd - xPosStart) * 2];
                for (int i = 0; i < xPosEnd - xPosStart; ++i) {
                    pointArray[i * 2] = this.offSetX + xPosStart + i;
                    pointArray[i * 2 + 1] = this.offSetY + (int)(singleResponseRegression.getResponse(xPosStart + i) + 0.5);
                }
                this.setLineMark(LineMark.PARABOLA_LINE);
                CurveSurvey.this.canvasGC.drawPolyline(pointArray);
            }
            int leftExtremum = (int)singleResponseRegression.getResponse(((Integer)points.get(0).x()).intValue());
            int rightExtremum = (int)singleResponseRegression.getResponse(((Integer)points.get(points.size() - 1).x()).intValue());
            int yLowerLimitTmp = Math.max(this.yLowerLimit, Math.max(leftExtremum, rightExtremum));
            int yUpperLimitTmp = Math.min(this.yUpperLimit, Math.min(leftExtremum, rightExtremum));
            if (singleResponseRegression.getGamma() != 0.0) {
                Double xPosExtremum = singleResponseRegression.getParabolaExtremum();
                double mid = (double)((Integer)points.get(0).x() + (Integer)points.get(points.size() - 1).x()) / 2.0;
                if (Math.abs(xPosExtremum - mid) <= Math.abs((double)((Integer)points.get(0).x()).intValue() - mid)) {
                    int absoluteExtremum = (int)singleResponseRegression.getResponse(xPosExtremum);
                    yLowerLimitTmp = Math.max(this.yLowerLimit, absoluteExtremum);
                    yUpperLimitTmp = Math.min(this.yUpperLimit, absoluteExtremum);
                }
            }
            this.yLowerLimit = Math.min(this.height, yLowerLimitTmp + 3);
            this.yUpperLimit = Math.max(0, yUpperLimitTmp - 3);
            log.finer(() -> "yUpperLimit=" + this.yUpperLimit + " yLowerLimit=" + this.yLowerLimit);
        }

        public void drawCross(int posFromLeft1, int posFromTop1) {
            this.drawVerticalLine(posFromLeft1, 0, this.height, LineMark.MEASURE_CROSS);
            this.drawHorizontalLine(posFromTop1, 0, this.width, LineMark.MEASURE_CROSS);
        }

        public void drawDoubleCross(int posFromLeft1, int posFromTop1, int posFromLeft2, int posFromTop2) {
            this.drawVerticalLine(posFromLeft1, 0, this.height, LineMark.MEASURE_CROSS);
            this.drawHorizontalLine(posFromTop1, 0, this.width, LineMark.MEASURE_CROSS);
            this.drawVerticalLine(posFromLeft2, 0, this.height, LineMark.DELTA_CROSS);
            this.drawHorizontalLine(posFromTop2, 0, this.width, LineMark.DELTA_CROSS);
            this.drawConnectingLine(posFromLeft1, posFromTop1, posFromLeft2, posFromTop2, LineMark.DIAG_LINE);
            this.yLowerLimit = Math.max(this.yLowerLimit, Math.max(posFromTop1, posFromTop2));
            this.yUpperLimit = Math.min(this.yUpperLimit, Math.min(posFromTop1, posFromTop2));
            this.xLeftLimit = Math.min(this.xLeftLimit, Math.min(posFromLeft1, posFromLeft2));
            this.xRightLimit = Math.max(this.xRightLimit, Math.max(posFromLeft1, posFromLeft2));
            log.finer(() -> "xLeftLimit=" + this.xLeftLimit + " xRightLimit=" + this.xRightLimit + "yUpperLimit=" + this.yUpperLimit + " yLowerLimit=" + this.yLowerLimit);
        }

        public void drawBoxplot(int xPos, int[] yPosBoxplot) {
            int yPosTop;
            int halfBoxWidth = this.getBoxWidth() / 2;
            int xPosLeft = xPos - halfBoxWidth;
            int xPosRight = xPos + halfBoxWidth;
            int radius = halfBoxWidth / 4;
            this.xLeftLimit = Math.min(xPosLeft, this.xLeftLimit);
            this.xRightLimit = Math.max(xPosRight, this.xRightLimit);
            int yPosQuartile1 = yPosBoxplot[ElementaryQuantile.BoxplotItems.QUARTILE1.ordinal()];
            this.drawHorizontalLine(yPosQuartile1, xPosLeft, halfBoxWidth * 2, LineMark.BOXPLOT);
            this.drawHorizontalLine(yPosBoxplot[ElementaryQuantile.BoxplotItems.QUARTILE2.ordinal()], xPosLeft, halfBoxWidth * 2, LineMark.BOXPLOT);
            int yPosQuartile3 = yPosBoxplot[ElementaryQuantile.BoxplotItems.QUARTILE3.ordinal()];
            this.drawHorizontalLine(yPosQuartile3, xPosLeft, halfBoxWidth * 2, LineMark.BOXPLOT);
            this.drawVerticalLine(xPosLeft, yPosQuartile3, yPosQuartile1 - yPosQuartile3, LineMark.BOXPLOT);
            this.drawVerticalLine(xPosRight, yPosQuartile3, yPosQuartile1 - yPosQuartile3, LineMark.BOXPLOT);
            int yPosLowerWhisker = yPosBoxplot[ElementaryQuantile.BoxplotItems.LOWER_WHISKER.ordinal()];
            this.drawHorizontalLine(yPosLowerWhisker, xPos - halfBoxWidth / 2, halfBoxWidth, LineMark.BOXPLOT);
            this.drawVerticalLine(xPos, yPosQuartile1, yPosLowerWhisker - yPosQuartile1, LineMark.BOXPLOT);
            int yPosUpperWhisker = yPosBoxplot[ElementaryQuantile.BoxplotItems.UPPER_WHISKER.ordinal()];
            this.drawHorizontalLine(yPosUpperWhisker, xPos - halfBoxWidth / 2, halfBoxWidth, LineMark.BOXPLOT);
            this.drawVerticalLine(xPos, yPosUpperWhisker, yPosQuartile3 - yPosUpperWhisker, LineMark.BOXPLOT);
            log.finer(() -> String.format("xPos=%d  LW=%d Q1=%d Q2=%d Q3=%d UW=%d ", xPos, yPosLowerWhisker, yPosQuartile1, yPosBoxplot[ElementaryQuantile.BoxplotItems.QUARTILE2.ordinal()], yPosQuartile3, yPosUpperWhisker));
            int yPosBottom = yPosBoxplot[ElementaryQuantile.BoxplotItems.QUARTILE0.ordinal()];
            if (yPosBottom != yPosBoxplot[ElementaryQuantile.BoxplotItems.LOWER_WHISKER.ordinal()]) {
                this.drawOutlier(xPos, yPosBottom, radius, LineMark.BOXPLOT);
            }
            if ((yPosTop = yPosBoxplot[ElementaryQuantile.BoxplotItems.QUARTILE4.ordinal()]) != yPosBoxplot[ElementaryQuantile.BoxplotItems.UPPER_WHISKER.ordinal()]) {
                this.drawOutlier(xPos, yPosTop, radius, LineMark.BOXPLOT);
            }
            this.yLowerLimit = Math.max(this.yLowerLimit, yPosBottom + radius);
            this.yUpperLimit = Math.min(this.yUpperLimit, yPosTop - radius);
            log.finer(() -> "xLeftLimit=" + this.xLeftLimit + " xRightLimit=" + this.xRightLimit + " yUpperLimit=" + this.yUpperLimit + " yLowerLimit=" + this.yLowerLimit);
        }

        private void setLineMark(LineMark lineMark) {
            CurveSurvey.this.canvasGC.setLineWidth(lineMark.lineWidth);
            CurveSurvey.this.canvasGC.setLineDash(lineMark.lineDash);
            CurveSurvey.this.canvasGC.setLineStyle(lineMark.lineStyle);
            if (lineMark.lineColor == null) {
                CurveSurvey.this.canvasGC.setForeground(ColorUtils.getColor(CurveSurvey.this.trailRecord.getRGB()));
            } else {
                CurveSurvey.this.canvasGC.setForeground(SWTResourceManager.getColor(lineMark.lineColor));
            }
        }

        private int getBoxWidth() {
            int boxWidth = 15;
            if (Math.abs(GraphicsMeasuring.xPosDelta - GraphicsMeasuring.xPosMeasure) > boxWidth) {
                log.log(Level.FINEST, "boxwidth=", boxWidth += (int)Math.log(Math.abs(GraphicsMeasuring.xPosDelta - GraphicsMeasuring.xPosMeasure)) * 4 - 10);
            }
            return boxWidth + boxWidth * (Settings.getInstance().getBoxplotScaleOrdinal() - 1) / 2;
        }

        public String toString() {
            return "LinePainter [offSetX=" + this.offSetX + ", offSetY=" + this.offSetY + ", width=" + this.width + ", height=" + this.height + ", yLowerLimit=" + this.yLowerLimit + ", yUpperLimit=" + this.yUpperLimit + ", xLeftLimit=" + this.xLeftLimit + ", xRightLimit=" + this.xRightLimit + ", getBoxWidth()=" + this.getBoxWidth() + "]";
        }
    }

    public static enum LineMark {
        MEASURE_CROSS(1, 6, 2, null),
        DELTA_CROSS(1, 9, 2, null),
        DIAG_LINE(1, 8, 3, new int[]{5, 2}),
        AVG_LINE(2, null, 2, null),
        PARABOLA_LINE(2, null, 3, null),
        SLOPE_LINE(2, null, 1, null),
        BOXPLOT(2, null, 1, null);

        private final int lineWidth;
        private final Integer lineColor;
        private final int lineStyle;
        private final int[] lineDash;

        private LineMark(int lineWidth, Integer lineColor, int lineStyle, int[] lineDash) {
            this.lineWidth = lineWidth;
            this.lineColor = lineColor;
            this.lineStyle = lineStyle;
            this.lineDash = lineDash;
        }
    }
}

