/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.Analyzer;
import gde.device.IChannelItem;
import gde.device.TrailDisplayType;
import gde.device.TrailTypes;
import gde.device.TrailVisibilityType;
import gde.device.resource.DeviceXmlResource;
import gde.histo.recordings.TrailRecord;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class TrailSelector {
    private static final String $CLASS_NAME = TrailSelector.class.getName();
    protected static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();
    protected final String deviceName;
    protected final IChannelItem channelItem;
    protected final String recordName;
    protected final boolean smartStatistics;
    protected final int channelConfigNumber;
    protected final Analyzer analyzer;
    protected int trailTextSelectedIndex = -1;
    protected List<String> applicableTrailsTexts;
    protected List<Integer> applicableTrailsOrdinals;
    protected int[] extremumIndices = null;

    protected TrailSelector(TrailRecord trailRecord) {
        this.deviceName = trailRecord.getParent().getDevice().getName();
        this.channelItem = trailRecord.channelItem;
        this.recordName = trailRecord.getName();
        this.smartStatistics = trailRecord.getParent().isSmartStatistics();
        this.channelConfigNumber = trailRecord.getParent().getChannelConfigNumber();
        this.analyzer = trailRecord.getParent().getAnalyzer();
        if (!this.deviceName.equals(this.analyzer.getActiveDevice().getName())) {
            throw new IllegalArgumentException("deviceName=" + this.deviceName + " != " + this.analyzer.getActiveDevice().getName());
        }
        if (this.channelConfigNumber != this.analyzer.getActiveChannel().getNumber()) {
            throw new IllegalArgumentException("channelNumber=" + this.channelConfigNumber + " != " + this.analyzer.getActiveChannel().getNumber());
        }
        this.setApplicableTrails();
    }

    protected TrailSelector(Analyzer analyzer, IChannelItem channelItem, String recordName, boolean smartStatistics) {
        this.deviceName = analyzer.getActiveDevice().getName();
        this.channelItem = channelItem;
        this.recordName = recordName;
        this.smartStatistics = smartStatistics;
        this.channelConfigNumber = analyzer.getActiveChannel().getNumber();
        this.analyzer = analyzer;
        this.setApplicableTrails();
    }

    public void setMostApplicableTrailTextOrdinal() {
        int displaySequence = Integer.MAX_VALUE;
        for (int i = 0; i < this.applicableTrailsOrdinals.size(); ++i) {
            int tmpDisplaySequence = TrailTypes.fromOrdinal(this.applicableTrailsOrdinals.get(i)).getDisplaySequence();
            if (tmpDisplaySequence >= displaySequence) continue;
            displaySequence = tmpDisplaySequence;
            this.setTrailTextSelectedIndex(i);
        }
    }

    public Integer getTrailTextSelectedIndex() {
        return this.trailTextSelectedIndex;
    }

    public void setTrailTextSelectedIndex(int value) {
        this.trailTextSelectedIndex = value;
    }

    public String getTrailText() {
        return this.applicableTrailsTexts.size() == 0 ? "" : this.applicableTrailsTexts.get(this.trailTextSelectedIndex);
    }

    public List<String> getApplicableTrailsTexts() {
        return this.applicableTrailsTexts;
    }

    public int getTrailOrdinal() {
        return this.applicableTrailsOrdinals.get(this.trailTextSelectedIndex);
    }

    public abstract boolean isTrailSuite();

    public abstract boolean isRangePlotSuite();

    public abstract boolean isBoxPlotSuite();

    public abstract boolean isOddRangeTrail();

    public abstract int getSuiteMasterIndex();

    public abstract List<TrailTypes> getSuiteMembers();

    protected String getDeviceXmlReplacement(String replacementKey) {
        return replacementKey != null ? this.xmlResource.getReplacement(replacementKey) : "";
    }

    public int[] getExtremumTrailsOrdinals() {
        if (this.extremumIndices == null) {
            this.setExtremumIndices();
        }
        return new int[]{this.applicableTrailsOrdinals.get(this.extremumIndices[0]), this.applicableTrailsOrdinals.get(this.extremumIndices[1])};
    }

    public String[] getExtremumTrailsTexts() {
        if (this.extremumIndices == null) {
            this.setExtremumIndices();
        }
        return new String[]{this.applicableTrailsTexts.get(this.extremumIndices[0]), this.applicableTrailsTexts.get(this.extremumIndices[1])};
    }

    public int[] getExtremumTrailsIndices() {
        if (this.extremumIndices == null) {
            this.setExtremumIndices();
        }
        return this.extremumIndices;
    }

    protected void setExtremumIndices() {
        int i;
        int indexMin = -1;
        int indexMax = -1;
        for (i = 0; i < this.applicableTrailsOrdinals.size(); ++i) {
            if (this.applicableTrailsOrdinals.get(i).intValue() == TrailTypes.Q0.ordinal()) {
                indexMin = i;
                continue;
            }
            if (this.applicableTrailsOrdinals.get(i).intValue() != TrailTypes.Q4.ordinal()) continue;
            indexMax = i;
        }
        if (indexMin == -1 || indexMax == -1) {
            for (i = 0; i < this.applicableTrailsOrdinals.size(); ++i) {
                if (this.applicableTrailsOrdinals.get(i).intValue() == TrailTypes.MIN.ordinal()) {
                    indexMin = i;
                    continue;
                }
                if (this.applicableTrailsOrdinals.get(i).intValue() != TrailTypes.MAX.ordinal()) continue;
                indexMax = i;
            }
        }
        this.extremumIndices = indexMin == -1 || indexMax == -1 ? new int[]{0, 0} : new int[]{indexMin, indexMax};
    }

    protected abstract void setApplicableTrails();

    protected void setApplicableSuiteTrails() {
        Optional<TrailDisplayType> trailDisplay = this.channelItem.getTrailDisplay();
        if (trailDisplay.isPresent()) {
            List displayTrails;
            boolean hideAllTrails = trailDisplay.map(TrailDisplayType::isDiscloseAll).orElse(false);
            if (hideAllTrails) {
                displayTrails = trailDisplay.map(x -> x.getExposed().stream().map(TrailVisibilityType::getTrail).filter(TrailTypes::isSuite).filter(t -> t.isSmartStatistics() == this.smartStatistics).collect(Collectors.toList())).orElse(new ArrayList());
            } else {
                List disclosedTrails = trailDisplay.map(x -> x.getDisclosed().stream().map(TrailVisibilityType::getTrail).filter(TrailTypes::isSuite).filter(t -> t.isSmartStatistics() == this.smartStatistics).collect(Collectors.toList())).orElse(new ArrayList());
                displayTrails = TrailTypes.getSuites().stream().filter(t -> !disclosedTrails.contains(t)).filter(t -> t.isSmartStatistics() == this.smartStatistics).collect(Collectors.toList());
            }
            for (TrailTypes suiteTrailType : displayTrails) {
                this.applicableTrailsOrdinals.add(suiteTrailType.ordinal());
                this.applicableTrailsTexts.add(suiteTrailType.getDisplayName().intern());
            }
        } else {
            for (TrailTypes suiteTrailType : TrailTypes.getSuites()) {
                if (suiteTrailType.isSmartStatistics() != this.smartStatistics) continue;
                this.applicableTrailsOrdinals.add(suiteTrailType.ordinal());
                this.applicableTrailsTexts.add(suiteTrailType.getDisplayName().intern());
            }
        }
    }

    protected void adaptTrailsToDisplayType(BitSet trails, TrailDisplayType displayType) {
        if (displayType.isDiscloseAll().booleanValue()) {
            trails.clear();
        }
        BitSet exposedTrails = new BitSet();
        displayType.getExposed().stream().map(TrailVisibilityType::getTrail).filter(t -> !t.isSuite()).filter(t -> t.isSmartStatistics() == this.smartStatistics).map(Enum::ordinal).forEach(idx -> exposedTrails.set((int)idx));
        trails.or(exposedTrails);
        BitSet disclosedTrails = new BitSet();
        displayType.getDisclosed().stream().map(TrailVisibilityType::getTrail).filter(t -> !t.isSuite()).filter(t -> t.isSmartStatistics() == this.smartStatistics).map(Enum::ordinal).forEach(idx -> disclosedTrails.set((int)idx));
        trails.andNot(disclosedTrails);
        if (trails.isEmpty() && displayType.getDefaultTrail() != null) {
            trails.set(displayType.getDefaultTrail().ordinal());
        }
    }

    public String toString() {
        return "TrailSelector [" + this.recordName + " trailTextSelectedIndex=" + this.trailTextSelectedIndex + " " + this.getTrailText() + ", applicableTrailsTexts=" + this.applicableTrailsTexts + ", applicableTrailsOrdinals=" + this.applicableTrailsOrdinals + ", extremumIndices=" + Arrays.toString(this.extremumIndices) + "]";
    }
}

