/*
 * Decompiled with CFR 0.152.
 */
package gde.device.opentx;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.opentx.OpenTxAdapter;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.MissMatchDeviceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;

public class CSVReaderWriter {
    static Logger log = Logger.getLogger(CSVReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    public static HashMap<String, String> getHeader(char separator, String filePath) throws NotSupportedFileFormatException, IOException {
        String line = "*";
        HashMap<String, String> header = new HashMap<String, String>();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
            line = reader.readLine();
            String[] headerData = line.split("" + separator);
            if (headerData.length > 2 || headerData.length < 1) {
                String tmpHeaderLine = application.getActiveDevice().getName() + separator + channels.getActiveChannel().getChannelConfigKey();
                headerData = tmpHeaderLine.split("" + separator);
            }
            for (int i = 0; i < headerData.length; ++i) {
                if (i == 0) {
                    header.put("DeviceName : ", headerData[i].split("\\r")[0].trim());
                }
                if (i != 1) continue;
                header.put("Channel/Configuration Name: ", headerData[i].split(" ")[0].split("\\r")[0].trim());
            }
            log.log(Level.FINE, "DeviceName : " + (String)header.get("DeviceName : "));
            log.log(Level.FINE, "Channel/Configuration Name: " + (header.get("Channel/Configuration Name: ") != null ? (String)header.get("Channel/Configuration Name: ") : ""));
            while (!line.startsWith("Date,Time") && (line = reader.readLine()) != null) {
            }
            header.put("CSV_data_header : ", line);
            log.log(Level.FINE, "CSV_data_header : " + (header.get("CSV_data_header : ") != null ? (String)header.get("CSV_data_header : ") : ""));
        }
        return header;
    }

    public static HashMap<String, String> evaluateType(char separator, HashMap<String, String> header, DeviceConfiguration deviceConfig) {
        StringBuilder sb_measurements = new StringBuilder();
        StringBuilder sb_units = new StringBuilder();
        String headerLine = header.get("CSV_data_header : ");
        String[] headerLineArray = headerLine.split("" + separator);
        header.put("CSV_data_type : ", "raw");
        log.log(Level.FINE, "CSV_data_type : " + header.get("CSV_data_type : "));
        String channelConfig = header.get("Channel/Configuration Name: ");
        int channelNumber = channels.getChannelNumber(channelConfig);
        if (channelConfig != null && !channels.getActiveChannel().getChannelConfigKey().equals(channelConfig) && channelNumber >= 1 && channelNumber <= deviceConfig.getChannelCount()) {
            channels.setActiveChannelNumber(channelNumber);
        } else {
            channelConfig = channels.getActiveChannel().getChannelConfigKey();
            channels.setActiveChannelNumber(channels.getActiveChannelNumber());
            channelNumber = channels.getActiveChannelNumber();
        }
        header.put("Channel/Configuration Name: ", channelConfig);
        header.put("Channel/Configuration Number : ", "" + channels.getActiveChannelNumber());
        log.log(Level.FINE, "Channel/Configuration Name: " + header.get("Channel/Configuration Number : ") + " : " + header.get("Channel/Configuration Name: "));
        ArrayList<String> ignoreIndexList = new ArrayList<String>();
        int i = 2;
        int j = 2;
        while (i < headerLineArray.length) {
            if (headerLineArray[i].contains("LSW")) {
                ignoreIndexList.add("" + j);
                header.put("CSV_data_ignore_index : ", StringHelper.listToString(ignoreIndexList, (char)separator));
            } else {
                String inUnit;
                String mappedMeasurement;
                String string = headerLineArray[i].contains("(") ? String.format("%s [%s]", headerLineArray[i].substring(0, headerLineArray[i].indexOf("(")), headerLineArray[i].substring(headerLineArray[i].indexOf("(") + 1, headerLineArray[i].length() - 1)) : (mappedMeasurement = OpenTxAdapter.properties.getProperty(headerLineArray[i].contains("(") ? headerLineArray[i].substring(0, headerLineArray[i].indexOf("(")) : headerLineArray[i]));
                if (mappedMeasurement == null) {
                    mappedMeasurement = String.format("%s [-]", headerLineArray[i]);
                }
                int count = 1;
                for (String measurement : sb_measurements.toString().split(";")) {
                    if (!mappedMeasurement.split("\\[|]")[0].trim().equals(measurement)) continue;
                    mappedMeasurement = String.format("%s %d [%s]", mappedMeasurement.split("\\[|]")[0].trim().indexOf(32) > 0 ? mappedMeasurement.substring(0, mappedMeasurement.indexOf(32)) : mappedMeasurement.split("\\[|]")[0].trim(), count++, mappedMeasurement.split("\\[|]")[1]);
                }
                log.log(Level.INFO, "corrected mappedMeasurement = " + mappedMeasurement);
                String[] inHeaderMeasurement = mappedMeasurement.trim().split("\\[|]");
                String inMeasurement = inHeaderMeasurement.length >= 1 ? inHeaderMeasurement[0].trim() : "---";
                String string2 = inUnit = inHeaderMeasurement.length == 2 ? inHeaderMeasurement[1].trim() : "---";
                if (inMeasurement.equals("GPS")) {
                    sb_measurements.append(inMeasurement + ".latitude").append(";");
                    sb_units.append("\u00b0").append(";");
                    sb_measurements.append(inMeasurement + ".longitude").append(";");
                    sb_units.append("\u00b0").append(";");
                    ++j;
                } else if (inMeasurement.startsWith("GPS") && inMeasurement.toLowerCase().contains("zeit") && !sb_measurements.toString().toLowerCase().contains("gps datum") && !sb_measurements.toString().toLowerCase().contains("gps time")) {
                    mappedMeasurement = OpenTxAdapter.properties.getProperty("GPS.date");
                    if (mappedMeasurement != null) {
                        sb_measurements.append(mappedMeasurement.split("\\[|]")[0].trim()).append(";");
                        sb_units.append(mappedMeasurement.split("\\[|]")[1].trim()).append(";");
                    } else {
                        sb_measurements.append("GPS.date").append(";");
                        sb_units.append("yy-mm-dd").append(";");
                    }
                    mappedMeasurement = OpenTxAdapter.properties.getProperty("GPS.time");
                    if (mappedMeasurement != null) {
                        sb_measurements.append(mappedMeasurement.split("\\[|]")[0].trim()).append(";");
                        sb_units.append(mappedMeasurement.split("\\[|]")[1].trim()).append(";");
                    } else {
                        sb_measurements.append("GPS.time").append(";");
                        sb_units.append("HH:mm:ss").append(";");
                    }
                } else if (inMeasurement.toLowerCase().startsWith("date")) {
                    mappedMeasurement = OpenTxAdapter.properties.getProperty("GPS.date");
                    if (mappedMeasurement != null) {
                        sb_measurements.append(mappedMeasurement.split("\\[|]")[0].trim()).append(";");
                        sb_units.append(mappedMeasurement.split("\\[|]")[1].trim()).append(";");
                    } else {
                        sb_measurements.append("GPS.date").append(";");
                        sb_units.append("yy-mm-dd").append(";");
                    }
                    mappedMeasurement = OpenTxAdapter.properties.getProperty("GPS.time");
                    if (mappedMeasurement != null) {
                        sb_measurements.append(mappedMeasurement.split("\\[|]")[0].trim()).append(";");
                        sb_units.append(mappedMeasurement.split("\\[|]")[1].trim()).append(";");
                    } else {
                        sb_measurements.append("GPS.time").append(";");
                        sb_units.append("HH:mm:ss").append(";");
                    }
                } else {
                    sb_measurements.append(inMeasurement).append(";");
                    sb_units.append(inUnit).append(";");
                }
            }
            ++i;
            ++j;
        }
        header.put("CSV_data_header_measurements : ", sb_measurements.toString());
        header.put("CSV_data_header_units : ", sb_units.toString());
        return header;
    }

    public static RecordSet read(char separator, String filePath, String recordSetNameExtend) throws NotSupportedFileFormatException, MissMatchDeviceException, IOException, DataInconsitsentException, DataTypeException {
        RecordSet recordSet;
        block72: {
            String line = "*";
            recordSet = null;
            long inputFileSize = new File(filePath).length();
            int progressLineLength = Math.abs(application.getActiveDevice().getDataBlockSize(InputTypes.FILE_IO));
            IDevice device = application.getActiveDevice();
            Channel activeChannel = null;
            Vector<String> createdRecordSets = new Vector<String>();
            try {
                HashMap<String, String> fileHeader = CSVReaderWriter.getHeader(separator, filePath);
                activeChannel = (Channel)channels.get((Object)channels.getChannelNumber(fileHeader.get("Channel/Configuration Name: ")));
                Channel channel = activeChannel = activeChannel == null ? channels.getActiveChannel() : activeChannel;
                if (activeChannel == null) break block72;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0134") + filePath);
                GDE.getUiNotification().setProgress(0);
                long time_ms = 0L;
                if (!application.getActiveDevice().getName().equals(fileHeader.get("DeviceName : "))) {
                    MissMatchDeviceException e = new MissMatchDeviceException(Messages.getString((String)"GDE_MSGW0013", (Object[])new Object[]{fileHeader.get("DeviceName : ")}));
                    log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    throw e;
                }
                fileHeader = CSVReaderWriter.evaluateType(separator, fileHeader, (DeviceConfiguration)device);
                log.log(Level.FINE, "device name check ok, channel/configuration ok");
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                int lineNumber = 0;
                while (!line.startsWith("Date,Time") && (line = reader.readLine()) != null) {
                    ++lineNumber;
                }
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                String[] tmpRecordNames = fileHeader.get("CSV_data_header_measurements : ").split(";");
                String[] tmpRecordUnits = fileHeader.get("CSV_data_header_units : ").split(";");
                String[] tmpRecordSymbols = new String[tmpRecordNames.length];
                for (int i = 0; i < tmpRecordNames.length; ++i) {
                    tmpRecordSymbols[i] = "";
                }
                recordSet = CSVReaderWriter.createRecordSet(recordSetNameExtend, device, activeChannel, tmpRecordNames, tmpRecordUnits, tmpRecordSymbols);
                String recordSetName = recordSet.getName();
                createdRecordSets.add(recordSetName);
                for (int i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    if (record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("speed") || record.getName().toLowerCase().contains("geschw")) || record.getName().startsWith("GSpd")) {
                        record.setDataType(Record.DataType.GPS_SPEED);
                    } else if (record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("alt") || record.getName().toLowerCase().contains("h\u00f6he")) || record.getName().startsWith("Alt") || record.getName().startsWith("GAlt")) {
                        record.setDataType(Record.DataType.GPS_ALTITUDE);
                    } else if (record.getUnit().contains("\u00b0") && record.getUnit().contains("'") && (record.getName().toLowerCase().contains("long") || record.getName().toLowerCase().contains("l\u00e4nge")) || record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("long") || record.getName().toLowerCase().contains("l\u00e4nge")) || record.getName().toLowerCase().contains("ngengrad")) {
                        record.setDataType(Record.DataType.GPS_LONGITUDE);
                        if (record.getUnit().equals("-")) {
                            record.setUnit("\u00b0");
                        }
                    } else if (record.getUnit().contains("\u00b0") && record.getUnit().contains("'") && (record.getName().toLowerCase().contains("lat") || record.getName().toLowerCase().contains("breit")) || record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("lat") || record.getName().toLowerCase().contains("breit")) || record.getName().toLowerCase().contains("breitengrad")) {
                        record.setDataType(Record.DataType.GPS_LATITUDE);
                        if (record.getUnit().equals("-")) {
                            record.setUnit("\u00b0");
                        }
                    } else if (record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("date") || record.getName().toLowerCase().contains("time") || record.getName().toLowerCase().contains("datum") || record.getName().toLowerCase().contains("zeit")) || record.getName().toLowerCase().contains("date")) {
                        record.setDataType(Record.DataType.GPS_TIME);
                    }
                    MeasurementType measurement = device.getMeasurement(activeChannel.getNumber(), i);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, tmpRecordNames[i]);
                    }
                    measurement.setName(tmpRecordNames[i]);
                    measurement.setSymbol(tmpRecordSymbols[i]);
                    measurement.setUnit(tmpRecordUnits[i]);
                }
                long startTimeStamp = 0L;
                long lastTimeStamp = 0L;
                String[] updateRecordNames = recordSet.getRecordNames();
                int[] points = new int[updateRecordNames.length];
                while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    if (line.startsWith("#")) {
                        if (recordSet.getRecordSetDescription().endsWith(GDE.LINE_SEPARATOR)) {
                            recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + line.substring(1) + GDE.LINE_SEPARATOR);
                            continue;
                        }
                        recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + line.replace('#', ' ') + GDE.LINE_SEPARATOR);
                        continue;
                    }
                    String[] dataStr = line.replace(", ", ",").split(" |" + separator);
                    String data = dataStr[0].trim();
                    int year = Integer.parseInt(data.substring(0, 4));
                    int month = Integer.parseInt(data.substring(5, 7));
                    int day = Integer.parseInt(data.substring(8, 10));
                    data = dataStr[1].trim();
                    int hour = Integer.parseInt(data.substring(0, 2));
                    int minute = Integer.parseInt(data.substring(3, 5));
                    int second = Integer.parseInt(data.substring(6, 8));
                    int millis = Integer.parseInt(data.substring(9, 12));
                    GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                    long timeStamp = calendar.getTimeInMillis() + (long)millis;
                    if (lastTimeStamp >= timeStamp) continue;
                    if (timeStamp - lastTimeStamp > 5000L) {
                        if (recordSet.get(0).size() > 100) {
                            if (lastTimeStamp > 0L) {
                                log.log(Level.WARNING, String.format("time differenze = %s msec, actual number record entries = %d", CSVReaderWriter.getFormatedTimeDiff(startTimeStamp, lastTimeStamp), recordSet.get(0).size()));
                            }
                            recordSet.setSaved(true);
                            activeChannel.put((Object)recordSetName, (Object)recordSet);
                            activeChannel.setActiveRecordSet(recordSetName);
                            activeChannel.applyTemplate(recordSetName, true);
                            device.updateVisibilityStatus(recordSet, true);
                        } else {
                            log.log(Level.WARNING, String.format("time differenze = %d msec, actual number record entries = %d (< 100 -> remove)", timeStamp - lastTimeStamp, recordSet.get(0).size()));
                        }
                        recordSet = CSVReaderWriter.createRecordSet(recordSetNameExtend, device, activeChannel, tmpRecordNames, tmpRecordUnits, tmpRecordSymbols);
                        recordSetName = recordSet.getName();
                        startTimeStamp = 0L;
                        lastTimeStamp = 0L;
                        if (!createdRecordSets.contains(recordSetName)) {
                            createdRecordSets.add(recordSetName);
                        }
                    }
                    time_ms = lastTimeStamp == 0L ? 0L : time_ms + (timeStamp - lastTimeStamp);
                    lastTimeStamp = timeStamp;
                    if (startTimeStamp == 0L) {
                        startTimeStamp = timeStamp;
                        recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                        recordSet.setStartTimeStamp(startTimeStamp);
                        recordSet.descriptionAppendFilename(filePath);
                        activeChannel.setFileDescription(new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp).substring(0, 10) + activeChannel.getFileDescription().substring(10));
                    }
                    for (int i = 0; i < recordSet.size(); ++i) {
                        Record record = recordSet.get(i);
                        if (record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("speed") || record.getName().toLowerCase().contains("geschw")) || record.getName().startsWith("GSpd")) {
                            record.setDataType(Record.DataType.GPS_SPEED);
                        } else if (record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("alt") || record.getName().toLowerCase().contains("h\u00f6he")) || record.getName().startsWith("Alt") || record.getName().startsWith("GAlt")) {
                            record.setDataType(Record.DataType.GPS_ALTITUDE);
                        } else if (record.getUnit().contains("\u00b0") && record.getUnit().contains("'") && (record.getName().toLowerCase().contains("long") || record.getName().toLowerCase().contains("l\u00e4nge")) || record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("long") || record.getName().toLowerCase().contains("l\u00e4nge")) || record.getName().toLowerCase().contains("gengrad")) {
                            record.setDataType(Record.DataType.GPS_LONGITUDE);
                            if (record.getUnit().equals("-")) {
                                record.setUnit("\u00b0");
                            }
                        } else if (record.getUnit().contains("\u00b0") && record.getUnit().contains("'") && (record.getName().toLowerCase().contains("lat") || record.getName().toLowerCase().contains("breit")) || record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("lat") || record.getName().toLowerCase().contains("breit")) || record.getName().toLowerCase().contains("tengrad")) {
                            record.setDataType(Record.DataType.GPS_LATITUDE);
                            if (record.getUnit().equals("-")) {
                                record.setUnit("\u00b0");
                            }
                        } else if (record.getName().toLowerCase().contains("gps") && (record.getName().toLowerCase().contains("date") || record.getName().toLowerCase().contains("time") || record.getName().toLowerCase().contains("datum") || record.getName().toLowerCase().contains("zeit")) || record.getName().toLowerCase().contains("date")) {
                            record.setDataType(Record.DataType.GPS_TIME);
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, record.getName() + " - " + record.getDataType());
                        }
                        MeasurementType measurement = device.getMeasurement(activeChannel.getNumber(), i);
                        measurement.setName(tmpRecordNames[i]);
                        measurement.setSymbol(tmpRecordSymbols[i]);
                        measurement.setUnit(tmpRecordUnits[i]);
                    }
                    List skipIndexList = fileHeader.get("CSV_data_ignore_index : ") != null ? StringHelper.stringToList((String)fileHeader.get("CSV_data_ignore_index : "), (char)separator) : new ArrayList();
                    int i = 0;
                    int j = 0;
                    while (i < updateRecordNames.length) {
                        while (skipIndexList.size() > 0 && j + 2 == Integer.parseInt((String)skipIndexList.get(0))) {
                            skipIndexList = skipIndexList.subList(1, skipIndexList.size());
                            ++j;
                        }
                        if (j + 2 < dataStr.length) {
                            try {
                                data = dataStr[j + 2].trim().replace(" ", "");
                            }
                            catch (Exception e) {
                                data = "0";
                                log.log(Level.WARNING, String.format("Check line = %s position %d", line, j));
                            }
                            switch (recordSet.get(i).getDataType()) {
                                case GPS_LONGITUDE: 
                                case GPS_LATITUDE: {
                                    if (data.contains("-")) {
                                        points[i] = 0;
                                        break;
                                    }
                                    data = data.replace("E", "").replace('W', '-').replace("N", "").replace('S', '-').replace(":", "");
                                    data = recordSet.get(i).getUnit().endsWith("'") ? data.replace(".", "") : (data.length() != 0 ? String.format(Locale.ENGLISH, "%.6f", Double.parseDouble(data)).replace(".", "") : "0.0");
                                    try {
                                        points[i] = Double.valueOf(data).intValue();
                                    }
                                    catch (NumberFormatException e) {
                                        e.printStackTrace();
                                    }
                                    break;
                                }
                                case GPS_TIME: {
                                    try {
                                        if (data.contains("-") && data.length() == 10) {
                                            data = data.trim().replace("-", "");
                                            points[i] = Integer.parseInt(data.substring(2)) * 1000;
                                            break;
                                        }
                                        if (data.contains(":") && data.length() == 8) {
                                            data = data.trim().replace(":", "");
                                            points[i] = Integer.parseInt(data) * 1000;
                                            break;
                                        }
                                        points[i] = 0;
                                    }
                                    catch (NumberFormatException e) {
                                        points[i] = 0;
                                    }
                                    break;
                                }
                                default: {
                                    try {
                                        double value = Double.valueOf(data);
                                        if (value <= -2147483.0 || value >= 2147483.0) {
                                            log.log(Level.WARNING, String.format("Check line %d, found misterious value %s", lineNumber, data));
                                            break;
                                        }
                                        points[i] = (int)(value * 1000.0);
                                        break;
                                    }
                                    catch (NumberFormatException e) {
                                        points[i] = 0;
                                    }
                                }
                            }
                        }
                        ++i;
                        ++j;
                    }
                    recordSet.addPoints(points, (double)time_ms);
                    int progress = (progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length()) > 0 && inputFileSize > 0L ? (int)((long)(lineNumber * 100) / (inputFileSize / (long)progressLineLength)) : 50;
                    if (progress > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                    GDE.getUiNotification().setProgress(progress);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                if (recordSet.get(0).size() > 100) {
                    recordSet.setSaved(true);
                    activeChannel.put((Object)recordSetName, (Object)recordSet);
                    activeChannel.setActiveRecordSet(recordSetName);
                    activeChannel.applyTemplate(recordSetName, true);
                    device.updateVisibilityStatus(recordSet, true);
                } else {
                    activeChannel.remove(recordSetName);
                    if (createdRecordSets.contains(recordSetName)) {
                        createdRecordSets.remove(recordSetName);
                    }
                    log.log(Level.WARNING, "recordSet removed, number of measurements " + recordSet.get(0).size() + " < 100");
                }
                if (GDE.isWithUi() && createdRecordSets.size() > 0) {
                    activeChannel.switchRecordSet((String)createdRecordSets.firstElement());
                }
                reader.close();
                reader = null;
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new UnsupportedEncodingException(Messages.getString((String)"GDE_MSGW0010"));
            }
            catch (FileNotFoundException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
            }
            finally {
                GDE.getUiNotification().setProgress(100);
                GDE.getUiNotification().setStatusMessage("");
                if (GDE.isWithUi()) {
                    application.getMenuToolBar().updateChannelSelector();
                    application.getMenuToolBar().updateRecordSetSelectCombo();
                }
            }
        }
        return recordSet;
    }

    private static RecordSet createRecordSet(String recordSetNameExtend, IDevice device, Channel activeChannel, String[] tmpRecordNames, String[] tmpRecordUnits, String[] tmpRecordSymbols) {
        String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
        RecordSet recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannel.getNumber(), (String[])tmpRecordNames, (String[])tmpRecordSymbols, (String[])tmpRecordUnits, (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
        return recordSet;
    }

    public static void write(char separator, String recordSetKey, String filePath, boolean isRaw) throws Exception {
        try {
            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0138", (Object[])new String[]{"csv", filePath}));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "ISO-8859-1"));
            char decimalSeparator = Settings.getInstance().getDecimalSeparator();
            df3.setGroupingUsed(false);
            sb = new StringBuffer();
            RecordSet recordSet = (RecordSet)Channels.getInstance().getActiveChannel().get((Object)recordSetKey);
            IDevice device = DataExplorer.getInstance().getActiveDevice();
            sb.append(device.getName()).append(separator).append(recordSet.getChannelConfigName()).append(lineSep);
            writer.write(sb.toString());
            log.log(Level.FINE, "written header line = " + sb.toString());
            sb = new StringBuffer();
            sb.append(Messages.getString((String)"GDE_MSGT0137")).append(separator);
            for (int i = 0; i < recordSet.size(); ++i) {
                MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), i);
                Record record = recordSet.get(i);
                log.log(Level.FINEST, "append " + record.getName());
                if (isRaw) {
                    if (measurement.isCalculation()) continue;
                    sb.append(record.getName()).append(" [---]").append(separator);
                    log.log(Level.FINEST, "append " + record.getName());
                    continue;
                }
                sb.append(record.getName()).append(" [").append(record.getUnit()).append(']').append(separator);
                log.log(Level.FINEST, "append " + record.getName());
            }
            sb.deleteCharAt(sb.length() - 1).append(lineSep);
            log.log(Level.FINER, "header line = " + sb.toString());
            writer.write(sb.toString());
            long startTime = new Date(recordSet.getTime(0)).getTime();
            int recordEntries = recordSet.getRecordDataSize(true);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            for (int i = 0; i < recordEntries; ++i) {
                sb = new StringBuffer();
                String[] row = recordSet.getExportRow(i, true);
                sb.append(row[0].replace('.', decimalSeparator)).append(separator).append(" ");
                for (int j = 0; j < recordSet.size(); ++j) {
                    MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), j);
                    if (isRaw) {
                        if (measurement.isCalculation()) continue;
                        if (recordSet.isRaw()) {
                            sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                            continue;
                        }
                        sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                        continue;
                    }
                    sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                }
                sb.deleteCharAt(sb.length() - 1).append(lineSep);
                writer.write(sb.toString());
                if (i % 50 == 0) {
                    GDE.getUiNotification().setProgress(++progressCycle * 5000 / recordEntries);
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "data line = " + sb.toString());
            }
            sb = null;
            log.log(Level.TIME, "CSV file = " + filePath + " erfolgreich geschiebenwrite time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
            writer.flush();
            writer.close();
            writer = null;
            GDE.getUiNotification().setProgress(100);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0006", (Object[])new Object[]{"csv", filePath, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
    }

    public static String getFormatedTimeDiff(long startTime_ms, long endTime_ms) {
        long difference = (endTime_ms - startTime_ms) / 1000L;
        long hours = difference / 3600L;
        long minutes = (difference %= 3600L) / 60L;
        long seconds = difference %= 60L;
        return String.format(Locale.ENGLISH, "%02d:%02d:%02d", hours, minutes, seconds);
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

