/* 
    Copyright (C) 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptwah";
declare description "wah filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.10";
declare license "GPL 3.0 or later";

//link the libraries
ve = library("vaeffects.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
  nchannels = 2;// number of channels; 1 for mono, 2 for stereo
};

// a slider for the gain
enableauto = button("[1]auto");
frequency = hslider("[2][lv2: integer]frequency", 1, 1, 6500, 1);

//wah
wah = select2(enableauto == 1,ve.wah4(frequency),ve.autowah(1));

     
// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :
				     
				     //cptbasics.Ndrywetmonofx(i, wah) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i, wah) : //for 2 channels only; enables effect balance slider
				     

				     cptbasics.bargraphoutput(i) );



