/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptstereocompressor";
declare description "compressor filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.15";
declare license "GPL 3.0 or later";

//link the libraries
ba = library("basics.lib");
si = library("signals.lib");
co = library("compressors.lib");
an = library("analyzers.lib");
cptbasics = library("lib/basics.lib");

//constant variables used in this program
constant = environment {
	     nchannels = 2; // number of channels; do not change this - this is a stereo filter 
};

// a stereo compressor function that will multiplied with makeupgain
compressor = co.compressor_stereo(rat,thresh,att,rel): par(i, constant.nchannels,_*makeupgain)
with {

  // a slider for ratio of the compressor
  rat = hslider("[4]ratio",1,1,20,0.1);

  // a slider for threshold of the compressor
  thresh = hslider("[3]threshold",0,-60,0,0.1) : si.smoo;

  // a slider for attack of the compressor in seconds
  att = hslider("[1]attack",0,0,1,0.01) : si.smoo;

  // a slider for release of the compressor in seconds
  rel = hslider("[2]release",0,0,1,0.01) : si.smoo;

  // a slider for make-up gain, used after the compressor is applied
  makeupgain = hslider("[5]make-up gain",1,0,30,0.1) : si.smoo;
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i)) :
	  
	  cptbasics.stereodrywetstereofx(compressor) ://for 2 channels only; enables effect balance slider
	  
	  par(i, constant.nchannels, cptbasics.bargraphoutput(i));


































