/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptgraphicalequalizer";
declare description "graphical equalizer";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.13";
declare license "GPL 3.0 or later";

//link the libraries
ba = library("basics.lib");
fi = library("filter.lib");
an = library("analyzers.lib");
cptbasics = library ("lib/basics.lib");
cptanalyzers = library("lib/analyzers.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
	     ftop = 20000; //frequency top
	     humanftop = 1100; //human frequency top
	     N = 16; //number of bands
	     peakrelease = 1; // peak release in seconds
	   };

//a slider for low
lowpassctFreq = vgroup("[0]equalizer",20000 - hslider("[4][lv2:integer]low", 0, 0, 20000, 1) +1);

//lowpass filter
lowpass = _ <: select2(lowpassctFreq <= 20000,_,fi.lowpass(1,lowpassctFreq)) :> _;

//a slider for high
highpassctFreq = vgroup("[0]equalizer",hslider("[3][lv2:integer]high", 0 , 0, 20000, 1) +1);

//highpass filter
highpass = _ <: select2(highpassctFreq >= 2,_,fi.highpass(1, highpassctFreq)) :> _;

//a slider fot master gain
gain = vgroup("[0]equalizer",hslider("[2] master gain", 1,0,30,0.001));

//a button to enable the equalizer
enablecheckbox = vgroup("[0]equalizer",hgroup("[0]",checkbox("[0]enable")));

//ftop
ftoporhumanftop = vgroup("[0]equalizer",hgroup("[0]",select2((checkbox("[1]human_eq") == 1), constant.ftop, constant.humanftop)));

//equalizer
equalizer(N) = seq(i,N,oneBand(i)) with {
 
  //single band
  oneBand(j) = peakeq with {


    peakeq = fi.peak_eq(level,freq,bandwidth);
    //oder of bands
    bandorder = j+10;

    //band number to display
    
    bandn = j+1; // just so that band numbers don't start at 0
    
    //a slider for the level to boost or cut in dB
    level = vgroup("[0]equalizer", hgroup("[5]bands",vslider("[%bandorder]band %bandn[unit:db]",0,-90,24,0.01))) ;

    //peak frequency
    freq = select2(j == 0,((ftoporhumanftop/(constant.N-1))*j),(ftoporhumanftop/16)/4);

    //bandwidth of peak in Hz
    bandwidth = freq*3/Q with {

      Q = j+1;
    };
};

};


// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i,constant.nchannels, cptbasics.stereodrywetmonofx(i,(_ <: (_*(enablecheckbox == 0)), enablecheckbox * ( equalizer(constant.N) :
										       lowpass : highpass * gain  ) :> _
	     ))) <:
	  cptanalyzers.multispectrumanalyzer(constant.nchannels,constant.N,constant.ftop,constant.peakrelease,5);

