/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptresonance";
declare description "resonance filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.12";
declare license "GPL 3.0 or later";

//link the librarys
pm = library("physmodels.lib");
si = library("signals.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	   };

// function for the resonance
resonance = pm.modeFilter(freq,sec,gain)
with {
  // a slider for the mode gain
  gain = hslider("[1][unit:dB]gain",1,0,1,0.01) : si.smoo;

  // a slider for the mode frequency
  freq = hslider("[2][unit:Hz][lv2:integer]frequency",0,0,10000,1) : si.smoo;

  // a slider for the mode resonance duration
  sec = hslider("[3]resonance duration",0,0,10,0.1) : si.smoo;
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :

				     //cptbasics.Ndrywetmonofx(i, resonance) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i, resonance) ://for 2 channels only; enables effect balance slider
				     cptbasics.bargraphoutput(i));
