/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptlowpass";
declare description "lowpass filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.13";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
fi = library("effect.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	     peak_bandwidth = 200;// the bandwidth for applying the peak
	   };

// a slider for the cutoff frequency
ctFreq = hslider("[1][unit:Hz][lv2:integer]cutoff frequency", 500, 50, 10000, 1) : si.smoo;

// a slider for the peak
p = hslider("[2]peak", 0, 0, 100, 0.1) : si.smoo;

// the function for applying the peak
peak =  fi.peak_eq(p/3, ctFreq, constant.peak_bandwidth);

// the function that decribes the lopass filter
lowpass = fi.lowpass(1, ctFreq);

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :

				     //cptbasics.Ndrywetmonofx(i, lowpass : peak) ://for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i,lowpass : peak) : //for 2 channels only; enables effect balance slider
	                             cptbasics.bargraphoutput(i));
