/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptchannelspectrumanalyzer";
declare description "channel spectrum analyzer";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.10";
declare license "GPL 3.0 or later";

//link the librarys
ba = library("basics.lib");
an = library("analyzers.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
	     ftop = 1100; //frequency top
	     N = 12; //number of bands
	     peakrelease = 1; // peak release in seconds
	   };

//bar graph for each band
bargraphoutput(channeln,band) = bandsGroup(
				  _ <: attach(_,(
					       //enable peakhold if checked
					       select2(peakholdcheckbox,_,peakhold(constant.peakrelease)) :

					       //bargraph for one band
					       abs : ba.linear2db :
					       hbargraph("[%nbandorder]channel %channeln band %bandn",-60,0)))) with {
   //one group for each channel
  channelGroup(x) = vgroup("[00]channel %channeln",x);

    //one group for all bands
  bandsGroup(x) = hgroup("",channelGroup(x));
  
  //order of bands, starting with 10
  nbandorder =  10 + constant.N-band;

  //bandnumber to display
  bandn = constant.N-band+1;

   //a checkbox for preak hold
  peakholdcheckbox = checkbox("channel %channeln peak hold");

  //peak hold
  peakhold(p)  = an.amp_follower(p);

};
  
//the analyzer
analyzer(channeln) =  (an.mth_octave_analyzer6e(constant.N/2,constant.ftop,constant.N));

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process =   par(i,constant.nchannels,analyzer(i) : par(j,constant.N,bargraphoutput(i,j+1)):>_);
