/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptstereolimiter";
declare description "limiter filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.13";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
co = library("compressors.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2;// number of channels; do not change this - this is a stereo filter
	     lookaheaddelay = 0.01;// is the lookahead delay in seconds
};

// the function for the limiter
limiter = co.limiter_lad_N(constant.nchannels, constant.lookaheaddelay, ceiling, att, hol, rel)
with{
  // a slider for ceiling
  ceiling = hslider("[1]ceiling",1,0,1,0.01) : si.smoo;

  // a slider for attack
  att = hslider("[2]attack",1,0.01,1,0.01) : si.smoo;

  // a slider for hold
  hol = hslider("[3]hold",1,0.01,1,0.01) : si.smoo;

  //// a slider for release
  rel = hslider("[4]release",1,0,1,0.01) : si.smoo;
};
// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i)) :
	  
	  cptbasics.stereodrywetstereofx(limiter) : //for 2 channels only; enables effect balance slider
	  par(i, constant.nchannels, cptbasics.bargraphoutput(i));
