/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include <stdio.h>


#include "text.hxx"

COMF_NS_BEGIN


//*********** TextOutputFile
void TextOutputFile::writeChar(char k)
{
	_file.resize(_ptr+1);
	_file.ptr()[_ptr] = k;
	++_ptr;
}

void TextOutputFile::write(char k)
{
	COMF_ASSERT(valid(k));
	writeChar(k);	
}

void TextOutputFile::write(const char * str) 
{
	while(*str)
	{
		write(*str);
		++str;
	}
}

void TextOutputFile::writeln(const char * str) 
{
	write(str);
	writeChar('\n');
}

void TextOutputFile::writeln() 
{
	writeChar('\n');
}


//*********** TextInputFile

int TextInputFile::readChar()
{
	if(_ptr>=_file.size())
		return EOF;
	int k = unsign(_file.cptr()[_ptr]);	
	++_ptr;
	return k;
}


bool TextInputFile::read(std::string & str)
{
	str.clear();
	while(true)
	{
		int k = readChar();
		if(k==EOF) return false;
		if(k=='\n') break;
		if(k=='\r') continue;
		str += validate(k);
	}
	return true;
}

std::auto_ptr<std::string> TextInputFile::read()
{
	std::auto_ptr<std::string> str(new std::string);
	while(true)
	{
		int k = readChar();
		if(k==EOF)
		{
			if(str->empty())
				return std::auto_ptr<std::string>(0);
			else return str;
		}
		if(k=='\n') break;
		if(k=='\r') continue;
		*str += validate(k);
	}
	return str;
}


COMF_NS_END
