/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include <float.h>
#include <math.h>
#include <string>

#include "test.hxx"
#include "string.hxx"
#include "exception.hxx"
#include "mystd.hxx"


COMF_NS_BEGIN


void Test::checkreal(const char * f, const char * s0, const char * s1, double v0, double v1) 
{
	bool fail = (fabs(v0 - v1) > sqrt(DBL_EPSILON)) || !finite(v0) || !finite(v1);
	printf("@%c %s: checkreal(%s=%g,%s=%g)\n",fail?'?':'!',f,s0,v0,s1,v1);
	_fail |= fail;
}

void Test::checkint(const char * f, const char * s0, const char * s1, int v0, int v1)
{
	bool fail = (v0 != v1);
	printf("@%c %s: checkint(%s=%d,%s=%d)\n",fail?'?':'!',f,s0,v0,s1,v1);
	_fail |= fail;
}

void Test::checkbool(const char * f, const char * s0, const char * s1, bool v0, bool v1) 
{
	bool fail = (v0 != v1);
	printf("@%c %s: checkbool(%s=%s,%s=%s)\n",fail?'?':'!',f,s0,v0?"true":"false",s1,v1?"true":"false");
	_fail |= fail;
}

void Test::checkstring(const char * f, const char * s0, const char * s1, const std::string & v0, const std::string & v1)
{
	bool fail = (v0 != v1);
	printf("@%c %s: checkstring(%s=%s,%s=%s)\n",fail?'?':'!',f,s0,quote(v0).data(),s1,quote(v1).data());
	_fail |= fail;
}

bool Test::run()
{
	_fail = false;
	try
	{
		vrun();
	}
	catch(Exception & xe)
	{
		printf("@? Exception: %s\n",xe.text().data());
		xe.printStackTrace(stderr);
		_fail = true;
	}
	catch(...)
	{
		printf("@? c++ exception\n");
		_fail = true;
	}
	
	return _fail;
}

void TestSuite::add(Test * t)
{
	_tests.insert(t);
}

bool TestSuite::run()
{
	bool fail = false;
	
	puts("# begin TestSuite");
	COMF_CITERATE(std::set<Test*>,it,_tests)
		fail |= (*it)->run();

	if(fail)
		puts("# end TestSuite: FAILED");
	else
		puts("# end TestSuite: OK");
	
	return fail;
}
		

COMF_NS_END

