/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_ZSTRING_HXX
#define COMF_ZSTRING_HXX

#include <string.h>
#include <string>
#include <vector>

#include "globals.hxx"
#include "integer.hxx"

COMF_NS_BEGIN

char digitletter(unsigned int n);


template <typename T> size_t utobase(T n, char * str, unsigned int base, size_t minwidth)
{
	COMF_assertDBG(inoc(base,1u,36u));
		
	char tmp[sizeof(n)*CHAR_BIT+1]; //1 for null terminator
	char * p = tmp;
	
	T m = n;
	for(;m;++p)
	{
		unsigned int module = m % base;		
		m /= base;
		*p = digitletter(module);
	}	
	
	char * pe = str+minwidth-(p-tmp);
	char * s = str;
	for(;s<pe;++s) *s = '0';
	for(;p>tmp;++s,--p) *s = *(p-1);

	if(s==str)
	{
		*s = '0';
		++s;
	}
		
	*s = 0;
	return (s-str);
}



template <typename T> size_t utod(T n, char * str)
{
	return utobase(unsign(n),str,10,1);
}
	
template <typename T> size_t utob(T n, char * str)
{
	*str = '%';
	return utobase(unsign(n),str+1,2,sizeof(n)*CHAR_BIT);
}

template <typename T> size_t utox(T n, char * str)
{
	*str = '$';
	return utobase(unsign(n),str+1,16,sizeof(n)*CHAR_BIT/4);
}

template <typename T> size_t utoo(T n, char * str)
{
	return utobase(unsign(n),str,8);
}

template <typename T> std::string utod(T n)
{
	char tmp[sizeof(n)*3+1];
	utod(n,tmp);
	return std::string(tmp);
}

template <typename T> std::string utob(T n)
{
	char tmp[sizeof(n)*8+2];
	utob(n,tmp);
	return std::string(tmp);
}

template <typename T> std::string utox(T n)
{
	char tmp[sizeof(n)*2+2]; // +2 for '$' '\0'
	utox(n,tmp);
	return std::string(tmp);
}

template <typename T> std::string utoo(T n)
{
	char tmp[sizeof(n)*3+2];
	utoo(n,tmp);
	return std::string(tmp);
}



size_t itod(int n, char * str, bool plus = false);
std::string itod(int);

unsigned int stou(const char * str, char ** endptr);
unsigned int stou(const char * str);
unsigned int stou(const std::string &);

unsigned long stoul(const char * str, char ** endptr);
unsigned long stoul(const char * str);
unsigned long stoul(const std::string &);


size_t ftod(double, char *);
std::string ftod(double);
size_t ftox(double, char *);
std::string ftox(double);

double stof(const char *);


std::string ptoa(const void *);

std::string trim(const std::string &, const char * pattern = " \t\r\n");

void strupr(char *);
void strlwr(char *);
void makeupper(std::string &);
void makelower(std::string &);
std::string toupper(const std::string &);                   
std::string tolower(const std::string &);                   

std::string rjus(const std::string &, size_t totalsize, char pad = ' '); 
std::string ljus(const std::string &, size_t totalsize, char pad = ' '); 

std::string format(const char * pattern, const std::vector<std::string> &);

std::string quote(const char *);
std::string quote(const std::string &);

std::string escape(const char *);
std::string escape(const std::string &);

std::vector<std::string> parse(
	const std::string & str,
	bool usespc,
	const char * tok,
	bool toka,
	bool sdla,
	const char * com
	);


class Format
{
	protected:
	std::string _form;
	std::vector<std::string> _data;
	
	public:
	Format(const char *);
	Format(const std::string &);
	Format & operator % (const char *);
	Format & operator % (const std::string &);

	operator std::string () const;
};

COMF_NS_END

#endif
