/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include <set>

#include "object.hxx"
#include "mymacros.hxx"


COMF_NS_BEGIN

//*///////////////////////////////////////////

Entity::Entity(const Entity &)
{
	ASSERT(false);
}

void Entity::operator = (const Entity &)
{
	ASSERT(false);
}

//*////////////////////////////////////////

#ifdef NDEBUG
class UserObjPrivate : public Private {};
#else
class UserObjPrivate : public Private
{
	public:
	void * _user;
	const UsedObj * _used;
};
#endif

IMPLEMENT_DEFAULTPRIVATE(UserObj,UserObjPrivate)

#ifdef NDEBUG
UserObj::UserObj(void *, const UsedObj &) {private_init();}
UserObj::~UserObj() {}
#else

UserObj::UserObj(void * user, const UsedObj & used)
{
	private_init();
	UserObjPrivate * p = static_cast<UserObjPrivate*>(private_get());
	p->_user = user;
	p->_used = &used;
	p->_used->addUser(p->_user);
}

UserObj::~UserObj()
{
	UserObjPrivate * p = static_cast<UserObjPrivate*>(private_get());
	p->_used->delUser(p->_user);
}
#endif

//*//////////////////////////////////

#ifdef NDEBUG
class UsedObjPrivate : public Private {};
#else
class UsedObjPrivate : public Private
{
	public:
	std::set<const void*> _use;
};
#endif

IMPLEMENT_DEFAULTPRIVATE(UsedObj,UsedObjPrivate)

UsedObj::UsedObj()
{
	private_init();
}

#ifndef NDEBUG
UsedObj::~UsedObj()	
{
	UsedObjPrivate * p = static_cast<UsedObjPrivate*>(private_get());
	ASSERT(p->_use.empty());
}
#else
UsedObj::~UsedObj()	{}
#endif

#ifndef NDEBUG
void UsedObj::addUser(const void* ptr) const
{
	UsedObjPrivate * p = static_cast<UsedObjPrivate*>(private_get());
	ASSERT(p->_use.insert(ptr).second);
}
#else
void UsedObj::addUser(const void*) const {}
#endif

#ifndef NDEBUG
void UsedObj::delUser(const void* ptr) const
{
	UsedObjPrivate * p = static_cast<UsedObjPrivate*>(private_get());
	ASSERT(p->_use.erase(ptr)==1);
}
#else
void UsedObj::delUser(const void*) const {}
#endif

UsePrivate::UsePrivate()
{
	_private_data = 0;
}


UsePrivate::~UsePrivate()
{
	delete _private_data;
}

void UsePrivate::private_set(Private * p)
{
	ASSERT(_private_data==0);
	_private_data = p;
}



COMF_NS_END

