/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_ZMEMORY_HXX
#define COMF_ZMEMORY_HXX

#include "object.hxx"

COMF_NS_BEGIN

template <class T> void constructor(T * ptr)
{
	::new(ptr) T();
}

template <class T> void constructor(T * ptr, const T & a)
{
	::new(ptr) T(a);
}

template <class T> void destructor(T * ptr)
{
	ptr->~T();
}

template <class T> T * nil()
{
	return static_cast<T*>(NULL);
}

template <class T> const T * cnil()
{
	return static_cast<const T*>(NULL);
}



class ConstSegment : public UsedObj
{
	public:
	ConstSegment() {}
	virtual ~ConstSegment() {}

	virtual size_t size() const = 0;
	virtual const char * cptr() const = 0;
	void dump(FILE *) const;
};

class Segment : public ConstSegment
{
	public:
	Segment() {}
	virtual ~Segment() {}

	virtual char * ptr() const = 0;
};

class DynamicSegment : public Segment
{
	public:
	DynamicSegment() {}
	virtual ~DynamicSegment() {}
	
	virtual void resize(size_t) = 0;
	virtual void clear(size_t) = 0;
	virtual void clear() = 0;
};

class Memory : public DynamicSegment, public Serializable
{
	DECLARE_SERIALIZABLE(Memory);
	
	public:

	Memory();
	Memory(size_t);
	virtual ~Memory();
	Memory(const ConstSegment &);
	Memory & operator = (const ConstSegment &);

	size_t size() const;
	const char * cptr() const;
	char * ptr() const;
	
	void resize(size_t);
	void clear(size_t);
	void clear();

	void serialize(BOStorage &) const;
	void serialize(BIStorage &);
	void serialize(TOStorage &) const;
	void serialize(TIStorage &);


	private:
	static const size_t _s_minsize;
	void * _ptr;
	size_t _size;
	size_t _allocsize;
};


class ConstSegmentView : public ConstSegment
{
	public:
	ConstSegmentView(const void * p, size_t z) : _ptr(static_cast<const char*>(p)), _size(z) {}
	virtual ~ConstSegmentView() {}
	
	virtual size_t size() const {return _size;}
	virtual const char * cptr() const {return _ptr;}
	
	protected:
	const char * _ptr;
	size_t _size;
};


class SegmentView : public Segment
{
	public:
	SegmentView(void * p, size_t z) : _ptr(static_cast<char*>(p)), _size(z) {}

	virtual ~SegmentView() {}
	
	virtual size_t size() const {return _size;}
	virtual const char * cptr() const {return _ptr;}
	virtual char * ptr() const {return _ptr;}
	
	protected:
	char * _ptr;
	size_t _size;
};



COMF_NS_END

#endif
