/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include "libinfo.hxx"

#include "string.hxx"
#include "mystd.hxx"


COMF_NS_BEGIN


std::vector<LibInfo> LibInfo::_list;

std::string LibInfo::format() const
{
	std::string s("%$ %$.%$.%$ (%$) %$");						
	if(_debug) s += " debug";									
	s += "\n";
	return Format(s)										
		% _product										
		% utod(_version)								
		% utod(_release)								
		% utod(_build)								
		% _timestamp											
		% _author;
}

void LibInfo::regthis() const
{
	_list.push_back(*this);
}


void LibInfo::print(FILE * f) const
{
	fputs(format().data(),f);
}
	

const std::vector<LibInfo> & LibInfo::queryList()
{
	return _list;
}

void LibInfo::printList(FILE * f)
{
	COMF_CITERATE(std::vector<LibInfo>,it,_list)
		it->print(f);
}
	
	


LibInfoRegister::LibInfoRegister(const LibInfo & a)
{
	a.regthis();
}
		



COMF_NS_END



