/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: exception.hxx,v 1.2 2006/01/02 22:08:04 zeldan Exp $

#ifndef COMF_EXCEPTION_HXX
#define COMF_EXCEPTION_HXX

#include <errno.h>
#include <vector>
#include <string>

#include "defs.hxx"


COMF_NS_BEGIN


//! Generic exception
class Exception
{
	public:

	//! Default constructor for DEBUG
	Exception(const char * file, int line, const std::vector<std::string> & st)
		: _file(file), _line(line), _stack(st) {}
	//! Default constructor
	Exception() : _line(-1) {}

	virtual ~Exception() {}

	//! Descriptive full text
	const std::string text() const;
	void logit(int level) const; //level as in syslog(3)
	
	void printStackTrace(FILE*, const char * prefix = "") const;

	virtual void rethrow() const = 0;

		
	protected:
	//! Descriptive text generator
	virtual std::string vtext() const = 0;

	private:
	std::string _file;
	int _line;
	std::vector<std::string> _stack;
 

};

//! Exception encapsulating \c errno
class ErrException : public Exception
{
	public:

	//! Constructor for DEBUG
	ErrException(int e, const char * file, int line, const std::vector<std::string> & st) 
		: Exception(file,line,st), _err(e) {}
	//! Constructor
	ErrException(int e) : _err(e) {}

	virtual ~ErrException() {}

	//! Get errno
	int err() const {return _err;}

	COMF_EXCEPTION_RETHROW(ErrException);


	protected:
	virtual std::string vtext() const;

	private:
	int _err;

};


//! COMF exception
class COMFException : public Exception
{
	public:

	//! Constructor for DEBUG
	COMFException(const std::string & t, const char * file, int line, const std::vector<std::string> & st) 
		: Exception(file,line,st), _text(t) {}
	//! Constructor for DEBUG
	COMFException(const char * t, const char * file, int line, const std::vector<std::string> & st) 
		: Exception(file,line,st), _text(t) {}
	//! Constructor
	COMFException(const std::string & t) : _text(t) {}
	//! Constructor
	COMFException(const char * t) : _text(t) {}

	virtual ~COMFException() {}

	COMF_EXCEPTION_RETHROW(COMFException);


	protected:
	virtual std::string vtext() const;

	private:
	std::string _text;

};


COMF_NS_END

#endif
