/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: defs.hxx,v 1.2 2006/01/02 22:08:04 zeldan Exp $

#include <signal.h>

#ifndef COMF_DEFS_HXX
#define COMF_DEFS_HXX

#ifndef __GNUC__
	#error "GNU C++ compiler version 3.3 or greater required"
#endif

#if(__GNUC__ < 3)
	#error "GNU C++ compiler version 3.3 or greater required"
#endif

#if((__GNUC__ == 3) && (__GNUC_MINOR__ < 3))
	#error "GNU C++ compiler version 3.3 or greater required"
#endif

#define COMF_NS comf
#define COMF_NS_BEGIN namespace COMF_NS {
#define COMF_NS_END }

#define COMF_STRINGIZE(L) #L
#define COMF_APPLY(M,L) M(L)

#define COMF_STACKALLOC(T,n) (T*)_alloca(n*sizeof(T))
 
#define COMF_LOOPX(V,N) for((V)=0;((V)<(N));++(V))
#define COMF_LOOP(T,V,N) for(T V=0;((V)<(N));++(V))
#define COMF_EVER for(;;)                           

#define COMF_STRCLR(s) (s)[0]=0

#define COMF_DIM(x) (sizeof(x)/sizeof((x)[0]))
#define COMF_CALLPTR(p,f) if((p)) p->f








// use following macros (lowercase function-like) in headers
#define COMF_throwCOMFEXCEPTION(TEXT) throw COMF_NS::COMFException(TEXT,__FILE__,__LINE__,COMF_NS::stacktrace())
#define COMF_logCOMFEXCEPTION(TEXT) {COMF_NS::COMFException ex(TEXT,__FILE__,__LINE__,COMF_NS::stacktrace());ex.logerror();}

#define COMF_assertDBG(x) COMF_NS::assertdbg(x,#x,__FILE__,__LINE__)



// __NEVER__ use following macros in headers

#ifndef NDEBUG
	#define COMF_THROWEXCEPTION(TYPE,VALUE) throw TYPE(VALUE,__FILE__,__LINE__,stacktrace())
	#define COMF_LOGEXCEPTION(TYPE,VALUE) {TYPE ex(VALUE,__FILE__,__LINE__,stacktrace()); ex.logerror();}
#else
	#define COMF_THROWEXCEPTION(TYPE,VALUE) throw TYPE(VALUE)
	#define COMF_LOGEXCEPTION(TYPE,VALUE,LEVEL) {TYPE ex(VALUE); ex.logit((LEVEL));}
#endif


#define COMF_THROWCOMFEXCEPTION(TEXT) COMF_THROWEXCEPTION(COMF_NS::COMFException,TEXT)
#define COMF_THROWCOMFEXCEPTIONHERE() COMF_THROWEXCEPTION(COMF_NS::COMFException,__PRETTY_FUNCTION__)
#define COMF_THROWERREXCEPTION(ERR) COMF_THROWEXCEPTION(COMF_NS::ErrException,ERR)
#define COMF_THROWERREXCEPTIONHERE() COMF_THROWEXCEPTION(COMF_NS::ErrException,errno)

#define COMF_LOGCOMFEXCEPTION(TEXT) COMF_LOGEXCEPTION(COMF_NS::COMFException,TEXT)
#define COMF_LOGCOMFEXCEPTIONHERE() COMF_LOGEXCEPTION(COMF_NS::COMFException,__PRETTY_FUNCTION__)
#define COMF_LOGERREXCEPTION(ERR,LEVEL) COMF_LOGEXCEPTION(COMF_NS::ErrException,ERR,LEVEL)
#define COMF_LOGERREXCEPTIONHERE(LEVEL) COMF_LOGEXCEPTION(COMF_NS::ErrException,errno,LEVEL)


#define COMF_ERRCALL(f) if(-1==(f)) COMF_THROWERREXCEPTIONHERE()

#define COMF_EXCEPTION_RETHROW(CLASS) public: virtual void rethrow() const {throw CLASS(*this);}


#ifndef NDEBUG
	#define COMF_TRACEPARA(x,...) {fprintf(stderr,"%s(%d):",__FILE__,__LINE__);fprintf(stderr,x,__VA_ARGS__);}
	#define COMF_TRACE(x) fprintf(stderr,"%s(%d):%s",__FILE__,__LINE__,x) 
	#define COMF_VERIFY(x) COMF_assertDBG(x)
	#define COMF_ASSERT(x) COMF_assertDBG(x)
	#define COMF_TODO COMF_NS::assertdbg(false,"TODO",__FILE__,__LINE__)
#else
	#define COMF_TRACEPARA(x,...) ((void)0)
	#define COMF_TRACE(x, ...) ((void)0)
	#define COMF_VERIFY(x) (x)
	#define COMF_ASSERT(x) ((void)0)
	#define COMF_TODO {::raise(SIGABRT);}
#endif




#endif
