/*
**  ObjCMethodHandler.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _ObjCMethodHandler_H_
#define _ObjCMethodHandler_H_

#include "ObjCCommentHandler.h"
#include <CodeEditorView/MethodHandler.h>

/**
 * MethodStart MethodSymbol   MethodReturnValue        MethodName      MethodEnd
 *                 +/-      (        id         )  simpleMethod:value      ;
 *
 * MethodStart is after each ';' or new line
 * MethodSymbol is +/- for objective-C
 * MethodReturnValue is surround by '(' and ')', and can be ignore
 * MethodName contain method name and messages
 * MethodNone is not method;
 */

typedef enum _CheckStep
{
  MethodStart, 
  MethodSymbol,
  MethodReturnValue,
  MethodName, 
  MethodNone
} CheckStep;

/**
 * MethodNamePart MethodSeparatePart   MethodReturnValuePart   MethodMessagePart
 *   action              :           (      id               )    sender
 * 
 * Method parts is only under MethodName (CheckStep)
 *
 * MethodNamePart must exist at least once
 * MethodSeparatePart
 * MethodReturnValuePart is optional
 * MethodMessagePart must follow each MethodSeparatePart
 */

typedef enum _MethodPart
{
  MethodNamePart,
  MethodSeparatePart,
  MethodReturnValuePart,
  MethodMessagePart,
  NotMethodPart
} MethodPart;


@class NSMutableString;
@class NSMutableArray;
@class MethodNode;

@interface ObjCMethodHandler: ObjCCommentHandler < MethodHandler >
{
  unsigned int position;

  NSMutableString *method, *classDefinition;
  NSMutableArray *methods;
  MethodNode *rootNode, *currentNode;
  unichar _preSymbol; 
  unsigned methodBeginPosition;

  BOOL classDefined; /* YES between @implementation/@interface, before '\n' */
  CheckStep step;
  MethodPart part;
}
@end

#endif /* _ObjCMethodHandler_H_ */
